/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils.service;

import com.mafuyu404.instantlyinteractinternally.network.NetworkHandler;
import com.mafuyu404.instantlyinteractinternally.network.UseProgressEnd;
import com.mafuyu404.instantlyinteractinternally.network.UseProgressStart;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="instantlyinteractinternally", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class UseProgressTracker {
    private static final Map<UUID, InProgress> USING = new ConcurrentHashMap<UUID, InProgress>();

    private UseProgressTracker() {
    }

    public static void beginUseFromSlot(ServerPlayer player, Slot slot) {
        if (player == null || slot == null || !slot.m_6657_()) {
            return;
        }
        if (USING.containsKey(player.m_20148_())) {
            return;
        }
        ItemStack src = slot.m_7993_();
        ItemStack one = src.m_41777_();
        one.m_41764_(1);
        src.m_41774_(1);
        slot.m_5852_(src.m_41619_() ? ItemStack.f_41583_ : src);
        slot.m_6654_();
        player.f_36096_.m_38946_();
        int duration = one.m_41779_();
        if (duration <= 0) {
            duration = 1;
        }
        long end = UseProgressTracker.getServer(player).m_129921_() + duration;
        USING.put(player.m_20148_(), new InProgress(one, end));
        NetworkHandler.sendToClient(player, new UseProgressStart(duration));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (USING.isEmpty()) {
            return;
        }
        USING.forEach((uuid, prog) -> {
            ServerPlayer player = UseProgressTracker.findPlayer(evt, uuid);
            if (player == null) {
                USING.remove(uuid);
                return;
            }
            long now = UseProgressTracker.getServer(player).m_129921_();
            if (now >= prog.endTick()) {
                UseProgressTracker.finish(player, prog);
                USING.remove(uuid);
            }
        });
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            USING.remove(sp.m_20148_());
        }
    }

    private static void finish(ServerPlayer player, InProgress prog) {
        boolean added;
        ItemStack after = prog.toConsume().m_41671_(player.m_9236_(), (LivingEntity)player);
        if (!after.m_41619_() && !(added = player.m_150109_().m_36054_(after))) {
            player.m_36176_(after, false);
        }
        player.f_36096_.m_38946_();
        NetworkHandler.sendToClient(player, new UseProgressEnd());
    }

    private static MinecraftServer getServer(ServerPlayer p) {
        return p.m_20194_();
    }

    private static ServerPlayer findPlayer(TickEvent.ServerTickEvent evt, UUID id) {
        for (ServerLevel lvl : evt.getServer().m_129785_()) {
            ServerPlayer p = lvl.m_7654_().m_6846_().m_11259_(id);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private record InProgress(ItemStack toConsume, long endTick) {
    }
}

