/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.instantlyinteractinternally.utils.service;

import com.mafuyu404.instantlyinteractinternally.utils.FakeLevel;
import com.mafuyu404.instantlyinteractinternally.utils.service.WorldContext;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class WorldContextRegistry {
    private static final Map<UUID, WorldContext> CONTEXTS = new ConcurrentHashMap<UUID, WorldContext>();

    private WorldContextRegistry() {
    }

    public static FakeLevel getOrCreateLevel(ServerPlayer player) {
        WorldContextRegistry.maybeLoadContext(player);
        return WorldContextRegistry.CONTEXTS.computeIfAbsent((UUID)player.m_20148_(), (Function<UUID, WorldContext>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getOrCreateLevel$0(net.minecraft.server.level.ServerPlayer java.util.UUID ), (Ljava/util/UUID;)Lcom/mafuyu404/instantlyinteractinternally/utils/service/WorldContext;)((ServerPlayer)player)).level;
    }

    public static WorldContext getContext(ServerPlayer player) {
        WorldContextRegistry.maybeLoadContext(player);
        return CONTEXTS.get(player.m_20148_());
    }

    public static void clear(ServerPlayer player) {
        CONTEXTS.remove(player.m_20148_());
    }

    public static void saveAllAndClear(MinecraftServer server) {
        CONTEXTS.clear();
    }

    public static BlockPos ensurePosForSession(ServerPlayer player, String sessionId) {
        WorldContextRegistry.maybeLoadContext(player);
        WorldContext ctx = CONTEXTS.computeIfAbsent(player.m_20148_(), id -> new WorldContext(player));
        BlockPos pos = ctx.sessionToPos.get(sessionId);
        if (pos != null) {
            return pos;
        }
        BlockPos newPos = WorldContextRegistry.computeNearPos(player, sessionId, ctx.nextIndex++);
        ctx.sessionToPos.put(sessionId, newPos);
        return newPos;
    }

    public static void maybeLoadContext(ServerPlayer player) {
        UUID id = player.m_20148_();
        if (CONTEXTS.containsKey(id)) {
            return;
        }
        WorldContext ctx = new WorldContext(player);
        CONTEXTS.put(id, ctx);
    }

    public static BlockPos computeNearPos(ServerPlayer player, String key, int index) {
        int baseX = (int)Math.floor(player.m_20185_());
        int baseY = player.m_146904_();
        int baseZ = (int)Math.floor(player.m_20189_());
        int h = key.hashCode() ^ index * 31;
        int dx = 2 + (h & 3);
        int dz = 2 + (h >> 2 & 3);
        int dy = (h >> 4 & 1) == 0 ? 0 : 1;
        return new BlockPos(baseX + dx, baseY + dy, baseZ + dz);
    }

    private static /* synthetic */ WorldContext lambda$getOrCreateLevel$0(ServerPlayer player, UUID id) {
        return new WorldContext(player);
    }
}

