/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.BoneAnimationController;
import com.henrique.punchy.client.render.BoneSnapshotBridge;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1755;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1835;
import net.minecraft.class_3489;

public final class ActionAnimationManager {
    private static final Map<ActionType, List<ClipAssignment>> CLIP_BY_ACTION = new EnumMap<ActionType, List<ClipAssignment>>(ActionType.class);
    private static final Map<ActionType, String> DEFAULT_CLIP = new EnumMap<ActionType, String>(ActionType.class);

    private ActionAnimationManager() {
    }

    public static void trigger(class_1657 player, class_1268 hand, ActionType actionType, class_1799 stack, String clipOverride, boolean capturePose) {
        if (player == null || hand == null) {
            return;
        }
        String clip = clipOverride;
        if (clip == null || clip.isEmpty()) {
            clip = ActionAnimationManager.resolveClip(actionType, stack);
        }
        if (clip == null || clip.isEmpty()) {
            Punchy.LOGGER.warn("[ActionAnimationManager] resolved an empty clip for {} ({})", (Object)actionType, (Object)(stack == null ? "empty stack" : stack.method_7909()));
            return;
        }
        Punchy.LOGGER.debug("[ActionAnimationManager] requesting snapshot before triggering {} for {} (clip={} capturePose={})", new Object[]{actionType, hand, clip, capturePose});
        if (capturePose) {
            BoneSnapshotBridge.queueSnapshotForNextAnimation(hand);
        }
        BoneAnimationController.triggerActivation(player, hand, clip);
    }

    public static String resolveClip(ActionType actionType, class_1799 stack) {
        if (actionType == null) {
            return "";
        }
        List<ClipAssignment> assignments = CLIP_BY_ACTION.get((Object)actionType);
        if (assignments != null && !assignments.isEmpty()) {
            for (ClipAssignment assignment : assignments) {
                if (!assignment.matches(stack)) continue;
                return assignment.clip();
            }
        }
        return DEFAULT_CLIP.getOrDefault((Object)actionType, "");
    }

    public static void register(ActionType actionType, ItemGroup group, String clip) {
        if (actionType == null || group == null || clip == null || clip.isEmpty()) {
            return;
        }
        CLIP_BY_ACTION.computeIfAbsent(actionType, k -> new ArrayList()).add(new ClipAssignment(group, clip));
    }

    static {
        DEFAULT_CLIP.put(ActionType.ATTACK, "attack");
        DEFAULT_CLIP.put(ActionType.MINING, "punch");
        DEFAULT_CLIP.put(ActionType.USE, "insert");
        ActionAnimationManager.register(ActionType.ATTACK, ItemGroup.TRIDENT, "trident_attack");
        ActionAnimationManager.register(ActionType.ATTACK, ItemGroup.SPEAR, "spear_attack");
        ActionAnimationManager.register(ActionType.ATTACK, ItemGroup.SWORD, "attack");
        ActionAnimationManager.register(ActionType.MINING, ItemGroup.PICKAXE, "mining");
        ActionAnimationManager.register(ActionType.MINING, ItemGroup.AXE, "sway_sideways");
        ActionAnimationManager.register(ActionType.MINING, ItemGroup.HOE, "sway_throw");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.PICKAXE, "sway_forward");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.AXE, "sway_sideways");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.SHOVEL, "sway_digging");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.HOE, "sway_forward");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.SWORD, "attack");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.BUCKET, "bucket_fill");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.SHIELD, "rise_shield");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.BOW, "bow_load_bow_hand");
        ActionAnimationManager.register(ActionType.USE, ItemGroup.CROSSBOW, "crossbow_load_crossbow_hand");
    }

    public static enum ActionType {
        ATTACK,
        MINING,
        USE;

    }

    private static final class ClipAssignment {
        private final ItemGroup group;
        private final String clip;

        private ClipAssignment(ItemGroup group, String clip) {
            this.group = group;
            this.clip = clip;
        }

        private boolean matches(class_1799 stack) {
            return this.group.matches(stack);
        }

        private String clip() {
            return this.clip;
        }
    }

    private static enum ItemGroup {
        PICKAXE(stack -> stack != null && stack.method_31573(class_3489.field_42614)),
        AXE(stack -> stack != null && stack.method_31573(class_3489.field_42612)),
        SHOVEL(stack -> stack != null && stack.method_31573(class_3489.field_42615)),
        HOE(stack -> stack != null && stack.method_31573(class_3489.field_42613)),
        SWORD(stack -> stack != null && stack.method_31573(class_3489.field_42611)),
        TRIDENT(stack -> stack != null && stack.method_7909() instanceof class_1835),
        SPEAR(stack -> stack != null && stack.method_31573(class_3489.field_63257)),
        BOW(stack -> stack != null && stack.method_7909() instanceof class_1753),
        CROSSBOW(stack -> stack != null && stack.method_7909() instanceof class_1764),
        SHIELD(stack -> stack != null && stack.method_7909() instanceof class_1819),
        BUCKET(stack -> stack != null && stack.method_7909() instanceof class_1755);

        private final Predicate<class_1799> matcher;

        private ItemGroup(Predicate<class_1799> matcher) {
            this.matcher = matcher;
        }

        private boolean matches(class_1799 stack) {
            return this.matcher.test(stack);
        }
    }
}

