/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import net.minecraft.class_1268;

public final class ArmAnimationOverrides {
    private static float forceMainHand = 0.0f;
    private static float forceOffHand = 0.0f;

    private ArmAnimationOverrides() {
    }

    public static void setForceRender(class_1268 hand, boolean force) {
        ArmAnimationOverrides.setForceRender(hand, force ? 1.0f : 0.0f);
    }

    public static void setForceRender(class_1268 hand, float strength) {
        if (hand == class_1268.field_5810) {
            forceOffHand = Math.max(0.0f, Math.min(1.0f, strength));
        } else {
            forceMainHand = Math.max(0.0f, Math.min(1.0f, strength));
        }
    }

    public static void lerpForceRender(class_1268 hand, float target, float amount) {
        float clamped = Math.max(0.0f, Math.min(1.0f, target));
        if (hand == class_1268.field_5810) {
            forceOffHand = ArmAnimationOverrides.lerp(forceOffHand, clamped, amount);
        } else {
            forceMainHand = ArmAnimationOverrides.lerp(forceMainHand, clamped, amount);
        }
    }

    private static float lerp(float current, float target, float amount) {
        return current + (target - current) * Math.max(0.0f, Math.min(1.0f, amount));
    }

    public static boolean isForceRender(class_1268 hand) {
        float value = hand == class_1268.field_5810 ? forceOffHand : forceMainHand;
        return value > 0.01f;
    }

    public static float forceStrength(class_1268 hand) {
        return hand == class_1268.field_5810 ? forceOffHand : forceMainHand;
    }

    public static void clear(class_1268 hand) {
        ArmAnimationOverrides.setForceRender(hand, 0.0f);
    }

    public static void clearAll() {
        forceMainHand = 0.0f;
        forceOffHand = 0.0f;
    }
}

