/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.AxolotlPhysics;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.VanillaProxyContext;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10444;
import net.minecraft.class_10515;
import net.minecraft.class_11659;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public final class AxolotlBucketRenderer
implements class_10515<LayerData> {
    static final AxolotlBucketRenderer INSTANCE = new AxolotlBucketRenderer();
    private static final EnumMap<class_1268, AxolotlPhysics> PHYSICS = new EnumMap(class_1268.class);

    private AxolotlBucketRenderer() {
    }

    public void submit(@Nullable LayerData data, class_811 context, class_4587 poseStack, class_11659 collector, int light, int overlay, boolean foilActive, int seed) {
        float pivotZ;
        float pivotY;
        float pivotX;
        class_243 contextPivot;
        if (data == null || data.renderType == null || data.quads == null || data.quads.isEmpty()) {
            return;
        }
        class_1268 hand = data.hand == null ? class_1268.field_5808 : data.hand;
        PunchyClient.JumpSpringPose pose = PunchyClient.jumpSpringPose(class_1268.field_5808);
        boolean left = hand == class_1268.field_5810;
        class_243 tuningPivot = VanillaProxyContext.getItemPivot(hand);
        class_243 class_2432 = contextPivot = tuningPivot != null ? tuningPivot : VanillaProxyContext.getSpringPivot(hand);
        if (contextPivot != null) {
            pivotX = (float)contextPivot.method_10216();
            pivotY = (float)contextPivot.method_10214();
            pivotZ = (float)contextPivot.method_10215();
        } else {
            PunchyClient.JumpSpringPivot pivot = PunchyClient.jumpSpringPivot();
            pivotX = pivot.x();
            pivotY = pivot.y();
            pivotZ = pivot.z();
        }
        if (left) {
            pivotX = -pivotX;
        }
        poseStack.method_46416(pivotX, pivotY, pivotZ);
        AxolotlPhysics physics = AxolotlBucketRenderer.stateFor(hand);
        PunchyClient.CameraDrift drift = PunchyClient.cameraDrift();
        physics.update(pose, left, drift);
        float pitch = physics.getPitch();
        float roll = physics.getRoll();
        if (left) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation((float)Math.PI));
        }
        if (pitch != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(pitch));
        }
        if (roll != 0.0f) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(roll));
        }
        if (left) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotation((float)Math.PI));
        }
        poseStack.method_46416(-pivotX, -pivotY, -pivotZ);
        float jumpDeformation = physics.getDeformation();
        if (Math.abs(jumpDeformation) > 0.001f) {
            float jumpSy = 1.0f + jumpDeformation;
            float jumpSxz = 1.0f - jumpDeformation * 0.5f;
            poseStack.method_22905(jumpSxz, jumpSy, jumpSxz);
        }
        HandSwayPhysics swayPhysics = HandSwayPhysics.get();
        swayPhysics.applyElasticity(poseStack, 1.0f);
        collector.method_73480(poseStack, context, light, overlay, seed, data.tintLayers, data.quads, data.renderType, data.foilType);
    }

    public void method_72175(Consumer<Vector3fc> consumer) {
    }

    @Nullable
    public LayerData extractArgument(class_1799 stack) {
        return null;
    }

    private static AxolotlPhysics stateFor(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return PHYSICS.computeIfAbsent(resolved, h -> new AxolotlPhysics());
    }

    public record LayerData(class_1268 hand, class_1921 renderType, class_10444.class_10445 foilType, int[] tintLayers, List<class_777> quads) {
    }
}

