/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.item.AnimatedBoneProxy;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.event.item.GeoItemPreRenderEvent;
import software.bernie.geckolib.renderer.internal.BoneSnapshots;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;

public final class BoneSnapshotBridge {
    private static final Set<String> TARGET_BONES = Set.of("bone_anchor_right", "bone_anchor_left", "item_anchor_point_right", "item_anchor_point_left", "item_anchor_base_right", "item_anchor_base_left");
    private static final BoneSnapshotBridge INSTANCE = new BoneSnapshotBridge();
    private static final float MIN_SLOWDOWN = 0.2f;
    private static final float SPRING_AMPLITUDE = 0.25f;
    private static final int SPRING_TICKS = 20;
    private static final int IDLE_CAPTURE_DELAY_TICKS = 2;
    private final EnumMap<class_1268, Map<String, BonePose>> lastPoseByHand = new EnumMap(class_1268.class);
    private final EnumMap<class_1268, Map<String, BonePose>> pendingPoseByHand = new EnumMap(class_1268.class);
    private final EnumMap<class_1268, TransitionBlend> blends = new EnumMap(class_1268.class);
    private final EnumMap<class_1268, Float> speedFactors = new EnumMap(class_1268.class);
    private final EnumMap<class_1268, Integer> springTicks = new EnumMap(class_1268.class);
    private final EnumMap<class_1268, Boolean> selectSuppressed = new EnumMap(class_1268.class);
    private final EnumMap<class_1268, Boolean> snapshotQueued = new EnumMap(class_1268.class);

    private BoneSnapshotBridge() {
        for (class_1268 hand : class_1268.values()) {
            this.lastPoseByHand.put(hand, new HashMap());
            this.pendingPoseByHand.put(hand, new HashMap());
            this.blends.put(hand, new TransitionBlend());
            this.speedFactors.put(hand, Float.valueOf(1.0f));
            this.springTicks.put(hand, 0);
            this.selectSuppressed.put(hand, false);
            this.snapshotQueued.put(hand, false);
        }
    }

    public static void register() {
        GeoItemPreRenderEvent.EVENT.register(event -> {
            RenderPassInfo info = event.getRenderPassInfo();
            Object item = info.renderState().getGeckolibData(DataTickets.ITEM);
            if (!(item instanceof AnimatedBoneProxy)) {
                return true;
            }
            class_1268 hand = VanillaProxyContext.getHand();
            class_1268 resolvedHand = hand == null ? class_1268.field_5808 : hand;
            info.addBoneUpdater((renderPassInfo, snapshots) -> INSTANCE.handleBoneSnapshot(resolvedHand, snapshots));
            return true;
        });
    }

    public static void queueSnapshotForNextAnimation(class_1268 hand) {
        BoneSnapshotBridge.queueSnapshotInternal(hand, 0);
    }

    public static void queueBlendToIdle(class_1268 hand) {
        BoneSnapshotBridge.queueIdleBlendFromLastPose(hand, 2);
    }

    private static void queueSnapshotInternal(class_1268 hand, int captureDelayTicks) {
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        Map<String, BonePose> current = BoneSnapshotBridge.INSTANCE.lastPoseByHand.get(hand);
        Map pending = BoneSnapshotBridge.INSTANCE.pendingPoseByHand.computeIfAbsent(hand, h -> new HashMap());
        if (BoneSnapshotBridge.INSTANCE.snapshotQueued.getOrDefault(hand, false).booleanValue()) {
            Punchy.LOGGER.debug("[BoneSnapshotBridge] skipping snapshot queue for {} (still pending)", (Object)hand);
            return;
        }
        pending.clear();
        if (current == null || current.isEmpty()) {
            Punchy.LOGGER.debug("[BoneSnapshotBridge] no captured pose available for {}, using identity fallback", (Object)hand);
            for (String bone : TARGET_BONES) {
                pending.put(bone, BonePose.identity());
            }
        } else {
            Punchy.LOGGER.debug("[BoneSnapshotBridge] queued {} bone poses for {}", (Object)current.size(), (Object)hand);
            current.forEach(pending::put);
        }
        TransitionBlend blend = BoneSnapshotBridge.INSTANCE.blends.get(hand);
        if (blend != null) {
            blend.startSnapshots(pending);
            blend.waitingForTarget = true;
            blend.active = false;
            blend.progress = 0.0f;
            blend.springScheduled = false;
            blend.targetDelayTicks = Math.max(0, captureDelayTicks);
            INSTANCE.setSpeedFactor(hand, 1.0f);
            Punchy.LOGGER.debug("[BoneSnapshotBridge] queued blend start for {}", (Object)hand);
            BoneSnapshotBridge.INSTANCE.snapshotQueued.put(hand, true);
        }
    }

    private static void queueIdleBlendFromLastPose(class_1268 hand, int captureDelayTicks) {
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        Map<String, BonePose> last = BoneSnapshotBridge.INSTANCE.lastPoseByHand.get(hand);
        HashMap<String, BonePose> start = new HashMap<String, BonePose>();
        if (last == null || last.isEmpty()) {
            for (String bone : TARGET_BONES) {
                start.put(bone, BonePose.identity());
            }
            Punchy.LOGGER.debug("[BoneSnapshotBridge] idle blend falling back to identity for {}", (Object)hand);
        } else {
            start.putAll(last);
        }
        TransitionBlend blend = BoneSnapshotBridge.INSTANCE.blends.get(hand);
        if (blend != null) {
            blend.startSnapshots(start);
            HashMap<String, BonePose> identityTarget = new HashMap<String, BonePose>();
            for (String bone : TARGET_BONES) {
                identityTarget.put(bone, BonePose.identity());
            }
            blend.targetSnapshots(identityTarget);
            blend.waitingForTarget = false;
            blend.active = true;
            blend.progress = 0.0f;
            blend.springScheduled = false;
            blend.targetDelayTicks = Math.max(0, captureDelayTicks);
            INSTANCE.setSpeedFactor(hand, 1.0f);
            Punchy.LOGGER.debug("[BoneSnapshotBridge] queued idle blend start for {}", (Object)hand);
        }
    }

    private void handleBoneSnapshot(class_1268 hand, BoneSnapshots snapshots) {
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        this.updateSpringState(hand);
        this.applyPendingSnapshot(hand, snapshots);
        this.captureCurrentPose(hand, snapshots);
        this.applyBlend(hand, snapshots);
    }

    private void applyPendingSnapshot(class_1268 hand, BoneSnapshots snapshots) {
        Map pending = this.pendingPoseByHand.computeIfAbsent(hand, h -> new HashMap());
        if (pending.isEmpty()) {
            return;
        }
        if (this.isSelectSuppressed(hand)) {
            return;
        }
        Punchy.LOGGER.debug("[BoneSnapshotBridge] applying pending pose ({} bones) for {}", (Object)pending.size(), (Object)hand);
        for (Map.Entry entry : pending.entrySet()) {
            String boneName = (String)entry.getKey();
            Punchy.LOGGER.debug("[BoneSnapshotBridge] applying bone {}", (Object)boneName);
            snapshots.get(boneName).ifPresent(snapshot -> {
                this.logBoneSnapshotState("before pending apply", hand, boneName, (BoneSnapshot)snapshot);
                ((BonePose)entry.getValue()).applyTo((BoneSnapshot)snapshot);
                this.logBoneSnapshotState("after pending apply", hand, boneName, (BoneSnapshot)snapshot);
            });
        }
        pending.clear();
        BoneSnapshotBridge.INSTANCE.snapshotQueued.put(hand, false);
    }

    private void logBoneSnapshotState(String context, class_1268 hand, String boneName, BoneSnapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        if (!"bone_anchor_right".equals(boneName) && !"item_anchor_base_right".equals(boneName)) {
            return;
        }
        class_1268 resolved = this.resolveHand(hand);
    }

    private void applyBlend(class_1268 hand, BoneSnapshots snapshots) {
        TransitionBlend blend = this.blends.get(hand);
        if (blend == null) {
            return;
        }
        if (blend.waitingForTarget) {
            for (String boneName : TARGET_BONES) {
                BonePose start = blend.startPose(boneName);
                snapshots.get(boneName).ifPresent(start::applyTo);
            }
            return;
        }
        if (!blend.active) {
            return;
        }
        if (this.isSelectSuppressed(hand)) {
            return;
        }
        float t = blend.progress / blend.durationTicks;
        if (t >= 1.0f) {
            t = 1.0f;
            blend.active = false;
            blend.waitingForTarget = false;
        }
        float eased = BoneSnapshotBridge.ease(t);
        float slowFactor = Math.max(0.2f, 1.0f - 0.8f * eased);
        this.setSpeedFactor(hand, slowFactor);
        Punchy.LOGGER.debug("[BoneSnapshotBridge] applying blend for {} (slowFactor={})", (Object)hand, (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(slowFactor)));
        for (String boneName : TARGET_BONES) {
            BonePose start = blend.startPose(boneName);
            BonePose target = blend.targetPose(boneName);
            BonePose result = start.lerp(target, eased);
            blend.recordPose(boneName, result);
            snapshots.get(boneName).ifPresent(result::applyTo);
        }
        blend.progress += 1.0f;
        Punchy.LOGGER.debug("[BoneSnapshotBridge] blend progress {} for {}", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(t)), (Object)hand);
        if (t >= 1.0f && !blend.springScheduled) {
            this.startSpring(hand);
            blend.springScheduled = true;
        }
    }

    private static float ease(float value) {
        return value < 0.5f ? 2.0f * value * value : -1.0f + (4.0f - 2.0f * value) * value;
    }

    private void captureCurrentPose(class_1268 hand, BoneSnapshots snapshots) {
        Map captured = this.lastPoseByHand.computeIfAbsent(hand, h -> new HashMap());
        for (String boneName : TARGET_BONES) {
            snapshots.get(boneName).ifPresent(snapshot -> captured.put(boneName, BonePose.from(snapshot)));
        }
        TransitionBlend blend = this.blends.get(hand);
        if (blend != null && blend.waitingForTarget) {
            if (blend.targetDelayTicks > 0) {
                --blend.targetDelayTicks;
                Punchy.LOGGER.debug("[BoneSnapshotBridge] waiting {} ticks before capturing target for {}", (Object)blend.targetDelayTicks, (Object)hand);
                return;
            }
            blend.targetSnapshots(captured);
            blend.waitingForTarget = false;
            blend.active = true;
            blend.progress = 0.0f;
            Punchy.LOGGER.debug("[BoneSnapshotBridge] started blend for {}", (Object)hand);
        }
    }

    public static void logPoseSnapshot(String context, class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        Map<String, BonePose> captured = BoneSnapshotBridge.INSTANCE.lastPoseByHand.get(resolved);
        if (captured == null || captured.isEmpty()) {
            Punchy.LOGGER.info("[BoneSnapshotBridge] {} {} has no pose yet", (Object)context, (Object)resolved);
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (String bone : TARGET_BONES) {
            BonePose pose = captured.get(bone);
            if (pose == null) continue;
            builder.append(String.format(Locale.ROOT, "%s(rot=%.2f,%.2f,%.2f trans=%.2f,%.2f,%.2f) ", bone, Float.valueOf(pose.rotX), Float.valueOf(pose.rotY), Float.valueOf(pose.rotZ), Float.valueOf(pose.posX), Float.valueOf(pose.posY), Float.valueOf(pose.posZ)));
        }
        Punchy.LOGGER.info("[BoneSnapshotBridge] {} {} pose snapshot: {}", new Object[]{context, resolved, builder});
    }

    private void updateSpringState(class_1268 hand) {
        class_1268 resolved;
        class_1268 class_12682 = resolved = hand == null ? class_1268.field_5808 : hand;
        if (this.isBlending(resolved)) {
            return;
        }
        int ticks = this.springTicks.getOrDefault(resolved, 0);
        if (ticks > 0) {
            float factor = 1.0f + 0.25f * ((float)ticks / 20.0f);
            this.setSpeedFactor(resolved, factor);
            this.springTicks.put(resolved, ticks - 1);
            if (ticks - 1 <= 0) {
                this.springTicks.put(resolved, 0);
                this.setSpeedFactor(resolved, 1.0f);
            }
        } else {
            this.setSpeedFactor(resolved, 1.0f);
        }
    }

    private boolean isBlending(class_1268 hand) {
        TransitionBlend blend = this.blends.get(hand);
        return blend != null && blend.active;
    }

    private void startSpring(class_1268 hand) {
        this.springTicks.put(hand, 20);
        Punchy.LOGGER.debug("[BoneSnapshotBridge] spring scheduled for {} ({} ticks)", (Object)hand, (Object)20);
    }

    private void setSpeedFactor(class_1268 hand, float factor) {
        this.speedFactors.put(hand, Float.valueOf(factor));
    }

    private class_1268 resolveHand(class_1268 hand) {
        return hand == null ? class_1268.field_5808 : hand;
    }

    private void setSelectSuppressed(class_1268 hand, boolean suppressed) {
        class_1268 resolved = this.resolveHand(hand);
        this.selectSuppressed.put(resolved, suppressed);
    }

    private boolean isSelectSuppressed(class_1268 hand) {
        return this.selectSuppressed.getOrDefault(this.resolveHand(hand), false);
    }

    public static void suspendBlendForSelect(class_1268 hand) {
        INSTANCE.setSelectSuppressed(hand, true);
        Punchy.LOGGER.debug("[BoneSnapshotBridge] suspend blend for {} (from select)", (Object)hand);
    }

    public static void resumeBlendAfterSelect(class_1268 hand) {
        INSTANCE.setSelectSuppressed(hand, false);
        Punchy.LOGGER.debug("[BoneSnapshotBridge] resume blend for {} (after select)", (Object)hand);
    }

    public static float transitionSpeedFactor(class_1268 hand) {
        class_1268 resolved = hand == null ? class_1268.field_5808 : hand;
        return BoneSnapshotBridge.INSTANCE.speedFactors.getOrDefault(resolved, Float.valueOf(1.0f)).floatValue();
    }

    public static void applyCurrentBlendToSnapshot(class_1268 hand, String bone, BoneSnapshot snapshot) {
        if (hand == null || bone == null || snapshot == null) {
            return;
        }
        TransitionBlend blend = BoneSnapshotBridge.INSTANCE.blends.get(hand);
        if (blend == null || !blend.active) {
            return;
        }
        BonePose pose = blend.currentPose(bone);
        if (pose != null) {
            pose.applyTo(snapshot);
        }
    }

    private static final class TransitionBlend {
        private static final float DEFAULT_DURATION = 20.0f;
        private final Map<String, BonePose> start = new HashMap<String, BonePose>();
        private final Map<String, BonePose> target = new HashMap<String, BonePose>();
        private boolean waitingForTarget = false;
        private boolean active = false;
        private float progress = 0.0f;
        private float durationTicks = 20.0f;
        private boolean springScheduled = false;
        private int targetDelayTicks = 0;
        private final Map<String, BonePose> currentPoses = new HashMap<String, BonePose>();

        private TransitionBlend() {
        }

        void startSnapshots(Map<String, BonePose> snapshots) {
            this.start.clear();
            this.start.putAll(snapshots);
            this.currentPoses.clear();
        }

        void targetSnapshots(Map<String, BonePose> snapshots) {
            this.target.clear();
            this.target.putAll(snapshots);
        }

        BonePose startPose(String bone) {
            return this.start.getOrDefault(bone, BonePose.identity());
        }

        BonePose targetPose(String bone) {
            return this.target.getOrDefault(bone, this.startPose(bone));
        }

        void recordPose(String bone, BonePose pose) {
            if (pose == null) {
                this.currentPoses.remove(bone);
            } else {
                this.currentPoses.put(bone, pose);
            }
        }

        BonePose currentPose(String bone) {
            return this.currentPoses.get(bone);
        }
    }

    private static final class BonePose {
        private final float rotX;
        private final float rotY;
        private final float rotZ;
        private final float posX;
        private final float posY;
        private final float posZ;
        private final float scaleX;
        private final float scaleY;
        private final float scaleZ;

        private BonePose(float rotX, float rotY, float rotZ, float posX, float posY, float posZ, float scaleX, float scaleY, float scaleZ) {
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
        }

        static BonePose from(BoneSnapshot snapshot) {
            if (snapshot == null) {
                return new BonePose(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            return new BonePose(snapshot.getRotX(), snapshot.getRotY(), snapshot.getRotZ(), snapshot.getTranslateX(), snapshot.getTranslateY(), snapshot.getTranslateZ(), snapshot.getScaleX(), snapshot.getScaleY(), snapshot.getScaleZ());
        }

        static BonePose identity() {
            return new BonePose(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }

        void applyTo(BoneSnapshot snapshot) {
            if (snapshot == null) {
                return;
            }
            snapshot.setRotation(this.rotX, this.rotY, this.rotZ);
            snapshot.setTranslation(this.posX, this.posY, this.posZ);
            snapshot.setScale(this.scaleX, this.scaleY, this.scaleZ);
        }

        BonePose lerp(BonePose other, float t) {
            float inv = 1.0f - t;
            return new BonePose(inv * this.rotX + t * other.rotX, inv * this.rotY + t * other.rotY, inv * this.rotZ + t * other.rotZ, inv * this.posX + t * other.posX, inv * this.posY + t * other.posY, inv * this.posZ + t * other.posZ, inv * this.scaleX + t * other.scaleX, inv * this.scaleY + t * other.scaleY, inv * this.scaleZ + t * other.scaleZ);
        }
    }
}

