/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.geo.renderer;

import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.render.anim.BoneAnimationIds;
import com.henrique.punchy.util.HandHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.internal.BoneSnapshots;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;

public class GlintAwareGeoItemRenderer<T extends class_1792>
extends GeoItemRenderer<T> {
    private boolean skipBaseMesh = false;

    public GlintAwareGeoItemRenderer(GeoModel<T> model) {
        super(model);
    }

    public GlintAwareGeoItemRenderer<T> setSkipBaseMesh(boolean skip) {
        this.skipBaseMesh = skip;
        return this;
    }

    public boolean isSkipBaseMesh() {
        return this.skipBaseMesh;
    }

    public long getInstanceId(T animatable, GeoItemRenderer.RenderData renderData) {
        class_1309 owner;
        class_1268 hand = VanillaProxyContext.getHand();
        class_1309 class_13092 = owner = renderData.itemOwner() != null ? renderData.itemOwner().method_72393() : null;
        if (hand != null && owner instanceof class_1657) {
            class_1657 player = (class_1657)owner;
            return BoneAnimationIds.compute(player, hand);
        }
        return super.getInstanceId(animatable, renderData);
    }

    public void captureDefaultRenderState(T animatable, GeoItemRenderer.RenderData renderData, GeoRenderState state, float partialTick) {
        super.captureDefaultRenderState(animatable, renderData, state, partialTick);
        boolean hasGlint = false;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1724 != null) {
            for (class_1268 hand : class_1268.values()) {
                class_1799 s = HandHelper.getConfiguredHandItem((class_1657)client.field_1724, hand);
                if (s.method_7960() || s.method_7909() != animatable || !s.method_7958()) continue;
                hasGlint = true;
                break;
            }
        }
        state.addGeckolibData(DataTickets.HAS_GLINT, (Object)hasGlint);
        state.addGeckolibData(DataTickets.IS_ENCHANTED, (Object)hasGlint);
    }

    public void adjustModelBonesForRender(RenderPassInfo<GeoRenderState> renderPassInfo, BoneSnapshots snapshots) {
        if (!this.skipBaseMesh) {
            return;
        }
        for (GeoBone bone : renderPassInfo.model().topLevelBones()) {
            this.skipBoneTree(bone, snapshots);
        }
    }

    private void skipBoneTree(GeoBone bone, BoneSnapshots snapshots) {
        snapshots.ifPresent(bone.name(), snapshot -> snapshot.skipRender(true));
        for (GeoBone child : bone.children()) {
            this.skipBoneTree(child, snapshots);
        }
    }
}

