/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.item;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.ClientBridge;
import com.henrique.punchy.client.render.BoneSnapshotBridge;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.object.LoopType;
import software.bernie.geckolib.animation.object.PlayState;
import software.bernie.geckolib.animation.state.AnimationTest;
import software.bernie.geckolib.animation.state.KeyFrameEvent;
import software.bernie.geckolib.cache.animation.keyframeevent.CustomInstructionKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.KeyFrameData;
import software.bernie.geckolib.cache.animation.keyframeevent.SoundKeyframeData;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AnimatedTool
extends class_1792
implements GeoItem {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final ThreadLocal<class_1268> NEXT_ACTION_HAND = ThreadLocal.withInitial(() -> class_1268.field_5808);
    private static final ThreadLocal<Double> NEXT_ACTIVATION_SPEED = ThreadLocal.withInitial(() -> 1.0);
    private static final ThreadLocal<Boolean> NEXT_ACTION_IS_USE = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final float SWAY_SIDEWAYS_ROTATION_DELTA = 50.0f;
    public static final String HAND_IN_CLIP = "hand_in";
    public static final String HAND_OUT_CLIP = "hand_out";
    public static final double FAST_MOVEMENT_ANIM_SPEED = 1.3;
    private static final int TRANSITION_NONE = 0;
    private static final int TRANSITION_SHORT = 0;
    private static final int TRANSITION_MEDIUM = 0;
    private static final int TRANSITION_LONG = 0;

    protected AnimatedTool(class_1792.class_1793 settings) {
        super(settings);
        SingletonGeoAnimatable.registerSyncedAnimatable((SingletonGeoAnimatable)this);
    }

    protected abstract String anim(String var1, class_1268 var2);

    public abstract void createGeoRenderer(Consumer<GeoRenderProvider> var1);

    private String animOrEmpty(String key, class_1268 hand) {
        String clip = this.anim(key, hand);
        return clip == null ? "" : clip;
    }

    public static void markNextActionHand(class_1268 hand) {
        if (hand != null) {
            NEXT_ACTION_HAND.set(hand);
        }
    }

    public static void markNextActionFromUse(boolean fromUse) {
        NEXT_ACTION_IS_USE.set(fromUse);
    }

    public static void markNextActivationSpeed(double multiplier) {
        if (multiplier == 0.0 || !Double.isFinite(multiplier)) {
            return;
        }
        NEXT_ACTIVATION_SPEED.set(multiplier);
    }

    public static void resetActivationSpeed() {
        NEXT_ACTIVATION_SPEED.set(1.0);
    }

    public static double currentActivationSpeedValue() {
        return AnimatedTool.currentActivationSpeed();
    }

    private static double currentActivationSpeed() {
        Double value = NEXT_ACTIVATION_SPEED.get();
        if (value == null || value == 0.0 || !Double.isFinite(value)) {
            NEXT_ACTIVATION_SPEED.set(1.0);
            return 1.0;
        }
        return value;
    }

    public static class_1268 currentActionHand() {
        class_1268 hand = NEXT_ACTION_HAND.get();
        return hand == null ? class_1268.field_5808 : hand;
    }

    public static boolean isCurrentActionUse() {
        Boolean flag = NEXT_ACTION_IS_USE.get();
        return flag != null && flag != false;
    }

    public static String triggerName(String base, class_1268 hand) {
        return base + (hand == class_1268.field_5810 ? "_left" : "_right");
    }

    public boolean hasMultiMiningVariants() {
        return false;
    }

    protected String activateClipKey() {
        return "mining";
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController activation = new AnimationController("Activation", 0, state -> {
            String name;
            double speed = Punchy.ANIM_SPEED * this.speedScale() * AnimatedTool.currentActivationSpeed();
            RawAnimation current = state.controller().getCurrentRawAnimation();
            if (current != null && !current.getAnimationStages().isEmpty() && (name = ((RawAnimation.Stage)current.getAnimationStages().get(0)).animationName()) != null) {
                if (name.contains("transition") || name.contains("usebrush")) {
                    speed = 1.0;
                } else if (name.equals("bucket_fill") || name.equals("bucket_throw") || name.equals("fishing")) {
                    speed = 1.0;
                } else if (name.equals("insert")) {
                    speed = 5.4;
                }
            }
            float blended = AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), (float)speed, AnimatedTool.currentActionHand());
            state.setControllerSpeed(blended);
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        activation.receiveTriggeredAnimations();
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "activate", this.activateClipKey(), true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "mining", "mining", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "attack", "attack", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "punch_attack", "punch_attack", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_forward", "sway_forward", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_forward_2", "sway_forward_2", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_forward_3", "sway_forward_3", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_sideways", "sway_sideways", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_sideways_2", "sway_sideways_2", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_sideways_3", "sway_sideways_3", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_digging", "sway_digging", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "sway_throw", "sway_throw", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "usebrush", "usebrush", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "bucket_fill", "bucket_fill", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "bucket_throw", "bucket_throw", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "fishing", "fishing", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "insert", "insert", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "flint_and_steel", "flint_and_steel", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "attack_2", "attack_2", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "attack_3", "attack_3", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "attack_mace", "attack_mace", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "trident_attack", "trident_attack", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "spear_attack", "spear_attack", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)activation, "transition", "transition", false);
        activation.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        activation.setSoundKeyframeHandler(this::onSoundKeyframe);
        controllers.add(activation);
        AnimationController consume = new AnimationController("Consume", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), 1.0f, AnimatedTool.currentActionHand()));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        consume.receiveTriggeredAnimations();
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)consume, "eat", "eat", true) | this.registerHandedAnimation((AnimationController<AnimatedTool>)consume, "drink", "drink", true)) {
            consume.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
            consume.setSoundKeyframeHandler(this::onSoundKeyframe);
            controllers.add(consume);
        }
        AnimationController inspect = new AnimationController("Inspect", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), 1.0f, AnimatedTool.handForStage(AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller()))));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        inspect.receiveTriggeredAnimations();
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)inspect, "inspect_my_item", "inspect_my_item", false)) {
            inspect.setSoundKeyframeHandler(this::onSoundKeyframe);
            inspect.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
            controllers.add(inspect);
        }
        AnimationController bowLoad = new AnimationController("BowLoad", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        bowLoad.receiveTriggeredAnimations();
        bowLoad.setAnimationSpeed(1.0);
        bowLoad.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        bowLoad.setSoundKeyframeHandler(this::onSoundKeyframe);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)bowLoad, "bow_load_bow_hand", "bow_load_bow_hand", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)bowLoad, "bow_load_arrow_hand", "bow_load_arrow_hand", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)bowLoad, "idle_stop", "idle_stop", false)) {
            controllers.add(bowLoad);
        }
        AnimationController crossbowLoad = new AnimationController("CrossbowLoad", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        crossbowLoad.receiveTriggeredAnimations();
        crossbowLoad.setAnimationSpeed(1.0);
        crossbowLoad.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        crossbowLoad.setSoundKeyframeHandler(this::onSoundKeyframe);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)crossbowLoad, "crossbow_load_crossbow_hand", "crossbow_load_crossbow_hand", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)crossbowLoad, "crossbow_load_arrow_hand", "crossbow_load_arrow_hand", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)crossbowLoad, "idle_stop", "idle_stop", false)) {
            controllers.add(crossbowLoad);
        }
        AnimationController trident = new AnimationController("Trident", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        trident.receiveTriggeredAnimations();
        trident.setAnimationSpeed(1.0);
        trident.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        trident.setSoundKeyframeHandler(this::onSoundKeyframe);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)trident, "trident_throw", "trident_throw", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)trident, "trident_throw_release", "trident_throw_release", false)) {
            controllers.add(trident);
        }
        AnimationController spearCharge = new AnimationController("SpearCharge", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), 1.0f, AnimatedTool.handForStage(AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller()))));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        spearCharge.receiveTriggeredAnimations();
        spearCharge.setAnimationSpeed(1.0);
        spearCharge.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        spearCharge.setSoundKeyframeHandler(this::onSoundKeyframe);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)spearCharge, "spear_hold", "spear_hold", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)spearCharge, "spear_release", "spear_release", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)spearCharge, "idle_stop", "idle_stop", false)) {
            controllers.add(spearCharge);
        }
        AnimationController shield = new AnimationController("Shield", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        shield.receiveTriggeredAnimations();
        shield.setAnimationSpeed(1.0);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)shield, "rise_shield", "rise_shield", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)shield, "idle_stop", "idle_stop", false)) {
            controllers.add(shield);
        }
        AnimationController shieldImpact = new AnimationController("ShieldImpact", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        shieldImpact.receiveTriggeredAnimations();
        shieldImpact.setAnimationSpeed(1.0);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)shieldImpact, "shield_hit", "shield_hit", false)) {
            controllers.add(shieldImpact);
        }
        AnimationController spyglass = new AnimationController("Spyglass", 0, state -> {
            float speed = (float)(Punchy.ANIM_SPEED * this.speedScale() * 2.0);
            state.setControllerSpeed(speed);
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        spyglass.receiveTriggeredAnimations();
        spyglass.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        spyglass.setSoundKeyframeHandler(this::onSoundKeyframe);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)spyglass, "usespyglass", "usespyglass", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)spyglass, "idle_stop", "idle_stop", false)) {
            controllers.add(spyglass);
        }
        AnimationController fallingWater = new AnimationController("FallingWater", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        fallingWater.receiveTriggeredAnimations();
        fallingWater.setAnimationSpeed(1.0);
        fallingWater.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
        AnimationController fallingWaterLoop = new AnimationController("FallingWaterLoop", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        fallingWaterLoop.receiveTriggeredAnimations();
        fallingWaterLoop.setAnimationSpeed(1.0);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)fallingWater, "falling_in_water", "falling_in_water", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)fallingWater, "idle_stop", "idle_stop", false)) {
            controllers.add(fallingWater);
        }
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)fallingWaterLoop, "falling_in_water_loop", "falling_in_water_loop", true)) {
            controllers.add(fallingWaterLoop);
        }
        AnimationController swimming = new AnimationController("Swimming", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), (float)AnimatedTool.currentActivationSpeed(), AnimatedTool.handForStage(AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller()))));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        swimming.receiveTriggeredAnimations();
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)swimming, "swiming", "swiming", true) | this.registerHandedAnimation((AnimationController<AnimatedTool>)swimming, "idle_stop", "idle_stop", false)) {
            controllers.add(swimming);
        }
        AnimationController swimStrafe = new AnimationController("SwimStrafe", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), (float)AnimatedTool.currentActivationSpeed(), AnimatedTool.handForStage(AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller()))));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        swimStrafe.receiveTriggeredAnimations();
        boolean hasStrafe = false;
        hasStrafe |= this.registerHandedAnimation((AnimationController<AnimatedTool>)swimStrafe, "swiming_left", "swiming_left", true);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)swimStrafe, "transition_to_idle_sway_sideways", "transition_to_idle_sway_sideways", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)swimStrafe, "idle_stop", "idle_stop", false);
        if (hasStrafe |= this.registerHandedAnimation((AnimationController<AnimatedTool>)swimStrafe, "swiming_right", "swiming_right", true)) {
            controllers.add(swimStrafe);
        }
        AnimationController walkOnWater = new AnimationController("WalkOnWater", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), (float)ClientBridge.hooks().walkOnWaterAnimationSpeed(), AnimatedTool.handForStage(AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller()))));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        walkOnWater.receiveTriggeredAnimations();
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)walkOnWater, "walk_on_water", "walk_on_water", true) | this.registerHandedAnimation((AnimationController<AnimatedTool>)walkOnWater, "idle_stop", "idle_stop", false)) {
            controllers.add(walkOnWater);
        }
        AnimationController jump = new AnimationController("Jump", 0, state -> {
            double speed = 1.3;
            String name = AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller());
            if (name != null && !name.isEmpty()) {
                speed = ClientBridge.hooks().jumpSpeedForClip(name);
            }
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), (float)speed, AnimatedTool.handForStage(name)));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        jump.receiveTriggeredAnimations();
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)jump, "jump", "jump", false)) {
            controllers.add(jump);
        }
        AnimationController landing = new AnimationController("Landing", 0, state -> {
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), 1.3f, AnimatedTool.handForStage(AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller()))));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        landing.receiveTriggeredAnimations();
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)landing, "landing", "landing", false)) {
            controllers.add(landing);
        }
        AnimationController fallCharge = new AnimationController("FallCharge", 0, state -> AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state));
        fallCharge.receiveTriggeredAnimations();
        fallCharge.setAnimationSpeed(1.0);
        if (this.registerHandedAnimation((AnimationController<AnimatedTool>)fallCharge, "attack_mace_charge", "attack_mace_charge", false) | this.registerHandedAnimation((AnimationController<AnimatedTool>)fallCharge, "idle_stop", "idle_stop", false)) {
            controllers.add(fallCharge);
        }
        AnimationController select = new AnimationController("Select", 0, state -> {
            double speed = 4.5;
            String name = AnimatedTool.currentStageName((AnimationController<AnimatedTool>)state.controller());
            class_1268 stageHand = AnimatedTool.handForStage(name);
            if (name != null && !name.isEmpty()) {
                class_1268 hand = name.endsWith("_left") ? class_1268.field_5810 : class_1268.field_5808;
                speed = 4.5 * PunchyClient.selectAnimationSpeedScale(hand);
            }
            state.setControllerSpeed(AnimatedTool.blendedSpeed((AnimationController<AnimatedTool>)state.controller(), (float)speed, stageHand));
            return AnimatedTool.triggeredPlayState((AnimationTest<AnimatedTool>)state);
        });
        select.receiveTriggeredAnimations();
        boolean hasSelect = false;
        if (!(hasSelect |= this.registerHandedAnimation((AnimationController<AnimatedTool>)select, HAND_IN_CLIP, HAND_IN_CLIP, false))) {
            hasSelect |= this.registerHandedAnimation((AnimationController<AnimatedTool>)select, "select", "select", false);
        }
        if (hasSelect) {
            select.setSoundKeyframeHandler(this::onSoundKeyframe);
            select.setCustomInstructionKeyframeHandler(this::onCustomInstruction);
            controllers.add(select);
        }
        this.registerHandedAnimation((AnimationController<AnimatedTool>)select, HAND_OUT_CLIP, HAND_OUT_CLIP, false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)select, "select_out", "select_out", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)select, "transition_to_idle_select", "transition_to_idle_select", false);
        this.registerHandedAnimation((AnimationController<AnimatedTool>)select, "transition_to_idle_select_out", "transition_to_idle_select_out", false);
    }

    private boolean registerHandedAnimation(AnimationController<AnimatedTool> controller, String triggerBase, String clipKey, boolean loop) {
        boolean added = false;
        added |= this.registerSingleHand(controller, triggerBase, clipKey, class_1268.field_5808, loop);
        added |= this.registerSingleHand(controller, triggerBase, clipKey, class_1268.field_5810, loop);
        for (String variant : this.animationVariants()) {
            added |= this.registerVariantHand(controller, triggerBase, clipKey, variant, class_1268.field_5808, loop);
            added |= this.registerVariantHand(controller, triggerBase, clipKey, variant, class_1268.field_5810, loop);
        }
        return added;
    }

    private boolean registerSingleHand(AnimationController<AnimatedTool> controller, String triggerBase, String clipKey, class_1268 hand, boolean loop) {
        String clip = this.animOrEmpty(clipKey, hand);
        return this.registerClip(controller, triggerBase, clip, hand, loop, this.shouldHoldOnLastFrame(triggerBase));
    }

    private boolean registerVariantHand(AnimationController<AnimatedTool> controller, String triggerBase, String clipKey, String variant, class_1268 hand, boolean loop) {
        String clip = this.clipForVariant(clipKey, variant, hand);
        if (clip == null || clip.isEmpty()) {
            return false;
        }
        return this.registerClip(controller, triggerBase + "_" + variant, clip, hand, loop, this.shouldHoldOnLastFrame(triggerBase));
    }

    private boolean registerClip(AnimationController<AnimatedTool> controller, String triggerBase, String clip, class_1268 hand, boolean loop, boolean holdOnLastFrame) {
        if (clip == null || clip.isEmpty()) {
            return false;
        }
        LoopType loopType = loop ? LoopType.LOOP : (holdOnLastFrame ? LoopType.HOLD_ON_LAST_FRAME : LoopType.PLAY_ONCE);
        String normalizedClip = AnimatedTool.normalizeClipResource(clip);
        RawAnimation animation = RawAnimation.begin().then(normalizedClip, loopType);
        controller.triggerableAnim(AnimatedTool.triggerName(triggerBase, hand), animation);
        return true;
    }

    private boolean shouldHoldOnLastFrame(String triggerBase) {
        if (triggerBase == null || triggerBase.isEmpty()) {
            return false;
        }
        if (triggerBase.startsWith("bow_load_")) {
            return true;
        }
        if (triggerBase.startsWith("crossbow_load_")) {
            return true;
        }
        if (triggerBase.startsWith("trident_throw") && !triggerBase.contains("release")) {
            return true;
        }
        if ("spear_hold".equals(triggerBase)) {
            return true;
        }
        if ("rise_shield".equals(triggerBase)) {
            return true;
        }
        if ("attack_mace_charge".equals(triggerBase)) {
            return true;
        }
        return HAND_OUT_CLIP.equals(triggerBase) || "select_out".equals(triggerBase);
    }

    protected Collection<String> animationVariants() {
        return Collections.emptyList();
    }

    protected String clipForVariant(String clipKey, String variant, class_1268 hand) {
        return "";
    }

    private static String normalizeClipResource(String clip) {
        if (clip == null) {
            return "";
        }
        return clip.trim();
    }

    protected void onCustomInstruction(KeyFrameEvent<AnimatedTool, CustomInstructionKeyframeData> event) {
        String instr = ((CustomInstructionKeyframeData)event.keyframeData()).getInstructions();
        String norm = instr == null ? "" : instr.toLowerCase().replace("[", "").replace("]", "").replace(";", "").trim();
        this.recordKeyframeEvent(event, (String)(norm.isEmpty() ? "instr" : "instr:" + norm));
        switch (norm) {
            case "impact": {
                this.handleImpactInstruction();
                break;
            }
            case "rotete_in": 
            case "rotate_in": {
                this.handleRotateInstruction(true);
                break;
            }
            case "rotete_out": 
            case "rotate_out": {
                this.handleRotateInstruction(false);
                break;
            }
            case "flip_trident": {
                this.handleFlipTridentInstruction();
                break;
            }
            case "arrow_in": {
                ClientBridge.hooks().onArrowInstruction(true);
                break;
            }
            case "arrow_out": {
                ClientBridge.hooks().onArrowInstruction(false);
                break;
            }
            case "can_start_animation": 
            case "loadstart": {
                ClientBridge.hooks().onBowAnimationGate();
                break;
            }
            case "use_now": {
                ClientBridge.hooks().onSpyglassInstruction();
                break;
            }
            case "hide_item": {
                ClientBridge.hooks().onCrossbowItemVisibility(AnimatedTool.currentActionHand(), true);
                break;
            }
            case "show_item": {
                ClientBridge.hooks().onCrossbowItemVisibility(AnimatedTool.currentActionHand(), false);
                break;
            }
            case "going_to_land": {
                this.handleGoingToLandInstruction(event);
                break;
            }
            case "arm_in": {
                this.handleFlintAndSteelArmInInstruction();
                break;
            }
            case "arm_out": {
                this.handleFlintAndSteelArmOutInstruction();
                break;
            }
            case "spark": {
                this.handleFlintAndSteelSparkInstruction();
            }
        }
    }

    private void handleRotateInstruction(boolean entering) {
        class_1268 hand = AnimatedTool.currentActionHand();
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        if (entering) {
            float delta = hand == class_1268.field_5810 ? 50.0f : -50.0f;
            ToolAnimationOverrides.setRotationOffset(hand, 0.0f, 0.0f, delta);
        } else {
            ToolAnimationOverrides.clear(hand);
        }
    }

    private void handleFlipTridentInstruction() {
    }

    private void handleGoingToLandInstruction(KeyFrameEvent<AnimatedTool, CustomInstructionKeyframeData> event) {
        class_1268 hand = AnimatedTool.currentActionHand();
        double tick = event == null ? 0.0 : event.getAnimationTick();
        ClientBridge.hooks().onJumpGoingToLand(hand, tick);
    }

    private void handleFlintAndSteelArmInInstruction() {
        class_1268 hand = AnimatedTool.currentActionHand();
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        ClientBridge.hooks().onFlintAndSteelArmIn(hand);
    }

    private void handleFlintAndSteelArmOutInstruction() {
        class_1268 hand = AnimatedTool.currentActionHand();
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        ClientBridge.hooks().onFlintAndSteelArmOut(hand);
    }

    private void handleFlintAndSteelSparkInstruction() {
        class_1268 hand = AnimatedTool.currentActionHand();
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        ClientBridge.hooks().onFlintAndSteelSpark(hand);
    }

    private void handleImpactInstruction() {
        class_1268 hand = AnimatedTool.currentActionHand();
        if (hand == null) {
            hand = class_1268.field_5808;
        }
        PunchyClient.nudgeLantern(hand, -0.65f, hand == class_1268.field_5810 ? 0.4f : -0.4f);
        ClientBridge.hooks().handleImpactInstruction(this);
    }

    private void recordKeyframeEvent(KeyFrameEvent<AnimatedTool, ? extends KeyFrameData> event, String label) {
        AnimationController controller = event.controller();
        if (controller == null) {
            return;
        }
        RawAnimation current = controller.getCurrentRawAnimation();
        if (current == null || current.getAnimationStages().isEmpty()) {
            return;
        }
        String clipName = ((RawAnimation.Stage)current.getAnimationStages().get(0)).animationName();
        String controllerName = controller.getName();
        double tick = 0.0;
        KeyFrameData data = event.keyframeData();
        if (data != null) {
            tick = data.getTime();
        }
        ClientBridge.hooks().onAnimationKeyframe(controllerName, clipName, label, tick);
    }

    protected double speedScale() {
        return 1.0;
    }

    public double getToolSpeedScale() {
        return this.speedScale();
    }

    protected void onSoundKeyframe(KeyFrameEvent<AnimatedTool, SoundKeyframeData> event) {
        class_2960 id;
        String soundId = null;
        try {
            SoundKeyframeData data = (SoundKeyframeData)event.keyframeData();
            if (data != null) {
                soundId = data.getSound();
            }
        }
        catch (Throwable ignored) {
            try {
                soundId = (String)AnimatedTool.class.getMethod("getSoundFromEvent", Object.class).invoke(null, event);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (soundId == null || soundId.isEmpty()) {
            return;
        }
        this.recordKeyframeEvent(event, "sound:" + soundId);
        try {
            id = soundId.contains(":") ? class_2960.method_12829((String)soundId) : class_2960.method_60655((String)"punchy", (String)soundId);
        }
        catch (Throwable t) {
            return;
        }
        class_3414 se = (class_3414)class_7923.field_41172.method_63535(id);
        if (se == null) {
            se = class_3414.method_47908((class_2960)id);
        }
        float vol = 1.0f;
        float pitch = (float)Math.max(0.25, Math.min(2.0, Punchy.SOUND_RATE));
        ClientBridge.hooks().playLocalSound(se, vol, pitch);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_1269.field_5811;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static String currentStageName(AnimationController<AnimatedTool> controller) {
        RawAnimation animation = controller.getCurrentRawAnimation();
        if (animation == null || animation.getAnimationStages().isEmpty()) {
            return null;
        }
        String name = ((RawAnimation.Stage)animation.getAnimationStages().get(0)).animationName();
        return name == null || name.isEmpty() ? null : name;
    }

    private static class_1268 handForStage(String stage) {
        if (stage != null && stage.endsWith("_left")) {
            return class_1268.field_5810;
        }
        return class_1268.field_5808;
    }

    private static PlayState triggeredPlayState(AnimationTest<AnimatedTool> state) {
        return state.controller().getPlayState() == PlayState.CONTINUE ? PlayState.CONTINUE : PlayState.STOP;
    }

    private static float blendedSpeed(AnimationController<AnimatedTool> controller, float baseSpeed, class_1268 hand) {
        class_1268 resolvedHand = hand == null ? AnimatedTool.currentActionHand() : hand;
        float blend = BoneSnapshotBridge.transitionSpeedFactor(resolvedHand);
        float finalSpeed = baseSpeed * blend;
        return finalSpeed;
    }
}

