/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.gui.PunchyConfigScreen;
import com.henrique.punchy.client.tuning.TuningKeybinds;
import com.henrique.punchy.command.ModCommands;
import com.henrique.punchy.config.PunchyTuningConfig;
import com.henrique.punchy.platform.ClientPlatform;
import com.henrique.punchy.platform.Platform;
import com.henrique.punchy.platform.forge.ForgeClientPlatformServices;
import com.henrique.punchy.platform.forge.ForgePlatformServices;
import com.henrique.punchy.util.OffhandMirrorGuard;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="punchy")
public final class PunchyForge {
    public PunchyForge(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        Platform.init(ForgePlatformServices.INSTANCE);
        ModCommands.register();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, parent) -> new PunchyConfigScreen((Screen)parent)));
        Punchy.ITEMS.register(modBusGroup);
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::onCommonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientPlatform.init(ForgeClientPlatformServices.INSTANCE);
            ForgeClientPlatformServices.INSTANCE.bindToModBus(modBusGroup);
            ForgeClientPlatformServices.INSTANCE.registerClientEvents();
            FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(ClientHooks::onClientSetup);
            TuningKeybinds.register();
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            OffhandMirrorGuard.initConfig(Platform.get().getConfigDirectory());
            OffhandMirrorGuard.registerTickHandler();
            Punchy.initialize();
            ForgePlatformServices.INSTANCE.finalizePayloadRegistrations();
        });
    }

    private static final class ClientHooks {
        private ClientHooks() {
        }

        private static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                PunchyClient.initialize();
                PunchyTuningConfig.loadAndApply();
            });
        }
    }
}

