/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import net.minecraft.world.InteractionHand;

public final class ArmAnimationOverrides {
    private static float forceMainHand = 0.0f;
    private static float forceOffHand = 0.0f;

    private ArmAnimationOverrides() {
    }

    public static void setForceRender(InteractionHand hand, boolean force) {
        ArmAnimationOverrides.setForceRender(hand, force ? 1.0f : 0.0f);
    }

    public static void setForceRender(InteractionHand hand, float strength) {
        if (hand == InteractionHand.OFF_HAND) {
            forceOffHand = Math.max(0.0f, Math.min(1.0f, strength));
        } else {
            forceMainHand = Math.max(0.0f, Math.min(1.0f, strength));
        }
    }

    public static void lerpForceRender(InteractionHand hand, float target, float amount) {
        float clamped = Math.max(0.0f, Math.min(1.0f, target));
        if (hand == InteractionHand.OFF_HAND) {
            forceOffHand = ArmAnimationOverrides.lerp(forceOffHand, clamped, amount);
        } else {
            forceMainHand = ArmAnimationOverrides.lerp(forceMainHand, clamped, amount);
        }
    }

    private static float lerp(float current, float target, float amount) {
        return current + (target - current) * Math.max(0.0f, Math.min(1.0f, amount));
    }

    public static boolean isForceRender(InteractionHand hand) {
        float value = hand == InteractionHand.OFF_HAND ? forceOffHand : forceMainHand;
        return value > 0.01f;
    }

    public static float forceStrength(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? forceOffHand : forceMainHand;
    }

    public static void clear(InteractionHand hand) {
        ArmAnimationOverrides.setForceRender(hand, 0.0f);
    }

    public static void clearAll() {
        forceMainHand = 0.0f;
        forceOffHand = 0.0f;
    }
}

