/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.PunchyClient;
import net.minecraft.util.Mth;

public class AxolotlPhysics {
    private final SpringAxis pitchSpring = new SpringAxis(0.08f, 0.9f, 0.1f);
    private final SpringAxis rollSpring = new SpringAxis(0.09f, 0.9f, 0.12f);
    private final SpringAxis offsetSpring = new SpringAxis(0.14f, 0.94f, 0.2f);
    private float lastDrive = 0.0f;
    private float pitch;
    private float roll;
    private float offY;

    public void update(PunchyClient.JumpSpringPose pose, boolean leftHand, PunchyClient.CameraDrift drift) {
        float rollTarget = pose.rotZ() * 0.7f;
        float pitchTarget = pose.rotX() * 0.35f - pose.rotZ() * 0.1f;
        float offsetTarget = -pose.offY() * 1.75f;
        float delta = offsetTarget - this.lastDrive;
        if (this.lastDrive < -0.01f && delta > 0.02f) {
            this.offsetSpring.impulse(-0.08f);
            this.pitchSpring.impulse(-0.04f);
        }
        if (delta < -0.035f) {
            this.offsetSpring.impulse(delta * 0.8f - 0.12f);
            this.rollSpring.impulse(delta * 0.28f);
            this.pitchSpring.impulse(-delta * 0.3f);
        } else if (delta > 0.035f) {
            this.offsetSpring.impulse(delta * 0.9f + 0.18f);
            this.rollSpring.impulse(delta * 0.42f);
            this.pitchSpring.impulse(-delta * 0.38f);
        }
        float yawImpulse = -Mth.clamp((float)drift.yawDeg(), (float)-30.0f, (float)30.0f) * 0.003f;
        float pitchImpulse = Mth.clamp((float)drift.pitchDeg(), (float)-20.0f, (float)20.0f) * 0.003f;
        float mirroredPitchImpulse = leftHand ? pitchImpulse : -pitchImpulse;
        float forwardImpulse = yawImpulse * 0.6f;
        this.rollSpring.impulse(0.0f);
        this.pitchSpring.impulse(forwardImpulse + mirroredPitchImpulse * 0.4f);
        this.offsetSpring.impulse(-forwardImpulse * 0.2f);
        this.pitch = this.pitchSpring.update(pitchTarget);
        this.roll = this.rollSpring.update(rollTarget);
        this.offY = this.offsetSpring.update(offsetTarget);
        this.lastDrive = offsetTarget;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRoll() {
        return this.roll;
    }

    public float getOffY() {
        return this.offY;
    }

    private static final class SpringAxis {
        private final float stiffness;
        private final float damping;
        private final float maxVelocity;
        private float value;
        private float velocity;

        SpringAxis(float stiffness, float damping, float maxVelocity) {
            this.stiffness = stiffness;
            this.damping = damping;
            this.maxVelocity = maxVelocity;
        }

        float update(float target) {
            float accel = (target - this.value) * this.stiffness;
            this.velocity += accel;
            this.velocity = Mth.clamp((float)this.velocity, (float)(-this.maxVelocity), (float)this.maxVelocity);
            this.velocity *= this.damping;
            this.value += this.velocity;
            float delta = target - this.value;
            if (Math.signum(this.velocity) != Math.signum(delta)) {
                this.velocity *= 0.25f;
            }
            if (Math.abs(delta) < 0.01f && Math.abs(this.velocity) < 0.01f) {
                this.value = target;
                this.velocity = 0.0f;
            }
            return this.value;
        }

        void impulse(float delta) {
            this.velocity += delta;
        }
    }
}

