/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.anim.BoneAnimationIds;
import com.henrique.punchy.item.AnimatedBoneProxy;
import com.henrique.punchy.item.AnimatedTool;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;

public final class BoneAnimationController {
    private static final String ACTIVATION = "Activation";

    private BoneAnimationController() {
    }

    private static AnimatedBoneProxy boneProxy() {
        return Punchy.boneProxy();
    }

    private static long instanceId(Player player, InteractionHand hand) {
        return BoneAnimationIds.compute(player, hand);
    }

    public static void triggerActivation(Player player, InteractionHand hand, String animation) {
        BoneAnimationController.trigger(player, hand, ACTIVATION, animation);
    }

    public static void stopActivation(Player player, InteractionHand hand, String animation) {
        BoneAnimationController.stop(player, hand, ACTIVATION, animation);
    }

    public static void trigger(Player player, InteractionHand hand, String controller, String animation) {
        AnimatedBoneProxy proxy = BoneAnimationController.boneProxy();
        if (proxy == null || player == null || animation == null || animation.isEmpty()) {
            return;
        }
        AnimationVariant variant = BoneAnimationController.resolveVariant(player, hand);
        String triggerKeyBase = BoneAnimationController.selectTriggerBase(proxy, animation, variant, hand);
        if (triggerKeyBase == null || triggerKeyBase.isEmpty()) {
            return;
        }
        long id = BoneAnimationController.instanceId(player, hand);
        String resolved = BoneAnimationController.resolvedAnimation(triggerKeyBase, hand);
        proxy.triggerAnim((Entity)player, id, controller, resolved);
        PunchyClient.onAnimationTriggered(player, hand, controller, resolved, id);
    }

    public static void stop(Player player, InteractionHand hand, String controller, String animation) {
        AnimatedBoneProxy proxy = BoneAnimationController.boneProxy();
        if (proxy == null || player == null || animation == null || animation.isEmpty()) {
            return;
        }
        AnimationVariant variant = BoneAnimationController.resolveVariant(player, hand);
        String triggerKeyBase = BoneAnimationController.selectTriggerBase(proxy, animation, variant, hand);
        if (triggerKeyBase == null || triggerKeyBase.isEmpty()) {
            return;
        }
        long id = BoneAnimationController.instanceId(player, hand);
        String resolved = BoneAnimationController.resolvedAnimation(triggerKeyBase, hand);
        proxy.stopTriggeredAnim((Entity)player, id, controller, resolved);
        PunchyClient.onAnimationStopped(player, hand, controller, resolved, id);
    }

    private static String resolvedAnimation(String animation, InteractionHand hand) {
        return AnimatedTool.triggerName(animation, hand);
    }

    private static AnimationVariant resolveVariant(Player player, InteractionHand hand) {
        if (player == null) {
            return AnimationVariant.DEFAULT;
        }
        ItemStack stack = player.getItemInHand(hand == null ? InteractionHand.MAIN_HAND : hand);
        if (stack == null || stack.isEmpty()) {
            return AnimationVariant.DEFAULT;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            return AnimationVariant.BLOCK;
        }
        if (item instanceof CrossbowItem) {
            return AnimationVariant.CROSSBOW;
        }
        if (item instanceof BowItem) {
            return AnimationVariant.BOW;
        }
        ItemUseAnimation useAnim = stack.getUseAnimation();
        if (useAnim == ItemUseAnimation.EAT || useAnim == ItemUseAnimation.DRINK) {
            return AnimationVariant.FOOD;
        }
        return AnimationVariant.DEFAULT;
    }

    private static String applyVariant(String animation, AnimationVariant variant) {
        if (variant == AnimationVariant.DEFAULT) {
            return animation;
        }
        return animation + "_" + variant.suffix();
    }

    private static String selectTriggerBase(AnimatedBoneProxy proxy, String animation, AnimationVariant variant, InteractionHand hand) {
        if (animation == null || animation.isEmpty()) {
            return "";
        }
        if (variant != AnimationVariant.DEFAULT && proxy != null && proxy.hasVariantClip(animation, variant.suffix(), hand)) {
            return BoneAnimationController.applyVariant(animation, variant);
        }
        return animation;
    }

    private static enum AnimationVariant {
        DEFAULT("default"),
        BLOCK("block"),
        FOOD("food"),
        BOW("bow"),
        CROSSBOW("crossbow");

        private final String suffix;

        private AnimationVariant(String suffix) {
            this.suffix = suffix;
        }

        public String suffix() {
            return this.suffix;
        }
    }
}

