/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public final class HandItemOverrides {
    private static ItemStack mainOverride = ItemStack.EMPTY;
    private static ItemStack offOverride = ItemStack.EMPTY;
    private static boolean hideMain = false;
    private static boolean hideOff = false;

    private HandItemOverrides() {
    }

    public static void setOverride(InteractionHand hand, ItemStack stack) {
        ItemStack copy;
        ItemStack itemStack = copy = stack == null ? ItemStack.EMPTY : stack.copy();
        if (hand == InteractionHand.OFF_HAND) {
            offOverride = copy;
        } else {
            mainOverride = copy;
        }
    }

    public static ItemStack getOverride(InteractionHand hand) {
        ItemStack stored = hand == InteractionHand.OFF_HAND ? offOverride : mainOverride;
        return stored == null ? ItemStack.EMPTY : stored;
    }

    public static boolean hasOverride(InteractionHand hand) {
        ItemStack stored = hand == InteractionHand.OFF_HAND ? offOverride : mainOverride;
        return stored != null && !stored.isEmpty();
    }

    public static void clear(InteractionHand hand) {
        HandItemOverrides.setOverride(hand, ItemStack.EMPTY);
        HandItemOverrides.setHidden(hand, false);
    }

    public static void clearAll() {
        mainOverride = ItemStack.EMPTY;
        offOverride = ItemStack.EMPTY;
        hideMain = false;
        hideOff = false;
    }

    public static void setHidden(InteractionHand hand, boolean hidden) {
        if (hand == InteractionHand.OFF_HAND) {
            hideOff = hidden;
        } else {
            hideMain = hidden;
        }
    }

    public static boolean isHidden(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? hideOff : hideMain;
    }
}

