/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public final class HandRenderState {
    private final InteractionHand hand;
    private ItemStack originalStack = ItemStack.EMPTY;
    private Object player;
    private boolean hasSpringPivot = false;
    private float springPivotX;
    private float springPivotY;
    private float springPivotZ;
    private boolean suppressSneak;
    private boolean hasItemPivot = false;
    private float itemPivotX;
    private float itemPivotY;
    private float itemPivotZ;
    private float boneExtraZ = 0.0f;

    HandRenderState(InteractionHand hand) {
        this.hand = hand;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public ItemStack getOriginalStack() {
        return this.originalStack;
    }

    public void setOriginalStack(ItemStack stack) {
        this.originalStack = stack == null ? ItemStack.EMPTY : stack;
    }

    public Object getPlayer() {
        return this.player;
    }

    public void setPlayer(Object player) {
        this.player = player;
    }

    public void clear() {
        this.originalStack = ItemStack.EMPTY;
        this.player = null;
        this.clearSpringPivot();
        this.clearItemPivot();
        this.suppressSneak = false;
        this.boneExtraZ = 0.0f;
    }

    public void setSpringPivot(float x, float y, float z) {
        this.hasSpringPivot = true;
        this.springPivotX = x;
        this.springPivotY = y;
        this.springPivotZ = z;
    }

    public void clearSpringPivot() {
        this.hasSpringPivot = false;
        this.springPivotX = 0.0f;
        this.springPivotY = 0.0f;
        this.springPivotZ = 0.0f;
    }

    public boolean hasSpringPivot() {
        return this.hasSpringPivot;
    }

    public float springPivotX() {
        return this.springPivotX;
    }

    public float springPivotY() {
        return this.springPivotY;
    }

    public float springPivotZ() {
        return this.springPivotZ;
    }

    public void setItemPivot(float x, float y, float z) {
        this.hasItemPivot = true;
        this.itemPivotX = x;
        this.itemPivotY = y;
        this.itemPivotZ = z;
    }

    public void clearItemPivot() {
        this.hasItemPivot = false;
        this.itemPivotX = 0.0f;
        this.itemPivotY = 0.0f;
        this.itemPivotZ = 0.0f;
    }

    public boolean hasItemPivot() {
        return this.hasItemPivot;
    }

    public float itemPivotX() {
        return this.itemPivotX;
    }

    public float itemPivotY() {
        return this.itemPivotY;
    }

    public float itemPivotZ() {
        return this.itemPivotZ;
    }

    public void setBoneExtraZ(float z) {
        this.boneExtraZ = z;
    }

    public float boneExtraZ() {
        return this.boneExtraZ;
    }

    public boolean isSneakSuppressed() {
        return this.suppressSneak;
    }

    public void setSneakSuppressed(boolean suppressSneak) {
        this.suppressSneak = suppressSneak;
    }
}

