/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import java.util.EnumMap;
import net.minecraft.world.InteractionHand;

public class HandSwayPhysics {
    private static final HandSwayPhysics INSTANCE = new HandSwayPhysics();
    private final EnumMap<InteractionHand, SwayState> states = new EnumMap(InteractionHand.class);

    public static HandSwayPhysics get() {
        return INSTANCE;
    }

    private HandSwayPhysics() {
        this.states.put(InteractionHand.MAIN_HAND, new SwayState());
        this.states.put(InteractionHand.OFF_HAND, new SwayState());
    }

    public void tick() {
        this.states.values().forEach(SwayState::tick);
    }

    public void trigger(InteractionHand hand) {
        if (hand == null) {
            return;
        }
        this.states.get(hand).impulse();
    }

    public float getX(InteractionHand hand) {
        return this.states.get((Object)hand).valX;
    }

    public float getY(InteractionHand hand) {
        return this.states.get((Object)hand).valY;
    }

    public float getRoll(InteractionHand hand) {
        return this.states.get((Object)hand).valRoll;
    }

    public void reset() {
        this.states.values().forEach(SwayState::reset);
    }

    private static class SwayState {
        private static final float STIFFNESS = 0.08f;
        private static final float DAMPING = 0.85f;
        private float valX;
        private float velX;
        private float valY;
        private float velY;
        private float valRoll;
        private float velRoll;
        private float direction = 1.0f;

        private SwayState() {
        }

        void tick() {
            this.velX += -this.valX * 0.08f;
            this.velX *= 0.85f;
            this.valX += this.velX;
            this.velY += -this.valY * 0.08f;
            this.velY *= 0.85f;
            this.valY += this.velY;
            this.velRoll += -this.valRoll * 0.08f;
            this.velRoll *= 0.85f;
            this.valRoll += this.velRoll;
            if (Math.abs(this.valX) < 0.001f && Math.abs(this.velX) < 0.001f) {
                this.velX = 0.0f;
                this.valX = 0.0f;
            }
            if (Math.abs(this.valY) < 0.001f && Math.abs(this.velY) < 0.001f) {
                this.velY = 0.0f;
                this.valY = 0.0f;
            }
            if (Math.abs(this.valRoll) < 0.001f && Math.abs(this.velRoll) < 0.001f) {
                this.velRoll = 0.0f;
                this.valRoll = 0.0f;
            }
        }

        void impulse() {
            this.direction = -this.direction;
            float strength = 0.01f;
            this.velX += strength * this.direction;
            this.velY += 0.02f;
            this.velRoll += -0.7f * this.direction;
        }

        void reset() {
            this.velX = 0.0f;
            this.valX = 0.0f;
            this.velY = 0.0f;
            this.valY = 0.0f;
            this.velRoll = 0.0f;
            this.valRoll = 0.0f;
            this.direction = 1.0f;
        }
    }
}

