/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class PunchyArmMeshes {
    private static final LayerDefinition WIDE_LAYER = PunchyArmMeshes.createLayer(false);
    private static final LayerDefinition SLIM_LAYER = PunchyArmMeshes.createLayer(true);

    private PunchyArmMeshes() {
    }

    public static ModelPart arm(boolean slimBody, boolean leftArm) {
        LayerDefinition layer = slimBody ? SLIM_LAYER : WIDE_LAYER;
        ModelPart root = layer.bakeRoot();
        ModelPart arm = root.getChild("arm");
        if (leftArm) {
            arm.x = -arm.x;
        }
        return arm;
    }

    private static LayerDefinition createLayer(boolean slim) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        float width = slim ? 3.0f : 4.0f;
        float height = 12.0f;
        float depth = 4.0f;
        float xOffset = -width / 2.0f;
        root.addOrReplaceChild("arm", CubeListBuilder.create().texOffs(40, 16).addBox(xOffset, -2.0f, -2.0f, width, height, depth), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }
}

