/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;

public final class ToolKindResolver {
    private static final Set<Item> REDSTONE_COMPONENTS = Set.of(Items.REDSTONE, Items.REDSTONE_BLOCK, Items.REDSTONE_TORCH, Items.REPEATER, Items.COMPARATOR, Items.REDSTONE_LAMP, Items.OBSERVER, Items.LEVER, Items.DISPENSER, Items.DROPPER, Items.NOTE_BLOCK, Items.DAYLIGHT_DETECTOR, Items.TRIPWIRE_HOOK, Items.TARGET, Items.HOPPER, Items.PISTON, Items.STICKY_PISTON, Items.LIGHTNING_ROD, Items.POWERED_RAIL, Items.DETECTOR_RAIL, Items.ACTIVATOR_RAIL, Items.SCULK_SENSOR, Items.CALIBRATED_SCULK_SENSOR);

    private ToolKindResolver() {
    }

    private static boolean isRedstoneComponent(Item item) {
        return REDSTONE_COMPONENTS.contains(item);
    }

    private static boolean isPendulumFlower(Item item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        if (id == null) {
            return false;
        }
        String path = id.getPath();
        return "pink_petals".equals(path) || "wildflowers".equals(path) || "leaf_litter".equals(path);
    }

    public static boolean isPendulumFlower(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ToolKindResolver.isPendulumFlower(stack.getItem());
    }

    private static boolean isCreatureBucket(Item item) {
        return item == Items.AXOLOTL_BUCKET || item == Items.TROPICAL_FISH_BUCKET || item == Items.PUFFERFISH_BUCKET || item == Items.COD_BUCKET || item == Items.SALMON_BUCKET || item == Items.TADPOLE_BUCKET;
    }

    private static boolean isMinecart(Item item) {
        return item instanceof MinecartItem;
    }

    private static boolean isBoat(Item item) {
        return item instanceof BoatItem;
    }

    private static boolean isButtonOrPlate(BlockItem blockItem) {
        Block block = blockItem.getBlock();
        return block instanceof ButtonBlock || block instanceof PressurePlateBlock;
    }

    private static boolean isTrapdoor(BlockItem blockItem) {
        return blockItem.getBlock() instanceof TrapDoorBlock;
    }

    private static boolean isCarpet(BlockItem blockItem) {
        return blockItem.getBlock() instanceof CarpetBlock;
    }

    private static boolean isBed(BlockItem blockItem) {
        return blockItem.getBlock() instanceof BedBlock;
    }

    public static VanillaFirstPersonItemLayer.ToolKind resolveItemKind(ItemStack stack, VanillaFirstPersonItemLayer.ToolKind fallback) {
        Item item;
        Item item2 = item = stack == null ? null : stack.getItem();
        if (item == null) {
            return fallback;
        }
        if (stack.is(ItemTags.SWORDS)) {
            return VanillaFirstPersonItemLayer.ToolKind.SWORD;
        }
        if (stack.is(ItemTags.AXES)) {
            return VanillaFirstPersonItemLayer.ToolKind.AXE;
        }
        if (stack.is(ItemTags.PICKAXES)) {
            return VanillaFirstPersonItemLayer.ToolKind.PICKAXE;
        }
        if (stack.is(ItemTags.SHOVELS)) {
            return VanillaFirstPersonItemLayer.ToolKind.SHOVEL;
        }
        if (stack.is(ItemTags.HOES)) {
            return VanillaFirstPersonItemLayer.ToolKind.HOE;
        }
        if (stack.has(DataComponents.CONSUMABLE)) {
            return VanillaFirstPersonItemLayer.ToolKind.FOOD;
        }
        if (item == Items.LANTERN || item == Items.SOUL_LANTERN) {
            return VanillaFirstPersonItemLayer.ToolKind.LANTERN;
        }
        if (ToolKindResolver.isPendulumFlower(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.FLOWER_PENDULUM;
        }
        if (ToolKindResolver.isCreatureBucket(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.CREATURE_BUCKET;
        }
        if (ToolKindResolver.isMinecart(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.MINECART;
        }
        if (ToolKindResolver.isBoat(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.BOAT;
        }
        if (item instanceof BowItem) {
            return VanillaFirstPersonItemLayer.ToolKind.BOW;
        }
        if (item == Items.ARROW) {
            return VanillaFirstPersonItemLayer.ToolKind.ARROW;
        }
        if (item instanceof FishingRodItem) {
            return VanillaFirstPersonItemLayer.ToolKind.FISHING_ROD;
        }
        if (item instanceof CrossbowItem) {
            return VanillaFirstPersonItemLayer.ToolKind.CROSSBOW;
        }
        if (item instanceof TridentItem) {
            return VanillaFirstPersonItemLayer.ToolKind.TRIDENT;
        }
        if (item instanceof ShieldItem) {
            return VanillaFirstPersonItemLayer.ToolKind.SHIELD;
        }
        if (item instanceof SpyglassItem) {
            return VanillaFirstPersonItemLayer.ToolKind.SPYGLASS;
        }
        if (item instanceof FlintAndSteelItem) {
            return VanillaFirstPersonItemLayer.ToolKind.FLINT;
        }
        if (item instanceof MaceItem) {
            return VanillaFirstPersonItemLayer.ToolKind.MACE;
        }
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.getBlock() instanceof TorchBlock) {
                return VanillaFirstPersonItemLayer.ToolKind.TORCH;
            }
            if (ToolKindResolver.isButtonOrPlate(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.BUTTON_PLATE;
            }
            if (ToolKindResolver.isTrapdoor(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.TRAPDOOR;
            }
            if (ToolKindResolver.isCarpet(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.CARPET;
            }
            if (ToolKindResolver.isBed(blockItem)) {
                return VanillaFirstPersonItemLayer.ToolKind.BED;
            }
            return VanillaFirstPersonItemLayer.ToolKind.BLOCK;
        }
        if (ToolKindResolver.isRedstoneComponent(item)) {
            return VanillaFirstPersonItemLayer.ToolKind.REDSTONE;
        }
        return VanillaFirstPersonItemLayer.ToolKind.INGREDIENT;
    }

    public static PlayerArmModelLayer.ToolKind resolveArmKind(ItemStack stack, PlayerArmModelLayer.ToolKind fallback) {
        Item item;
        Item item2 = item = stack == null ? null : stack.getItem();
        if (item == null) {
            return fallback;
        }
        if (stack.is(ItemTags.SWORDS)) {
            return PlayerArmModelLayer.ToolKind.SWORD;
        }
        if (stack.is(ItemTags.AXES)) {
            return PlayerArmModelLayer.ToolKind.AXE;
        }
        if (stack.is(ItemTags.PICKAXES)) {
            return PlayerArmModelLayer.ToolKind.PICKAXE;
        }
        if (stack.is(ItemTags.SHOVELS)) {
            return PlayerArmModelLayer.ToolKind.SHOVEL;
        }
        if (stack.is(ItemTags.HOES)) {
            return PlayerArmModelLayer.ToolKind.HOE;
        }
        if (stack.has(DataComponents.CONSUMABLE)) {
            return PlayerArmModelLayer.ToolKind.FOOD;
        }
        if (item instanceof BowItem) {
            return PlayerArmModelLayer.ToolKind.BOW;
        }
        if (item instanceof CrossbowItem) {
            return PlayerArmModelLayer.ToolKind.CROSSBOW;
        }
        if (item instanceof TridentItem) {
            return PlayerArmModelLayer.ToolKind.TRIDENT;
        }
        if (item instanceof ShieldItem) {
            return PlayerArmModelLayer.ToolKind.SHIELD;
        }
        if (item instanceof MaceItem) {
            return PlayerArmModelLayer.ToolKind.MACE;
        }
        if (item instanceof BlockItem) {
            return PlayerArmModelLayer.ToolKind.BLOCK;
        }
        if (ToolKindResolver.isPendulumFlower(item)) {
            return PlayerArmModelLayer.ToolKind.BLOCK;
        }
        return fallback;
    }
}

