/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;

public final class ArmToolTuning {
    private static Profile RIGHT_GLOBAL;
    private static Profile LEFT_GLOBAL;

    private ArmToolTuning() {
    }

    public static void resetDefaults() {
        RIGHT_GLOBAL = new Profile(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        LEFT_GLOBAL = RIGHT_GLOBAL.mirror();
    }

    public static Profile get(PlayerArmModelLayer.ToolKind kind, boolean left) {
        return ArmToolTuning.getGlobal(left);
    }

    public static Profile getGlobal(boolean left) {
        return left ? LEFT_GLOBAL : RIGHT_GLOBAL;
    }

    public static void apply(PlayerArmModelLayer.ToolKind kind, boolean left, Profile p) {
        if (p == null) {
            return;
        }
        Profile dst = ArmToolTuning.getGlobal(left);
        dst.scale = p.scale;
        dst.offX = p.offX;
        dst.offY = p.offY;
        dst.offZ = p.offZ;
        dst.rotX = p.rotX;
        dst.rotY = p.rotY;
        dst.rotZ = p.rotZ;
    }

    public static Profile snapshot(PlayerArmModelLayer.ToolKind kind, boolean left) {
        Profile s = ArmToolTuning.getGlobal(left);
        return new Profile(s.scale, s.offX, s.offY, s.offZ, s.rotX, s.rotY, s.rotZ);
    }

    public static void applyGlobal(boolean left, Profile p) {
        ArmToolTuning.apply(null, left, p);
    }

    public static Profile snapshotGlobal(boolean left) {
        return ArmToolTuning.snapshot(null, left);
    }

    static {
        ArmToolTuning.resetDefaults();
    }

    public static final class Profile {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;

        public Profile(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
        }

        public Profile mirror() {
            return new Profile(this.scale, -this.offX, this.offY, this.offZ, this.rotX, -this.rotY, -this.rotZ);
        }
    }
}

