/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.debug.AnchorDebugProbe;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.MatrixOverrideModelPart;
import com.henrique.punchy.client.render.PunchyArmMeshes;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.renderer.layer.ArmMeshTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.util.ProxyItemHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class PlayerArmModelLayer<T extends Item>
extends GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState> {
    private final String boneName;
    private final boolean leftArm;
    private final ToolKind kind;
    private final boolean matchContextHand;
    private final boolean requireOffhandItem;
    private final Predicate<ItemStack> originalFilter;
    private static long lastLogTick = -9999L;
    private static CameraType lastPerspective = null;
    private static long rearmAtTick = -1L;
    private static final EnumMap<InteractionHand, Float> extraZCache = new EnumMap(InteractionHand.class);

    static float springExtraZ(InteractionHand hand) {
        return extraZCache.getOrDefault(hand == null ? InteractionHand.MAIN_HAND : hand, Float.valueOf(0.0f)).floatValue();
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName) {
        this(renderer, boneName, false, ToolKind.AXE, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, boolean leftArm) {
        this(renderer, boneName, leftArm, ToolKind.AXE, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind) {
        this(renderer, boneName, false, kind, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, boolean leftArm, ToolKind kind) {
        this(renderer, boneName, leftArm, kind, true, true, stack -> true);
    }

    public PlayerArmModelLayer(GeoItemRenderer<T> renderer, String boneName, boolean leftArm, ToolKind kind, boolean matchContextHand, boolean requireOffhandItem, Predicate<ItemStack> originalFilter) {
        super(renderer);
        this.boneName = boneName;
        this.leftArm = leftArm;
        this.kind = kind;
        this.matchContextHand = matchContextHand;
        this.requireOffhandItem = requireOffhandItem;
        this.originalFilter = originalFilter == null ? stack -> true : originalFilter;
    }

    public void addPerBoneRender(GeoRenderState state, BakedGeoModel bakedModel, boolean includeChildren, BiConsumer<GeoBone, PerBoneRender<GeoRenderState>> consumer) {
        Optional opt = bakedModel.getBone(this.boneName);
        if (opt.isEmpty()) {
            return;
        }
        GeoBone target = (GeoBone)opt.get();
        consumer.accept(target, new PerBoneRender<GeoRenderState>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void submitRenderTask(GeoRenderState s, PoseStack matrices, GeoBone bone, SubmitNodeCollector queue, CameraRenderState camera, int light, int overlay, int unknown) {
                ItemStack filterStack;
                ItemStack off;
                InteractionHand renderHand;
                InteractionHand expectedHand;
                Minecraft client = Minecraft.getInstance();
                if (client == null || client.player == null) {
                    return;
                }
                InteractionHand contextHand = VanillaProxyContext.getHand();
                InteractionHand interactionHand = expectedHand = PlayerArmModelLayer.this.leftArm ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
                if (PlayerArmModelLayer.this.matchContextHand && contextHand != expectedHand) {
                    return;
                }
                InteractionHand interactionHand2 = renderHand = PlayerArmModelLayer.this.matchContextHand ? contextHand : expectedHand;
                if (renderHand == null) {
                    renderHand = expectedHand;
                }
                if (client.player != null && !ProxyItemHelper.requiresProxy((Player)client.player, renderHand)) {
                    return;
                }
                boolean forceRender = ArmAnimationOverrides.isForceRender(renderHand);
                if (PlayerArmModelLayer.this.leftArm && PlayerArmModelLayer.this.requireOffhandItem && !forceRender && ((off = client.player.getOffhandItem()) == null || off.isEmpty())) {
                    return;
                }
                ItemStack original = VanillaProxyContext.getOriginal();
                ItemStack itemStack = filterStack = original == null ? ItemStack.EMPTY : original;
                if (!forceRender && !PlayerArmModelLayer.this.originalFilter.test(filterStack)) {
                    return;
                }
                boolean pendulumFlower = ToolKindResolver.isPendulumFlower(filterStack);
                boolean baseLantern = !filterStack.isEmpty() && (filterStack.is(Items.LANTERN) || filterStack.is(Items.SOUL_LANTERN));
                boolean lanternLike = pendulumFlower || baseLantern;
                CameraType perspective = client.options.getCameraType();
                if (perspective != CameraType.FIRST_PERSON) {
                    lastPerspective = perspective;
                    rearmAtTick = -1L;
                    return;
                }
                lastPerspective = perspective;
                LocalPlayer player = client.player;
                ResourceLocation skinTex = null;
                boolean slim = false;
                if (!Punchy.ARM_USE_PLAYER_SKIN && Punchy.ARM_SKIN_OVERRIDE != null) {
                    skinTex = Punchy.ARM_SKIN_OVERRIDE;
                } else {
                    PlayerSkin skin = player.getSkin();
                    if (skin != null) {
                        boolean bl = slim = skin.model() == PlayerModelType.SLIM;
                        if (skin.body() != null) {
                            skinTex = skin.body().texturePath();
                        }
                    }
                }
                if (skinTex == null) {
                    ResourceLocation def = DefaultPlayerSkin.getDefaultTexture();
                    if (def != null) {
                        skinTex = def;
                    }
                    if (skinTex == null) {
                        skinTex = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(slim ? "textures/entity/player/slim/alex.png" : "textures/entity/player/wide/steve.png"));
                    }
                }
                if (skinTex == null) {
                    return;
                }
                matrices.pushPose();
                RenderSneakSuppressor.push();
                try {
                    float armScale;
                    float sneakOffset;
                    boolean hasSpringPivot;
                    InteractionHand curHand = renderHand;
                    boolean useLeft = curHand == InteractionHand.OFF_HAND;
                    ModelPart arm = PunchyArmMeshes.arm(slim, useLeft);
                    float savedPitch = arm.xRot;
                    float savedYaw = arm.yRot;
                    float savedRoll = arm.zRot;
                    arm.xRot = 0.0f;
                    arm.yRot = 0.0f;
                    arm.zRot = 0.0f;
                    PunchyClient.LanternPose lanternPose = lanternLike ? PunchyClient.lanternPhysics(renderHand) : null;
                    ArmToolTuning.Profile toolProf = ArmToolTuning.getGlobal(PlayerArmModelLayer.this.leftArm);
                    ArmMeshTuning.Profile meshProf = ArmMeshTuning.getGlobal(PlayerArmModelLayer.this.leftArm);
                    float offX = toolProf.offX + meshProf.offX;
                    float offY = toolProf.offY + meshProf.offY;
                    float offZ = toolProf.offZ + meshProf.offZ;
                    float gripBlend = PunchyClient.lanternGripBlend(curHand);
                    if (gripBlend > 0.0f) {
                        float deltaX = PunchyClient.lanternGripDeltaX(useLeft);
                        float deltaY = PunchyClient.lanternGripDeltaY();
                        float deltaZ = PunchyClient.lanternGripDeltaZ();
                        offX += deltaX * gripBlend;
                        offY += deltaY * gripBlend;
                        offZ += deltaZ * gripBlend;
                    }
                    float rotX = toolProf.rotX + meshProf.rotX;
                    float rotY = toolProf.rotY + meshProf.rotY;
                    float rotZ = toolProf.rotZ + meshProf.rotZ;
                    float tiltRad = PunchyClient.cameraTiltRadians(curHand);
                    if (tiltRad != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotation(tiltRad));
                    }
                    PunchyClient.JumpSpringPose springPose = PunchyClient.jumpSpringPose(curHand);
                    PunchyClient.JumpSpringPivot springPivot = PunchyClient.jumpSpringPivot();
                    float springPivotX = springPivot.x();
                    if (PlayerArmModelLayer.this.leftArm) {
                        springPivotX = -springPivotX;
                    }
                    float springPivotY = springPivot.y();
                    float springPivotZ = springPivot.z();
                    boolean bl = hasSpringPivot = springPivotX != 0.0f || springPivotY != 0.0f || springPivotZ != 0.0f;
                    if (hasSpringPivot) {
                        matrices.translate(springPivotX, springPivotY, springPivotZ);
                    }
                    float springPitch = springPose.rotX();
                    float springRoll = springPose.rotZ();
                    float springOffY = springPose.offY();
                    float targetExtraZ = springPitch * 0.1f;
                    if (springOffY > 0.02f) {
                        targetExtraZ += 0.1f;
                    } else if (springOffY < -0.02f) {
                        targetExtraZ -= 0.1f;
                    }
                    float prevExtra = extraZCache.getOrDefault(curHand, Float.valueOf(0.0f)).floatValue();
                    float extraZ = Mth.lerp((float)0.15f, (float)prevExtra, (float)targetExtraZ);
                    extraZCache.put(curHand, Float.valueOf(extraZ));
                    VanillaProxyContext.setBoneExtraZ(curHand, extraZ);
                    if (springPitch != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotation(springPitch));
                    }
                    if (springRoll + extraZ != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.ZP.rotation(springRoll + extraZ));
                    }
                    if (hasSpringPivot) {
                        matrices.translate(-springPivotX, -springPivotY, -springPivotZ);
                    }
                    if (springOffY != 0.0f) {
                        matrices.translate(0.0f, springOffY, 0.0f);
                    }
                    if ((sneakOffset = PunchyClient.sneakOffset(curHand)) != 0.0f) {
                        matrices.translate(0.0f, sneakOffset, 0.0f);
                    }
                    HandSwayPhysics sway = HandSwayPhysics.get();
                    float swayX = sway.getX(curHand);
                    float swayY = sway.getY(curHand);
                    float swayRoll = sway.getRoll(curHand);
                    if (swayX != 0.0f || swayY != 0.0f || swayRoll != 0.0f) {
                        matrices.translate(0.0f, swayY, swayX);
                        if (swayRoll != 0.0f) {
                            matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(swayRoll));
                        }
                    }
                    if (offX != 0.0f || offY != 0.0f || offZ != 0.0f) {
                        matrices.translate(offX, offY, offZ);
                    }
                    if (rotX != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(rotX));
                    }
                    ToolAnimationOverrides.RotationOffset rotOffset = ToolAnimationOverrides.rotationOffset(curHand);
                    float overrideRotX = (float)Math.toDegrees(rotOffset.rotXRad());
                    float overrideRotY = (float)Math.toDegrees(rotOffset.rotYRad());
                    float overrideRotZ = (float)Math.toDegrees(rotOffset.rotZRad());
                    if (overrideRotX != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(overrideRotX));
                    }
                    if (overrideRotY != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(overrideRotY));
                    }
                    if (overrideRotZ != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(overrideRotZ));
                    }
                    if (rotY != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotY));
                    }
                    if (rotZ != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(rotZ));
                    }
                    if ((armScale = toolProf.scale + (meshProf.scale - 1.0f)) != 1.0f) {
                        matrices.scale(armScale, armScale, armScale);
                    }
                    ItemStack playerHeld = player != null ? player.getItemInHand(curHand) : ItemStack.EMPTY;
                    ResourceLocation playerHeldId = playerHeld.isEmpty() ? null : BuiltInRegistries.ITEM.getKey((Object)playerHeld.getItem());
                    String playerHeldStr = playerHeldId == null ? "empty" : playerHeldId.toString();
                    boolean playerProxy = ProxyItemHelper.requiresProxy(playerHeld);
                    boolean stackEmpty = original == null || original.isEmpty();
                    Matrix4f override = new Matrix4f((Matrix4fc)matrices.last().pose());
                    ((MatrixOverrideModelPart)arm).punchy$setOverrideMatrix(override);
                    try {
                        int resolvedLight = PlayerArmModelLayer.resolveArmLight(client, (LivingEntity)player, light);
                        queue.submitModelPart(arm, matrices, RenderType.entityCutoutNoCull((ResourceLocation)skinTex), resolvedLight, overlay, null);
                        if (client.level != null) {
                            AnchorDebugProbe.sampleArm(renderHand, matrices.last(), client.level.getGameTime());
                        }
                    }
                    finally {
                        ((MatrixOverrideModelPart)arm).punchy$setOverrideMatrix(null);
                        arm.xRot = savedPitch;
                        arm.yRot = savedYaw;
                        arm.zRot = savedRoll;
                    }
                }
                finally {
                    RenderSneakSuppressor.pop();
                    matrices.popPose();
                }
            }
        });
    }

    private static int resolveArmLight(Minecraft client, LivingEntity entity, int fallback) {
        if (fallback > 0 && fallback != 0xF000F0) {
            return fallback;
        }
        if (entity == null) {
            return 0xF000F0;
        }
        Level level = entity.level();
        if (level == null) {
            return 0xF000F0;
        }
        Vec3 eye = entity.getEyePosition();
        BlockPos pos = BlockPos.containing((double)eye.x, (double)eye.y, (double)eye.z);
        int block = level.getBrightness(LightLayer.BLOCK, pos);
        block = Mth.clamp((int)block, (int)0, (int)15);
        int sky = level.getBrightness(LightLayer.SKY, pos) - level.getSkyDarken();
        sky = Mth.clamp((int)sky, (int)0, (int)15);
        return LightTexture.pack((int)block, (int)sky);
    }

    static {
        extraZCache.put(InteractionHand.MAIN_HAND, Float.valueOf(0.0f));
        extraZCache.put(InteractionHand.OFF_HAND, Float.valueOf(0.0f));
    }

    public static enum ToolKind {
        AXE,
        PICKAXE,
        HOE,
        SWORD,
        SHOVEL,
        SHIELD,
        BLOCK,
        BLOCK_DOUBLE,
        FOOD,
        BOW,
        BOW_DOUBLE,
        CROSSBOW,
        CROSSBOW_DOUBLE,
        SHUBBA_DUCK,
        MACE,
        TRIDENT;

    }
}

