/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.renderer.layer;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.debug.AnchorDebugProbe;
import com.henrique.punchy.client.render.AxolotlBucketAnimator;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.render.UseAnimationSuppressor;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateAccessor;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateLayerAccessor;
import com.henrique.punchy.util.ProxyItemHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class VanillaFirstPersonItemLayer<T extends Item>
extends GeoRenderLayer<T, GeoItemRenderer.RenderData, GeoRenderState> {
    private static final ItemStack DEBUG_PIVOT_MARKER = new ItemStack((ItemLike)Items.RED_CONCRETE);
    private static final ItemStack SPRING_PIVOT_MARKER = new ItemStack((ItemLike)Items.BLUE_CONCRETE);
    private final String anchorBoneName;
    private final String infoBoneName;
    private final ToolKind kind;
    private final Boolean leftHandGate;
    private final Predicate<ItemStack> stackFilter;
    private static boolean loggedEmptyItemMain = false;
    private static boolean loggedEmptyItemOff = false;
    private static boolean loggedNonEmptyItemMain = false;
    private static boolean loggedNonEmptyItemOff = false;
    private static ResourceLocation lastLoggedItemMainId = null;
    private static ResourceLocation lastLoggedItemOffId = null;
    private static final IdentityHashMap<GeoBone, Baseline> BASELINES = new IdentityHashMap();

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName) {
        this(renderer, boneName, boneName, ToolKind.AXE, null, null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind) {
        this(renderer, boneName, boneName, kind, null, null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind, boolean leftArm) {
        this(renderer, boneName, boneName, kind, (Boolean)leftArm, (Predicate<ItemStack>)null);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String boneName, ToolKind kind, boolean leftArm, Predicate<ItemStack> filter) {
        this(renderer, boneName, boneName, kind, (Boolean)leftArm, filter);
    }

    public VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String anchorBoneName, String infoBoneName, ToolKind kind, boolean leftArm, Predicate<ItemStack> filter) {
        this(renderer, anchorBoneName, infoBoneName, kind, (Boolean)leftArm, filter);
    }

    private VanillaFirstPersonItemLayer(GeoItemRenderer<T> renderer, String anchorBoneName, String infoBoneName, ToolKind kind, Boolean leftHandGate, Predicate<ItemStack> filter) {
        super(renderer);
        this.anchorBoneName = anchorBoneName;
        this.infoBoneName = infoBoneName == null ? anchorBoneName : infoBoneName;
        this.kind = kind;
        this.leftHandGate = leftHandGate;
        this.stackFilter = filter == null ? stack -> true : filter;
    }

    public void addPerBoneRender(GeoRenderState state, BakedGeoModel bakedModel, boolean includeChildren, BiConsumer<GeoBone, PerBoneRender<GeoRenderState>> consumer) {
        Optional anchorOpt = bakedModel.getBone(this.anchorBoneName);
        if (anchorOpt.isEmpty()) {
            return;
        }
        final Optional infoOpt = this.infoBoneName.equals(this.anchorBoneName) ? anchorOpt : bakedModel.getBone(this.infoBoneName);
        consumer.accept((GeoBone)anchorOpt.get(), new PerBoneRender<GeoRenderState>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void submitRenderTask(GeoRenderState s, PoseStack matrices, GeoBone bone, SubmitNodeCollector queue, CameraRenderState camera, int light, int overlay, int unknown) {
                InteractionHand hand = VanillaProxyContext.getHand();
                if (VanillaFirstPersonItemLayer.this.leftHandGate != null) {
                    if (VanillaFirstPersonItemLayer.this.leftHandGate.booleanValue() && hand != InteractionHand.OFF_HAND) {
                        return;
                    }
                    if (!VanillaFirstPersonItemLayer.this.leftHandGate.booleanValue() && hand != InteractionHand.MAIN_HAND) {
                        return;
                    }
                }
                InteractionHand effectiveHand = hand == null ? InteractionHand.MAIN_HAND : hand;
                boolean left = effectiveHand == InteractionHand.OFF_HAND;
                Minecraft client = Minecraft.getInstance();
                if (client != null && client.player != null && !ProxyItemHelper.requiresProxy((Player)client.player, effectiveHand)) {
                    return;
                }
                ItemStack original = VanillaProxyContext.getOriginal();
                if (original == null) {
                    original = ItemStack.EMPTY;
                }
                if (original.isEmpty()) {
                    VanillaFirstPersonItemLayer.resetNonEmptyItemLog(effectiveHand);
                } else {
                    VanillaFirstPersonItemLayer.clearEmptyItemLog(effectiveHand);
                }
                if (!VanillaFirstPersonItemLayer.this.stackFilter.test(original)) {
                    return;
                }
                if (client == null) {
                    return;
                }
                ItemModelResolver imm = client.getItemModelResolver();
                ItemStackRenderState renderState = new ItemStackRenderState();
                ItemDisplayContext ctx = left ? ItemDisplayContext.FIRST_PERSON_LEFT_HAND : ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                final ClientLevel world = client.level;
                LocalPlayer player = client.player;
                final Vec3 entityPos = Vec3.ZERO;
                ItemOwner held = new ItemOwner(){
                    final /* synthetic */ LivingEntity val$player;
                    {
                        this.val$player = livingEntity;
                    }

                    public Level level() {
                        return world;
                    }

                    public Vec3 position() {
                        return entityPos;
                    }

                    public float getVisualRotationYInDegrees() {
                        return this.val$player != null ? this.val$player.yBodyRot : 0.0f;
                    }

                    public LivingEntity asLivingEntity() {
                        return this.val$player;
                    }
                };
                boolean freezeVanillaUse = VanillaFirstPersonItemLayer.shouldFreezeVanillaUse(original, effectiveHand);
                if (freezeVanillaUse) {
                    UseAnimationSuppressor.push();
                }
                try {
                    imm.updateForTopItem(renderState, original, ctx, (Level)world, held, 0);
                }
                finally {
                    if (freezeVanillaUse) {
                        UseAnimationSuppressor.pop();
                    }
                }
                VanillaFirstPersonItemLayer.neutralizeDisplayTransforms(renderState);
                AxolotlBucketAnimator.apply(original, renderState, effectiveHand);
                RenderSneakSuppressor.push();
                try {
                    boolean showPivotDebug;
                    float sneakOffset;
                    float totalPivotZ;
                    float totalPivotY;
                    float totalPivotX;
                    boolean hasPivot;
                    PunchyClient.LanternPose pose;
                    boolean lanternLike;
                    boolean hasSpringPivot;
                    ToolKind resolvedKind = ToolKindResolver.resolveItemKind(original, VanillaFirstPersonItemLayer.this.kind);
                    ToolTuning.Profile tuning = ToolTuning.resolveProfile(original, resolvedKind, left);
                    ToolAnimationOverrides.RotationOffset overrides = ToolAnimationOverrides.rotationOffset(effectiveHand);
                    ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)original.getItem());
                    boolean logItemSample = VanillaFirstPersonItemLayer.shouldLogItemSample(effectiveHand, itemId);
                    boolean proxyItem = ProxyItemHelper.requiresProxy(original);
                    PunchyClient.JumpSpringPose springPose = PunchyClient.jumpSpringPose(effectiveHand);
                    PunchyClient.JumpSpringPivot springPivot = PunchyClient.jumpSpringPivot();
                    float springPivotRawX = springPivot.x();
                    float springPivotX = left ? -springPivotRawX : springPivotRawX;
                    float springPivotY = springPivot.y();
                    float springPivotZ = springPivot.z();
                    boolean bl = hasSpringPivot = springPivotX != 0.0f || springPivotY != 0.0f || springPivotZ != 0.0f;
                    if (hasSpringPivot) {
                        VanillaProxyContext.setSpringPivot(effectiveHand, springPivotRawX, springPivotY, springPivotZ);
                    } else {
                        VanillaProxyContext.clearSpringPivot(effectiveHand);
                    }
                    GeoBone infoBone = infoOpt.orElse(bone);
                    Baseline baseline = BASELINES.computeIfAbsent(infoBone, b -> new Baseline(b.getRotX(), b.getRotY(), b.getRotZ(), b.getPivotX() - bone.getPivotX(), b.getPivotY() - bone.getPivotY(), b.getPivotZ() - bone.getPivotZ(), b.getPosX(), b.getPosY(), b.getPosZ()));
                    float basePivotDiffX = baseline.diffX() / 16.0f;
                    float basePivotDiffY = baseline.diffY() / 16.0f;
                    float basePivotDiffZ = baseline.diffZ() / 16.0f;
                    float currPivotDiffX = (infoBone.getPivotX() - bone.getPivotX()) / 16.0f;
                    float currPivotDiffY = (infoBone.getPivotY() - bone.getPivotY()) / 16.0f;
                    float currPivotDiffZ = (infoBone.getPivotZ() - bone.getPivotZ()) / 16.0f;
                    float pivotDeltaX = currPivotDiffX - basePivotDiffX;
                    float pivotDeltaY = currPivotDiffY - basePivotDiffY;
                    float pivotDeltaZ = currPivotDiffZ - basePivotDiffZ;
                    float animOffX = (infoBone.getPosX() - baseline.posX()) / 16.0f;
                    float animOffY = (infoBone.getPosY() - baseline.posY()) / 16.0f;
                    float animOffZ = (infoBone.getPosZ() - baseline.posZ()) / 16.0f;
                    float offX = tuning.offX;
                    float offY = tuning.offY;
                    float offZ = tuning.offZ;
                    float baseOffX = offX;
                    float baseOffY = offY;
                    float baseOffZ = offZ;
                    float boneExtraZ = PlayerArmModelLayer.springExtraZ(effectiveHand);
                    float animRotXRad = infoBone.getRotX() - baseline.rotX();
                    float animRotYRad = infoBone.getRotY() - baseline.rotY();
                    float animRotZRad = infoBone.getRotZ() - baseline.rotZ();
                    float rotXRad = animRotXRad + tuning.rotXRad() + overrides.rotXRad();
                    float rotYRad = animRotYRad + tuning.rotYRad() + overrides.rotYRad();
                    float rotZRad = animRotZRad + tuning.rotZRad() + overrides.rotZRad();
                    float finalRotXDeg = (float)Math.toDegrees(rotXRad);
                    float finalRotYDeg = (float)Math.toDegrees(rotYRad);
                    float finalRotZDeg = (float)Math.toDegrees(rotZRad);
                    float animRotXDeg = (float)Math.toDegrees(animRotXRad);
                    float animRotYDeg = (float)Math.toDegrees(animRotYRad);
                    float animRotZDeg = (float)Math.toDegrees(animRotZRad);
                    float tuningRotXDeg = (float)Math.toDegrees(tuning.rotXRad());
                    float tuningRotYDeg = (float)Math.toDegrees(tuning.rotYRad());
                    float tuningRotZDeg = (float)Math.toDegrees(tuning.rotZRad());
                    float overridesRotXDeg = (float)Math.toDegrees(overrides.rotXRad());
                    float overridesRotYDeg = (float)Math.toDegrees(overrides.rotYRad());
                    float overridesRotZDeg = (float)Math.toDegrees(overrides.rotZRad());
                    float scale = tuning.scale;
                    float pivotX = tuning.pivotX;
                    float pivotY = tuning.pivotY;
                    float pivotZ = tuning.pivotZ;
                    boolean bl2 = lanternLike = resolvedKind == ToolKind.LANTERN || resolvedKind == ToolKind.FLOWER_PENDULUM;
                    if (lanternLike && (pose = PunchyClient.lanternPhysics(effectiveHand)) != null) {
                        rotXRad += pose.rotX();
                        rotYRad += pose.rotY();
                        rotZRad += pose.rotZ();
                        float blend = PunchyClient.lanternGripBlend(effectiveHand);
                        if (blend > 0.0f) {
                            offX = baseOffX + PunchyClient.lanternGripDeltaX(left) * blend;
                            offY = baseOffY + PunchyClient.lanternGripDeltaY() * blend;
                            offZ = baseOffZ + PunchyClient.lanternGripDeltaZ() * blend;
                        } else {
                            offX = baseOffX;
                            offY = baseOffY;
                            offZ = baseOffZ;
                        }
                    }
                    boolean hasInfoPivot = Math.abs(pivotDeltaX) > 1.0E-4f || Math.abs(pivotDeltaY) > 1.0E-4f || Math.abs(pivotDeltaZ) > 1.0E-4f;
                    boolean bl3 = hasPivot = Math.abs(pivotX) > 1.0E-4f || Math.abs(pivotY) > 1.0E-4f || Math.abs(pivotZ) > 1.0E-4f;
                    if (hasInfoPivot || hasPivot) {
                        totalPivotX = (hasInfoPivot ? pivotDeltaX : 0.0f) + (hasPivot ? pivotX : 0.0f);
                        totalPivotY = (hasInfoPivot ? pivotDeltaY : 0.0f) + (hasPivot ? pivotY : 0.0f);
                        totalPivotZ = (hasInfoPivot ? pivotDeltaZ : 0.0f) + (hasPivot ? pivotZ : 0.0f);
                        VanillaProxyContext.setItemPivot(effectiveHand, totalPivotX, totalPivotY, totalPivotZ);
                    } else {
                        VanillaProxyContext.clearItemPivot(effectiveHand);
                    }
                    if (hasInfoPivot || hasPivot) {
                        totalPivotX = (hasInfoPivot ? pivotDeltaX : 0.0f) + (hasPivot ? pivotX : 0.0f);
                        totalPivotY = (hasInfoPivot ? pivotDeltaY : 0.0f) + (hasPivot ? pivotY : 0.0f);
                        totalPivotZ = (hasInfoPivot ? pivotDeltaZ : 0.0f) + (hasPivot ? pivotZ : 0.0f);
                        VanillaProxyContext.setItemPivot(effectiveHand, totalPivotX, totalPivotY, totalPivotZ);
                    } else {
                        VanillaProxyContext.clearItemPivot(effectiveHand);
                    }
                    boolean hasOffset = offX != 0.0f || offY != 0.0f || offZ != 0.0f;
                    float armTilt = PunchyClient.cameraTiltRadians(effectiveHand);
                    if (armTilt != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotation(armTilt));
                    }
                    float armTiltDeg = (float)Math.toDegrees(armTilt);
                    float springPitch = springPose.rotX();
                    float springRoll = springPose.rotZ();
                    float springOffY = springPose.offY();
                    float springPitchDeg = (float)Math.toDegrees(springPitch);
                    float springRollDeg = (float)Math.toDegrees(springRoll);
                    if (hasSpringPivot) {
                        matrices.translate(springPivotX, springPivotY, springPivotZ);
                    }
                    if (Punchy.DEBUG_POSITION && hasSpringPivot) {
                        matrices.pushPose();
                        matrices.scale(0.12f, 0.12f, 0.12f);
                        ItemStackRenderState springState = new ItemStackRenderState();
                        imm.updateForTopItem(springState, SPRING_PIVOT_MARKER, ctx, (Level)world, held, 0);
                        int debugLight = VanillaFirstPersonItemLayer.resolveLight((Level)world, (LivingEntity)player, light);
                        springState.submit(matrices, queue, debugLight, OverlayTexture.NO_OVERLAY, 0);
                        matrices.popPose();
                    }
                    if (springPitch != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotation(springPitch));
                    }
                    if (springRoll + boneExtraZ != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.ZP.rotation(springRoll + boneExtraZ));
                    }
                    if (hasSpringPivot) {
                        matrices.translate(-springPivotX, -springPivotY, -springPivotZ);
                    }
                    if (springOffY != 0.0f) {
                        matrices.translate(0.0f, springOffY, 0.0f);
                    }
                    if ((sneakOffset = PunchyClient.sneakOffset(effectiveHand)) != 0.0f) {
                        matrices.translate(0.0f, sneakOffset, 0.0f);
                    }
                    HandSwayPhysics sway = HandSwayPhysics.get();
                    float swayX = sway.getX(effectiveHand);
                    float swayY = sway.getY(effectiveHand);
                    float swayRoll = sway.getRoll(effectiveHand);
                    if (swayX != 0.0f || swayY != 0.0f || swayRoll != 0.0f) {
                        matrices.translate(0.0f, swayY, swayX);
                        if (swayRoll != 0.0f) {
                            matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(swayRoll));
                        }
                    }
                    ArmToolTuning.Profile armProfile = ArmToolTuning.getGlobal(left);
                    float gripBlend = PunchyClient.lanternGripBlend(effectiveHand);
                    float armShiftX = 0.0f;
                    float armShiftY = 0.0f;
                    float armShiftZ = 0.0f;
                    float armProfileRotX = 0.0f;
                    float armProfileRotY = 0.0f;
                    float armProfileRotZ = 0.0f;
                    float armProfileScale = 1.0f;
                    if (armProfile != null) {
                        armShiftX = armProfile.offX;
                        armShiftY = armProfile.offY;
                        armShiftZ = armProfile.offZ;
                        if (gripBlend > 0.0f) {
                            float deltaX = PunchyClient.lanternGripDeltaX(left);
                            float deltaY = PunchyClient.lanternGripDeltaY();
                            float deltaZ = PunchyClient.lanternGripDeltaZ();
                            armShiftX = armProfile.offX + deltaX * gripBlend;
                            armShiftY = armProfile.offY + deltaY * gripBlend;
                            armShiftZ = armProfile.offZ + deltaZ * gripBlend;
                        }
                        if (armShiftX != 0.0f || armShiftY != 0.0f || armShiftZ != 0.0f) {
                            matrices.translate(armShiftX, armShiftY, armShiftZ);
                        }
                        armProfileRotX = armProfile.rotX;
                        armProfileRotY = armProfile.rotY;
                        armProfileRotZ = armProfile.rotZ;
                        if (armProfileRotX != 0.0f) {
                            matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(armProfileRotX));
                        }
                        if (armProfileRotY != 0.0f) {
                            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(armProfileRotY));
                        }
                        if (armProfileRotZ != 0.0f) {
                            matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(armProfileRotZ));
                        }
                        if ((armProfileScale = armProfile.scale) != 1.0f) {
                            matrices.scale(armProfileScale, armProfileScale, armProfileScale);
                        }
                    }
                    if (hasInfoPivot) {
                        matrices.translate(pivotDeltaX, pivotDeltaY, pivotDeltaZ);
                    }
                    if (hasPivot) {
                        matrices.translate(pivotX, pivotY, pivotZ);
                    }
                    if (showPivotDebug = Punchy.DEBUG_POSITION) {
                        matrices.pushPose();
                        matrices.scale(0.12f, 0.12f, 0.12f);
                        ItemStackRenderState debugState = new ItemStackRenderState();
                        imm.updateForTopItem(debugState, DEBUG_PIVOT_MARKER, ctx, (Level)world, held, 0);
                        int debugLight = VanillaFirstPersonItemLayer.resolveLight((Level)world, (LivingEntity)player, light);
                        debugState.submit(matrices, queue, debugLight, OverlayTexture.NO_OVERLAY, 0);
                        matrices.popPose();
                    }
                    if (rotZRad != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.ZP.rotation(rotZRad));
                    }
                    if (rotXRad != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.XP.rotation(rotXRad));
                    }
                    if (rotYRad != 0.0f) {
                        matrices.mulPose((Quaternionfc)Axis.YP.rotation(rotYRad));
                    }
                    float anchorOffX = animOffX;
                    float anchorOffY = animOffY;
                    float anchorOffZ = animOffZ;
                    if (hasPivot) {
                        matrices.translate(-pivotX, -pivotY, -pivotZ);
                        anchorOffX += pivotX;
                        anchorOffY += pivotY;
                        anchorOffZ += pivotZ;
                    }
                    if (hasInfoPivot) {
                        matrices.translate(-pivotDeltaX, -pivotDeltaY, -pivotDeltaZ);
                        anchorOffX += pivotDeltaX;
                        anchorOffY += pivotDeltaY;
                        anchorOffZ += pivotDeltaZ;
                    }
                    float finalOffX = anchorOffX + offX;
                    float finalOffY = anchorOffY + offY;
                    float finalOffZ = anchorOffZ + offZ;
                    if (finalOffX != 0.0f || finalOffY != 0.0f || finalOffZ != 0.0f) {
                        matrices.translate(finalOffX, finalOffY, finalOffZ);
                    }
                    if (logItemSample) {
                        String string;
                        String string2 = string = itemId == null ? "unknown" : itemId.toString();
                    }
                    if (scale != 1.0f) {
                        matrices.scale(scale, scale, scale);
                    }
                    if (client.level != null) {
                        AnchorDebugProbe.sampleItem(effectiveHand, matrices.last(), client.level.getGameTime());
                    }
                    int resolvedLight = VanillaFirstPersonItemLayer.resolveLight((Level)world, (LivingEntity)player, light);
                    renderState.submit(matrices, queue, resolvedLight, OverlayTexture.NO_OVERLAY, 0);
                }
                finally {
                    RenderSneakSuppressor.pop();
                }
            }
        });
    }

    private static void neutralizeDisplayTransforms(ItemStackRenderState renderState) {
        if (!(renderState instanceof ItemStackRenderStateAccessor)) {
            return;
        }
        ItemStackRenderStateAccessor accessor = (ItemStackRenderStateAccessor)renderState;
        ItemStackRenderState.LayerRenderState[] layers = accessor.punchy$layers();
        int count = accessor.punchy$activeLayerCount();
        if (layers == null || count <= 0) {
            return;
        }
        for (int i = 0; i < count && i < layers.length; ++i) {
            ItemStackRenderStateLayerAccessor layerAccessor;
            ItemTransform transform;
            ItemStackRenderState.LayerRenderState layer = layers[i];
            if (!(layer instanceof ItemStackRenderStateLayerAccessor) || (transform = (layerAccessor = (ItemStackRenderStateLayerAccessor)layer).punchy$transform()) == null || transform == ItemTransform.NO_TRANSFORM) continue;
            layerAccessor.punchy$setTransform(ItemTransform.NO_TRANSFORM);
        }
    }

    private static int resolveLight(Level world, LivingEntity player, int fallback) {
        if (fallback > 0 && fallback != 0xF000F0) {
            return fallback;
        }
        if (world == null || player == null) {
            return 0xF000F0;
        }
        Vec3 eye = player.getEyePosition();
        BlockPos pos = BlockPos.containing((double)eye.x, (double)eye.y, (double)eye.z);
        int block = world.getBrightness(LightLayer.BLOCK, pos);
        block = Mth.clamp((int)block, (int)0, (int)15);
        int sky = world.getBrightness(LightLayer.SKY, pos) - world.getSkyDarken();
        sky = Mth.clamp((int)sky, (int)0, (int)15);
        return LightTexture.pack((int)block, (int)sky);
    }

    private static boolean shouldFreezeVanillaUse(ItemStack stack, InteractionHand hand) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (!PunchyClient.isBowHandSuppressed(hand)) {
            return false;
        }
        if (stack.getUseAnimation() == ItemUseAnimation.BOW) {
            return true;
        }
        Item item = stack.getItem();
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    private static void resetNonEmptyItemLog(InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            loggedNonEmptyItemOff = false;
            lastLoggedItemOffId = null;
        } else {
            loggedNonEmptyItemMain = false;
            lastLoggedItemMainId = null;
        }
    }

    private static void clearEmptyItemLog(InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            loggedEmptyItemOff = false;
        } else {
            loggedEmptyItemMain = false;
        }
    }

    private static boolean shouldLogEmptyItem(InteractionHand hand) {
        boolean already;
        boolean left = hand == InteractionHand.OFF_HAND;
        boolean bl = already = left ? loggedEmptyItemOff : loggedEmptyItemMain;
        if (!already) {
            if (left) {
                loggedEmptyItemOff = true;
            } else {
                loggedEmptyItemMain = true;
            }
            return true;
        }
        return false;
    }

    private static boolean shouldLogItemSample(InteractionHand hand, ResourceLocation itemId) {
        boolean needsLog;
        boolean left = hand == InteractionHand.OFF_HAND;
        ResourceLocation lastId = left ? lastLoggedItemOffId : lastLoggedItemMainId;
        boolean alreadyLogged = left ? loggedNonEmptyItemOff : loggedNonEmptyItemMain;
        boolean bl = needsLog = !alreadyLogged || !Objects.equals(lastId, itemId);
        if (needsLog) {
            if (left) {
                loggedNonEmptyItemOff = true;
                lastLoggedItemOffId = itemId;
            } else {
                loggedNonEmptyItemMain = true;
                lastLoggedItemMainId = itemId;
            }
        }
        return needsLog;
    }

    public static enum ToolKind {
        AXE,
        PICKAXE,
        HOE,
        SWORD,
        SHOVEL,
        SHIELD,
        BLOCK,
        TORCH,
        LANTERN,
        FLOWER_PENDULUM,
        CREATURE_BUCKET,
        MINECART,
        BOAT,
        BUTTON_PLATE,
        TRAPDOOR,
        CARPET,
        BED,
        BOW,
        ARROW,
        CROSSBOW,
        SPYGLASS,
        FLINT,
        FOOD,
        SHUBBA_DUCK,
        MACE,
        TRIDENT,
        FISHING_ROD,
        REDSTONE,
        INGREDIENT;

    }

    private record Baseline(float rotX, float rotY, float rotZ, float diffX, float diffY, float diffZ, float posX, float posY, float posZ) {
    }
}

