/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.tuning;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.renderer.layer.ArmMeshTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import com.henrique.punchy.config.PunchyTuningConfig;
import com.henrique.punchy.platform.ClientPlatform;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public final class TuningKeybinds {
    private static final KeyMapping.Category CATEGORY = KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"punchy", (String)"tuning"));
    private static final VanillaFirstPersonItemLayer.ToolKind[] ITEM_KINDS = VanillaFirstPersonItemLayer.ToolKind.values();
    private static KeyMapping nextKindKey;
    private static KeyMapping prevKindKey;
    private static KeyMapping toggleTargetKey;
    private static KeyMapping toggleHandKey;
    private static KeyMapping cycleModeKey;
    private static KeyMapping cycleAxisKey;
    private static KeyMapping setAxisXKey;
    private static KeyMapping setAxisYKey;
    private static KeyMapping setAxisZKey;
    private static KeyMapping increaseKey;
    private static KeyMapping decreaseKey;
    private static KeyMapping saveKey;
    private static KeyMapping resetKey;
    private static boolean registered;
    private static Target target;
    private static Axis axis;
    private static Mode mode;
    private static InteractionHand hand;
    private static VanillaFirstPersonItemLayer.ToolKind currentKind;
    private static ResourceLocation currentItemId;

    private TuningKeybinds() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        nextKindKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.next_kind", InputConstants.Type.KEYSYM, 260, CATEGORY));
        prevKindKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.prev_kind", InputConstants.Type.KEYSYM, 268, CATEGORY));
        toggleTargetKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.toggle_target", InputConstants.Type.KEYSYM, 266, CATEGORY));
        toggleHandKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.toggle_hand", InputConstants.Type.KEYSYM, 267, CATEGORY));
        cycleModeKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.cycle_mode", InputConstants.Type.KEYSYM, 261, CATEGORY));
        cycleAxisKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.cycle_axis", InputConstants.Type.KEYSYM, 269, CATEGORY));
        setAxisXKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.axis_x", InputConstants.Type.KEYSYM, 324, CATEGORY));
        setAxisYKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.axis_y", InputConstants.Type.KEYSYM, 325, CATEGORY));
        setAxisZKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.axis_z", InputConstants.Type.KEYSYM, 326, CATEGORY));
        increaseKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.increase", InputConstants.Type.KEYSYM, 265, CATEGORY));
        decreaseKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.decrease", InputConstants.Type.KEYSYM, 264, CATEGORY));
        saveKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.save", InputConstants.Type.KEYSYM, 295, CATEGORY));
        resetKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.tuning.reset", InputConstants.Type.KEYSYM, 82, CATEGORY));
        registered = true;
    }

    public static void handleClientTick(Minecraft client) {
        boolean decreased;
        if (!registered || client == null || client.player == null) {
            return;
        }
        if (!Punchy.DEBUG_POSITION) {
            return;
        }
        TuningKeybinds.autoSelectCurrentItem(client);
        while (nextKindKey.consumeClick()) {
            TuningKeybinds.cycleKind(client, 1);
        }
        while (prevKindKey.consumeClick()) {
            TuningKeybinds.cycleKind(client, -1);
        }
        while (toggleTargetKey.consumeClick()) {
            Target[] values = Target.values();
            target = values[(target.ordinal() + 1) % values.length];
            TuningKeybinds.autoSelectCurrentItem(client);
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
        while (toggleHandKey.consumeClick()) {
            hand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            TuningKeybinds.autoSelectCurrentItem(client);
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
        while (cycleModeKey.consumeClick()) {
            mode = Mode.values()[(mode.ordinal() + 1) % Mode.values().length];
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
        while (cycleAxisKey.consumeClick()) {
            TuningKeybinds.cycleAxis(client);
        }
        if (setAxisXKey.consumeClick()) {
            TuningKeybinds.setAxis(client, Axis.X);
        }
        if (setAxisYKey.consumeClick()) {
            TuningKeybinds.setAxis(client, Axis.Y);
        }
        if (setAxisZKey.consumeClick()) {
            TuningKeybinds.setAxis(client, Axis.Z);
        }
        while (saveKey.consumeClick()) {
            PunchyTuningConfig.saveCurrent();
            TuningKeybinds.toast(client, (Component)Component.literal((String)"Saved Punchy tuning to config"));
        }
        while (resetKey.consumeClick()) {
            TuningKeybinds.resetCurrentTarget(client);
        }
        boolean increased = increaseKey.isDown() && !decreaseKey.isDown();
        boolean bl = decreased = decreaseKey.isDown() && !increaseKey.isDown();
        if (increased) {
            TuningKeybinds.applyDelta(client, true);
        } else if (decreased) {
            TuningKeybinds.applyDelta(client, false);
        }
    }

    private static void cycleKind(Minecraft client, int step) {
        if (target == Target.ITEM_KIND) {
            TuningKeybinds.toast(client, (Component)Component.literal((String)"Selecao automatica: segure o item da categoria desejada."));
        } else if (target == Target.ITEM_SPECIFIC) {
            TuningKeybinds.toast(client, (Component)Component.literal((String)"Segure o item exato que deseja editar para focar nele."));
        } else if (target == Target.ITEM_GLOBAL) {
            TuningKeybinds.toast(client, (Component)Component.literal((String)"Item global e unico; nao ha outros slots."));
        } else {
            TuningKeybinds.toast(client, (Component)Component.literal((String)"Braco e global; nao ha outros slots."));
        }
    }

    private static void cycleAxis(Minecraft client) {
        if (!TuningKeybinds.mode.usesAxis) {
            TuningKeybinds.toast(client, (Component)Component.literal((String)("Axis not used in " + TuningKeybinds.mode.label + " mode")));
            return;
        }
        axis = Axis.values()[(axis.ordinal() + 1) % Axis.values().length];
        TuningKeybinds.toast(client, TuningKeybinds.describeState());
    }

    private static void setAxis(Minecraft client, Axis desired) {
        if (!TuningKeybinds.mode.usesAxis) {
            TuningKeybinds.toast(client, (Component)Component.literal((String)("Axis not used in " + TuningKeybinds.mode.label + " mode")));
            return;
        }
        axis = desired;
        TuningKeybinds.toast(client, TuningKeybinds.describeState());
    }

    private static void applyDelta(Minecraft client, boolean positive) {
        if (mode == Mode.PIVOT && (target == Target.ARM || target == Target.ARM_MESH)) {
            TuningKeybinds.toast(client, (Component)Component.literal((String)"Pivot edits only apply to item bones"));
            return;
        }
        float delta = TuningKeybinds.computeStep(client);
        if (!positive) {
            delta *= -1.0f;
        }
        boolean leftHand = hand == InteractionHand.OFF_HAND;
        switch (target.ordinal()) {
            case 0: {
                ToolTuning.Profile profile = ToolTuning.get(currentKind, leftHand);
                AdjustmentResult result = TuningKeybinds.adjustToolProfile(profile, delta);
                if (result == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Falha ao aplicar ajuste no item selecionado."));
                    return;
                }
                ToolTuning.commitKind(currentKind, leftHand);
                ToolTuning.markKindDetached(currentKind, leftHand);
                TuningKeybinds.report(client, result);
                break;
            }
            case 1: {
                if (currentItemId == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Segure o item que deseja editar especificamente."));
                    return;
                }
                ToolTuning.Profile profile = ToolTuning.getSpecificProfile(currentItemId, currentKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Nao foi possivel preparar o perfil especifico desse item."));
                    return;
                }
                AdjustmentResult result = TuningKeybinds.adjustToolProfile(profile, delta);
                if (result == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Falha ao aplicar ajuste no item especifico."));
                    return;
                }
                TuningKeybinds.report(client, result);
                break;
            }
            case 2: {
                ToolTuning.Profile profile = ToolTuning.getGlobal(leftHand);
                AdjustmentResult result = TuningKeybinds.adjustToolProfile(profile, delta);
                if (result == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Nao foi possivel aplicar o ajuste global de item."));
                    return;
                }
                ToolTuning.commitGlobal(leftHand);
                TuningKeybinds.report(client, result);
                break;
            }
            case 3: {
                ArmToolTuning.Profile profile = ArmToolTuning.getGlobal(leftHand);
                TuningKeybinds.report(client, TuningKeybinds.adjustArmProfile(profile, delta));
                break;
            }
            case 4: {
                ArmMeshTuning.Profile profile = ArmMeshTuning.getGlobal(leftHand);
                TuningKeybinds.report(client, TuningKeybinds.adjustArmMeshProfile(profile, delta));
            }
        }
    }

    private static void resetCurrentTarget(Minecraft client) {
        boolean leftHand = hand == InteractionHand.OFF_HAND;
        switch (target.ordinal()) {
            case 0: {
                ToolTuning.Profile profile = ToolTuning.get(currentKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Nenhum perfil de item carregado."));
                    return;
                }
                TuningKeybinds.resetToolProfile(profile);
                ToolTuning.commitKind(currentKind, leftHand);
                ToolTuning.markKindAttached(currentKind, leftHand);
                TuningKeybinds.toast(client, (Component)Component.literal((String)"Offsets e rotacoes resetados para o tipo selecionado."));
                break;
            }
            case 2: {
                ToolTuning.Profile profile = ToolTuning.getGlobal(leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Nenhum perfil global de item carregado."));
                    return;
                }
                TuningKeybinds.resetToolProfile(profile);
                ToolTuning.commitGlobal(leftHand);
                TuningKeybinds.toast(client, (Component)Component.literal((String)"Offsets e rotacoes globais resetados."));
                break;
            }
            case 1: {
                if (currentItemId == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Segure o item especifico para resetar."));
                    return;
                }
                ToolTuning.Profile profile = ToolTuning.getSpecificProfile(currentItemId, currentKind, leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Nao foi possivel localizar o perfil especifico."));
                    return;
                }
                TuningKeybinds.resetToolProfile(profile);
                TuningKeybinds.toast(client, (Component)Component.literal((String)"Offsets e rotacoes do item especifico resetados."));
                break;
            }
            case 3: {
                ArmToolTuning.Profile profile = ArmToolTuning.getGlobal(leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Perfil de braco indisponivel."));
                    return;
                }
                TuningKeybinds.resetArmProfile(profile);
                TuningKeybinds.toast(client, (Component)Component.literal((String)"Offsets e rotacoes do braco resetados."));
                break;
            }
            case 4: {
                ArmMeshTuning.Profile profile = ArmMeshTuning.getGlobal(leftHand);
                if (profile == null) {
                    TuningKeybinds.toast(client, (Component)Component.literal((String)"Perfil de braco indisponivel."));
                    return;
                }
                TuningKeybinds.resetArmMeshProfile(profile);
                TuningKeybinds.toast(client, (Component)Component.literal((String)"Offsets e rotacoes do braco apenas resetados."));
            }
        }
    }

    private static void resetToolProfile(ToolTuning.Profile profile) {
        profile.offZ = 0.0f;
        profile.offY = 0.0f;
        profile.offX = 0.0f;
        profile.rotZ = 0.0f;
        profile.rotY = 0.0f;
        profile.rotX = 0.0f;
        profile.recomputeRadians();
    }

    private static void resetArmProfile(ArmToolTuning.Profile profile) {
        profile.offZ = 0.0f;
        profile.offY = 0.0f;
        profile.offX = 0.0f;
        profile.rotZ = 0.0f;
        profile.rotY = 0.0f;
        profile.rotX = 0.0f;
    }

    private static void resetArmMeshProfile(ArmMeshTuning.Profile profile) {
        profile.offZ = 0.0f;
        profile.offY = 0.0f;
        profile.offX = 0.0f;
        profile.rotZ = 0.0f;
        profile.rotY = 0.0f;
        profile.rotX = 0.0f;
    }

    private static AdjustmentResult adjustToolProfile(ToolTuning.Profile profile, float delta) {
        AdjustmentResult result = switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("offX", profile.offX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("offY", profile.offY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("offZ", profile.offZ += delta);
            }
            case 1 -> {
                AdjustmentResult v1 = switch (axis.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> new AdjustmentResult("rotX", profile.rotX += delta);
                    case 1 -> new AdjustmentResult("rotY", profile.rotY += delta);
                    case 2 -> new AdjustmentResult("rotZ", profile.rotZ += delta);
                };
                AdjustmentResult res = v1;
                profile.recomputeRadians();
                yield res;
            }
            case 2 -> {
                profile.scale = Math.max(0.01f, profile.scale + delta);
                AdjustmentResult v2 = new AdjustmentResult("scale", profile.scale);
                yield v2;
            }
            case 3 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("pivotX", profile.pivotX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("pivotY", profile.pivotY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("pivotZ", profile.pivotZ += delta);
            }
        };
        return result;
    }

    private static AdjustmentResult adjustArmProfile(ArmToolTuning.Profile profile, float delta) {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("offX", profile.offX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("offY", profile.offY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("offZ", profile.offZ += delta);
            }
            case 1 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("rotX", profile.rotX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("rotY", profile.rotY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("rotZ", profile.rotZ += delta);
            }
            case 2 -> {
                profile.scale = Math.max(0.25f, profile.scale + delta);
                AdjustmentResult v1 = new AdjustmentResult("scale", profile.scale);
                yield v1;
            }
            case 3 -> throw new IllegalStateException("Pivot editing should be gated for arms");
        };
    }

    private static AdjustmentResult adjustArmMeshProfile(ArmMeshTuning.Profile profile, float delta) {
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("offX", profile.offX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("offY", profile.offY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("offZ", profile.offZ += delta);
            }
            case 1 -> {
                switch (axis.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield new AdjustmentResult("rotX", profile.rotX += delta);
                    }
                    case 1: {
                        yield new AdjustmentResult("rotY", profile.rotY += delta);
                    }
                    case 2: 
                }
                yield new AdjustmentResult("rotZ", profile.rotZ += delta);
            }
            case 2 -> {
                profile.scale = Math.max(0.25f, profile.scale + delta);
                AdjustmentResult v1 = new AdjustmentResult("scale", profile.scale);
                yield v1;
            }
            case 3 -> throw new IllegalStateException("Pivot editing should be gated for arms");
        };
    }

    private static float computeStep(Minecraft client) {
        float base;
        switch (mode.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 3: {
                float f = 0.01f;
                break;
            }
            case 1: {
                float f = 1.0f;
                break;
            }
            case 2: {
                float f = base = 0.01f;
            }
        }
        if (client.options == null) {
            return base;
        }
        if (client.options.keySprint.isDown()) {
            base *= 5.0f;
        }
        if (client.options.keyShift.isDown()) {
            base *= 0.2f;
        }
        return base;
    }

    private static void report(Minecraft client, AdjustmentResult result) {
        if (result == null) {
            return;
        }
        TuningKeybinds.toast(client, TuningKeybinds.describeState(result));
    }

    private static Component describeState() {
        return TuningKeybinds.describeState(null);
    }

    private static Component describeState(AdjustmentResult change) {
        String selection = switch (target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> TuningKeybinds.friendlyName(currentKind.name());
            case 1 -> {
                if (currentItemId != null) {
                    yield currentItemId.toString();
                }
                yield "Nenhum item";
            }
            case 2 -> "Global item";
            case 3 -> "Global arm";
            case 4 -> "Arm mesh";
        };
        StringBuilder stringBuilder = new StringBuilder("Tuning ");
        StringBuilder sb = stringBuilder.append(switch (target.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "item";
            case 1 -> "item-specific";
            case 2 -> "item-global";
            case 3 -> "arm";
            case 4 -> "arm mesh";
        }).append(" [").append(selection).append(" | ").append(hand == InteractionHand.MAIN_HAND ? "MAIN" : "OFF").append("] ").append(TuningKeybinds.mode.label);
        if (TuningKeybinds.mode.usesAxis) {
            sb.append(" (").append(axis.name()).append(")");
        }
        if (change != null) {
            sb.append(" -> ").append(change.property).append("=").append(String.format(Locale.ROOT, "%.4f", Float.valueOf(change.value)));
        }
        return Component.literal((String)sb.toString());
    }

    private static void toast(Minecraft client, Component message) {
        if (client == null || client.player == null) {
            return;
        }
        client.gui.setOverlayMessage(message, false);
    }

    private static void autoSelectCurrentItem(Minecraft client) {
        if (target != Target.ITEM_KIND && target != Target.ITEM_SPECIFIC || client == null || client.player == null) {
            return;
        }
        ItemStack stack = client.player.getItemInHand(hand);
        VanillaFirstPersonItemLayer.ToolKind resolved = ToolKindResolver.resolveItemKind(stack, currentKind);
        boolean changed = resolved != currentKind;
        currentKind = resolved;
        if (stack == null || stack.isEmpty()) {
            if (currentItemId != null) {
                currentItemId = null;
                changed = true;
            }
        } else {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (!id.equals((Object)currentItemId)) {
                currentItemId = id;
                changed = true;
            }
        }
        if (changed) {
            TuningKeybinds.toast(client, TuningKeybinds.describeState());
        }
    }

    private static String friendlyName(String raw) {
        String lower = raw.toLowerCase(Locale.ROOT).replace('_', ' ');
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }

    static {
        registered = false;
        target = Target.ITEM_KIND;
        axis = Axis.X;
        mode = Mode.TRANSLATE;
        hand = InteractionHand.MAIN_HAND;
        currentKind = ITEM_KINDS[0];
        currentItemId = null;
    }

    private static enum Target {
        ITEM_KIND,
        ITEM_SPECIFIC,
        ITEM_GLOBAL,
        ARM,
        ARM_MESH;

    }

    private static enum Mode {
        TRANSLATE("offsets", true),
        ROTATE("rotation", true),
        SCALE("scale", false),
        PIVOT("pivot", true);

        final String label;
        final boolean usesAxis;

        private Mode(String label, boolean usesAxis) {
            this.label = label;
            this.usesAxis = usesAxis;
        }
    }

    private static enum Axis {
        X,
        Y,
        Z;

    }

    private record AdjustmentResult(String property, float value) {
    }
}

