/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.combat;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.networking.packet.ImpactAttackPayload;
import com.henrique.punchy.platform.ClientPlatform;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class ImpactClientHooks {
    private static final AtomicInteger SWING_SEQUENCE = new AtomicInteger();

    private ImpactClientHooks() {
    }

    public static void fireAttackImpact(Entity target, InteractionHand actionHand) {
        InteractionHand hand;
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.player == null || client.gameMode == null) {
            return;
        }
        if (!Punchy.USE_IMPACT_TIMING) {
            if (target != null) {
                client.gameMode.attack((Player)client.player, target);
            }
            return;
        }
        InteractionHand interactionHand = hand = actionHand != null ? actionHand : client.player.getUsedItemHand();
        if (hand == null) {
            hand = InteractionHand.MAIN_HAND;
        }
        int swingId = ImpactClientHooks.nextSwingId();
        long sentAt = System.currentTimeMillis();
        int targetId = target != null ? target.getId() : -1;
        ImpactAttackPayload payload = new ImpactAttackPayload(swingId, sentAt, hand, targetId);
        ClientPlatform.get().sendToServer(payload);
        try {
            client.player.resetAttackStrengthTicker();
            client.player.swing(hand, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int nextSwingId() {
        return SWING_SEQUENCE.updateAndGet(current -> current == Integer.MAX_VALUE ? 1 : current + 1);
    }
}

