/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.combat;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.networking.packet.ImpactAttackPayload;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public final class ImpactServer {
    private static final long MAX_LATENCY_MS = 300L;
    private static final Map<UUID, Integer> LAST_SWING = new ConcurrentHashMap<UUID, Integer>();

    private ImpactServer() {
    }

    public static void handleImpact(ServerPlayer player, ImpactAttackPayload payload) {
        if (!Punchy.USE_IMPACT_TIMING || player.isSpectator() || player.isRemoved()) {
            return;
        }
        long now = Util.getMillis();
        if (now - payload.sentAt() > 300L) {
            return;
        }
        UUID uuid = player.getUUID();
        Integer previous = LAST_SWING.put(uuid, payload.swingId());
        if (previous != null && previous.intValue() == payload.swingId()) {
            return;
        }
        Entity target = ImpactServer.resolveTarget(player, payload.targetId());
        if (target != null && ImpactServer.isValidTarget(player, target)) {
            player.attack(target);
        }
    }

    private static Entity resolveTarget(ServerPlayer player, int hintedId) {
        Entity hinted;
        ServerLevel world = player.level();
        double reach = Math.max(3.0, player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
        if (hintedId >= 0 && ImpactServer.isValidTarget(player, hinted = world.getEntity(hintedId), reach)) {
            return hinted;
        }
        return ImpactServer.raycastForEntity(player, reach);
    }

    private static boolean isValidTarget(ServerPlayer player, Entity target) {
        double reach = Math.max(3.0, player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
        return ImpactServer.isValidTarget(player, target, reach);
    }

    private static boolean isValidTarget(ServerPlayer player, Entity target, double reach) {
        if (target == null || !target.isAttackable() || target == player) {
            return false;
        }
        double maxDistance = (reach + 1.0) * (reach + 1.0);
        return player.distanceToSqr(target) <= maxDistance;
    }

    private static Entity raycastForEntity(ServerPlayer player, double reach) {
        AABB box;
        Vec3 look;
        Vec3 end;
        Vec3 start = player.getEyePosition(1.0f);
        EntityHitResult hit = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)start, (Vec3)(end = start.add((look = player.getViewVector(1.0f)).scale(reach))), (AABB)(box = player.getBoundingBox().expandTowards(look.scale(reach)).inflate(1.0)), entity -> ImpactServer.isValidTarget(player, entity, reach), (double)(reach * reach));
        return hit != null ? hit.getEntity() : null;
    }
}

