/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.henrique.punchy.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public final class PunchyConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "punchy.json";
    private boolean tapMiningEnabled = false;
    private SpeedPreset speedPreset = SpeedPreset.VANILLA;
    private boolean removeAttackCooldown = false;
    private boolean hideAttackIndicator = false;
    private boolean jumpPhysicsEnabled = true;
    private boolean debugPosition = false;
    private final Set<String> compatPacks = new LinkedHashSet<String>();
    private String compatEditTarget = "";

    public boolean isTapMiningEnabled() {
        return this.tapMiningEnabled;
    }

    public void setTapMiningEnabled(boolean tapMiningEnabled) {
        this.tapMiningEnabled = tapMiningEnabled;
    }

    public SpeedPreset getSpeedPreset() {
        return this.speedPreset;
    }

    public void setSpeedPreset(SpeedPreset speedPreset) {
        if (speedPreset != null) {
            this.speedPreset = speedPreset;
        }
    }

    public boolean isRemoveAttackCooldown() {
        return this.removeAttackCooldown;
    }

    public void setRemoveAttackCooldown(boolean removeAttackCooldown) {
        this.removeAttackCooldown = removeAttackCooldown;
    }

    public boolean isHideAttackIndicator() {
        return this.hideAttackIndicator;
    }

    public void setHideAttackIndicator(boolean hideAttackIndicator) {
        this.hideAttackIndicator = hideAttackIndicator;
    }

    public boolean isJumpPhysicsEnabled() {
        return this.jumpPhysicsEnabled;
    }

    public void setJumpPhysicsEnabled(boolean jumpPhysicsEnabled) {
        this.jumpPhysicsEnabled = jumpPhysicsEnabled;
    }

    public boolean isDebugPosition() {
        return this.debugPosition;
    }

    public void setDebugPosition(boolean debugPosition) {
        this.debugPosition = debugPosition;
    }

    public Set<String> getCompatPacks() {
        return Collections.unmodifiableSet(this.compatPacks);
    }

    public boolean isCompatPackEnabled(String id) {
        String normalized = PunchyConfig.normalizeCompatId(id);
        return !normalized.isEmpty() && this.compatPacks.contains(normalized);
    }

    public void setCompatPackEnabled(String id, boolean enabled) {
        String normalized = PunchyConfig.normalizeCompatId(id);
        if (normalized.isEmpty()) {
            return;
        }
        if (enabled) {
            this.compatPacks.add(normalized);
            this.compatEditTarget = normalized;
        } else {
            this.compatPacks.remove(normalized);
            if (this.compatEditTarget.equals(normalized)) {
                this.compatEditTarget = this.compatPacks.stream().findFirst().orElse("");
            }
        }
    }

    public String getCompatEditTarget() {
        if (!this.compatEditTarget.isEmpty() && this.compatPacks.contains(this.compatEditTarget)) {
            return this.compatEditTarget;
        }
        this.compatEditTarget = this.compatPacks.stream().findFirst().orElse("");
        return this.compatEditTarget;
    }

    public void setCompatEditTarget(String id) {
        String normalized = PunchyConfig.normalizeCompatId(id);
        if (normalized.isEmpty()) {
            this.compatEditTarget = "";
        } else if (this.compatPacks.contains(normalized)) {
            this.compatEditTarget = normalized;
        }
    }

    private static String normalizeCompatId(String id) {
        return id == null ? "" : id.trim().toLowerCase(Locale.ROOT);
    }

    private void migrateLegacyCompatIds() {
        if (this.compatPacks.remove("tool_and_utils")) {
            this.compatPacks.add("items_compat");
            if ("tool_and_utils".equals(this.compatEditTarget)) {
                this.compatEditTarget = "items_compat";
            }
        }
    }

    public static PunchyConfig load() {
        block19: {
            PunchyConfig punchyConfig;
            File cfg2 = PunchyConfig.getFile();
            if (!cfg2.exists()) break block19;
            FileReader r = new FileReader(cfg2);
            try {
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)r, JsonObject.class);
                PunchyConfig config = new PunchyConfig();
                if (obj != null) {
                    if (obj.has("tapMiningEnabled")) {
                        config.tapMiningEnabled = obj.get("tapMiningEnabled").getAsBoolean();
                    }
                    if (obj.has("speedPreset")) {
                        config.speedPreset = SpeedPreset.fromName(obj.get("speedPreset").getAsString());
                    }
                    if (obj.has("removeAttackCooldown")) {
                        config.removeAttackCooldown = obj.get("removeAttackCooldown").getAsBoolean();
                    }
                    if (obj.has("hideAttackIndicator")) {
                        config.hideAttackIndicator = obj.get("hideAttackIndicator").getAsBoolean();
                    }
                    if (obj.has("jumpPhysicsEnabled")) {
                        config.jumpPhysicsEnabled = obj.get("jumpPhysicsEnabled").getAsBoolean();
                    }
                    if (obj.has("debugPosition")) {
                        config.debugPosition = obj.get("debugPosition").getAsBoolean();
                    }
                    if (obj.has("compatPacks") && obj.get("compatPacks").isJsonArray()) {
                        JsonArray array = obj.getAsJsonArray("compatPacks");
                        for (JsonElement element : array) {
                            String id;
                            if (!element.isJsonPrimitive() || (id = PunchyConfig.normalizeCompatId(element.getAsString())).isEmpty()) continue;
                            config.compatPacks.add(id);
                        }
                    } else {
                        String id;
                        boolean legacyEnabled;
                        boolean bl = legacyEnabled = obj.has("compatTuningEnabled") && obj.get("compatTuningEnabled").getAsBoolean();
                        if (legacyEnabled && obj.has("compatProfile") && !(id = PunchyConfig.normalizeCompatId(obj.get("compatProfile").getAsString())).isEmpty()) {
                            config.compatPacks.add(id);
                        }
                    }
                    if (obj.has("compatEditTarget")) {
                        config.compatEditTarget = PunchyConfig.normalizeCompatId(obj.get("compatEditTarget").getAsString());
                    }
                }
                config.migrateLegacyCompatIds();
                punchyConfig = config;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception cfg2) {
                    // empty catch block
                }
            }
            r.close();
            return punchyConfig;
        }
        PunchyConfig config = new PunchyConfig();
        config.migrateLegacyCompatIds();
        return config;
    }

    public void save() {
        try {
            File cfg = PunchyConfig.getFile();
            if (!cfg.getParentFile().exists()) {
                cfg.getParentFile().mkdirs();
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("tapMiningEnabled", Boolean.valueOf(this.tapMiningEnabled));
            obj.addProperty("speedPreset", this.speedPreset.name());
            obj.addProperty("removeAttackCooldown", Boolean.valueOf(this.removeAttackCooldown));
            obj.addProperty("hideAttackIndicator", Boolean.valueOf(this.hideAttackIndicator));
            obj.addProperty("jumpPhysicsEnabled", Boolean.valueOf(this.jumpPhysicsEnabled));
            obj.addProperty("debugPosition", Boolean.valueOf(this.debugPosition));
            JsonArray compatArray = new JsonArray();
            for (String id : this.compatPacks) {
                compatArray.add(id);
            }
            obj.add("compatPacks", (JsonElement)compatArray);
            obj.addProperty("compatEditTarget", this.getCompatEditTarget());
            try (FileWriter w = new FileWriter(cfg);){
                GSON.toJson((JsonElement)obj, (Appendable)w);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static File getFile() {
        Path configDirPath = Platform.get().getConfigDirectory();
        Path punchyConfigDir = configDirPath.resolve("punchy");
        try {
            Files.createDirectories(punchyConfigDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return punchyConfigDir.resolve(FILE_NAME).toFile();
    }

    public static enum SpeedPreset {
        VANILLA(6.3, "preset.punchy.vanilla"),
        PUNCHYA(6.3, "preset.punchy.punchya");

        public final double speed;
        private final String translationKey;

        private SpeedPreset(double speed, String translationKey) {
            this.speed = speed;
            this.translationKey = translationKey;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public static SpeedPreset fromName(String n) {
            if (n != null) {
                if (n.equalsIgnoreCase("REALISTIC")) {
                    return VANILLA;
                }
                if (n.equalsIgnoreCase("ORIGINAL") || n.equalsIgnoreCase("DEBUG")) {
                    return PUNCHYA;
                }
                for (SpeedPreset preset : SpeedPreset.values()) {
                    if (!preset.name().equalsIgnoreCase(n)) continue;
                    return preset;
                }
            }
            return PUNCHYA;
        }
    }
}

