/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.render.ToolTuning;
import com.henrique.punchy.client.renderer.layer.ArmMeshTuning;
import com.henrique.punchy.client.renderer.layer.ArmToolTuning;
import com.henrique.punchy.client.renderer.layer.PlayerArmModelLayer;
import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import com.henrique.punchy.platform.Platform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public final class PunchyTuningConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String FILE_NAME = "punchy_tuning.json";
    private static final ResourceLocation DEFAULTS_ID = ResourceLocation.fromNamespaceAndPath((String)"punchy", (String)"default_tuning.json");
    private static final String COMPAT_DIR_NAME = "punchy/compat";
    private static final float EPSILON = 1.0E-6f;
    private static final String[] BUNDLED_COMPAT_PROFILES = new String[]{"items_compat"};
    private static final String ARM_MESH_SIDE_KEY = "global";
    private static Data BASELINE_STATE;

    private PunchyTuningConfig() {
    }

    private static File getFile() {
        Path configDir = Platform.get().getConfigDirectory();
        if (configDir == null) {
            Minecraft client = Minecraft.getInstance();
            configDir = client != null ? client.gameDirectory.toPath().resolve("config") : Path.of("config", new String[0]);
        }
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configDir.resolve("punchy").resolve(FILE_NAME).toFile();
    }

    public static void loadAndApply() {
        try {
            Data defaults = PunchyTuningConfig.loadDefaultsFromResource();
            if (defaults != null) {
                PunchyTuningConfig.saveData(defaults);
                ToolTuning.resetAttachments();
                ToolTuning.clearSpecifics();
                PunchyTuningConfig.applyData(defaults);
                PunchyTuningConfig.rememberBaseline();
                PunchyTuningConfig.applyCompatOverlays();
                return;
            }
            Data data = null;
            File file = PunchyTuningConfig.getFile();
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    data = (Data)GSON.fromJson((Reader)reader, Data.class);
                }
            }
            if (data != null) {
                ToolTuning.resetAttachments();
                ToolTuning.clearSpecifics();
                PunchyTuningConfig.applyData(data);
                PunchyTuningConfig.rememberBaseline();
                PunchyTuningConfig.applyCompatOverlays();
            } else {
                BASELINE_STATE = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Data loadDefaultsFromResource() {
        try {
            Resource res;
            InputStream stream = null;
            Minecraft client = Minecraft.getInstance();
            if (client != null && (res = (Resource)client.getResourceManager().getResource(DEFAULTS_ID).orElse(null)) != null) {
                stream = res.open();
            }
            if (stream == null) {
                stream = PunchyTuningConfig.class.getResourceAsStream("/assets/punchy/default_tuning.json");
            }
            if (stream == null) {
                return null;
            }
            try (InputStream in = stream;){
                Data data;
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    data = (Data)GSON.fromJson((Reader)reader, Data.class);
                }
                return data;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void applyData(Data data) {
        SideSet meshSet;
        SideSet globalItem;
        if (data == null) {
            return;
        }
        if (data.item == null) {
            data.item = new HashMap<String, SideSet>();
        }
        if ((globalItem = PunchyTuningConfig.resolveGlobalItem(data)) != null) {
            if (globalItem.right != null) {
                ToolTuning.applyGlobal(false, globalItem.right.toTool());
            }
            if (globalItem.left != null) {
                ToolTuning.applyGlobal(true, globalItem.left.toTool());
            }
        }
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            SideSet set = data.item.get(kind.name());
            if (set == null) continue;
            if (set.right != null) {
                ToolTuning.apply(kind, false, set.right.toTool());
                ToolTuning.markKindDetached(kind, false);
            }
            if (set.left == null) continue;
            ToolTuning.apply(kind, true, set.left.toTool());
            ToolTuning.markKindDetached(kind, true);
        }
        SideSet globalArm = PunchyTuningConfig.resolveGlobalArm(data);
        if (globalArm != null) {
            if (globalArm.right != null) {
                ArmToolTuning.applyGlobal(false, globalArm.right.toArm());
            }
            if (globalArm.left != null) {
                ArmToolTuning.applyGlobal(true, globalArm.left.toArm());
            }
            ArmMeshTuning.resetGlobal(false);
            ArmMeshTuning.resetGlobal(true);
        }
        if (data.armMesh != null && (meshSet = data.armMesh.get(ARM_MESH_SIDE_KEY)) != null) {
            if (meshSet.right != null) {
                ArmMeshTuning.applyGlobal(false, meshSet.right.toArmMesh());
            }
            if (meshSet.left != null) {
                ArmMeshTuning.applyGlobal(true, meshSet.left.toArmMesh());
            }
        }
        if (data.itemSpecific != null) {
            for (Map.Entry<String, SpecificEntry> entry : data.itemSpecific.entrySet()) {
                VanillaFirstPersonItemLayer.ToolKind kind;
                ResourceLocation id;
                if (entry == null || entry.getValue() == null || entry.getValue().kind == null || (id = ResourceLocation.tryParse((String)entry.getKey())) == null) continue;
                try {
                    kind = VanillaFirstPersonItemLayer.ToolKind.valueOf(entry.getValue().kind);
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                SideSet transforms = entry.getValue().transforms;
                ToolTuning.Profile right = transforms != null && transforms.right != null ? transforms.right.toTool() : null;
                ToolTuning.Profile left = transforms != null && transforms.left != null ? transforms.left.toTool() : null;
                ToolTuning.applySpecific(id, kind, right, left);
            }
        }
        ToolTuning.refreshAll();
    }

    public static void saveCurrent() {
        try {
            Data data = PunchyTuningConfig.captureCurrent();
            String compatTarget = Punchy.ACTIVE_COMPAT_EDIT_TARGET;
            if (compatTarget != null && !compatTarget.isBlank()) {
                Data toSave = BASELINE_STATE != null ? PunchyTuningConfig.computeDelta(BASELINE_STATE, data) : data;
                PunchyTuningConfig.saveCompatData(compatTarget, toSave);
            } else {
                PunchyTuningConfig.saveData(data);
                BASELINE_STATE = data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Data captureCurrent() {
        Data d = new Data();
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            SideSet ss = null;
            if (!ToolTuning.isKindAttached(kind, false)) {
                ss = new SideSet();
                ss.right = Pose.fromTool(ToolTuning.snapshot(kind, false));
            }
            if (!ToolTuning.isKindAttached(kind, true)) {
                if (ss == null) {
                    ss = new SideSet();
                }
                ss.left = Pose.fromTool(ToolTuning.snapshot(kind, true));
            }
            if (ss == null) continue;
            d.item.put(kind.name(), ss);
        }
        SideSet globalItem = new SideSet();
        globalItem.right = Pose.fromTool(ToolTuning.snapshotGlobal(false));
        globalItem.left = Pose.fromTool(ToolTuning.snapshotGlobal(true));
        d.globalItem = globalItem;
        SideSet globalArm = new SideSet();
        globalArm.right = Pose.fromArm(ArmToolTuning.snapshotGlobal(false));
        globalArm.left = Pose.fromArm(ArmToolTuning.snapshotGlobal(true));
        d.globalArm = globalArm;
        SideSet meshSet = new SideSet();
        meshSet.right = Pose.fromArmMesh(ArmMeshTuning.snapshotGlobal(false));
        meshSet.left = Pose.fromArmMesh(ArmMeshTuning.snapshotGlobal(true));
        d.armMesh.put(ARM_MESH_SIDE_KEY, meshSet);
        d.arm = null;
        d.itemSpecific = PunchyTuningConfig.captureSpecificCurrent();
        return d;
    }

    private static void rememberBaseline() {
        BASELINE_STATE = PunchyTuningConfig.captureCurrent();
    }

    private static Map<String, SpecificEntry> captureSpecificCurrent() {
        HashMap<String, SpecificEntry> out = new HashMap<String, SpecificEntry>();
        Map<ResourceLocation, ToolTuning.SpecificSnapshot> snapshot = ToolTuning.snapshotSpecifics();
        snapshot.forEach((id, spec) -> {
            SpecificEntry entry = new SpecificEntry();
            entry.kind = spec.kind() == null ? null : spec.kind().name();
            SideSet set = new SideSet();
            if (spec.right() != null) {
                set.right = Pose.fromTool(spec.right());
            }
            if (spec.left() != null) {
                set.left = Pose.fromTool(spec.left());
            }
            entry.transforms = set;
            out.put(id.toString(), entry);
        });
        return out;
    }

    private static Data computeDelta(Data base, Data current) {
        SideSet baseSet;
        SideSet currentSet;
        SideSet diff;
        if (base == null) {
            return current;
        }
        Data delta = new Data();
        boolean hasData = false;
        delta.globalItem = PunchyTuningConfig.diffSideSet(current.globalItem, base.globalItem);
        if (delta.globalItem != null) {
            hasData = true;
        }
        delta.globalArm = PunchyTuningConfig.diffSideSet(current.globalArm, base.globalArm);
        if (delta.globalArm != null) {
            hasData = true;
        }
        HashMap<String, SideSet> itemDiff = new HashMap<String, SideSet>();
        if (current.item != null) {
            for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
                SideSet baseSet2;
                SideSet currentSet2 = current.item.get(kind.name());
                SideSet diff2 = PunchyTuningConfig.diffSideSet(currentSet2, baseSet2 = base.item != null ? base.item.get(kind.name()) : null);
                if (diff2 == null) continue;
                itemDiff.put(kind.name(), diff2);
                hasData = true;
            }
        }
        delta.item = itemDiff.isEmpty() ? null : itemDiff;
        HashMap<String, SideSet> meshDiff = new HashMap<String, SideSet>();
        if (current.armMesh != null && (diff = PunchyTuningConfig.diffSideSet(currentSet = current.armMesh.get(ARM_MESH_SIDE_KEY), baseSet = base.armMesh != null ? base.armMesh.get(ARM_MESH_SIDE_KEY) : null)) != null) {
            meshDiff.put(ARM_MESH_SIDE_KEY, diff);
            hasData = true;
        }
        delta.armMesh = meshDiff.isEmpty() ? null : meshDiff;
        HashMap<String, SpecificEntry> specificDiff = new HashMap<String, SpecificEntry>();
        Map<Object, Object> currentSpecific = current.itemSpecific != null ? current.itemSpecific : Collections.emptyMap();
        Map<Object, Object> baseSpecific = base.itemSpecific != null ? base.itemSpecific : Collections.emptyMap();
        for (Map.Entry<Object, Object> entry : currentSpecific.entrySet()) {
            boolean kindDiffers;
            SpecificEntry currentEntry = (SpecificEntry)entry.getValue();
            if (currentEntry == null) continue;
            SpecificEntry baseEntry = (SpecificEntry)baseSpecific.get(entry.getKey());
            SideSet transforms = baseEntry == null ? PunchyTuningConfig.copySideSet(currentEntry.transforms) : PunchyTuningConfig.diffSideSet(currentEntry.transforms, baseEntry.transforms);
            boolean bl = baseEntry == null ? currentEntry.kind != null : (kindDiffers = !Objects.equals(currentEntry.kind, baseEntry.kind));
            if (transforms == null && !kindDiffers) continue;
            SpecificEntry copy = new SpecificEntry();
            copy.kind = currentEntry.kind;
            copy.transforms = transforms != null ? transforms : PunchyTuningConfig.copySideSet(currentEntry.transforms);
            specificDiff.put((String)entry.getKey(), copy);
            hasData = true;
        }
        delta.itemSpecific = specificDiff.isEmpty() ? null : specificDiff;
        PunchyTuningConfig.pruneEmptyCollections(delta);
        if (!hasData && delta.itemSpecific == null && delta.item == null && delta.globalItem == null && delta.globalArm == null) {
            return new Data();
        }
        return delta;
    }

    private static SideSet diffSideSet(SideSet current, SideSet base) {
        if (current == null) {
            return null;
        }
        SideSet diff = new SideSet();
        if (current.right != null) {
            diff.right = PunchyTuningConfig.diffPose(current.right, base != null ? base.right : null);
        }
        if (current.left != null) {
            diff.left = PunchyTuningConfig.diffPose(current.left, base != null ? base.left : null);
        }
        if (diff.right == null && diff.left == null) {
            return null;
        }
        return diff;
    }

    private static Pose diffPose(Pose current, Pose base) {
        if (current == null) {
            return null;
        }
        if (base == null || !PunchyTuningConfig.poseEquals(current, base)) {
            return PunchyTuningConfig.copyPose(current);
        }
        return null;
    }

    private static Pose copyPose(Pose src) {
        if (src == null) {
            return null;
        }
        return new Pose(src.scale, src.offX, src.offY, src.offZ, src.rotX, src.rotY, src.rotZ, src.pivotX, src.pivotY, src.pivotZ);
    }

    private static SideSet copySideSet(SideSet src) {
        if (src == null) {
            return null;
        }
        SideSet copy = new SideSet();
        copy.right = PunchyTuningConfig.copyPose(src.right);
        copy.left = PunchyTuningConfig.copyPose(src.left);
        if (copy.right == null && copy.left == null) {
            return null;
        }
        return copy;
    }

    private static boolean poseEquals(Pose a, Pose b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return PunchyTuningConfig.nearlyEqual(a.scale, b.scale) && PunchyTuningConfig.nearlyEqual(a.offX, b.offX) && PunchyTuningConfig.nearlyEqual(a.offY, b.offY) && PunchyTuningConfig.nearlyEqual(a.offZ, b.offZ) && PunchyTuningConfig.nearlyEqual(a.rotX, b.rotX) && PunchyTuningConfig.nearlyEqual(a.rotY, b.rotY) && PunchyTuningConfig.nearlyEqual(a.rotZ, b.rotZ) && PunchyTuningConfig.nearlyEqual(a.pivotX, b.pivotX) && PunchyTuningConfig.nearlyEqual(a.pivotY, b.pivotY) && PunchyTuningConfig.nearlyEqual(a.pivotZ, b.pivotZ);
    }

    private static boolean nearlyEqual(float a, float b) {
        return Math.abs(a - b) <= 1.0E-6f;
    }

    private static void pruneEmptyCollections(Data data) {
        if (data.item != null && data.item.isEmpty()) {
            data.item = null;
        }
        if (data.arm != null && data.arm.isEmpty()) {
            data.arm = null;
        }
        if (data.armMesh != null && data.armMesh.isEmpty()) {
            data.armMesh = null;
        }
        if (data.itemSpecific != null && data.itemSpecific.isEmpty()) {
            data.itemSpecific = null;
        }
    }

    private static boolean isSideSetEqual(SideSet a, SideSet b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return PunchyTuningConfig.poseEquals(a.right, b.right) && PunchyTuningConfig.poseEquals(a.left, b.left);
    }

    private static boolean isDataEmpty(Data data) {
        if (data == null) {
            return true;
        }
        boolean globalsEmpty = (data.globalItem == null || data.globalItem.right == null && data.globalItem.left == null) && (data.globalArm == null || data.globalArm.right == null && data.globalArm.left == null);
        boolean mapsEmpty = !(data.item != null && !data.item.isEmpty() || data.arm != null && !data.arm.isEmpty() || data.itemSpecific != null && !data.itemSpecific.isEmpty());
        return globalsEmpty && mapsEmpty;
    }

    private static void stripRedundantEntries(Data data) {
        Map<String, SideSet> base;
        if (data == null || BASELINE_STATE == null) {
            return;
        }
        if (PunchyTuningConfig.isSideSetEqual(data.globalItem, PunchyTuningConfig.BASELINE_STATE.globalItem)) {
            data.globalItem = null;
        }
        if (PunchyTuningConfig.isSideSetEqual(data.globalArm, PunchyTuningConfig.BASELINE_STATE.globalArm)) {
            data.globalArm = null;
        }
        if (data.item != null) {
            base = PunchyTuningConfig.BASELINE_STATE.item;
            data.item.entrySet().removeIf(entry -> PunchyTuningConfig.isSideSetEqual((SideSet)entry.getValue(), base != null ? (SideSet)base.get(entry.getKey()) : null));
            if (data.item.isEmpty()) {
                data.item = null;
            }
        }
        if (data.armMesh != null) {
            base = PunchyTuningConfig.BASELINE_STATE.armMesh;
            data.armMesh.entrySet().removeIf(entry -> PunchyTuningConfig.isSideSetEqual((SideSet)entry.getValue(), base != null ? (SideSet)base.get(entry.getKey()) : null));
            if (data.armMesh.isEmpty()) {
                data.armMesh = null;
            }
        }
        if (data.itemSpecific != null) {
            Map<String, SpecificEntry> baseSpecific = PunchyTuningConfig.BASELINE_STATE.itemSpecific;
            data.itemSpecific.entrySet().removeIf(entry -> {
                SpecificEntry base = baseSpecific != null ? (SpecificEntry)baseSpecific.get(entry.getKey()) : null;
                boolean kindMatches = Objects.equals(((SpecificEntry)entry.getValue()).kind, base != null ? base.kind : null);
                boolean transformsMatch = PunchyTuningConfig.isSideSetEqual(((SpecificEntry)entry.getValue()).transforms, base != null ? base.transforms : null);
                return kindMatches && transformsMatch;
            });
            if (data.itemSpecific.isEmpty()) {
                data.itemSpecific = null;
            }
        }
        PunchyTuningConfig.pruneEmptyCollections(data);
    }

    private static void saveData(Data data) {
        File file = PunchyTuningConfig.getFile();
        File parent = file.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)data, (Appendable)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveCompatData(String profile, Data data) {
        Path compatDir = PunchyTuningConfig.getCompatDirectory();
        try {
            Files.createDirectories(compatDir, new FileAttribute[0]);
            Path target = compatDir.resolve(profile + ".json");
            try (FileWriter writer = new FileWriter(target.toFile());){
                GSON.toJson((Object)data, (Appendable)writer);
            }
            PunchyTuningConfig.mirrorCompatResource(profile, target);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void mirrorCompatResource(String profile, Path source) {
        if (!"items_compat".equals(profile) || source == null) {
            return;
        }
        try {
            Path workspace = Path.of("", new String[0]).toAbsolutePath();
            Path srcRoot = workspace.resolve("src");
            if (!Files.exists(srcRoot, new LinkOption[0])) {
                return;
            }
            Path compatDir = srcRoot.resolve("main").resolve("resources").resolve("assets").resolve("punchy").resolve("compat");
            Files.createDirectories(compatDir, new FileAttribute[0]);
            Path dest = compatDir.resolve(source.getFileName());
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void applyCompatOverlays() {
        PunchyTuningConfig.installBundledCompatProfiles();
        Set<String> profiles = PunchyTuningConfig.discoverCompatProfilesFromResourcePacks();
        if (profiles.isEmpty()) {
            return;
        }
        for (String profile : profiles) {
            Data compat;
            if (profile == null || profile.isBlank() || (compat = PunchyTuningConfig.loadCompatProfile(profile)) == null) continue;
            PunchyTuningConfig.applyData(compat);
        }
    }

    private static Set<String> discoverCompatProfilesFromResourcePacks() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Minecraft client = Minecraft.getInstance();
        if (client == null) {
            return result;
        }
        ResourceManager manager = client.getResourceManager();
        PunchyTuningConfig.collectCompatProfiles(manager, "compat", "punchy", "compat/", result);
        PunchyTuningConfig.collectCompatProfiles(manager, COMPAT_DIR_NAME, "minecraft", "punchy/compat/", result);
        return result;
    }

    private static void collectCompatProfiles(ResourceManager manager, String searchPath, String namespace, String prefix, Set<String> result) {
        Map found = manager.listResources(searchPath, loc -> loc.getNamespace().equals(namespace) && loc.getPath().startsWith(prefix) && loc.getPath().endsWith(".json"));
        for (ResourceLocation id : found.keySet()) {
            String path = id.getPath();
            String file = path.substring(prefix.length());
            if (file.endsWith(".json")) {
                file = file.substring(0, file.length() - 5);
            }
            if (file.isBlank()) continue;
            result.add(file.toLowerCase(Locale.ROOT));
        }
    }

    private static SideSet resolveGlobalArm(Data data) {
        if (data == null) {
            return null;
        }
        if (data.globalArm != null) {
            return data.globalArm;
        }
        if (data.arm != null) {
            for (PlayerArmModelLayer.ToolKind kind : PlayerArmModelLayer.ToolKind.values()) {
                SideSet set = data.arm.get(kind.name());
                if (set == null) continue;
                return set;
            }
        }
        return null;
    }

    private static SideSet resolveGlobalItem(Data data) {
        if (data == null) {
            return null;
        }
        if (data.globalItem != null) {
            return data.globalItem;
        }
        if (data.item != null) {
            for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
                SideSet set = data.item.get(kind.name());
                if (set == null) continue;
                return set;
            }
        }
        return null;
    }

    private static Data loadCompatProfile(String profile) {
        Minecraft client;
        String normalized = profile.endsWith(".json") ? profile.substring(0, profile.length() - 5) : profile;
        Path compatDir = PunchyTuningConfig.getCompatDirectory();
        try {
            Files.createDirectories(compatDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Path filePath = compatDir.resolve(normalized + ".json");
        if (Files.exists(filePath, new LinkOption[0])) {
            Data data;
            FileReader reader2 = new FileReader(filePath.toFile());
            try {
                data = PunchyTuningConfig.finalizeCompatData(normalized, (Data)GSON.fromJson((Reader)reader2, Data.class));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception reader2) {
                    // empty catch block
                }
            }
            reader2.close();
            return data;
        }
        if ((client = Minecraft.getInstance()) != null) {
            Data bundled = PunchyTuningConfig.loadCompatProfileFromResource(client, "punchy", "compat/" + normalized + ".json", normalized);
            if (bundled != null) {
                return bundled;
            }
            Data minecraft = PunchyTuningConfig.loadCompatProfileFromResource(client, "minecraft", "punchy/compat/" + normalized + ".json", normalized);
            if (minecraft != null) {
                return minecraft;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Data loadCompatProfileFromResource(Minecraft client, String namespace, String path, String profile) {
        block13: {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
            try {
                Optional resource = client.getResourceManager().getResource(id);
                if (!resource.isPresent()) break block13;
                try (InputStream stream = ((Resource)resource.get()).open();){
                    Data data;
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        data = PunchyTuningConfig.finalizeCompatData(profile, (Data)GSON.fromJson((Reader)reader, Data.class));
                    }
                    return data;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Data finalizeCompatData(String profile, Data data) {
        return data;
    }

    private static Path getCompatDirectory() {
        Path configDir = Platform.get().getConfigDirectory();
        return configDir.resolve(COMPAT_DIR_NAME);
    }

    private static void installBundledCompatProfiles() {
        for (String profile : BUNDLED_COMPAT_PROFILES) {
            PunchyTuningConfig.copyBundledCompatProfile(profile);
        }
    }

    private static void copyBundledCompatProfile(String profile) {
        try (InputStream stream = PunchyTuningConfig.openBundledCompatStream(profile);){
            if (stream == null) {
                return;
            }
            Path compatDir = PunchyTuningConfig.getCompatDirectory();
            Files.createDirectories(compatDir, new FileAttribute[0]);
            Path target = compatDir.resolve(profile + ".json");
            Files.copy(stream, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream openBundledCompatStream(String profile) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"punchy", (String)("compat/" + profile + ".json"));
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            try {
                Optional resource = client.getResourceManager().getResource(id);
                if (resource.isPresent()) {
                    return ((Resource)resource.get()).open();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PunchyTuningConfig.class.getResourceAsStream("/assets/punchy/compat/" + profile + ".json");
    }

    public static final class Data {
        public Map<String, SideSet> item = new HashMap<String, SideSet>();
        public Map<String, SideSet> arm = new HashMap<String, SideSet>();
        public Map<String, SideSet> armMesh = new HashMap<String, SideSet>();
        public SideSet globalItem;
        public SideSet globalArm;
        public Map<String, SpecificEntry> itemSpecific = new HashMap<String, SpecificEntry>();
    }

    public static final class SideSet {
        public Pose right;
        public Pose left;
    }

    public static final class Pose {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;
        public float pivotX;
        public float pivotY;
        public float pivotZ;

        public Pose() {
        }

        public Pose(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this(scale, offX, offY, offZ, rotX, rotY, rotZ, 0.0f, 0.0f, 0.0f);
        }

        public Pose(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ, float pivotX, float pivotY, float pivotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.pivotZ = pivotZ;
        }

        public static Pose fromTool(ToolTuning.Profile p) {
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ, p.pivotX, p.pivotY, p.pivotZ);
        }

        public static Pose fromArm(ArmToolTuning.Profile p) {
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ);
        }

        public ToolTuning.Profile toTool() {
            return new ToolTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ, this.pivotX, this.pivotY, this.pivotZ);
        }

        public ArmToolTuning.Profile toArm() {
            return new ArmToolTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ);
        }

        public static Pose fromArmMesh(ArmMeshTuning.Profile p) {
            if (p == null) {
                return null;
            }
            return new Pose(p.scale, p.offX, p.offY, p.offZ, p.rotX, p.rotY, p.rotZ);
        }

        public ArmMeshTuning.Profile toArmMesh() {
            return new ArmMeshTuning.Profile(this.scale, this.offX, this.offY, this.offZ, this.rotX, this.rotY, this.rotZ);
        }
    }

    public static final class SpecificEntry {
        public String kind;
        public SideSet transforms;
    }
}

