/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.PunchyClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.conditional.IsUsingItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IsUsingItem.class})
public abstract class IsUsingItemPropertyMixin {
    @Inject(method={"get"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$gateBowUsing(ItemStack stack, ClientLevel world, LivingEntity entity, int seed, ItemDisplayContext displayContext, CallbackInfoReturnable<Boolean> cir) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || player != mc.player) {
            return;
        }
        InteractionHand hand = IsUsingItemPropertyMixin.resolveHand(player, stack);
        if (hand == null) {
            return;
        }
        if (PunchyClient.isBowHandSuppressed(hand)) {
            cir.setReturnValue((Object)false);
        }
    }

    private static InteractionHand resolveHand(Player player, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = player.getItemInHand(hand);
            if (held == stack) {
                return hand;
            }
            if (held.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)held, (ItemStack)stack)) continue;
            return hand;
        }
        return null;
    }
}

