/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.PunchyClient;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityDamageEventMixin {
    @Inject(method={"handleDamageEvent"}, at={@At(value="TAIL")})
    private void punchy$handleShieldHit(DamageSource source, CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        if (!(self instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer local = (LocalPlayer)self;
        if (!local.level().isClientSide()) {
            return;
        }
        if (!local.isUsingItem()) {
            return;
        }
        ItemStack stack = local.getUseItem();
        if (stack == null || stack.isEmpty()) {
            return;
        }
        if (!(stack.getItem() instanceof ShieldItem)) {
            return;
        }
        PunchyClient.onShieldImpact(local);
    }
}

