/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.util.OffhandMirrorGuard;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
abstract class PlayerInventorySetStackMixin {
    @Shadow
    @Final
    public Player player;

    PlayerInventorySetStackMixin() {
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$blockOffhandInventorySet(int slot, ItemStack stack, CallbackInfo ci) {
        if (slot != 40) {
            return;
        }
        if (OffhandMirrorGuard.isPerformingInternalMutation()) {
            return;
        }
        if (stack.isEmpty()) {
            return;
        }
        if (OffhandMirrorGuard.isOffhandLocked(this.player)) {
            OffhandMirrorGuard.notifyLocked(this.player);
            ci.cancel();
            return;
        }
    }
}

