/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.platform;

import java.nio.file.Path;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public interface PlatformServices {
    public Path getConfigDirectory();

    public boolean isDevelopmentEnvironment();

    public void addCreativeTabEntry(ResourceKey<CreativeModeTab> var1, Item var2);

    public void registerWorldTick(WorldTickHandler var1);

    public void registerAttackBlockListener(AttackBlockListener var1);

    public void registerAttackEntityListener(AttackEntityListener var1);

    public <T extends CustomPacketPayload> void registerServerReceiver(CustomPacketPayload.Type<T> var1, StreamCodec<FriendlyByteBuf, T> var2, ServerPacketHandler<T> var3);

    public static interface ServerPacketContext {
        public ServerPlayer player();

        public MinecraftServer server();

        public void queue(Runnable var1);
    }

    @FunctionalInterface
    public static interface ServerPacketHandler<T extends CustomPacketPayload> {
        public void handle(T var1, ServerPacketContext var2);
    }

    @FunctionalInterface
    public static interface AttackEntityListener {
        public InteractionResult onAttackEntity(Player var1, Level var2, InteractionHand var3, Entity var4, HitResult var5);
    }

    @FunctionalInterface
    public static interface AttackBlockListener {
        public InteractionResult onAttackBlock(Player var1, Level var2, InteractionHand var3, BlockPos var4, Direction var5);
    }

    @FunctionalInterface
    public static interface WorldTickHandler {
        public void onWorldTick(ServerLevel var1);
    }
}

