/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.platform.forge;

import com.henrique.punchy.platform.ClientPlatformServices;
import com.henrique.punchy.platform.forge.ForgePlatformServices;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.network.Channel;

public final class ForgeClientPlatformServices
implements ClientPlatformServices {
    public static final ForgeClientPlatformServices INSTANCE = new ForgeClientPlatformServices();
    private final List<Runnable> startCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> tickCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> renderCallbacks = new CopyOnWriteArrayList<Runnable>();
    private final List<KeyMapping> pendingKeyMappings = new CopyOnWriteArrayList<KeyMapping>();
    private volatile boolean started = false;
    private volatile boolean clientEventsRegistered = false;

    private ForgeClientPlatformServices() {
    }

    public void bindToModBus(BusGroup modBusGroup) {
        RegisterKeyMappingsEvent.getBus((BusGroup)modBusGroup).addListener(this::onRegisterKeyMappings);
    }

    public void registerClientEvents() {
        if (!this.clientEventsRegistered) {
            this.clientEventsRegistered = true;
            TickEvent.ClientTickEvent.Post.BUS.addListener(this::onClientTick);
            ViewportEvent.ComputeCameraAngles.BUS.addListener(this::onViewportCompute);
        }
    }

    @Override
    public void registerClientStarted(Runnable runnable) {
        this.startCallbacks.add(runnable);
    }

    @Override
    public void registerClientTick(Runnable runnable) {
        this.tickCallbacks.add(runnable);
    }

    @Override
    public void registerRenderFrame(Runnable runnable) {
        this.renderCallbacks.add(runnable);
    }

    @Override
    public KeyMapping registerKeyBinding(KeyMapping mapping) {
        this.pendingKeyMappings.add(mapping);
        return mapping;
    }

    @Override
    public void sendToServer(CustomPacketPayload payload) {
        if (payload == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.getConnection() == null) {
            return;
        }
        Channel<CustomPacketPayload> channel = ForgePlatformServices.INSTANCE.getPayloadChannel();
        if (channel == null) {
            return;
        }
        channel.send((Object)payload, client.getConnection().getConnection());
    }

    public void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        this.pendingKeyMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private void onClientTick(TickEvent.ClientTickEvent.Post event) {
        if (!this.started) {
            this.started = true;
            this.startCallbacks.forEach(Runnable::run);
        }
        for (Runnable runnable : this.tickCallbacks) {
            runnable.run();
        }
    }

    private void onViewportCompute(ViewportEvent.ComputeCameraAngles event) {
        for (Runnable runnable : this.renderCallbacks) {
            runnable.run();
        }
    }
}

