/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.platform.forge;

import com.henrique.punchy.platform.PlatformServices;
import com.henrique.punchy.platform.forge.ForgeServerPacketContext;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuildable;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.payload.PayloadConnection;
import net.minecraftforge.network.payload.PayloadProtocol;

public final class ForgePlatformServices
implements PlatformServices {
    public static final ForgePlatformServices INSTANCE = new ForgePlatformServices();
    private final List<Consumer<BuildCreativeModeTabContentsEvent>> creativeTabCallbacks = new CopyOnWriteArrayList<Consumer<BuildCreativeModeTabContentsEvent>>();
    private final PayloadConnection<CustomPacketPayload> payloadConnection;
    private final PayloadProtocol<RegistryFriendlyByteBuf, CustomPacketPayload> playProtocol;
    private volatile Channel<CustomPacketPayload> payloadChannel;
    private volatile boolean payloadChannelBuilt = false;

    private ForgePlatformServices() {
        PayloadConnection connection;
        BuildCreativeModeTabContentsEvent.BUS.addListener(this::onBuildCreativeTabs);
        ResourceLocation channelId = ResourceLocation.fromNamespaceAndPath((String)"punchy", (String)"play");
        this.payloadConnection = connection = ChannelBuilder.named((ResourceLocation)channelId).networkProtocolVersion(1).optional().payloadChannel();
        this.playProtocol = connection.play();
    }

    private void onBuildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        for (Consumer<BuildCreativeModeTabContentsEvent> callback : this.creativeTabCallbacks) {
            callback.accept(event);
        }
    }

    @Override
    public Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.production;
    }

    @Override
    public void addCreativeTabEntry(ResourceKey<CreativeModeTab> tab, Item item) {
        this.creativeTabCallbacks.add(event -> {
            if (event.getTabKey().equals((Object)tab)) {
                event.accept((ItemLike)item);
            }
        });
    }

    @Override
    public void registerWorldTick(PlatformServices.WorldTickHandler handler) {
        TickEvent.LevelTickEvent.Post.BUS.addListener(event -> {
            Level level = event.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                handler.onWorldTick(serverLevel);
            }
        });
    }

    @Override
    public void registerAttackBlockListener(PlatformServices.AttackBlockListener listener) {
        PlayerInteractEvent.LeftClickBlock.BUS.addListener(event -> listener.onAttackBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace()));
    }

    @Override
    public void registerAttackEntityListener(PlatformServices.AttackEntityListener listener) {
        AttackEntityEvent.BUS.addListener(event -> listener.onAttackEntity(event.getEntity(), event.getEntity().level(), InteractionHand.MAIN_HAND, event.getTarget(), null));
    }

    @Override
    public <T extends CustomPacketPayload> void registerServerReceiver(CustomPacketPayload.Type<T> type, StreamCodec<FriendlyByteBuf, T> codec, PlatformServices.ServerPacketHandler<T> handler) {
        this.ensurePayloadChannelMutable();
        StreamCodec adapted = ForgePlatformServices.castCodec(codec);
        this.playProtocol.serverbound(flow -> flow.add(type, adapted, (payload, context) -> handler.handle(payload, new ForgeServerPacketContext((CustomPayloadEvent.Context)context))));
    }

    public synchronized void finalizePayloadRegistrations() {
        if (!this.payloadChannelBuilt) {
            ChannelBuildable builder = (ChannelBuildable)this.playProtocol;
            this.payloadChannel = builder.build();
            this.payloadChannelBuilt = true;
        }
    }

    private void ensurePayloadChannelMutable() {
        if (this.payloadChannelBuilt) {
            throw new IllegalStateException("Payload channel already built");
        }
    }

    private static <T extends CustomPacketPayload> StreamCodec<RegistryFriendlyByteBuf, T> castCodec(StreamCodec<FriendlyByteBuf, T> codec) {
        return codec;
    }

    public Channel<CustomPacketPayload> getPayloadChannel() {
        return this.payloadChannel;
    }
}

