/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.server;

import com.henrique.punchy.Punchy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public final class TapMiningManager {
    private static final Map<UUID, Map<BlockPos, Double>> PROGRESS = new HashMap<UUID, Map<BlockPos, Double>>();
    private static final Map<UUID, Map<BlockPos, Integer>> BREAKER_IDS = new HashMap<UUID, Map<BlockPos, Integer>>();
    private static final Map<UUID, Map<BlockPos, Long>> LAST_CLICK_TICKS = new HashMap<UUID, Map<BlockPos, Long>>();
    private static final int CLICK_TICKS = 5;
    private static final long RESET_TICKS = 100L;

    private TapMiningManager() {
    }

    public static void onClick(ServerPlayer player, ServerLevel world, BlockPos pos) {
        if (!Punchy.TAP_MINING_ENABLED) {
            return;
        }
        if (player == null || world == null || pos == null) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (state.isAir()) {
            return;
        }
        if (player.getAbilities().instabuild) {
            TapMiningManager.clearProgress(world, player, pos);
            world.destroyBlock(pos, false, (Entity)player);
            return;
        }
        double deltaPerTick = state.getDestroyProgress((Player)player, (BlockGetter)world, pos);
        if (deltaPerTick <= 0.0) {
            return;
        }
        double add = deltaPerTick * 5.0 * Punchy.MINING_SPEED_MULTIPLIER;
        long nowTick = world.getGameTime();
        Map map = PROGRESS.computeIfAbsent(player.getUUID(), k -> new HashMap());
        Map lastClick = LAST_CLICK_TICKS.computeIfAbsent(player.getUUID(), k -> new HashMap());
        double prev = map.getOrDefault(pos, 0.0);
        double now = Math.min(1.0, prev + add);
        if (now >= 1.0) {
            TapMiningManager.clearProgress(world, player, pos);
            world.destroyBlock(pos, true, (Entity)player);
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
        } else {
            map.put(pos, now);
            lastClick.put(pos, nowTick);
            int stage = Math.min(9, Math.max(0, (int)Math.floor(now * 10.0)));
            int id = TapMiningManager.getBreakerId(player, pos);
            world.destroyBlockProgress(id, pos, stage);
        }
    }

    public static void tickWorld(ServerLevel world) {
        if (!Punchy.TAP_MINING_ENABLED) {
            for (ServerPlayer player : world.players()) {
                TapMiningManager.clearPlayerProgress(world, player);
            }
            return;
        }
        long nowTick = world.getGameTime();
        for (ServerPlayer player : world.players()) {
            Map<BlockPos, Double> map = PROGRESS.get(player.getUUID());
            if (map == null || map.isEmpty()) continue;
            Map<BlockPos, Long> lastClick = LAST_CLICK_TICKS.get(player.getUUID());
            Iterator<Map.Entry<BlockPos, Double>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                long lastTick;
                Map.Entry<BlockPos, Double> entry = it.next();
                BlockPos pos = entry.getKey();
                double prog = entry.getValue();
                BlockState state = world.getBlockState(pos);
                if (state.isAir()) {
                    TapMiningManager.endProgressOverlay(world, player, pos);
                    if (lastClick != null) {
                        lastClick.remove(pos);
                    }
                    it.remove();
                    continue;
                }
                long l = lastTick = lastClick != null ? lastClick.getOrDefault(pos, nowTick) : nowTick;
                if (nowTick - lastTick >= 100L) {
                    TapMiningManager.endProgressOverlay(world, player, pos);
                    if (lastClick != null) {
                        lastClick.remove(pos);
                    }
                    it.remove();
                    continue;
                }
                if (prog >= 1.0) {
                    TapMiningManager.endProgressOverlay(world, player, pos);
                    if (lastClick != null) {
                        lastClick.remove(pos);
                    }
                    it.remove();
                    world.destroyBlock(pos, true, (Entity)player);
                    player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand());
                    continue;
                }
                int stage = Math.min(9, Math.max(0, (int)Math.floor(prog * 10.0)));
                int id = TapMiningManager.getBreakerId(player, pos);
                world.destroyBlockProgress(id, pos, stage);
            }
        }
    }

    private static void clearPlayerProgress(ServerLevel world, ServerPlayer player) {
        if (player == null) {
            return;
        }
        Map<BlockPos, Integer> ids = BREAKER_IDS.remove(player.getUUID());
        if (ids != null) {
            ids.forEach((pos, id) -> world.destroyBlockProgress(id.intValue(), pos, -1));
        }
        PROGRESS.remove(player.getUUID());
        LAST_CLICK_TICKS.remove(player.getUUID());
    }

    private static void clearProgress(ServerLevel world, ServerPlayer player, BlockPos pos) {
        Map<BlockPos, Long> lastClick;
        if (player == null || pos == null) {
            return;
        }
        Map<BlockPos, Double> map = PROGRESS.get(player.getUUID());
        if (map != null) {
            map.remove(pos);
        }
        if ((lastClick = LAST_CLICK_TICKS.get(player.getUUID())) != null) {
            lastClick.remove(pos);
        }
        TapMiningManager.endProgressOverlay(world, player, pos);
    }

    private static void endProgressOverlay(ServerLevel world, ServerPlayer player, BlockPos pos) {
        int id = TapMiningManager.getBreakerId(player, pos);
        world.destroyBlockProgress(id, pos, -1);
        TapMiningManager.clearBreakerId(player, pos);
    }

    private static int getBreakerId(ServerPlayer player, BlockPos pos) {
        Map ids = BREAKER_IDS.computeIfAbsent(player.getUUID(), k -> new HashMap());
        Integer id = (Integer)ids.get(pos);
        if (id != null) {
            return id;
        }
        int newId = 0x40000000 ^ player.getUUID().hashCode() ^ pos.hashCode();
        if (newId == player.getId()) {
            newId ^= 0x1FFFFF;
        }
        ids.put(pos, newId);
        return newId;
    }

    private static void clearBreakerId(ServerPlayer player, BlockPos pos) {
        Map<BlockPos, Integer> ids = BREAKER_IDS.get(player.getUUID());
        if (ids != null) {
            ids.remove(pos);
        }
    }
}

