/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.util;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.item.AnimatedBoneProxy;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import software.bernie.geckolib.animatable.GeoItem;

public final class ProxyItemHelper {
    private ProxyItemHelper() {
    }

    public static boolean requiresProxy(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.isEmpty()) {
            return true;
        }
        AnimatedBoneProxy proxy = Punchy.boneProxy();
        if (proxy != null && stack.getItem() == proxy) {
            return true;
        }
        return !(stack.getItem() instanceof GeoItem);
    }

    public static boolean requiresProxy(Player player, InteractionHand hand) {
        if (player == null) {
            return false;
        }
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        ItemStack held = player.getItemInHand(resolved);
        AnimatedBoneProxy proxy = Punchy.boneProxy();
        return !ProxyItemHelper.isGeo(held) || proxy != null && held.getItem() == proxy;
    }

    public static boolean isGeo(ItemStack stack) {
        return stack != null && !stack.isEmpty() && stack.getItem() instanceof GeoItem;
    }

    public static boolean isMap(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return stack.getItem() instanceof MapItem || stack.getItem() instanceof EmptyMapItem;
    }
}

