/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy;

import com.henrique.punchy.config.PunchyConfig;
import com.henrique.punchy.item.AnimatedBoneProxy;
import com.henrique.punchy.networking.ModMessages;
import com.henrique.punchy.platform.Platform;
import com.henrique.punchy.platform.PlatformServices;
import com.henrique.punchy.server.TapMiningManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Punchy {
    public static final String MOD_ID = "punchy";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"punchy");
    public static final DeferredHolder<Item, AnimatedBoneProxy> ANIMATED_BONE_PROXY = ITEMS.register("animated_bone_proxy", AnimatedBoneProxy::new);
    public static volatile double ANIM_SPEED = 4.0;
    public static volatile double SOUND_RATE = 1.0;
    public static volatile double SWORD_ANIM_SPEED = 2.0;
    public static volatile double BOW_ANIM_SPEED = 1.0;
    public static volatile double MACE_ANIM_SPEED = 2.0;
    public static volatile double TRIDENT_ANIM_SPEED = 4.0;
    public static volatile double TRIDENT_THROW_SPEED = 1.0;
    public static volatile double BLOCK_PLACE_SPEED = 7.0;
    public static volatile double MINING_SPEED_MULTIPLIER = 1.0;
    public static volatile boolean ARM_USE_PLAYER_SKIN = true;
    public static volatile ResourceLocation ARM_SKIN_OVERRIDE = null;
    public static volatile boolean REMOVE_ATTACK_COOLDOWN = true;
    public static volatile boolean HIDE_ATTACK_INDICATOR = false;
    public static volatile boolean USE_IMPACT_TIMING = true;
    public static volatile boolean TAP_MINING_ENABLED = true;
    public static volatile boolean JUMP_PHYSICS_ENABLED = true;
    public static volatile boolean DEBUG_POSITION = false;
    public static volatile Set<String> ACTIVE_COMPAT_PACKS = Collections.emptySet();
    public static volatile String ACTIVE_COMPAT_EDIT_TARGET = "";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"punchy");

    public static void initialize() {
        Punchy.applyCombatToggles(PunchyConfig.load());
        PlatformServices services = Platform.get();
        services.addCreativeTabEntry((ResourceKey<CreativeModeTab>)CreativeModeTabs.TOOLS_AND_UTILITIES, (Item)ANIMATED_BONE_PROXY.get());
        services.registerAttackBlockListener((player, world, hand, pos, direction) -> {
            if (!world.isClientSide()) {
                Punchy.triggerIfHolding(player, (ServerLevel)world, hand);
            }
            return InteractionResult.PASS;
        });
        services.registerAttackEntityListener((player, world, hand, entity, hitResult) -> {
            if (!world.isClientSide()) {
                Punchy.triggerIfHolding(player, (ServerLevel)world, hand);
            }
            return InteractionResult.PASS;
        });
        services.registerWorldTick(TapMiningManager::tickWorld);
        ModMessages.registerC2SPackets();
    }

    private static void triggerIfHolding(Player player, ServerLevel world, InteractionHand hand) {
    }

    public static AnimatedBoneProxy boneProxy() {
        return (AnimatedBoneProxy)((Object)ANIMATED_BONE_PROXY.get());
    }

    public static void applyCombatToggles(PunchyConfig config) {
        double global;
        if (config == null) {
            REMOVE_ATTACK_COOLDOWN = true;
            HIDE_ATTACK_INDICATOR = true;
            USE_IMPACT_TIMING = true;
            JUMP_PHYSICS_ENABLED = true;
            TAP_MINING_ENABLED = true;
            SWORD_ANIM_SPEED = ANIM_SPEED = PunchyConfig.SpeedPreset.PUNCHYA.speed;
            BOW_ANIM_SPEED = ANIM_SPEED;
            MACE_ANIM_SPEED = ANIM_SPEED;
            TRIDENT_ANIM_SPEED = ANIM_SPEED;
            TRIDENT_THROW_SPEED = ANIM_SPEED;
            BLOCK_PLACE_SPEED = ANIM_SPEED;
            DEBUG_POSITION = false;
            ACTIVE_COMPAT_PACKS = Collections.emptySet();
            ACTIVE_COMPAT_EDIT_TARGET = "";
            return;
        }
        boolean vanillaPreset = config.getSpeedPreset() == PunchyConfig.SpeedPreset.VANILLA;
        REMOVE_ATTACK_COOLDOWN = vanillaPreset ? false : config.isRemoveAttackCooldown();
        HIDE_ATTACK_INDICATOR = vanillaPreset ? false : config.isHideAttackIndicator();
        TAP_MINING_ENABLED = config.isTapMiningEnabled();
        USE_IMPACT_TIMING = !vanillaPreset;
        JUMP_PHYSICS_ENABLED = config.isJumpPhysicsEnabled();
        ACTIVE_COMPAT_PACKS = Collections.unmodifiableSet(new LinkedHashSet<String>(config.getCompatPacks()));
        ACTIVE_COMPAT_EDIT_TARGET = config.getCompatEditTarget();
        ANIM_SPEED = global = config.getSpeedPreset().speed;
        SWORD_ANIM_SPEED = global;
        BOW_ANIM_SPEED = global;
        MACE_ANIM_SPEED = global;
        TRIDENT_ANIM_SPEED = global;
        TRIDENT_THROW_SPEED = global;
        BLOCK_PLACE_SPEED = global;
        DEBUG_POSITION = config.isDebugPosition();
    }
}

