/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.henrique.punchy.Punchy;
import com.henrique.punchy.client.ClientBridge;
import com.henrique.punchy.client.debug.AnchorDebugProbe;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.BoneAnimationController;
import com.henrique.punchy.client.render.HandItemOverrides;
import com.henrique.punchy.client.render.HandSwayPhysics;
import com.henrique.punchy.client.render.ToolAnimationOverrides;
import com.henrique.punchy.client.render.ToolKindResolver;
import com.henrique.punchy.client.render.UseAnimationSuppressor;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.render.anim.BoneAnimationIds;
import com.henrique.punchy.client.tuning.TuningKeybinds;
import com.henrique.punchy.combat.ImpactClientHooks;
import com.henrique.punchy.config.PunchyConfig;
import com.henrique.punchy.config.PunchyTuningConfig;
import com.henrique.punchy.geo.renderer.LeftArmRenderer;
import com.henrique.punchy.geo.renderer.RightArmRenderer;
import com.henrique.punchy.item.AnimatedBoneProxy;
import com.henrique.punchy.item.AnimatedTool;
import com.henrique.punchy.item.AnimationRandomizer;
import com.henrique.punchy.mixin.accessor.LivingEntityAccessor;
import com.henrique.punchy.networking.ModMessages;
import com.henrique.punchy.networking.packet.BlockImpactPayload;
import com.henrique.punchy.platform.ClientPlatform;
import com.henrique.punchy.platform.ClientPlatformServices;
import com.henrique.punchy.util.ProxyItemHelper;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class PunchyClient {
    private static final int USE_ANIMATION_TICKS = 6;
    private static final int BUCKET_USE_ANIMATION_TICKS = 40;
    private static final JumpSpringPivot SPRING_PIVOT = new JumpSpringPivot(-1.0f, 0.3f, 0.2f);
    private static final float LANTERN_RIGHT_DELTA_X = 0.16f;
    private static final float LANTERN_LEFT_DELTA_X = -0.16f;
    private static final float LANTERN_DELTA_Y = 0.14f;
    private static final float LANTERN_DELTA_Z = 0.08f;
    private static final String TRANSITION_PREFIX = "transition_to_idle_";
    private static final String FLINT_STEEL_CLIP = "flint_and_steel";
    private static final ItemStack FLINT_AND_STEEL_PROXY_STACK = new ItemStack((ItemLike)Items.FLINT_AND_STEEL);
    private static final String[] SWORD_ATTACK_VARIANTS = new String[]{"attack", "attack_2", "attack_3"};
    private static final String PUNCH_TRIGGER = "mining";
    private static final String PUNCH_ATTACK_TRIGGER = "punch_attack";
    private static final String CONTROLLER_ACTIVATION = "Activation";
    private static Set<String> cachedTransitionAnimations = Set.of();
    private static boolean transitionAnimationsLoaded = false;
    private static final double FALL_CHARGE_MIN_DROP = 5.0;
    private static final double FALL_CHARGE_SPEED_THRESHOLD = -0.08;
    private static final String TRANSITION_TO_IDLE_PUNCH = "transition_to_idle_punch";
    private AttackTarget pendingAttackTarget;
    private long pendingAttackExpiryNanos;
    private static PunchyClient INSTANCE;
    private static KeyMapping inspectKey;
    public static boolean isMiningAnimationPlaying;
    public static long miningAnimationStartTime;
    public static BlockPos lastMiningTargetPos;
    private ItemStack lastMainhandStack = ItemStack.EMPTY;
    private ItemStack lastOffhandStack = ItemStack.EMPTY;
    private final EnumSet<InteractionHand> idleHands = EnumSet.noneOf(InteractionHand.class);
    private final Map<InteractionHand, String> idleClips = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private final Map<InteractionHand, LanternPhysicsState> lanternPhysics = new EnumMap<InteractionHand, LanternPhysicsState>(InteractionHand.class);
    private final Map<InteractionHand, LanternGripState> lanternGrips = new EnumMap<InteractionHand, LanternGripState>(InteractionHand.class);
    private final Map<InteractionHand, JumpSpringState> jumpSprings = new EnumMap<InteractionHand, JumpSpringState>(InteractionHand.class);
    private final Map<InteractionHand, SneakSpringState> sneakSprings = new EnumMap<InteractionHand, SneakSpringState>(InteractionHand.class);
    private final Map<InteractionHand, PunchLoopState> punchLoops = new EnumMap<InteractionHand, PunchLoopState>(InteractionHand.class);
    private final Map<InteractionHand, ArrayDeque<TransitionRequest>> idleTransitionQueues = new EnumMap<InteractionHand, ArrayDeque<TransitionRequest>>(InteractionHand.class);
    private final Map<InteractionHand, String> activeIdleTransitionClips = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private final Map<InteractionHand, PendingTransition> pendingIdleTransitionSources = new EnumMap<InteractionHand, PendingTransition>(InteractionHand.class);
    private final Map<InteractionHand, Double> deferredWalkRequests = new EnumMap<InteractionHand, Double>(InteractionHand.class);
    private final Map<InteractionHand, String> lastQueuedIdleClip = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private long lastLanternTickTime = System.nanoTime();
    private long lastSpringTickTime = System.nanoTime();
    private float lanternTimeRemainder = 0.0f;
    private float springTimeRemainder = 0.0f;
    private boolean consuming = false;
    private String consumingAnim = null;
    private InteractionHand consumeHand = InteractionHand.MAIN_HAND;
    private boolean wasAttacking = false;
    private int attackHoldTicks = 0;
    private boolean attackLoopArmed = false;
    private boolean wasUsing = false;
    private InteractionHand activationHand = InteractionHand.MAIN_HAND;
    private boolean transitionActive = false;
    private InteractionHand transitionHand = InteractionHand.MAIN_HAND;
    private long transitionStopGameTime = -1L;
    private float lastCameraYaw = Float.NaN;
    private float lastCameraPitch = Float.NaN;
    private float lastCameraYawDelta = 0.0f;
    private float lastCameraPitchDelta = 0.0f;
    private float yawLag = 0.0f;
    private float pitchLag = 0.0f;
    private float cameraTiltMainDeg = 0.0f;
    private float cameraTiltOffDeg = 0.0f;
    private float cameraTiltMainSmoothDeg = 0.0f;
    private float cameraTiltOffSmoothDeg = 0.0f;
    private long lastCameraLogTick = Long.MIN_VALUE;
    private float lastLoggedCameraMain = Float.NaN;
    private float lastLoggedCameraOff = Float.NaN;
    private boolean rangedChargeActive = false;
    private InteractionHand rangedChargeWeaponHand = InteractionHand.MAIN_HAND;
    private InteractionHand rangedChargeArrowHand = null;
    private boolean rangedSpriteSuppressed = false;
    private InteractionHand rangedSpriteHand = InteractionHand.MAIN_HAND;
    private int rangedSpriteHoldDepth = 0;
    private RangedChargeKind rangedChargeKind = RangedChargeKind.BOW;
    private final Map<InteractionHand, Long> rangedReleaseStopTimes = new EnumMap<InteractionHand, Long>(InteractionHand.class);
    private final Map<InteractionHand, ReleaseCleanup> rangedReleaseCleanup = new EnumMap<InteractionHand, ReleaseCleanup>(InteractionHand.class);
    private final EnumSet<InteractionHand> activeArrowOverrides = EnumSet.noneOf(InteractionHand.class);
    private final Map<InteractionHand, ItemStack> savedArrowOverrides = new EnumMap<InteractionHand, ItemStack>(InteractionHand.class);
    private final Map<InteractionHand, Boolean> savedArrowHidden = new EnumMap<InteractionHand, Boolean>(InteractionHand.class);
    private final Map<InteractionHand, Boolean> crossbowHiddenStates = new EnumMap<InteractionHand, Boolean>(InteractionHand.class);
    private boolean spyglassActive = false;
    private InteractionHand spyglassHand = InteractionHand.MAIN_HAND;
    private boolean spyglassZoomAllowed = false;
    private boolean fallToWaterActive = false;
    private final EnumSet<InteractionHand> fallToWaterHands = EnumSet.noneOf(InteractionHand.class);
    private boolean swimmingActive = false;
    private double swimmingDirection = 1.0;
    private final EnumSet<InteractionHand> swimmingHands = EnumSet.noneOf(InteractionHand.class);
    private long swimmingStopDeadline = -1L;
    private boolean swimRightKeyDown = false;
    private boolean swimLeftKeyDown = false;
    private boolean swimRightPending = false;
    private boolean swimLeftPending = false;
    private boolean swimForwardHeldLast = false;
    private final Map<InteractionHand, String> swimmingStrafeClips = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private static final int SWIM_STRAFE_BLEND_TICKS = 6;
    private final EnumSet<InteractionHand> fallingHands = EnumSet.noneOf(InteractionHand.class);
    private final Map<InteractionHand, String> fallingClips = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private boolean fallChargeActive = false;
    private double fallChargeStartY = Double.NaN;
    private boolean fallChargeTracking = false;
    private int swimStrafeBlendTicks = 0;
    private boolean swimStrafeStopScheduled = false;
    private boolean shieldActive = false;
    private InteractionHand shieldHand = InteractionHand.MAIN_HAND;
    private int shieldHurtTime = 0;
    private int shieldItemDamage = -1;
    private final EnumSet<InteractionHand> selectSuppressionHands = EnumSet.noneOf(InteractionHand.class);
    private final EnumSet<InteractionHand> walkingHands = EnumSet.noneOf(InteractionHand.class);
    private final EnumSet<InteractionHand> selectHands = EnumSet.noneOf(InteractionHand.class);
    private final EnumSet<InteractionHand> jumpHands = EnumSet.noneOf(InteractionHand.class);
    private final EnumSet<InteractionHand> jumpHoldHands = EnumSet.noneOf(InteractionHand.class);
    private final Map<InteractionHand, Double> jumpHoldProgress = new EnumMap<InteractionHand, Double>(InteractionHand.class);
    private final Map<InteractionHand, Long> jumpStopTimes = new EnumMap<InteractionHand, Long>(InteractionHand.class);
    private final Map<InteractionHand, Double> jumpClipDurations = new EnumMap<InteractionHand, Double>(InteractionHand.class);
    private final Map<InteractionHand, Double> walkSpeedByHand = new EnumMap<InteractionHand, Double>(InteractionHand.class);
    private final Map<InteractionHand, String> walkingClips = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private boolean walkActive = false;
    private double walkSpeedMultiplier = 1.0;
    private boolean jumpActive = false;
    private boolean wasOnGround = true;
    private boolean jumpInitialized = false;
    private boolean landingArmed = false;
    private long lastJumpSpringLogTick = Long.MIN_VALUE;
    private final Map<InteractionHand, JumpSpringPose> lastLoggedJumpSpringPoses = new EnumMap<InteractionHand, JumpSpringPose>(InteractionHand.class);
    private final Map<InteractionHand, Long> landingStopTimes = new EnumMap<InteractionHand, Long>(InteractionHand.class);
    private boolean idlePrimedThisSession = false;
    public static final ThreadLocal<Boolean> IN_MAP_RENDER;
    private static final int GECKOLIB_FPS = 60;
    private ActivationSource activationSource = ActivationSource.NONE;
    private boolean activationTargetIsEntity = false;
    private boolean inspectActive = false;
    private ItemStack inspectStack = ItemStack.EMPTY;
    private long inspectStopGameTime = -1L;
    private int inspectBlendTicks = 0;
    private static final int INSPECT_BLEND_TICKS = 8;
    private boolean pendingUseTrigger = false;
    private InteractionHand pendingUseHand = InteractionHand.MAIN_HAND;
    private boolean pendingUseInteractsWithBlock = false;
    private int useAnimationTicks = 0;
    private InteractionHand useAnimationHand = InteractionHand.MAIN_HAND;
    private String useAnimationClip = "";
    private boolean useInteractsWithBlock = false;
    private boolean usebrushHolding = false;
    private boolean useClickConsumed = false;
    private boolean useTargetWasEntity = false;
    private boolean flintAndSteelDualActive = false;
    private InteractionHand flintAndSteelProxyHand = null;
    private ItemStack flintAndSteelSavedOverride = ItemStack.EMPTY;
    private boolean flintAndSteelSavedHidden = false;
    private boolean flintAndSteelCleanupPending = false;
    private InteractionHand lockedUseHand = null;
    private ItemStack lockedUseStack = ItemStack.EMPTY;
    private final Map<InteractionHand, String> lastActivationClip = new EnumMap<InteractionHand, String>(InteractionHand.class);
    private final Map<AnimationRunKey, AnimationRunInfo> animationRuns = new HashMap<AnimationRunKey, AnimationRunInfo>();
    private boolean walkOnWaterActive = false;
    private final EnumSet<InteractionHand> walkOnWaterHands = EnumSet.noneOf(InteractionHand.class);
    private final EnumSet<InteractionHand> walkOnWaterPausedHands = EnumSet.noneOf(InteractionHand.class);
    private boolean walkOnWaterStopScheduled = false;
    private int walkOnWaterBlendTicks = 0;
    private double walkOnWaterAnimSpeed = 1.0;
    private int walkOnWaterExitGrace = 0;
    private static final int WALK_ON_WATER_BLEND_TICKS = 8;
    private static final int WALK_ON_WATER_EXIT_GRACE_TICKS = 6;
    private static final double SWAY_PRIMARY_WEIGHT = 0.85;
    private static final double SWAY_SECONDARY_WEIGHT = 0.15;

    public PunchyClient() {
        INSTANCE = this;
    }

    public static void initialize() {
        Punchy.applyCombatToggles(PunchyConfig.load());
        ClientBridge.setHooks(new ClientHooks());
        PunchyClient.registerInspectKey();
        PunchyClient client = new PunchyClient();
        ClientPlatformServices services = ClientPlatform.get();
        services.registerClientStarted(PunchyTuningConfig::loadAndApply);
        TuningKeybinds.register();
        services.registerClientTick(() -> client.onClientTick(Minecraft.getInstance()));
        services.registerRenderFrame(() -> client.onRenderFrame(Minecraft.getInstance()));
        client.handleResourceReload();
        ModMessages.registerS2CPackets();
    }

    private void handleResourceReload() {
        ToolAnimationOverrides.clearAll();
        ArmAnimationOverrides.clearAll();
        HandItemOverrides.clearAll();
        this.cancelPunchLoopForHand(InteractionHand.MAIN_HAND);
        this.cancelPunchLoopForHand(InteractionHand.OFF_HAND);
        this.lastActivationClip.clear();
        this.pendingIdleTransitionSources.clear();
        this.punchLoops.clear();
        this.selectHands.clear();
        this.attackLoopArmed = false;
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            this.ensureIdle(client);
        }
    }

    public static void queueUseAnimation(InteractionHand hand) {
        PunchyClient.queueUseAnimation(hand, false);
    }

    public static void queueUseAnimation(InteractionHand hand, boolean interactsWithBlock) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            InteractionHand resolved;
            inst.lockedUseHand = resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
            ItemStack lockStack = inst.lastStackForHand(resolved);
            inst.lockedUseStack = lockStack == null ? ItemStack.EMPTY : lockStack.copy();
            inst.pendingUseTrigger = true;
            inst.pendingUseHand = resolved;
            inst.pendingUseInteractsWithBlock = interactsWithBlock;
        }
    }

    public static void triggerImmediateUse(LocalPlayer player, InteractionHand hand, boolean interactsWithBlock) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        inst.lockedUseHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        ItemStack lockStack = inst.lastStackForHand(inst.lockedUseHand);
        inst.lockedUseStack = lockStack == null ? ItemStack.EMPTY : lockStack.copy();
        inst.startUseAction(client, hand, interactsWithBlock);
    }

    private void onClientTick(Minecraft client) {
        TuningKeybinds.handleClientTick(client);
        AnchorDebugProbe.tick(client);
        LocalPlayer player = client.player;
        if (player == null || client.level == null) {
            this.resetCameraLag();
            this.resetState(client);
            return;
        }
        if (!this.idlePrimedThisSession) {
            this.primeIdleState(player);
        }
        this.maintainFlintAndSteelVisibility();
        HitResult crosshair = client.hitResult;
        boolean hasBlockTarget = false;
        if (crosshair instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)crosshair;
            if (crosshair.getType() == HitResult.Type.BLOCK) {
                BlockState state = client.level.getBlockState(blockHit.getBlockPos());
                hasBlockTarget = state != null && !state.isAir();
            }
        }
        boolean attackKeyDown = client.options.keyAttack.isDown();
        boolean attackBlocked = player.isBlocking();
        boolean canStartAttack = attackKeyDown && !attackBlocked && this.activationSource == ActivationSource.NONE && (!this.wasAttacking || hasBlockTarget);
        int n = this.attackHoldTicks = attackKeyDown ? this.attackHoldTicks + 1 : 0;
        if (!attackKeyDown) {
            InteractionHand loopHand;
            PunchLoopState state;
            this.attackLoopArmed = false;
            if (this.activationSource == ActivationSource.PUNCH && (state = this.punchLoops.get(loopHand = this.activationHand == null ? InteractionHand.MAIN_HAND : this.activationHand)) != null) {
                state.requestStop(PunchLoopState.defaultTailTicks());
            }
        } else if (this.attackHoldTicks >= 6) {
            this.attackLoopArmed = true;
        }
        if (canStartAttack) {
            this.startPunch(client);
        } else if (!attackKeyDown && this.activationSource == ActivationSource.PUNCH) {
            this.attackLoopArmed = false;
        }
        this.wasAttacking = attackKeyDown;
        boolean useKeyDown = client.options.keyUse.isDown();
        if (!useKeyDown) {
            this.useClickConsumed = false;
        }
        this.wasUsing = useKeyDown;
        if (attackKeyDown) {
            this.updateMiningTarget(client);
        }
        if (this.pendingUseTrigger) {
            this.startUseAction(client, this.pendingUseHand, this.pendingUseInteractsWithBlock);
            this.pendingUseTrigger = false;
            this.pendingUseInteractsWithBlock = false;
        }
        if (this.transitionActive) {
            long now;
            boolean releasingHandActive;
            InteractionHand transitionHandLocal = this.transitionHand;
            boolean bl = releasingHandActive = transitionHandLocal == this.consumeHand && this.consuming;
            if (!releasingHandActive && client.player != null && client.level != null && this.transitionStopGameTime > 0L && (now = client.level.getGameTime()) >= this.transitionStopGameTime) {
                this.handleTransitionStopped(this.transitionHand);
            }
        }
        if (this.activationSource == ActivationSource.USE && this.useAnimationTicks > 0) {
            --this.useAnimationTicks;
            if (this.useAnimationTicks <= 0) {
                this.handleUseCycleComplete(client);
            }
        }
        this.tickPunchLoops(client);
        this.handleSelectAnimation(client);
        this.handleConsume(client);
        this.handleSpyglassUse(client);
        this.handleWaterFall(client);
        this.handleSwimming(client);
        this.tickSwimStrafeBlend(client.player);
        this.handleJumpAndLanding(client);
        this.handleWalk(client);
        this.handleRangedCharge(client);
        this.updateRangedReleaseStops(client.player);
        this.handleShieldUse(client);
        this.tickInspect(client);
        this.handleInspect(client);
        this.ensureIdle(client);
    }

    private void onRenderFrame(Minecraft client) {
        if (client == null) {
            return;
        }
        LocalPlayer player = client.player;
        if (player == null || client.level == null) {
            this.resetCameraLag();
            this.resetLanternPhysicsStates();
            this.resetJumpSpringStates();
            return;
        }
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            this.resetCameraLag();
            this.resetLanternPhysicsStates();
            this.resetJumpSpringStates();
            return;
        }
        float partial = client.getDeltaTracker().getGameTimeDeltaPartialTick(!client.isPaused());
        this.updateCameraLag(client, partial);
        this.updateLanternPhysics(client);
        this.updateJumpSprings(client);
        HandSwayPhysics.get().tick();
    }

    private void startPunch(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        this.cancelSwimming(player);
        this.stopInspect(player);
        this.interruptSelectForMouseAction(player, null);
        this.stopTransition((Player)player);
        this.stopJump((Player)player);
        this.stopLanding((Player)player);
        InteractionHand activeHand = this.findAttackHand(player);
        if (activeHand == null) {
            this.stopWalk((Player)player);
            this.stopFallingAnimations((Player)player);
            return;
        }
        this.stopWalkForHands((Player)player, EnumSet.of(activeHand));
        this.activationHand = activeHand;
        this.triggerPunchCycle(player, activeHand);
    }

    private void triggerPunchCycle(LocalPlayer player, InteractionHand hand) {
        String clip;
        if (player == null || hand == null) {
            return;
        }
        this.stopFallingAnimation((Player)player, hand);
        AnimatedTool.markNextActionHand(hand);
        AnimatedTool.markNextActionFromUse(false);
        ItemStack held = player.getItemInHand(hand);
        ItemStack clipStack = this.stackForAttackResolution(held, hand);
        AttackTarget target = this.consumePendingAttackTarget();
        if (target == null) {
            target = PunchyClient.detectAttackTarget(player);
        }
        boolean entityTarget = target.entity();
        boolean blockTarget = target.block();
        String previousClip = this.lastActivationClip.get(hand);
        boolean loopClip = false;
        if (!entityTarget && blockTarget) {
            clip = PunchyClient.randomizeLoopClip(PunchyClient.resolveBlockLoopClip(clipStack), previousClip);
            loopClip = true;
        } else {
            clip = PunchyClient.resolveAttackClip(clipStack, true, previousClip);
        }
        if (clip == null || clip.isEmpty()) {
            if (!entityTarget && blockTarget) {
                clip = PunchyClient.randomizeLoopClip(PunchyClient.resolveBlockLoopClip(clipStack), previousClip);
                loopClip = true;
            } else {
                clip = PunchyClient.resolveAttackClip(clipStack, true, previousClip);
            }
        }
        BoneAnimationController.triggerActivation((Player)player, hand, clip);
        HandSwayPhysics.get().trigger(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        this.lastActivationClip.put(hand, clip);
        this.activationSource = ActivationSource.PUNCH;
        this.activationTargetIsEntity = entityTarget;
        int durationTicks = Math.max(1, (int)Math.round(this.clipDurationSeconds((Player)player, hand, clip) * 20.0));
        if (loopClip) {
            this.punchLoops.put(hand, new PunchLoopState(durationTicks));
        } else {
            this.punchLoops.remove(hand);
        }
    }

    private void stopPunch(Minecraft client) {
        if (this.activationSource != ActivationSource.PUNCH) {
            return;
        }
        LocalPlayer player = client.player;
        InteractionHand cleanupHand = InteractionHand.MAIN_HAND;
        if (player != null) {
            InteractionHand activeHand = this.findAttackHand(player);
            InteractionHand handToUse = activeHand == null ? InteractionHand.MAIN_HAND : activeHand;
            ItemStack held = player.getItemInHand(handToUse);
            ItemStack clipStack = this.stackForAttackResolution(held, handToUse);
            boolean shouldTransition = ProxyItemHelper.requiresProxy(held);
            String clip = this.lastActivationClip.get(handToUse);
            if (clip == null || clip.isEmpty()) {
                AttackTarget target = PunchyClient.detectAttackTarget(player);
                boolean entityTarget = target.entity();
                boolean blockTarget = target.block();
                clip = blockTarget ? PunchyClient.randomizeLoopClip(PunchyClient.resolveBlockLoopClip(clipStack), null) : PunchyClient.resolveAttackClip(clipStack, entityTarget, null);
            }
            boolean playedTransition = false;
            boolean queuedIdleTransition = this.queueIdleTransitionAfterClip(handToUse, CONTROLLER_ACTIVATION, clip);
            if (!queuedIdleTransition && shouldTransition) {
                playedTransition = this.playReleaseTransition(player, handToUse);
            }
            if (!playedTransition) {
                AnimatedTool.markNextActivationSpeed(5.0);
                this.stopTransition((Player)player);
                this.stopActivationLoop((Player)player, handToUse, clip, false);
            }
            cleanupHand = handToUse;
            this.finalizePunch((Player)player, cleanupHand);
        } else {
            this.finalizePunch(null, cleanupHand);
        }
    }

    private void finalizePunch(Player player, InteractionHand cleanupHand) {
        LocalPlayer lp;
        LocalPlayer localPlayer;
        this.activationSource = ActivationSource.NONE;
        this.activationHand = InteractionHand.MAIN_HAND;
        InteractionHand safeHand = cleanupHand == null ? InteractionHand.MAIN_HAND : cleanupHand;
        this.lastActivationClip.remove(safeHand);
        this.punchLoops.remove(safeHand);
        this.activationTargetIsEntity = false;
        AnimatedTool.resetActivationSpeed();
        LocalPlayer localPlayer2 = localPlayer = player instanceof LocalPlayer ? (lp = (LocalPlayer)player) : Minecraft.getInstance().player;
        if (!this.transitionActive && localPlayer != null && !this.hasIdleTransitionInFlight(safeHand)) {
            ToolAnimationOverrides.clear(safeHand);
            this.ensureIdleAfterAction(localPlayer, safeHand);
        }
        this.resumeWalkOnWaterForHands(localPlayer, EnumSet.of(safeHand));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateMiningTarget(Minecraft client) {
        HitResult target = client.hitResult;
        if (target instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)target;
            if (target.getType() == HitResult.Type.BLOCK) {
                lastMiningTargetPos = blockHit.getBlockPos();
                return;
            }
        }
        lastMiningTargetPos = null;
    }

    private void resetState(Minecraft client) {
        this.finalizeFlintAndSteelCleanup(true);
        this.wasAttacking = false;
        this.stopPunch(client);
        this.stopJump((Player)(client != null ? client.player : null));
        this.stopLanding((Player)(client != null ? client.player : null));
        this.stopWalk((Player)(client != null ? client.player : null));
        this.stopTransition((Player)(client != null ? client.player : null));
        this.stopUseAction(client);
        this.stopInspect(client != null ? client.player : null);
        this.stopConsume((Player)(client != null ? client.player : null));
        this.punchLoops.clear();
        this.stopRangedCharge((Player)(client != null ? client.player : null));
        this.stopSpyglassUse((Player)(client != null ? client.player : null));
        this.stopShieldUse((Player)(client != null ? client.player : null));
        this.stopIdle((Player)(client != null ? client.player : null));
        this.pendingUseTrigger = false;
        this.pendingUseHand = InteractionHand.MAIN_HAND;
        this.pendingUseInteractsWithBlock = false;
        this.useAnimationHand = InteractionHand.MAIN_HAND;
        this.useAnimationTicks = 0;
        this.wasUsing = false;
        this.attackHoldTicks = 0;
        this.attackLoopArmed = false;
        this.useInteractsWithBlock = false;
        ToolAnimationOverrides.clearAll();
        ArmAnimationOverrides.clearAll();
        this.lanternPhysics.clear();
        this.lastLanternTickTime = System.nanoTime();
        this.idlePrimedThisSession = false;
        HandItemOverrides.clearAll();
        this.crossbowHiddenStates.clear();
        this.releaseBowSpriteSuppression();
        this.selectSuppressionHands.clear();
        this.resetCameraLag();
        this.resetLanternPhysicsStates();
        this.resetJumpSpringStates();
        this.resetIdleTransitionState();
        this.rangedReleaseStopTimes.clear();
        this.rangedReleaseCleanup.clear();
        this.lastActivationClip.clear();
    }

    private void resetLanternPhysicsStates() {
        for (LanternPhysicsState lanternPhysicsState : this.lanternPhysics.values()) {
            if (lanternPhysicsState == null) continue;
            lanternPhysicsState.reset();
        }
        for (LanternGripState lanternGripState : this.lanternGrips.values()) {
            if (lanternGripState == null) continue;
            lanternGripState.reset();
        }
        this.lanternTimeRemainder = 0.0f;
    }

    private void resetJumpSpringStates() {
        for (JumpSpringState jumpSpringState : this.jumpSprings.values()) {
            if (jumpSpringState == null) continue;
            jumpSpringState.reset();
        }
        for (SneakSpringState sneakSpringState : this.sneakSprings.values()) {
            if (sneakSpringState == null) continue;
            sneakSpringState.reset();
        }
        this.springTimeRemainder = 0.0f;
        this.lastLoggedJumpSpringPoses.clear();
        this.lastJumpSpringLogTick = Long.MIN_VALUE;
    }

    private void startUseAction(Minecraft client, InteractionHand hand, boolean interactsWithBlockHint) {
        boolean airClickEmptyMain;
        boolean specialEntityInsert;
        BlockHitResult blockHit;
        InteractionHand targetHand;
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        this.cancelSwimming(player);
        this.stopInspect(player);
        InteractionHand interactionHand = targetHand = hand == null ? PunchyClient.findProxyHand(player) : hand;
        if (targetHand == null) {
            return;
        }
        this.interruptSelectForMouseAction(player, targetHand);
        if (this.lockedUseHand != null && targetHand != this.lockedUseHand) {
            return;
        }
        ItemStack stack = player.getItemInHand(targetHand);
        if (!ProxyItemHelper.requiresProxy(stack)) {
            return;
        }
        if (PunchyClient.isShield(stack)) {
            return;
        }
        if (stack.getItem() instanceof TridentItem) {
            return;
        }
        if (stack.getItem() instanceof BowItem || stack.getItem() instanceof CrossbowItem) {
            return;
        }
        if (PunchyClient.isConsumable(stack)) {
            return;
        }
        boolean hasEntityTarget = client.crosshairPickEntity != null;
        boolean entityTarget = hasEntityTarget || client.hitResult instanceof EntityHitResult;
        HitResult hitResult = client.hitResult;
        boolean blockTarget = hitResult instanceof BlockHitResult && (blockHit = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK && client.level != null && !client.level.getBlockState(blockHit.getBlockPos()).isAir();
        boolean interactingWithBlock = interactsWithBlockHint || !entityTarget && blockTarget;
        boolean bl = specialEntityInsert = entityTarget && targetHand == InteractionHand.MAIN_HAND && PunchyClient.isEmptyHand(stack);
        if (specialEntityInsert) {
            interactingWithBlock = true;
        }
        boolean bl2 = airClickEmptyMain = targetHand == InteractionHand.MAIN_HAND && PunchyClient.isEmptyHand(stack) && (client.hitResult == null || client.hitResult.getType() == HitResult.Type.MISS);
        if (airClickEmptyMain && !specialEntityInsert) {
            this.useClickConsumed = true;
            return;
        }
        if (interactingWithBlock && PunchyClient.isThrowableItem(stack)) {
            interactingWithBlock = false;
        }
        if (this.activationSource == ActivationSource.USE && this.useAnimationHand == targetHand && "insert".equals(this.useAnimationClip)) {
            this.stopActivationLoop((Player)player, targetHand, "insert", false);
            ToolAnimationOverrides.clear(targetHand);
            this.activationSource = ActivationSource.NONE;
            this.useAnimationTicks = 0;
            this.useAnimationClip = "";
            this.useInteractsWithBlock = interactingWithBlock;
        } else {
            this.useInteractsWithBlock = interactingWithBlock;
        }
        this.useTargetWasEntity = specialEntityInsert;
        this.stopWalkForHands((Player)player, EnumSet.of(targetHand));
        AnimatedTool.markNextActionHand(targetHand);
        AnimatedTool.markNextActionFromUse(true);
        this.triggerUseClip(player, targetHand, stack, interactingWithBlock);
        this.stopIdleForHand((Player)player, targetHand);
    }

    private void triggerUseClip(LocalPlayer player, InteractionHand hand, ItemStack sourceStack, boolean interactingWithBlock) {
        String clip;
        if (player == null || hand == null) {
            return;
        }
        if (this.lockedUseHand != null && hand != this.lockedUseHand) {
            return;
        }
        ItemStack clipStack = this.stackForClipResolution(sourceStack, hand);
        if (PunchyClient.isThrowableItem(clipStack)) {
            interactingWithBlock = false;
        }
        if ((clip = PunchyClient.randomizeLoopClip(PunchyClient.resolveRightClickClip(clipStack, interactingWithBlock))) == null || clip.isEmpty()) {
            clip = PunchyClient.resolveRightClickClip(clipStack, interactingWithBlock);
        }
        if (PunchyClient.isBucketClip(clip)) {
            this.suppressNextSelect(hand);
        }
        BoneAnimationController.triggerActivation((Player)player, hand, clip);
        HandSwayPhysics.get().trigger(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        this.maybeTriggerFlintAndSteelDualAnimation(player, hand, clip);
        this.activationSource = ActivationSource.USE;
        this.useAnimationTicks = this.resolveUseAnimationTicks(player, hand, clip);
        this.useAnimationHand = hand;
        this.useAnimationClip = clip;
        this.usebrushHolding = "usebrush".equals(clip);
    }

    private void maybeTriggerFlintAndSteelDualAnimation(LocalPlayer player, InteractionHand hand, String clip) {
        InteractionHand other;
        if (player == null || hand == null || !FLINT_STEEL_CLIP.equals(clip)) {
            return;
        }
        InteractionHand interactionHand = other = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand != other) {
            this.beginFlintAndSteelProxy(other);
        }
        AnimatedTool.markNextActionHand(other);
        AnimatedTool.markNextActionFromUse(true);
        this.stopIdleForHand((Player)player, other);
        BoneAnimationController.triggerActivation((Player)player, other, FLINT_STEEL_CLIP);
    }

    private void beginFlintAndSteelProxy(InteractionHand other) {
        if (other == null) {
            return;
        }
        this.flintAndSteelProxyHand = other;
        ItemStack previous = HandItemOverrides.getOverride(other);
        this.flintAndSteelSavedOverride = previous == null ? ItemStack.EMPTY : previous.copy();
        this.flintAndSteelSavedHidden = HandItemOverrides.isHidden(other);
        HandItemOverrides.setHidden(other, false);
        HandItemOverrides.setOverride(other, FLINT_AND_STEEL_PROXY_STACK);
        this.flintAndSteelDualActive = true;
        this.flintAndSteelCleanupPending = false;
        ArmAnimationOverrides.setForceRender(other, true);
    }

    private void maintainFlintAndSteelVisibility() {
        if (this.flintAndSteelDualActive && this.flintAndSteelProxyHand != null) {
            ArmAnimationOverrides.setForceRender(this.flintAndSteelProxyHand, true);
        }
    }

    private void requestFlintAndSteelCleanup(Player player) {
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand == null || this.flintAndSteelCleanupPending) {
            return;
        }
        InteractionHand other = this.flintAndSteelProxyHand;
        if (player != null) {
            this.stopActivationLoop(player, other, FLINT_STEEL_CLIP, false);
            ToolAnimationOverrides.clear(other);
        }
        this.flintAndSteelCleanupPending = true;
    }

    private void finalizeFlintAndSteelCleanup(boolean force) {
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand == null) {
            this.flintAndSteelCleanupPending = false;
            return;
        }
        if (!force && !this.flintAndSteelCleanupPending) {
            return;
        }
        InteractionHand other = this.flintAndSteelProxyHand;
        HandItemOverrides.setOverride(other, this.flintAndSteelSavedOverride);
        HandItemOverrides.setHidden(other, this.flintAndSteelSavedHidden);
        ArmAnimationOverrides.clear(other);
        this.flintAndSteelDualActive = false;
        this.flintAndSteelProxyHand = null;
        this.flintAndSteelSavedOverride = ItemStack.EMPTY;
        this.flintAndSteelSavedHidden = false;
        this.flintAndSteelCleanupPending = false;
    }

    private void stopUseAction(Minecraft client) {
        if (this.activationSource != ActivationSource.USE) {
            return;
        }
        LocalPlayer player = client.player;
        if (player != null) {
            ItemStack held = player.getItemInHand(this.useAnimationHand);
            String clip = this.useAnimationClip == null || this.useAnimationClip.isEmpty() ? PunchyClient.resolveRightClickClip(held, this.useInteractsWithBlock) : this.useAnimationClip;
            boolean playedTransition = false;
            boolean queuedIdleTransition = this.queueIdleTransitionAfterClip(this.useAnimationHand, CONTROLLER_ACTIVATION, clip);
            if (!queuedIdleTransition && "insert".equals(clip)) {
                playedTransition = this.playReleaseTransition(player, this.useAnimationHand);
            }
            if (!playedTransition) {
                AnimatedTool.markNextActivationSpeed(2.0);
                this.stopActivationLoop((Player)player, this.useAnimationHand, clip, false);
            }
        }
        ToolAnimationOverrides.clear(this.useAnimationHand);
        this.requestFlintAndSteelCleanup((Player)player);
        this.finalizeFlintAndSteelCleanup(true);
        this.lockedUseHand = null;
        this.lockedUseStack = ItemStack.EMPTY;
        this.activationSource = ActivationSource.NONE;
        this.useAnimationTicks = 0;
        this.useAnimationHand = InteractionHand.MAIN_HAND;
        this.useAnimationClip = "";
        this.useInteractsWithBlock = false;
        this.usebrushHolding = false;
        this.useTargetWasEntity = false;
        AnimatedTool.resetActivationSpeed();
    }

    private void handleUseCycleComplete(Minecraft client) {
        boolean interactingWithBlock;
        BlockHitResult blockHit;
        LocalPlayer player;
        if (this.activationSource != ActivationSource.USE) {
            return;
        }
        LocalPlayer localPlayer = player = client == null ? null : client.player;
        if (player == null) {
            this.stopUseAction(client);
            return;
        }
        boolean hasEntityTarget = client.crosshairPickEntity != null;
        boolean entityTarget = hasEntityTarget || client.hitResult instanceof EntityHitResult;
        HitResult hitResult = client.hitResult;
        boolean blockTarget = hitResult instanceof BlockHitResult && (blockHit = (BlockHitResult)hitResult).getType() == HitResult.Type.BLOCK && client.level != null && !client.level.getBlockState(blockHit.getBlockPos()).isAir();
        boolean bl = interactingWithBlock = !entityTarget && blockTarget || this.useInteractsWithBlock;
        if (this.usebrushHolding) {
            this.useInteractsWithBlock = interactingWithBlock;
            return;
        }
        if (this.useClickConsumed) {
            this.useInteractsWithBlock = interactingWithBlock;
            return;
        }
        this.useClickConsumed = true;
        this.useInteractsWithBlock = interactingWithBlock;
        if (this.useTargetWasEntity) {
            this.useTargetWasEntity = false;
            this.stopUseAction(client);
            return;
        }
    }

    private void tickPunchLoops(Minecraft client) {
        boolean canLoop;
        HitResult target;
        if (this.activationSource != ActivationSource.PUNCH) {
            this.punchLoops.clear();
            return;
        }
        InteractionHand hand = this.activationHand == null ? InteractionHand.MAIN_HAND : this.activationHand;
        PunchLoopState state = this.punchLoops.get(hand);
        if (state == null) {
            return;
        }
        LocalPlayer player = client == null ? null : client.player;
        boolean stillHolding = client != null && client.options.keyAttack.isDown();
        String clip = this.lastActivationClip.get(hand);
        boolean hasBlockTarget = false;
        if (client != null && (target = client.hitResult) instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)target;
            if (target.getType() == HitResult.Type.BLOCK && client.level != null) {
                hasBlockTarget = !client.level.getBlockState(blockHit.getBlockPos()).isAir();
            }
        }
        boolean bl = canLoop = stillHolding && !state.stopRequested() && this.attackLoopArmed && player != null && ProxyItemHelper.requiresProxy(player.getItemInHand(hand)) && hasBlockTarget && PunchyClient.isMiningLoopClip(clip);
        if (state.tick(canLoop)) {
            if (state.justLooped()) {
                HandSwayPhysics.get().trigger(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
            }
        } else {
            this.punchLoops.remove(hand);
            if (player != null) {
                if (clip == null || clip.isEmpty()) {
                    clip = "attack";
                }
                AnimatedTool.markNextActivationSpeed(2.0);
                this.stopActivationLoop((Player)player, hand, clip, true);
            } else {
                this.finalizePunch(null, hand);
            }
        }
    }

    private void cancelPunchLoopForHand(InteractionHand hand) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        PunchLoopState state = this.punchLoops.remove(resolved);
        if (state != null) {
            state.requestStop(0);
        }
    }

    private void stopLoopedAnimation(Player player, String controller, String clip, InteractionHand hand) {
        this.requestStopForClip(player, hand, controller, clip);
        this.cancelPunchLoopForHand(hand);
    }

    private void stopActivationLoop(Player player, InteractionHand hand, String clip, boolean finalize) {
        this.stopLoopedAnimation(player, CONTROLLER_ACTIVATION, clip, hand);
        if (finalize && this.activationSource == ActivationSource.PUNCH) {
            this.finalizePunch(player, hand);
        }
    }

    private static boolean isMiningLoopClip(String clip) {
        String normalized = PunchyClient.normalizeClipKey(clip);
        if (normalized == null || normalized.isEmpty()) {
            return false;
        }
        return switch (normalized) {
            case "sway_forward", "sway_forward_2", "sway_forward_3", "sway_sideways", "sway_sideways_2", "sway_sideways_3", "sway_digging", "punch", PUNCH_TRIGGER -> true;
            default -> normalized.startsWith("walk_") || normalized.startsWith("mine");
        };
    }

    private void resetFallCharge(Player player) {
        if (player != null) {
            this.stopFallingAnimation(player, InteractionHand.MAIN_HAND);
            this.stopFallingAnimation(player, InteractionHand.OFF_HAND);
        }
        this.fallChargeActive = false;
        this.fallChargeStartY = Double.NaN;
        this.fallChargeTracking = false;
    }

    private void handleRangedCharge(Minecraft client) {
        InteractionHand arrowHand;
        ItemStack useStack;
        RangedChargeKind kind;
        boolean holdSuppressed;
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopRangedCharge(null);
            return;
        }
        boolean vanillaUsing = player.isUsingItem();
        boolean bl = holdSuppressed = UseAnimationSuppressor.isSuppressed() && this.rangedChargeActive;
        if (!vanillaUsing && !holdSuppressed) {
            this.stopRangedCharge((Player)player);
            return;
        }
        if (holdSuppressed) {
            this.clampBowUseTicks(player);
        }
        if ((kind = RangedChargeKind.fromStack(useStack = player.getUseItem())) == null) {
            this.stopRangedCharge((Player)player);
            return;
        }
        InteractionHand usedHand = player.getUsedItemHand();
        if (usedHand == null && this.rangedChargeActive) {
            usedHand = this.rangedChargeWeaponHand;
        }
        if (usedHand == null || !ProxyItemHelper.requiresProxy(player.getItemInHand(usedHand))) {
            this.stopRangedCharge((Player)player);
            return;
        }
        InteractionHand interactionHand = kind.usesArrowHand() ? (usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND) : (arrowHand = null);
        if (!this.rangedChargeActive || this.rangedChargeWeaponHand != usedHand || this.rangedChargeArrowHand != arrowHand || this.rangedChargeKind != kind) {
            this.startRangedCharge(player, kind, usedHand, arrowHand);
        }
    }

    private void startRangedCharge(LocalPlayer player, RangedChargeKind kind, InteractionHand weaponHand, InteractionHand arrowHand) {
        this.stopRangedCharge((Player)player);
        EnumSet<InteractionHand> walkHandsToStop = EnumSet.noneOf(InteractionHand.class);
        walkHandsToStop.add(weaponHand);
        if (arrowHand != null) {
            walkHandsToStop.add(arrowHand);
        }
        this.stopWalkForHands((Player)player, walkHandsToStop);
        if (kind.suppressSprite()) {
            this.suppressBowSprite(weaponHand, true);
        }
        this.rangedReleaseStopTimes.remove(weaponHand);
        AnimatedTool.markNextActionHand(weaponHand);
        BoneAnimationController.trigger((Player)player, weaponHand, kind.controller(), kind.weaponClip());
        if (kind.usesArrowHand() && arrowHand != null && !kind.arrowClip().isEmpty()) {
            AnimatedTool.markNextActionHand(arrowHand);
            this.rangedReleaseStopTimes.remove(arrowHand);
            BoneAnimationController.trigger((Player)player, arrowHand, kind.controller(), kind.arrowClip());
            ArmAnimationOverrides.setForceRender(arrowHand, true);
        } else {
            arrowHand = null;
        }
        this.rangedChargeActive = true;
        this.rangedChargeKind = kind;
        this.rangedChargeWeaponHand = weaponHand;
        this.rangedChargeArrowHand = arrowHand;
        this.stopIdleForHand((Player)player, weaponHand);
        if (arrowHand != null) {
            this.stopIdleForHand((Player)player, arrowHand);
        }
    }

    private void stopRangedCharge(Player player) {
        if (!this.rangedChargeActive) {
            return;
        }
        if (player != null) {
            if (!this.rangedChargeKind.releaseClip().isEmpty()) {
                this.playRangedReleaseClip(player, this.rangedChargeWeaponHand, this.rangedChargeKind);
                this.queueRangedReleaseCleanup(this.rangedChargeWeaponHand, this.rangedChargeArrowHand, this.rangedChargeKind);
            } else {
                this.queueIdleTransitionAfterClip(this.rangedChargeWeaponHand, this.rangedChargeKind.controller(), this.rangedChargeKind.weaponClip());
                BoneAnimationController.stop(player, this.rangedChargeWeaponHand, this.rangedChargeKind.controller(), this.rangedChargeKind.weaponClip());
                this.finalizeRangedReleaseCleanup(player, this.rangedChargeWeaponHand, this.rangedChargeArrowHand, this.rangedChargeKind.suppressSprite());
            }
            if (this.rangedChargeKind.usesArrowHand() && this.rangedChargeArrowHand != null && !this.rangedChargeKind.arrowClip().isEmpty()) {
                this.queueIdleTransitionAfterClip(this.rangedChargeArrowHand, this.rangedChargeKind.controller(), this.rangedChargeKind.arrowClip());
                BoneAnimationController.stop(player, this.rangedChargeArrowHand, this.rangedChargeKind.controller(), this.rangedChargeKind.arrowClip());
            }
        }
        if (this.rangedChargeKind.releaseClip().isEmpty()) {
            ArmAnimationOverrides.clear(this.rangedChargeWeaponHand);
            if (this.rangedChargeArrowHand != null) {
                ArmAnimationOverrides.clear(this.rangedChargeArrowHand);
                HandItemOverrides.clear(this.rangedChargeArrowHand);
                HandItemOverrides.setHidden(this.rangedChargeArrowHand, false);
            }
            ToolAnimationOverrides.clear(this.rangedChargeWeaponHand);
            if (this.rangedChargeArrowHand != null) {
                ToolAnimationOverrides.clear(this.rangedChargeArrowHand);
            }
            if (this.rangedChargeKind.suppressSprite()) {
                this.releaseBowSpriteSuppression();
            }
        }
        this.restoreAllCrossbowVisibility();
        this.rangedChargeActive = false;
        this.rangedChargeWeaponHand = InteractionHand.MAIN_HAND;
        this.rangedChargeArrowHand = null;
        this.rangedChargeKind = RangedChargeKind.BOW;
    }

    private void playRangedReleaseClip(Player player, InteractionHand hand, RangedChargeKind kind) {
        if (player == null || hand == null || kind == null || kind.releaseClip().isEmpty()) {
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.trigger(player, hand, kind.controller(), kind.releaseClip());
        double seconds = this.clipDurationSeconds(player, hand, kind.releaseClip());
        this.scheduleRangedReleaseStop(player, hand, seconds);
    }

    private void handleSpyglassUse(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopSpyglassUse(null);
            return;
        }
        if (!player.isUsingItem()) {
            this.stopSpyglassUse((Player)player);
            return;
        }
        ItemStack useStack = player.getUseItem();
        if (useStack == null || !(useStack.getItem() instanceof SpyglassItem)) {
            this.stopSpyglassUse((Player)player);
            return;
        }
        InteractionHand usedHand = player.getUsedItemHand();
        if (usedHand == null) {
            if (!this.spyglassActive) {
                this.stopSpyglassUse((Player)player);
                return;
            }
            usedHand = this.spyglassHand;
        }
        if (!ProxyItemHelper.requiresProxy(player.getItemInHand(usedHand))) {
            if (!this.spyglassActive) {
                this.stopSpyglassUse((Player)player);
                return;
            }
            usedHand = this.spyglassHand;
        }
        if (!this.spyglassActive || this.spyglassHand != usedHand) {
            this.startSpyglassUse(player, usedHand);
        }
    }

    private void startSpyglassUse(LocalPlayer player, InteractionHand hand) {
        this.stopSpyglassUse((Player)player);
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.trigger((Player)player, hand, "Spyglass", "use_spyglass");
        this.suppressBowSprite(hand, false);
        this.spyglassActive = true;
        this.spyglassHand = hand;
        this.spyglassZoomAllowed = false;
        this.stopIdleForHand((Player)player, hand);
    }

    private void stopSpyglassUse(Player player) {
        if (!this.spyglassActive) {
            return;
        }
        if (player != null) {
            BoneAnimationController.stop(player, this.spyglassHand, "Spyglass", "use_spyglass");
        }
        this.releaseBowSpriteSuppression();
        this.spyglassActive = false;
        this.spyglassZoomAllowed = false;
        this.spyglassHand = InteractionHand.MAIN_HAND;
    }

    private void handleWaterFall(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopWaterFall(null);
            return;
        }
        if (this.fallToWaterActive && (PunchyClient.isSupportedBySolid((Player)player) || player.isInWater() || player.getDeltaMovement().y > -0.05)) {
            this.stopWaterFall((Player)player);
            return;
        }
        if (this.fallToWaterActive) {
            return;
        }
        if (PunchyClient.isSupportedBySolid((Player)player) || player.isInWater()) {
            return;
        }
        if (player.getDeltaMovement().y > (double)-0.35f) {
            return;
        }
        BlockHitResult impact = this.clipWaterBelow(player, 64.0);
        if (impact == null) {
            return;
        }
        double drop = player.getY() - impact.getLocation().y;
        if (drop < 7.0) {
            return;
        }
        InteractionHand hand = this.findAttackHand(player);
        if (hand == null) {
            hand = InteractionHand.MAIN_HAND;
        }
        this.startWaterFall(player, hand);
    }

    private void startWaterFall(LocalPlayer player, InteractionHand preferredHand) {
        this.stopWaterFall((Player)player);
        this.fallToWaterHands.clear();
        for (InteractionHand hand : InteractionHand.values()) {
            AnimatedTool.markNextActionHand(hand);
            BoneAnimationController.trigger((Player)player, hand, "FallingWater", "falling_in_water");
            BoneAnimationController.trigger((Player)player, hand, "FallingWaterLoop", "falling_in_water_loop");
            ArmAnimationOverrides.setForceRender(hand, true);
            this.fallToWaterHands.add(hand);
        }
        this.fallToWaterActive = true;
    }

    private void stopWaterFall(Player player) {
        if (!this.fallToWaterActive) {
            return;
        }
        if (player != null) {
            for (InteractionHand hand : this.fallToWaterHands) {
                BoneAnimationController.stop(player, hand, "FallingWater", "falling_in_water");
                BoneAnimationController.stop(player, hand, "FallingWaterLoop", "falling_in_water_loop");
                ArmAnimationOverrides.clear(hand);
            }
        }
        this.fallToWaterHands.clear();
        this.fallToWaterActive = false;
    }

    private void handleSwimming(Minecraft client) {
        boolean inFluid;
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopSwimming(null);
            this.updateSwimStrafeState(false, false, null, client);
            return;
        }
        boolean forwardKey = client.options.keyUp.isDown();
        boolean backwardKey = client.options.keyDown.isDown();
        boolean submerged = player.isUnderWater() || player.isEyeInFluid(FluidTags.WATER);
        boolean bl = inFluid = player.isInWater() || submerged;
        if (this.isSwimmingActionBlocked()) {
            this.cancelSwimming(player);
            this.updateSwimStrafeState(inFluid, forwardKey, player, client);
            return;
        }
        this.updateSwimStrafeState(inFluid, forwardKey, player, client);
        if (!inFluid) {
            this.stopSwimming((Player)player);
            this.stopWalkOnWater(player);
            return;
        }
        if (!submerged) {
            this.stopSwimming((Player)player);
            this.startWalkOnWater(player);
            return;
        }
        double impulse = player.zza;
        double epsilon = 0.001;
        boolean forwardInput = impulse > 0.001 || forwardKey;
        boolean backwardInput = impulse < -0.001 || backwardKey;
        double desiredDirection = 0.0;
        if (forwardInput && !backwardInput) {
            desiredDirection = 1.0;
        } else if (backwardInput && !forwardInput) {
            desiredDirection = -1.0;
        } else if (forwardInput && backwardInput && (desiredDirection = Math.signum(impulse)) == 0.0) {
            double d = forwardKey ? 1.0 : (desiredDirection = backwardKey ? -1.0 : 0.0);
        }
        if (desiredDirection == 0.0) {
            this.updateSwimStrafeState(inFluid, false, player, client);
            this.ensureSwimmingCompletion(player);
            return;
        }
        if (!this.swimmingActive) {
            this.startSwimming(player, desiredDirection);
            return;
        }
        this.swimmingStopDeadline = -1L;
        if (Math.signum(this.swimmingDirection) != Math.signum(desiredDirection)) {
            this.startSwimming(player, desiredDirection);
        }
    }

    private void updateSwimStrafeState(boolean inFluid, boolean forwardHeld, LocalPlayer player, Minecraft client) {
        boolean triggerLeft;
        if (client == null || client.options == null) {
            this.swimRightKeyDown = false;
            this.swimLeftKeyDown = false;
            this.swimRightPending = false;
            this.swimLeftPending = false;
            this.swimForwardHeldLast = false;
            this.stopSwimStrafe((Player)player);
            return;
        }
        boolean forwardTransition = this.swimForwardHeldLast && !forwardHeld;
        this.swimForwardHeldLast = forwardHeld;
        boolean rightDown = client.options.keyRight.isDown();
        boolean leftDown = client.options.keyLeft.isDown();
        if (!inFluid) {
            this.stopSwimStrafe((Player)player);
            this.swimRightKeyDown = false;
            this.swimLeftKeyDown = false;
            this.swimRightPending = false;
            this.swimLeftPending = false;
            this.swimForwardHeldLast = false;
            return;
        }
        if (forwardHeld) {
            if (rightDown) {
                this.swimRightPending = true;
            }
            if (leftDown) {
                this.swimLeftPending = true;
            }
            this.stopSwimStrafe((Player)player);
            this.swimRightKeyDown = rightDown;
            this.swimLeftKeyDown = leftDown;
            return;
        }
        boolean triggerRight = rightDown && (forwardTransition || !this.swimRightKeyDown || this.swimRightPending);
        boolean bl = triggerLeft = leftDown && (forwardTransition || !this.swimLeftKeyDown || this.swimLeftPending);
        if (triggerRight) {
            this.triggerSwimStrafe(player, "swiming_right");
            this.swimRightPending = false;
        }
        if (triggerLeft) {
            this.triggerSwimStrafe(player, "swiming_left");
            this.swimLeftPending = false;
        }
        this.swimRightKeyDown = rightDown;
        this.swimLeftKeyDown = leftDown;
        if (!rightDown) {
            this.swimRightPending = false;
        }
        if (!leftDown) {
            this.swimLeftPending = false;
        }
        if (!rightDown && !leftDown) {
            this.scheduleSwimStrafeStopWithBlend();
        }
    }

    private void triggerSwimStrafe(LocalPlayer player, String clip) {
        if (player == null || clip == null || clip.isEmpty()) {
            return;
        }
        this.swimStrafeBlendTicks = 0;
        this.swimStrafeStopScheduled = false;
        EnumSet<InteractionHand> hands = PunchyClient.collectProxyHands((Player)player);
        if (hands.isEmpty()) {
            return;
        }
        this.cancelSwimming(player);
        this.stopTransition((Player)player);
        this.stopWalk((Player)player);
        for (InteractionHand hand : hands) {
            AnimatedTool.markNextActionHand(hand);
            AnimatedTool.markNextActionFromUse(false);
            BoneAnimationController.trigger((Player)player, hand, "SwimStrafe", clip);
            ArmAnimationOverrides.setForceRender(hand, true);
            this.swimmingStrafeClips.put(hand, clip);
        }
    }

    private void stopSwimStrafe(Player player) {
        if (this.swimmingStrafeClips.isEmpty()) {
            this.swimStrafeBlendTicks = 0;
            this.swimStrafeStopScheduled = false;
            return;
        }
        if (player != null) {
            for (Map.Entry<InteractionHand, String> entry : this.swimmingStrafeClips.entrySet()) {
                String clip = entry.getValue();
                if (clip == null || clip.isEmpty()) continue;
                BoneAnimationController.stop(player, entry.getKey(), "SwimStrafe", clip);
            }
        }
        this.swimmingStrafeClips.clear();
        this.swimStrafeBlendTicks = 0;
        this.swimStrafeStopScheduled = false;
    }

    private void scheduleSwimStrafeStopWithBlend() {
        if (this.swimmingStrafeClips.isEmpty() || this.swimStrafeStopScheduled) {
            return;
        }
        this.swimStrafeBlendTicks = 6;
        this.swimStrafeStopScheduled = true;
    }

    private void tickSwimStrafeBlend(LocalPlayer player) {
        if (!this.swimStrafeStopScheduled || this.swimStrafeBlendTicks <= 0) {
            return;
        }
        --this.swimStrafeBlendTicks;
        if (this.swimStrafeBlendTicks == 0) {
            this.stopSwimStrafe((Player)player);
        }
    }

    private void cancelSwimming(LocalPlayer player) {
        if (player == null) {
            return;
        }
        this.stopSwimStrafe((Player)player);
        this.stopSwimming((Player)player);
        this.stopWalkOnWater(player);
    }

    private void startSwimming(LocalPlayer player, double direction) {
        this.stopSwimming((Player)player);
        this.swimmingHands.clear();
        if (this.walkOnWaterActive) {
            this.scheduleWalkOnWaterStopWithBlend();
        }
        for (InteractionHand hand : InteractionHand.values()) {
            AnimatedTool.markNextActionHand(hand);
            AnimatedTool.markNextActivationSpeed(direction);
            AnimatedTool.markNextActionFromUse(false);
            BoneAnimationController.trigger((Player)player, hand, "Swimming", "swiming");
            ArmAnimationOverrides.setForceRender(hand, true);
            this.swimmingHands.add(hand);
        }
        AnimatedTool.resetActivationSpeed();
        this.swimmingDirection = direction;
        this.swimmingActive = true;
        this.swimmingStopDeadline = -1L;
    }

    private void startWalkOnWater(LocalPlayer player) {
        if (this.walkOnWaterActive) {
            this.walkOnWaterStopScheduled = false;
            this.walkOnWaterBlendTicks = 0;
            this.resetWalkOnWaterPose();
            this.walkOnWaterExitGrace = 6;
            return;
        }
        this.walkOnWaterHands.clear();
        this.walkOnWaterPausedHands.clear();
        this.stopWalk((Player)player);
        this.stopIdle((Player)player);
        for (InteractionHand hand : InteractionHand.values()) {
            this.stopWalkAnimation((Player)player, hand);
            this.stopIdleForHand((Player)player, hand);
            this.triggerWalkOnWaterForHand(player, hand);
        }
        this.walkOnWaterBlendTicks = 0;
        this.walkOnWaterStopScheduled = false;
        this.walkOnWaterExitGrace = 6;
        this.resetWalkOnWaterPose();
    }

    private void stopWalkOnWater(LocalPlayer player) {
        if (!this.walkOnWaterActive && this.walkOnWaterHands.isEmpty()) {
            this.resetWalkOnWaterPose();
            return;
        }
        if (player != null) {
            for (InteractionHand hand : this.walkOnWaterHands) {
                BoneAnimationController.stop((Player)player, hand, "WalkOnWater", "walk_on_water");
            }
        }
        this.walkOnWaterHands.clear();
        this.walkOnWaterActive = false;
        this.walkOnWaterBlendTicks = 0;
        this.walkOnWaterStopScheduled = false;
        this.walkOnWaterExitGrace = 0;
        this.walkOnWaterPausedHands.clear();
        this.resetWalkOnWaterPose();
    }

    private void triggerWalkOnWaterForHand(LocalPlayer player, InteractionHand hand) {
        if (player == null || hand == null) {
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        AnimatedTool.markNextActionFromUse(false);
        BoneAnimationController.trigger((Player)player, hand, "WalkOnWater", "walk_on_water");
        ArmAnimationOverrides.setForceRender(hand, true);
        this.walkOnWaterHands.add(hand);
        this.walkOnWaterActive = true;
    }

    private void stopWalkOnWaterForHand(Player player, InteractionHand hand) {
        if (hand == null) {
            return;
        }
        if (player != null && this.walkOnWaterHands.contains(hand)) {
            BoneAnimationController.stop(player, hand, "WalkOnWater", "walk_on_water");
        }
        this.walkOnWaterHands.remove(hand);
        if (this.walkOnWaterHands.isEmpty()) {
            this.walkOnWaterActive = false;
        }
    }

    private void resetWalkOnWaterPose() {
        this.walkOnWaterAnimSpeed = 1.0;
    }

    private void scheduleWalkOnWaterStopWithBlend() {
        if (!this.walkOnWaterActive) {
            return;
        }
        if (this.walkOnWaterStopScheduled) {
            return;
        }
        this.walkOnWaterExitGrace = 6;
        this.walkOnWaterBlendTicks = Math.max(this.walkOnWaterBlendTicks, 8);
        this.walkOnWaterStopScheduled = true;
    }

    private void stopSwimming(Player player) {
        if (!this.swimmingActive && this.swimmingHands.isEmpty()) {
            this.swimmingDirection = 1.0;
            this.swimmingStopDeadline = -1L;
            return;
        }
        if (player != null) {
            for (InteractionHand hand : this.swimmingHands) {
                BoneAnimationController.stop(player, hand, "Swimming", "swiming");
                ArmAnimationOverrides.clear(hand);
            }
            Minecraft client = Minecraft.getInstance();
            if (client != null) {
                this.ensureIdle(client);
            }
        }
        this.swimmingHands.clear();
        this.swimmingActive = false;
        this.swimmingDirection = 1.0;
        AnimatedTool.resetActivationSpeed();
        this.swimmingStopDeadline = -1L;
    }

    private void ensureSwimmingCompletion(LocalPlayer player) {
        if (!this.swimmingActive) {
            return;
        }
        if (player == null || player.level() == null) {
            this.stopSwimming((Player)player);
            return;
        }
        long gameTime = player.level().getGameTime();
        if (this.swimmingStopDeadline < 0L) {
            InteractionHand sampleHand = this.swimmingHands.isEmpty() ? InteractionHand.MAIN_HAND : (InteractionHand)this.swimmingHands.iterator().next();
            long ticks = this.swimmingDurationTicks((Player)player, sampleHand);
            this.swimmingStopDeadline = gameTime + ticks;
            return;
        }
        if (gameTime >= this.swimmingStopDeadline) {
            this.stopSwimming((Player)player);
        }
    }

    private void startJump(LocalPlayer player) {
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            return;
        }
        if (this.jumpActive) {
            return;
        }
        EnumSet<InteractionHand> hands = PunchyClient.collectProxyHands((Player)player);
        if (hands.isEmpty()) {
            return;
        }
        this.stopTransition((Player)player);
        this.stopWalk((Player)player);
        this.jumpActive = true;
        this.wasOnGround = false;
        this.landingArmed = true;
        for (InteractionHand hand : hands) {
            this.jumpSpringState(hand).impulse(-3.2f);
        }
    }

    private void stopJump(Player player) {
        if (!this.jumpActive && this.jumpHands.isEmpty() && this.jumpStopTimes.isEmpty()) {
            this.jumpHoldHands.clear();
            this.jumpHoldProgress.clear();
            this.jumpClipDurations.clear();
            return;
        }
        if (player != null) {
            EnumSet<InteractionHand> handsToStop = EnumSet.noneOf(InteractionHand.class);
            handsToStop.addAll(this.jumpHands);
            handsToStop.addAll(this.jumpStopTimes.keySet());
            if (handsToStop.isEmpty()) {
                handsToStop.add(InteractionHand.MAIN_HAND);
                handsToStop.add(InteractionHand.OFF_HAND);
            }
            for (InteractionHand hand : handsToStop) {
                BoneAnimationController.stop(player, hand, "Jump", "jump");
                ArmAnimationOverrides.clear(hand);
            }
        }
        this.jumpHands.clear();
        this.jumpStopTimes.clear();
        this.jumpHoldHands.clear();
        this.jumpHoldProgress.clear();
        this.jumpClipDurations.clear();
        this.stopFallingAnimations(player);
        this.jumpActive = false;
    }

    private void stopLanding(Player player) {
        if (this.landingStopTimes.isEmpty()) {
            return;
        }
        if (player != null) {
            for (InteractionHand hand : this.landingStopTimes.keySet()) {
                BoneAnimationController.stop(player, hand, "Landing", "landing");
                ArmAnimationOverrides.clear(hand);
            }
        }
        this.landingStopTimes.clear();
    }

    private void finishJumpAfterGround(LocalPlayer player) {
        if (player == null) {
            return;
        }
        EnumSet<InteractionHand> handsToResume = EnumSet.noneOf(InteractionHand.class);
        handsToResume.addAll(this.jumpHands);
        handsToResume.addAll(this.jumpHoldHands);
        this.stopFallingAnimations((Player)player);
        if (handsToResume.isEmpty()) {
            this.jumpActive = false;
            return;
        }
        for (InteractionHand hand : handsToResume) {
            this.resumeJumpHold((Player)player, hand);
        }
        this.jumpActive = false;
    }

    private void resumeJumpHold(Player player, InteractionHand hand) {
        double remaining;
        if (player == null || hand == null) {
            return;
        }
        boolean wasHolding = this.jumpHoldHands.remove(hand);
        double clipSeconds = this.jumpClipDurations.getOrDefault(hand, this.clipDurationSeconds(player, hand, "jump"));
        if (clipSeconds <= 0.0) {
            clipSeconds = 0.75;
        }
        if (wasHolding) {
            double pausedAt = this.jumpHoldProgress.getOrDefault(hand, clipSeconds);
            remaining = Math.max(0.01, clipSeconds - pausedAt);
        } else {
            remaining = 0.1;
        }
        this.jumpHoldProgress.remove(hand);
        this.scheduleJumpStop(player, hand, remaining);
    }

    private void triggerLanding(Player player) {
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            return;
        }
        if (player == null) {
            return;
        }
        EnumSet<InteractionHand> hands = PunchyClient.collectProxyHands(player);
        if (hands.isEmpty()) {
            return;
        }
        for (InteractionHand hand : hands) {
            this.jumpSpringState(hand).impulse(4.0f);
        }
    }

    private void scheduleLandingStop(Player player, InteractionHand hand) {
        if (player == null || hand == null || player.level() == null) {
            return;
        }
        long ticks = this.landingDurationTicks(player, hand);
        long stopTime = player.level().getGameTime() + ticks;
        this.landingStopTimes.put(hand, stopTime);
    }

    private void scheduleJumpStop(Player player, InteractionHand hand, double seconds) {
        if (player == null || hand == null || player.level() == null) {
            return;
        }
        long gameTime = player.level().getGameTime();
        this.scheduleJumpStop(player, hand, seconds, gameTime);
    }

    private void scheduleJumpStop(Player player, InteractionHand hand, double seconds, long currentGameTime) {
        if (player == null || hand == null || player.level() == null) {
            return;
        }
        if (seconds <= 0.0) {
            seconds = 0.1;
        }
        double speed = 1.3;
        long ticks = Math.max(1L, Math.round(seconds / Math.max(0.001, speed) * 20.0));
        long stopTime = currentGameTime + ticks;
        this.jumpStopTimes.put(hand, stopTime);
    }

    private void startFallingAnimation(LocalPlayer player, InteractionHand hand) {
        if (player == null || hand == null) {
            return;
        }
        ItemStack held = player.getItemInHand(hand);
        if (held == null || held.isEmpty() || !(held.getItem() instanceof MaceItem)) {
            return;
        }
        if (this.fallingHands.contains(hand)) {
            return;
        }
        this.stopWalkOnWater(player);
        AnimatedTool.markNextActionHand(hand);
        this.stopWalkAnimation((Player)player, hand);
        this.stopIdleForHand((Player)player, hand);
        AnimatedTool.markNextActivationSpeed(1.0);
        String clip = "attack_mace_charge";
        BoneAnimationController.trigger((Player)player, hand, "FallCharge", clip);
        ArmAnimationOverrides.setForceRender(hand, true);
        this.fallingHands.add(hand);
        this.fallingClips.put(hand, clip);
    }

    private void stopFallingAnimations(Player player) {
        if (this.fallingHands.isEmpty()) {
            return;
        }
        EnumSet<InteractionHand> active = EnumSet.copyOf(this.fallingHands);
        for (InteractionHand hand : active) {
            this.stopFallingAnimation(player, hand);
        }
        this.resetFallCharge(player);
    }

    private void stopFallingAnimation(Player player, InteractionHand hand) {
        if (hand == null) {
            return;
        }
        String clip = this.fallingClips.remove(hand);
        this.fallingHands.remove(hand);
        if (clip == null || clip.isEmpty() || player == null) {
            return;
        }
        BoneAnimationController.stop(player, hand, "FallCharge", clip);
        ArmAnimationOverrides.clear(hand);
        this.fallChargeActive = false;
        this.fallChargeStartY = Double.NaN;
        AnimatedTool.resetActivationSpeed();
    }

    private void scheduleRangedReleaseStop(Player player, InteractionHand hand, double seconds) {
        if (player == null || hand == null || player.level() == null) {
            return;
        }
        if (seconds <= 0.0) {
            seconds = 0.25;
        }
        long ticks = Math.max(1L, Math.round(seconds * 20.0));
        long stopTime = player.level().getGameTime() + ticks;
        this.rangedReleaseStopTimes.put(hand, stopTime);
    }

    private void queueRangedReleaseCleanup(InteractionHand weaponHand, InteractionHand arrowHand, RangedChargeKind kind) {
        boolean clearArrow = kind.usesArrowHand() && arrowHand != null && !kind.arrowClip().isEmpty();
        String releaseClip = kind.releaseClip();
        String controller = kind.controller();
        this.rangedReleaseCleanup.put(weaponHand, new ReleaseCleanup(arrowHand, clearArrow, kind.suppressSprite(), controller, releaseClip));
    }

    private void finalizeQueuedRelease(LocalPlayer player, InteractionHand weaponHand) {
        ReleaseCleanup cleanup = this.rangedReleaseCleanup.remove(weaponHand);
        if (player != null && cleanup != null && cleanup.releaseClip() != null && !cleanup.releaseClip().isEmpty()) {
            this.queueIdleTransitionAfterClip(weaponHand, cleanup.controller(), cleanup.releaseClip());
            BoneAnimationController.stop((Player)player, weaponHand, cleanup.controller(), cleanup.releaseClip());
        }
        if (cleanup == null) {
            this.finalizeRangedReleaseCleanup((Player)player, weaponHand, null, false);
            this.ensureIdleAfterAction(player, weaponHand);
            return;
        }
        this.finalizeRangedReleaseCleanup((Player)player, weaponHand, cleanup.clearArrow() ? cleanup.arrowHand() : null, cleanup.releaseSprite());
        this.ensureIdleAfterAction(player, weaponHand);
    }

    private void finalizeRangedReleaseCleanup(Player player, InteractionHand weaponHand, InteractionHand arrowHand, boolean releaseSprite) {
        ArmAnimationOverrides.clear(weaponHand);
        ToolAnimationOverrides.clear(weaponHand);
        if (arrowHand != null) {
            ToolAnimationOverrides.clear(arrowHand);
            this.restoreArrowHandState(arrowHand);
        }
        if (releaseSprite) {
            this.releaseBowSpriteSuppression();
        }
    }

    private void updateLandingStops(Player player) {
        if (this.landingStopTimes.isEmpty() || player == null) {
            return;
        }
        long gameTime = player.level() != null ? player.level().getGameTime() : 0L;
        Iterator<Map.Entry<InteractionHand, Long>> iterator = this.landingStopTimes.entrySet().iterator();
        boolean stoppedAny = false;
        while (iterator.hasNext()) {
            Map.Entry<InteractionHand, Long> entry = iterator.next();
            if (gameTime < entry.getValue()) continue;
            InteractionHand hand = entry.getKey();
            BoneAnimationController.stop(player, hand, "Landing", "landing");
            ArmAnimationOverrides.clear(hand);
            iterator.remove();
            stoppedAny = true;
        }
        if (stoppedAny) {
            this.handleWalk(Minecraft.getInstance());
        }
    }

    private void updateJumpStops(Player player) {
        if (this.jumpStopTimes.isEmpty() || player == null || player.level() == null) {
            return;
        }
        long gameTime = player.level().getGameTime();
        Iterator<Map.Entry<InteractionHand, Long>> iterator = this.jumpStopTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InteractionHand, Long> entry = iterator.next();
            if (gameTime < entry.getValue()) continue;
            InteractionHand hand = entry.getKey();
            BoneAnimationController.stop(player, hand, "Jump", "jump");
            ArmAnimationOverrides.clear(hand);
            iterator.remove();
            this.jumpHands.remove(hand);
            this.jumpHoldHands.remove(hand);
            this.jumpHoldProgress.remove(hand);
            this.jumpClipDurations.remove(hand);
        }
        if (this.jumpStopTimes.isEmpty() && this.jumpHands.isEmpty()) {
            this.jumpActive = false;
        }
    }

    private void handleWalk(Minecraft client) {
        double speed;
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopWalk(null);
            return;
        }
        boolean surface = this.isOnWaterSurface(player);
        if (surface) {
            if (!this.walkOnWaterActive && this.walkOnWaterPausedHands.isEmpty() && !this.walkOnWaterStopScheduled) {
                this.stopWalkOnWater(player);
                this.startWalkOnWater(player);
            }
            this.walkOnWaterExitGrace = 6;
            return;
        }
        if (!this.walkOnWaterPausedHands.isEmpty()) {
            return;
        }
        if (this.walkOnWaterActive) {
            if (this.walkOnWaterExitGrace > 0) {
                --this.walkOnWaterExitGrace;
                return;
            }
            if (this.walkOnWaterStopScheduled) {
                return;
            }
            this.stopWalkOnWater(player);
        }
        if (this.jumpActive || this.swimmingActive || this.fallToWaterActive) {
            this.stopWalk((Player)player);
            return;
        }
        EnumSet<InteractionHand> proxyHands = PunchyClient.collectProxyHands((Player)player);
        if (proxyHands.isEmpty()) {
            this.stopWalk((Player)player);
            return;
        }
        if (!PunchyClient.isSupportedBySolid((Player)player) || player.isInWater() || player.isUnderWater() || player.isFallFlying()) {
            this.stopWalk((Player)player);
            return;
        }
        if (!PunchyClient.isMovingHorizontally((Player)player)) {
            this.stopWalk((Player)player);
            return;
        }
        EnumSet<InteractionHand> eligibleHands = EnumSet.copyOf(this.walkingHands);
        for (InteractionHand hand : proxyHands) {
            if (eligibleHands.contains(hand) || this.isHandBusy(hand)) continue;
            eligibleHands.add(hand);
        }
        if (eligibleHands.isEmpty()) {
            this.stopWalk((Player)player);
            return;
        }
        double d = speed = player.isSprinting() ? 1.3 : 1.0;
        if (!this.walkActive || Math.abs(speed - this.walkSpeedMultiplier) > 0.001 || !eligibleHands.equals(this.walkingHands)) {
            this.startWalk(player, eligibleHands, speed);
        }
    }

    private boolean isSwimmingActionBlocked() {
        if (this.activationSource != ActivationSource.NONE) {
            return true;
        }
        return this.consuming || this.shieldActive || this.spyglassActive || this.rangedChargeActive;
    }

    private void startWalk(LocalPlayer player, EnumSet<InteractionHand> hands, double speed) {
        if (player == null || hands == null || hands.isEmpty()) {
            this.stopWalk((Player)player);
            return;
        }
        if (this.walkActive && hands.equals(this.walkingHands)) {
            this.walkSpeedMultiplier = speed;
            for (InteractionHand hand : hands) {
                this.walkSpeedByHand.put(hand, speed);
                this.deferredWalkRequests.remove(hand);
            }
            return;
        }
        Object previous = this.walkingHands.clone();
        if (!((AbstractCollection)previous).isEmpty() && player != null) {
            Iterator hand = ((AbstractCollection)previous).iterator();
            while (hand.hasNext()) {
                InteractionHand hand2 = (InteractionHand)hand.next();
                if (hands.contains(hand2)) continue;
                this.stopWalkAnimation((Player)player, hand2);
            }
        }
        this.walkActive = true;
        this.walkSpeedMultiplier = speed;
        this.walkingHands.clear();
        this.walkingHands.addAll(hands);
        EnumSet<InteractionHand> toStart = EnumSet.copyOf(hands);
        toStart.removeAll((Collection<?>)previous);
        for (InteractionHand hand : hands) {
            this.walkSpeedByHand.put(hand, speed);
            this.deferredWalkRequests.remove(hand);
            if (!toStart.contains(hand)) continue;
            if (this.hasIdleTransitionInFlight(hand)) {
                this.deferredWalkRequests.put(hand, speed);
                continue;
            }
            this.playWalkAnimation(player, hand, speed);
        }
    }

    private void stopWalkForHands(Player player, EnumSet<InteractionHand> hands) {
        if (hands == null || hands.isEmpty()) {
            return;
        }
        EnumSet<InteractionHand> waterHands = EnumSet.copyOf(hands);
        waterHands.retainAll(this.walkOnWaterHands);
        if (!waterHands.isEmpty()) {
            this.pauseWalkOnWaterForHands(player, waterHands);
        }
        EnumSet<InteractionHand> toStop = EnumSet.copyOf(hands);
        toStop.retainAll(this.walkingHands);
        if (toStop.isEmpty()) {
            return;
        }
        this.pauseWalkOnWaterForHands(player, EnumSet.copyOf(toStop));
        for (InteractionHand hand : toStop) {
            this.stopWalkAnimation(player, hand);
        }
        this.walkingHands.removeAll(toStop);
        if (this.walkingHands.isEmpty()) {
            this.walkActive = false;
            this.walkSpeedMultiplier = 1.0;
        }
    }

    private void resumeWalkOnWaterForHands(LocalPlayer player, EnumSet<InteractionHand> hands) {
        if (hands == null || hands.isEmpty()) {
            return;
        }
        EnumSet<InteractionHand> toResume = EnumSet.noneOf(InteractionHand.class);
        for (InteractionHand hand : hands) {
            if (!this.walkOnWaterPausedHands.remove(hand)) continue;
            toResume.add(hand);
        }
        if (toResume.isEmpty()) {
            return;
        }
        if (player != null && this.isOnWaterSurface(player)) {
            this.walkOnWaterExitGrace = 6;
        }
        if (this.walkOnWaterPausedHands.isEmpty()) {
            this.handleWalk(Minecraft.getInstance());
        }
    }

    private void pauseWalkOnWaterForHands(Player player, EnumSet<InteractionHand> hands) {
        if (!this.walkOnWaterActive || hands == null || hands.isEmpty()) {
            return;
        }
        EnumSet<InteractionHand> newlyPaused = EnumSet.noneOf(InteractionHand.class);
        for (InteractionHand hand : hands) {
            if (!this.walkOnWaterHands.contains(hand)) continue;
            this.stopWalkOnWaterForHand(player, hand);
            newlyPaused.add(hand);
        }
        if (!newlyPaused.isEmpty()) {
            this.walkOnWaterPausedHands.addAll(newlyPaused);
        }
    }

    private void stopWalk(Player player) {
        if (!this.walkActive && this.walkingHands.isEmpty() && this.deferredWalkRequests.isEmpty()) {
            return;
        }
        Object active = this.walkingHands.clone();
        if (player != null) {
            Iterator iterator = ((AbstractCollection)active).iterator();
            while (iterator.hasNext()) {
                InteractionHand hand = (InteractionHand)iterator.next();
                this.stopWalkAnimation(player, hand);
            }
        } else {
            Iterator iterator = ((AbstractCollection)active).iterator();
            while (iterator.hasNext()) {
                InteractionHand hand = (InteractionHand)iterator.next();
                this.stopWalkAnimation(null, hand);
            }
        }
        this.walkingHands.clear();
        this.walkingClips.clear();
        this.walkSpeedByHand.clear();
        this.deferredWalkRequests.clear();
        this.walkActive = false;
        this.walkSpeedMultiplier = 1.0;
    }

    private void playWalkAnimation(LocalPlayer player, InteractionHand hand, double speed) {
        if (player == null || hand == null) {
            return;
        }
        ItemStack held = player.getItemInHand(hand);
        if (!ProxyItemHelper.requiresProxy(held)) {
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        String clip = this.walkClipForHand(held);
        BoneAnimationController.trigger((Player)player, hand, "Walk", clip);
        this.walkingClips.put(hand, clip);
        this.walkSpeedByHand.put(hand, speed);
        this.deferredWalkRequests.remove(hand);
        this.stopIdleForHand((Player)player, hand);
        PunchyClient.applyMovementArmVisibility((Player)player, hand);
    }

    private void stopWalkAnimation(Player player, InteractionHand hand) {
        if (hand == null) {
            return;
        }
        String clip = this.walkingClips.get(hand);
        if ((clip == null || clip.isEmpty()) && player != null) {
            clip = this.walkClipForHand(player.getItemInHand(hand));
        }
        if (player != null && clip != null && !clip.isEmpty()) {
            BoneAnimationController.stop(player, hand, "Walk", clip);
        }
        ArmAnimationOverrides.clear(hand);
        this.walkingClips.remove(hand);
        this.walkSpeedByHand.remove(hand);
        this.deferredWalkRequests.remove(hand);
    }

    private boolean isOnWaterSurface(LocalPlayer player) {
        if (player == null || player.level() == null) {
            return false;
        }
        if (!player.isInWater() || player.isUnderWater()) {
            return false;
        }
        BlockPos feet = player.blockPosition();
        FluidState fluid = player.level().getFluidState(feet);
        if (!fluid.is(FluidTags.WATER)) {
            return false;
        }
        return player.getEyeY() > (double)((float)feet.getY() + fluid.getHeight((BlockGetter)player.level(), feet));
    }

    private void updateRangedReleaseStops(LocalPlayer player) {
        if (this.rangedReleaseStopTimes.isEmpty()) {
            return;
        }
        if (player == null || player.level() == null) {
            this.rangedReleaseStopTimes.clear();
            this.rangedReleaseCleanup.clear();
            return;
        }
        long now = player.level().getGameTime();
        Iterator<Map.Entry<InteractionHand, Long>> iterator = this.rangedReleaseStopTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InteractionHand, Long> entry = iterator.next();
            if (now < entry.getValue()) continue;
            InteractionHand hand = entry.getKey();
            this.finalizeQueuedRelease(player, hand);
            iterator.remove();
        }
    }

    private void handleJumpAndLanding(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopJump(null);
            this.wasOnGround = true;
            this.landingArmed = false;
            this.jumpInitialized = false;
            this.landingStopTimes.clear();
            this.jumpStopTimes.clear();
            return;
        }
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            this.stopJump((Player)player);
            this.landingArmed = false;
            this.jumpInitialized = false;
            this.landingStopTimes.clear();
            this.jumpStopTimes.clear();
            return;
        }
        this.updateLandingStops((Player)player);
        this.updateJumpStops((Player)player);
        if (!this.jumpInitialized) {
            this.wasOnGround = PunchyClient.isTouchingGroundOrLiquid((Player)player);
            this.landingArmed = false;
            this.jumpInitialized = true;
            return;
        }
        boolean onGround = PunchyClient.isTouchingGroundOrLiquid((Player)player);
        this.checkFallCharge(player, onGround);
        if (!onGround) {
            if (this.wasOnGround) {
                this.landingArmed = true;
                if (this.shouldTriggerJump(player, client)) {
                    this.startJump(player);
                }
            }
        } else if (!this.wasOnGround) {
            if (this.jumpActive) {
                this.finishJumpAfterGround(player);
            }
            if (this.landingArmed) {
                this.triggerLanding((Player)player);
                this.landingArmed = false;
            }
        } else {
            if (this.jumpActive) {
                this.finishJumpAfterGround(player);
            }
            this.landingArmed = false;
        }
        if (!onGround && this.walkActive) {
            this.stopWalk((Player)player);
        }
        this.wasOnGround = onGround;
    }

    private void checkFallCharge(LocalPlayer player, boolean onGround) {
        double drop;
        if (player == null) {
            this.resetFallCharge((Player)player);
            return;
        }
        if (onGround) {
            this.resetFallCharge((Player)player);
            return;
        }
        if (player.isUsingItem() || this.activationSource != ActivationSource.NONE) {
            this.resetFallCharge((Player)player);
            return;
        }
        if (player.isSwimming()) {
            this.resetFallCharge((Player)player);
            return;
        }
        double motionY = player.getDeltaMovement().y;
        if (motionY >= -0.08) {
            this.fallChargeTracking = false;
            this.fallChargeStartY = Double.NaN;
            return;
        }
        if (!this.fallChargeTracking || Double.isNaN(this.fallChargeStartY)) {
            this.fallChargeTracking = true;
            this.fallChargeStartY = player.getY();
        }
        if ((drop = this.fallChargeStartY - player.getY()) < 5.0) {
            return;
        }
        if (this.fallChargeActive) {
            return;
        }
        this.fallChargeActive = true;
        this.startFallingAnimation(player, InteractionHand.MAIN_HAND);
        this.startFallingAnimation(player, InteractionHand.OFF_HAND);
    }

    private boolean isPriorityActionActive() {
        return this.activationSource != ActivationSource.NONE || this.shieldActive || this.rangedChargeActive || this.swimmingActive || this.fallToWaterActive || this.consuming || this.inspectActive || this.inspectBlendTicks > 0;
    }

    public static double walkExpressivenessMultiplier() {
        PunchyClient inst = INSTANCE;
        if (inst == null || !inst.walkActive) {
            return 1.0;
        }
        return 1.35;
    }

    public static double jumpSpeedForClip(String clip) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 1.3;
        }
        InteractionHand hand = PunchyClient.inferHandFromClip(clip);
        return inst.jumpHoldHands.contains(hand == null ? InteractionHand.MAIN_HAND : hand) ? 0.0 : 1.3;
    }

    public static void onJumpGoingToLand(InteractionHand hand, double animationTick) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        inst.jumpHoldHands.add(resolved);
        inst.jumpHoldProgress.put(resolved, Math.max(0.0, animationTick));
        inst.jumpStopTimes.remove(resolved);
    }

    private boolean shouldTriggerJump(LocalPlayer player, Minecraft client) {
        Vec3 motion = player.getDeltaMovement();
        return client.options.keyJump.isDown() || motion.y > 0.08;
    }

    private long landingDurationTicks(Player player, InteractionHand hand) {
        double seconds = this.clipDurationSeconds(player, hand, "landing");
        double speed = 1.3;
        return Math.max(1L, Math.round(seconds / Math.max(0.001, speed) * 20.0));
    }

    private long swimmingDurationTicks(Player player, InteractionHand hand) {
        double seconds = this.clipDurationSeconds(player, hand, "swiming");
        return Math.max(1L, Math.round(seconds * 20.0));
    }

    private BlockHitResult clipWaterBelow(LocalPlayer player, double maxDistance) {
        Vec3 start = player.position();
        Vec3 end = start.add(0.0, -maxDistance, 0.0);
        ClipContext ctx = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)player);
        BlockHitResult result = player.level().clip(ctx);
        if (result.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockHitResult blockHit = result;
        BlockState state = player.level().getBlockState(blockHit.getBlockPos());
        if (!state.getFluidState().is(FluidTags.WATER)) {
            return null;
        }
        return blockHit;
    }

    private void handleArrowInstruction(boolean equip) {
        if (!this.rangedChargeActive || this.rangedChargeArrowHand == null) {
            return;
        }
        InteractionHand arrowHand = this.rangedChargeArrowHand;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (equip) {
            if (!this.activeArrowOverrides.contains(arrowHand)) {
                this.savedArrowOverrides.put(arrowHand, HandItemOverrides.getOverride(arrowHand));
                this.savedArrowHidden.put(arrowHand, HandItemOverrides.isHidden(arrowHand));
            }
            ItemStack arrowStack = this.createVisualArrowStack(player);
            HandItemOverrides.setOverride(arrowHand, arrowStack);
            HandItemOverrides.setHidden(arrowHand, false);
            ArmAnimationOverrides.setForceRender(arrowHand, true);
            this.activeArrowOverrides.add(arrowHand);
        } else {
            if (!this.activeArrowOverrides.contains(arrowHand)) {
                return;
            }
            HandItemOverrides.setOverride(arrowHand, ItemStack.EMPTY);
            HandItemOverrides.setHidden(arrowHand, true);
        }
    }

    private void handleCrossbowItemVisibility(InteractionHand hand, boolean hidden) {
        if (hand == null) {
            return;
        }
        InteractionHand resolved = hand;
        if (hidden) {
            this.crossbowHiddenStates.putIfAbsent(resolved, HandItemOverrides.isHidden(resolved));
            HandItemOverrides.setHidden(resolved, true);
            return;
        }
        Boolean previous = this.crossbowHiddenStates.remove(resolved);
        HandItemOverrides.setHidden(resolved, previous != null ? previous : false);
    }

    private void restoreAllCrossbowVisibility() {
        if (this.crossbowHiddenStates.isEmpty()) {
            return;
        }
        EnumSet<InteractionHand> hands = EnumSet.copyOf(this.crossbowHiddenStates.keySet());
        for (InteractionHand hand : hands) {
            this.handleCrossbowItemVisibility(hand, false);
        }
    }

    private void handleFlintAndSteelArmIn(InteractionHand hand) {
        if (hand != InteractionHand.OFF_HAND) {
            return;
        }
        if (!this.flintAndSteelDualActive || this.flintAndSteelProxyHand != hand) {
            this.beginFlintAndSteelProxy(hand);
        }
        this.flintAndSteelCleanupPending = false;
    }

    private void handleFlintAndSteelArmOut(InteractionHand hand) {
        if (hand != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        this.requestFlintAndSteelCleanup((Player)player);
        this.finalizeFlintAndSteelCleanup(true);
    }

    private void handleFlintAndSteelSpark(InteractionHand hand) {
        this.spawnFlintAndSteelSpark(hand);
    }

    private void spawnFlintAndSteelSpark(InteractionHand hand) {
        Vec3 up;
        Minecraft client = Minecraft.getInstance();
        if (client == null) {
            return;
        }
        LocalPlayer player = client.player;
        if (player == null || player.level() == null) {
            return;
        }
        Vec3 look = player.getViewVector(1.0f);
        Vec3 sideVec = look.cross(up = new Vec3(0.0, 1.0, 0.0));
        if (sideVec.lengthSqr() <= 1.0E-6) {
            sideVec = new Vec3(1.0, 0.0, 0.0);
        }
        sideVec = sideVec.normalize();
        double sideOffset = hand == InteractionHand.OFF_HAND ? -0.25 : 0.25;
        Vec3 offset = look.scale(0.5).add(sideVec.scale(sideOffset));
        Vec3 base = player.getEyePosition(1.0f).add(offset).add(0.0, -0.3, 0.0);
        RandomSource random = player.getRandom();
        Level level = player.level();
        int tinyColor = 0x66CCFF;
        DustParticleOptions tinySpark = new DustParticleOptions(tinyColor, 0.1f);
        DustParticleOptions tinySmoke = new DustParticleOptions(0x555555, 0.3f);
        for (int i = 0; i < 4; ++i) {
            double dx = (random.nextDouble() - 0.5) * 0.2;
            double dy = (random.nextDouble() - 0.5) * 0.2;
            double dz = (random.nextDouble() - 0.5) * 0.2;
            double vx = look.x * 0.2 + (random.nextDouble() - 0.5) * 0.1;
            double vy = look.y * 0.2 + (random.nextDouble() - 0.5) * 0.1;
            double vz = look.z * 0.2 + (random.nextDouble() - 0.5) * 0.1;
            if (!(random.nextDouble() < 0.33)) continue;
            double sx = base.x + dx * 0.6;
            double sy = base.y + dy * 0.6;
            double sz = base.z + dz * 0.6;
            level.addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, sx, sy, sz, vx * 1.9, vy * 1.9, vz * 1.9);
            level.addParticle((ParticleOptions)tinySpark, sx, sy, sz, vx * 1.9, vy * 1.9, vz * 1.9);
            for (int smoke = 0; smoke < 2; ++smoke) {
                double ox = sx + (random.nextDouble() - 0.5) * 0.05;
                double oy = sy + (random.nextDouble() - 0.5) * 0.05;
                double oz = sz + (random.nextDouble() - 0.5) * 0.05;
                level.addParticle((ParticleOptions)tinySmoke, ox, oy, oz, vx * 0.6, vy * 0.6, vz * 0.6);
            }
        }
    }

    private void handleSelectAnimation(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.lastMainhandStack = ItemStack.EMPTY;
            this.lastOffhandStack = ItemStack.EMPTY;
            return;
        }
        this.handleSelectForHand(player, InteractionHand.MAIN_HAND);
        this.handleSelectForHand(player, InteractionHand.OFF_HAND);
    }

    private void handleSelectForHand(LocalPlayer player, InteractionHand hand) {
        boolean changedItem;
        ItemStack last;
        boolean proxy;
        ItemStack stack = player.getItemInHand(hand);
        if (this.shieldActive && hand == this.shieldHand && !PunchyClient.isShield(stack)) {
            this.stopShieldUse((Player)player);
        }
        if (!(proxy = ProxyItemHelper.requiresProxy(stack))) {
            if (hand == InteractionHand.MAIN_HAND) {
                this.lastMainhandStack = ItemStack.EMPTY;
            } else {
                this.lastOffhandStack = ItemStack.EMPTY;
            }
            return;
        }
        ItemStack itemStack = last = hand == InteractionHand.MAIN_HAND ? this.lastMainhandStack : this.lastOffhandStack;
        if (this.consumeSelectSuppression(hand)) {
            this.storeLastStack(hand, stack);
            return;
        }
        boolean bl = changedItem = stack.isEmpty() != last.isEmpty();
        if (!changedItem && !stack.isEmpty()) {
            boolean bl2 = changedItem = stack.getItem() != last.getItem();
        }
        if (changedItem) {
            this.prioritizeMovementAnimation((Player)player, hand);
            AnimatedTool.markNextActionHand(hand);
            BoneAnimationController.trigger((Player)player, hand, "Select", "select");
            this.selectHands.add(hand);
        }
        this.storeLastStack(hand, stack);
    }

    private void prioritizeMovementAnimation(Player player, InteractionHand hand) {
        if (player != null && hand != null) {
            this.stopWalkForHands(player, EnumSet.of(hand));
        } else {
            this.stopWalk(player);
        }
        this.stopJump(player);
        this.stopLanding(player);
    }

    private void interruptSelectForMouseAction(LocalPlayer player, InteractionHand hand) {
        if (player == null) {
            return;
        }
        if (hand == null) {
            for (InteractionHand active : EnumSet.copyOf(this.selectHands)) {
                this.stopSelect((Player)player, active);
            }
            return;
        }
        this.stopSelect((Player)player, hand);
    }

    private void stopSelect(Player player, InteractionHand hand) {
        this.stopSelect(player, hand, true);
    }

    private void stopSelect(Player player, InteractionHand hand, boolean stopAnimation) {
        LocalPlayer lp;
        InteractionHand resolved;
        InteractionHand interactionHand = resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (!this.selectHands.contains(resolved)) {
            return;
        }
        if (stopAnimation && player != null) {
            BoneAnimationController.stop(player, resolved, "Select", "select");
        }
        if (player != null) {
            ArmAnimationOverrides.clear(resolved);
        }
        this.selectHands.remove(resolved);
        LocalPlayer local = player instanceof LocalPlayer ? (lp = (LocalPlayer)player) : Minecraft.getInstance().player;
        this.ensureIdleAfterAction(local, resolved);
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            this.handleWalk(client);
        }
    }

    private void handleConsume(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopConsume(null);
            return;
        }
        if (!ProxyItemHelper.requiresProxy(player.getItemInHand(InteractionHand.MAIN_HAND)) && !ProxyItemHelper.requiresProxy(player.getItemInHand(InteractionHand.OFF_HAND))) {
            this.stopConsume((Player)player);
            return;
        }
        if (player.isUsingItem()) {
            String anim;
            InteractionHand activeHand = player.getUsedItemHand();
            ItemStack held = player.getItemInHand(activeHand);
            if (!ProxyItemHelper.requiresProxy(held)) {
                return;
            }
            ItemStack useStack = player.getUseItem();
            ItemUseAnimation action = useStack.getUseAnimation();
            switch (action) {
                case DRINK: {
                    String string = "drink";
                    break;
                }
                case EAT: {
                    String string = "eat";
                    break;
                }
                default: {
                    String string = anim = null;
                }
            }
            if (anim != null && !this.consuming) {
                this.prioritizeMovementAnimation((Player)player, activeHand);
                AnimatedTool.markNextActionHand(activeHand);
                BoneAnimationController.trigger((Player)player, activeHand, "Consume", anim);
                this.consuming = true;
                this.consumingAnim = anim;
                this.consumeHand = activeHand;
            }
        } else if (this.consuming) {
            ItemStack held;
            InteractionHand finishedHand = this.stopConsume((Player)player);
            if (player != null && finishedHand != null && ProxyItemHelper.requiresProxy(held = player.getItemInHand(finishedHand))) {
                this.playReleaseTransition(player, finishedHand);
            }
        }
    }

    private InteractionHand stopConsume(Player player) {
        if (!this.consuming) {
            return null;
        }
        InteractionHand finishedHand = this.consumeHand;
        if (player != null && this.consumingAnim != null) {
            AnimatedTool.markNextActivationSpeed(5.0);
            BoneAnimationController.stop(player, finishedHand, "Consume", this.consumingAnim);
        }
        this.consuming = false;
        this.consumingAnim = null;
        this.consumeHand = InteractionHand.MAIN_HAND;
        AnimatedTool.resetActivationSpeed();
        return finishedHand;
    }

    private void handleInspect(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        ItemStack mainStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(!this.inspectActive || PunchyClient.isInspectEligible(mainStack) && PunchyClient.inspectStacksMatch(mainStack, this.inspectStack))) {
            this.stopInspect(player);
        }
        if (inspectKey == null || !inspectKey.consumeClick()) {
            return;
        }
        if (!PunchyClient.isInspectEligible(mainStack)) {
            return;
        }
        this.stopInspect(player);
        this.stopWalkForHands((Player)player, EnumSet.of(InteractionHand.MAIN_HAND));
        AnimatedTool.markNextActionHand(InteractionHand.MAIN_HAND);
        this.inspectActive = true;
        this.inspectBlendTicks = 0;
        this.inspectStack = mainStack.copy();
        BoneAnimationController.trigger((Player)player, InteractionHand.MAIN_HAND, "Inspect", "inspect_my_item");
        if (player.level() != null) {
            double duration = this.clipDurationSeconds((Player)player, InteractionHand.MAIN_HAND, "inspect_my_item");
            long ticks = Math.max(1L, Math.round(duration * 20.0));
            this.inspectStopGameTime = player.level().getGameTime() + ticks;
        } else {
            this.inspectStopGameTime = -1L;
        }
    }

    private void tickInspect(Minecraft client) {
        LocalPlayer local;
        if (client == null || client.level == null) {
            return;
        }
        if (this.inspectActive && this.inspectStopGameTime > 0L && client.level.getGameTime() >= this.inspectStopGameTime) {
            local = client.player;
            this.completeInspect(local);
        }
        if (this.inspectBlendTicks > 0) {
            --this.inspectBlendTicks;
            if (this.inspectBlendTicks == 0 && (local = client.player) != null) {
                this.ensureIdleAfterAction(local, InteractionHand.MAIN_HAND);
            }
        }
        if (this.walkOnWaterBlendTicks > 0) {
            --this.walkOnWaterBlendTicks;
            if (this.walkOnWaterBlendTicks == 0 && (local = client.player) != null) {
                this.stopWalkOnWater(local);
                this.ensureIdleAfterAction(local, InteractionHand.MAIN_HAND);
            }
        }
    }

    private void handleShieldUse(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopShieldUse(null);
            return;
        }
        if (!player.isUsingItem()) {
            this.stopShieldUse((Player)player);
            return;
        }
        ItemStack useStack = player.getUseItem();
        if (!PunchyClient.isShield(useStack)) {
            this.stopShieldUse((Player)player);
            return;
        }
        InteractionHand usedHand = player.getUsedItemHand();
        if (usedHand == null || !ProxyItemHelper.requiresProxy(player.getItemInHand(usedHand))) {
            this.stopShieldUse((Player)player);
            return;
        }
        HandItemOverrides.setOverride(usedHand, player.getItemInHand(usedHand));
        if (this.shieldActive && this.shieldHand != usedHand) {
            this.stopShieldUse((Player)player);
        }
        if (!this.shieldActive) {
            this.startShieldUse((Player)player, usedHand);
        }
        if (this.shieldActive && !player.isUsingItem()) {
            this.stopShieldUse((Player)player);
            return;
        }
        int currentHurt = player.hurtTime;
        if (this.shieldActive && currentHurt > this.shieldHurtTime) {
            this.handleShieldImpact(player);
        }
        this.shieldHurtTime = currentHurt;
        this.monitorShieldDamage(player, usedHand);
    }

    private void monitorShieldDamage(LocalPlayer player, InteractionHand hand) {
        if (!this.shieldActive || player == null || hand == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!PunchyClient.isShield(stack)) {
            return;
        }
        int damage = stack.getDamageValue();
        if (damage > this.shieldItemDamage) {
            this.handleShieldImpact(player);
        }
        this.shieldItemDamage = damage;
    }

    private void startShieldUse(Player player, InteractionHand hand) {
        int n;
        InteractionHand resolvedHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        this.prioritizeMovementAnimation(player, resolvedHand);
        AnimatedTool.markNextActionHand(resolvedHand);
        BoneAnimationController.trigger(player, resolvedHand, "Shield", "rise_shield");
        ItemStack stack = player.getItemInHand(resolvedHand);
        HandItemOverrides.setOverride(resolvedHand, stack);
        this.shieldActive = true;
        this.shieldHand = resolvedHand;
        if (player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            n = local.hurtTime;
        } else {
            n = 0;
        }
        this.shieldHurtTime = n;
        this.shieldItemDamage = stack.getDamageValue();
        this.stopIdleForHand(player, resolvedHand);
    }

    private void stopShieldUse(Player player) {
        if (!this.shieldActive) {
            return;
        }
        HandItemOverrides.clear(this.shieldHand);
        if (player != null) {
            BoneAnimationController.stop(player, this.shieldHand, "Shield", "rise_shield");
        }
        this.shieldActive = false;
        this.shieldHand = InteractionHand.MAIN_HAND;
        this.shieldHurtTime = 0;
        this.shieldItemDamage = -1;
    }

    private void handleShieldImpact(LocalPlayer player) {
        if (!this.shieldActive || player == null) {
            return;
        }
        AnimatedTool.markNextActionHand(this.shieldHand);
        BoneAnimationController.trigger((Player)player, this.shieldHand, "ShieldImpact", "shield_hit");
        this.shieldHurtTime = player.hurtTime;
    }

    private boolean playReleaseTransition(LocalPlayer player, InteractionHand hand) {
        if (player == null || hand == null) {
            return false;
        }
        ItemStack held = player.getItemInHand(hand);
        if (!ProxyItemHelper.requiresProxy(held)) {
            this.stopTransition((Player)player);
            return false;
        }
        if (this.jumpActive || !this.landingStopTimes.isEmpty()) {
            return false;
        }
        if (this.transitionActive && this.transitionHand == hand) {
            return true;
        }
        this.stopTransition((Player)player);
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.triggerActivation((Player)player, hand, TRANSITION_TO_IDLE_PUNCH);
        this.transitionActive = true;
        this.transitionHand = hand;
        if (player.level() != null) {
            long durationTicks = Math.max(1L, Math.round(this.clipDurationSeconds((Player)player, hand, TRANSITION_TO_IDLE_PUNCH) * 20.0));
            this.transitionStopGameTime = player.level().getGameTime() + durationTicks;
        } else {
            this.transitionStopGameTime = -1L;
        }
        return true;
    }

    private void stopTransition(Player player) {
        if (!this.transitionActive) {
            return;
        }
        if (player != null) {
            this.stopActivationLoop(player, this.transitionHand, TRANSITION_TO_IDLE_PUNCH, false);
            ToolAnimationOverrides.clear(this.transitionHand);
        }
        this.transitionActive = false;
        this.transitionHand = InteractionHand.MAIN_HAND;
        this.transitionStopGameTime = -1L;
    }

    private void handleTransitionStopped(InteractionHand hand) {
        InteractionHand effective;
        if (!this.transitionActive) {
            return;
        }
        InteractionHand interactionHand = effective = hand == null ? this.transitionHand : hand;
        if (effective != this.transitionHand) {
            return;
        }
        this.transitionActive = false;
        this.transitionHand = InteractionHand.MAIN_HAND;
        this.transitionStopGameTime = -1L;
        ToolAnimationOverrides.clear(effective);
        this.ensureIdleAfterAction(Minecraft.getInstance().player, effective);
    }

    private void ensureIdle(Minecraft client) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.stopIdle(null);
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            this.tryStartIdle(player, hand);
        }
    }

    private void primeIdleState(LocalPlayer player) {
        if (player == null) {
            return;
        }
        this.idlePrimedThisSession = true;
        this.storeLastStack(InteractionHand.MAIN_HAND, player.getMainHandItem());
        this.storeLastStack(InteractionHand.OFF_HAND, player.getOffhandItem());
        this.tryStartIdle(player, InteractionHand.MAIN_HAND);
        this.tryStartIdle(player, InteractionHand.OFF_HAND);
    }

    private void stopIdle(Player player) {
        if (player != null) {
            for (InteractionHand hand : this.idleHands) {
                BoneAnimationController.stop(player, hand, "Idle", this.idleClipName(hand));
            }
        }
        this.idleHands.clear();
        this.idleClips.clear();
    }

    private void stopIdleForHand(Player player, InteractionHand hand) {
        if (hand == null) {
            return;
        }
        String clip = this.idleClips.remove(hand);
        if (this.idleHands.remove(hand) && player != null) {
            BoneAnimationController.stop(player, hand, "Idle", clip == null ? "idle" : clip);
        }
    }

    private boolean isHandBusy(InteractionHand hand) {
        if (hand == null) {
            return true;
        }
        if (this.flintAndSteelDualActive && hand == this.flintAndSteelProxyHand) {
            return true;
        }
        switch (this.activationSource.ordinal()) {
            case 1: 
            case 2: {
                if (hand != this.activationHand) break;
                return true;
            }
            case 3: {
                if (hand != this.useAnimationHand) break;
                return true;
            }
        }
        if (this.consuming && hand == this.consumeHand) {
            return true;
        }
        if (this.shieldActive && hand == this.shieldHand) {
            return true;
        }
        if (this.spyglassActive && hand == this.spyglassHand) {
            return true;
        }
        if (this.rangedChargeActive) {
            if (hand == this.rangedChargeWeaponHand) {
                return true;
            }
            if (this.rangedChargeArrowHand != null && hand == this.rangedChargeArrowHand) {
                return true;
            }
        }
        if (this.rangedReleaseStopTimes.containsKey(hand)) {
            return true;
        }
        if (this.fallingHands.contains(hand)) {
            return true;
        }
        if (this.walkOnWaterActive && this.walkOnWaterHands.contains(hand)) {
            return true;
        }
        if (this.walkActive && this.walkingHands.contains(hand)) {
            return true;
        }
        if (this.jumpHands.contains(hand) || this.jumpStopTimes.containsKey(hand)) {
            return true;
        }
        if (this.landingStopTimes.containsKey(hand)) {
            return true;
        }
        return this.swimmingHands.contains(hand) || this.fallToWaterHands.contains(hand);
    }

    private void ensureIdleAfterAction(LocalPlayer player, InteractionHand hand) {
        if (player == null) {
            return;
        }
        if (hand != null) {
            this.tryStartIdle(player, hand);
        }
        this.ensureIdle(Minecraft.getInstance());
    }

    private void tryStartIdle(LocalPlayer player, InteractionHand hand) {
        if (player == null || hand == null) {
            return;
        }
        if (this.hasIdleTransitionInFlight(hand)) {
            return;
        }
        ItemStack held = player.getItemInHand(hand);
        if (held == null || !ProxyItemHelper.requiresProxy(held)) {
            this.stopIdleForHand((Player)player, hand);
            return;
        }
        if (this.isHandBusy(hand)) {
            this.stopIdleForHand((Player)player, hand);
            return;
        }
        String nextClip = this.idleClipForHand(held);
        if (this.idleHands.contains(hand)) {
            String currentClip = this.idleClips.get(hand);
            if (!nextClip.equals(currentClip)) {
                AnimatedTool.markNextActionHand(hand);
                BoneAnimationController.trigger((Player)player, hand, "Idle", nextClip);
                this.idleClips.put(hand, nextClip);
            }
            return;
        }
        AnimatedTool.markNextActionHand(hand);
        BoneAnimationController.trigger((Player)player, hand, "Idle", nextClip);
        this.idleHands.add(hand);
        this.idleClips.put(hand, nextClip);
    }

    private String idleClipName(InteractionHand hand) {
        return this.idleClips.getOrDefault(hand == null ? InteractionHand.MAIN_HAND : hand, "idle");
    }

    private String idleClipForHand(ItemStack stack) {
        if (PunchyClient.isLantern(stack)) {
            return "idle_lantern";
        }
        return "idle";
    }

    private String walkClipForHand(ItemStack stack) {
        if (PunchyClient.isLantern(stack)) {
            return "walk_lantern";
        }
        return "walk";
    }

    private static boolean isLantern(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.is(Items.LANTERN) || stack.is(Items.SOUL_LANTERN)) {
            return true;
        }
        return ToolKindResolver.isPendulumFlower(stack);
    }

    private void updateCameraLag(Minecraft client, float partialTicks) {
        LocalPlayer player = client.player;
        if (player == null) {
            this.resetCameraLag();
            return;
        }
        Level level = player.level();
        float yaw = player.getViewYRot(partialTicks);
        float pitch = player.getViewXRot(partialTicks);
        if (Float.isNaN(this.lastCameraYaw) || Float.isNaN(this.lastCameraPitch)) {
            this.lastCameraYaw = yaw;
            this.lastCameraPitch = pitch;
            this.yawLag = 0.0f;
            this.pitchLag = 0.0f;
            this.cameraTiltMainDeg = 0.0f;
            this.cameraTiltOffDeg = 0.0f;
            return;
        }
        float prevYaw = this.lastCameraYaw;
        float prevPitch = this.lastCameraPitch;
        this.lastCameraYaw = yaw;
        this.lastCameraPitch = pitch;
        float yawDelta = Mth.wrapDegrees((float)(yaw - prevYaw));
        float pitchDelta = pitch - prevPitch;
        this.lastCameraYawDelta = yawDelta;
        this.lastCameraPitchDelta = pitchDelta;
        float yawContribution = Mth.clamp((float)(yawDelta * 1.15f), (float)-18.0f, (float)18.0f);
        this.yawLag = this.yawLag * 0.78f + yawContribution * 0.22f;
        float pitchContribution = Mth.clamp((float)(pitchDelta * 0.85f), (float)-16.0f, (float)16.0f);
        this.pitchLag = this.pitchLag * 0.78f + pitchContribution * 0.22f;
        float downward = -Math.max(0.0f, this.pitchLag * 1.05f);
        downward = Mth.clamp((float)downward, (float)-18.0f, (float)0.0f);
        float rightTilt = this.yawLag > 0.0f ? -Math.min(18.0f, this.yawLag * 1.5f) : 0.0f;
        float leftTilt = this.yawLag < 0.0f ? -Math.min(18.0f, -this.yawLag * 1.5f) : 0.0f;
        this.cameraTiltMainDeg = Mth.clamp((float)(downward + rightTilt), (float)-22.0f, (float)0.0f);
        this.cameraTiltOffDeg = Mth.clamp((float)(downward + leftTilt), (float)-22.0f, (float)0.0f);
        this.cameraTiltMainSmoothDeg = Mth.lerp((float)0.4f, (float)this.cameraTiltMainSmoothDeg, (float)this.cameraTiltMainDeg);
        this.cameraTiltOffSmoothDeg = Mth.lerp((float)0.4f, (float)this.cameraTiltOffSmoothDeg, (float)this.cameraTiltOffDeg);
    }

    private void resetCameraLag() {
        this.lastCameraYaw = Float.NaN;
        this.lastCameraPitch = Float.NaN;
        this.yawLag = 0.0f;
        this.pitchLag = 0.0f;
        this.cameraTiltMainDeg = 0.0f;
        this.cameraTiltOffDeg = 0.0f;
        this.cameraTiltMainSmoothDeg = 0.0f;
        this.cameraTiltOffSmoothDeg = 0.0f;
        this.lastCameraYawDelta = 0.0f;
        this.lastCameraPitchDelta = 0.0f;
        this.lastCameraLogTick = Long.MIN_VALUE;
        this.lastLoggedCameraMain = Float.NaN;
        this.lastLoggedCameraOff = Float.NaN;
    }

    public static float cameraTiltRadians(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        float deg = hand == InteractionHand.OFF_HAND ? inst.cameraTiltOffSmoothDeg : inst.cameraTiltMainSmoothDeg;
        return (float)Math.toRadians(deg);
    }

    private InteractionHand findAttackHand(LocalPlayer player) {
        if (player == null) {
            return null;
        }
        InteractionHand hand = PunchyClient.findProxyHand(player);
        hand = PunchyClient.preferMainHandWhenProxyingFor(player, hand);
        if (!this.shieldActive || hand == null) {
            return hand;
        }
        if (hand != this.shieldHand) {
            return hand;
        }
        InteractionHand other = this.shieldHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherStack = player.getItemInHand(other);
        return ProxyItemHelper.requiresProxy(otherStack) ? other : null;
    }

    private static InteractionHand findProxyHand(LocalPlayer player) {
        boolean offHasItem;
        if (player == null) {
            return null;
        }
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean mainHasItem = main != null && !main.isEmpty();
        boolean bl = offHasItem = off != null && !off.isEmpty();
        if (mainHasItem && ProxyItemHelper.requiresProxy(main)) {
            return InteractionHand.MAIN_HAND;
        }
        if (offHasItem && ProxyItemHelper.requiresProxy(off)) {
            return InteractionHand.OFF_HAND;
        }
        if (ProxyItemHelper.requiresProxy(main)) {
            return InteractionHand.MAIN_HAND;
        }
        if (ProxyItemHelper.requiresProxy(off)) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static InteractionHand preferMainHandWhenProxyingFor(LocalPlayer player, InteractionHand candidate) {
        if (candidate != InteractionHand.OFF_HAND || player == null) {
            return candidate;
        }
        ItemStack main = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack off = player.getItemInHand(InteractionHand.OFF_HAND);
        if ((main == null || main.isEmpty()) && off != null && !off.isEmpty()) {
            return InteractionHand.MAIN_HAND;
        }
        return candidate;
    }

    public static double walkSpeedForHand(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null || hand == null) {
            return 1.0;
        }
        return inst.walkSpeedByHand.getOrDefault(hand, 1.0);
    }

    public static double walkOnWaterAnimationSpeed() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 1.0;
        }
        return inst.walkOnWaterAnimSpeed;
    }

    private static EnumSet<InteractionHand> collectProxyHands(Player player) {
        EnumSet<InteractionHand> hands = EnumSet.noneOf(InteractionHand.class);
        if (player == null) {
            return hands;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack held = player.getItemInHand(hand);
            if (!ProxyItemHelper.requiresProxy(held)) continue;
            hands.add(hand);
        }
        return hands;
    }

    private static boolean isMovingHorizontally(Player player) {
        if (player == null) {
            return false;
        }
        Vec3 motion = player.getDeltaMovement();
        if (motion.horizontalDistanceSqr() > 1.0E-4) {
            return true;
        }
        if (player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            return (double)Math.abs(local.zza) > 0.001 || (double)Math.abs(local.xxa) > 0.001;
        }
        return false;
    }

    private static boolean isBlockItem(ItemStack stack) {
        return stack != null && !stack.isEmpty() && stack.getItem() instanceof BlockItem;
    }

    private static boolean isConsumable(ItemStack stack) {
        return stack != null && !stack.isEmpty() && stack.has(DataComponents.CONSUMABLE);
    }

    private static boolean isEmptyHand(ItemStack stack) {
        return stack == null || stack.isEmpty();
    }

    private static void applyMovementArmVisibility(Player player, InteractionHand hand) {
        ItemStack held;
        if (hand == null) {
            return;
        }
        ItemStack itemStack = held = player == null ? ItemStack.EMPTY : player.getItemInHand(hand);
        if (PunchyClient.isEmptyHand(held)) {
            ArmAnimationOverrides.clear(hand);
            return;
        }
        ArmAnimationOverrides.setForceRender(hand, true);
    }

    private static void registerInspectKey() {
        if (inspectKey != null) {
            return;
        }
        inspectKey = ClientPlatform.get().registerKeyBinding(new KeyMapping("key.punchy.inspect", InputConstants.Type.KEYSYM, 73, KeyMapping.Category.MISC));
    }

    private static boolean isSupportedBySolid(Player player) {
        if (player == null) {
            return false;
        }
        return player.onGround() || player.verticalCollisionBelow;
    }

    private static boolean isTouchingGroundOrLiquid(Player player) {
        if (player == null) {
            return false;
        }
        return player.onGround() || player.verticalCollisionBelow || player.isInWater() || player.isInLava();
    }

    private static boolean isProjectileWeapon(ItemStack stack) {
        return stack != null && !stack.isEmpty() && (stack.getItem() instanceof BowItem || stack.getItem() instanceof CrossbowItem);
    }

    private static boolean isEmptyBucket(ItemStack stack) {
        return stack != null && stack.is(Items.BUCKET);
    }

    private static boolean isBucket(ItemStack stack) {
        return stack != null && !stack.isEmpty() && stack.getItem() instanceof BucketItem;
    }

    private static boolean isFilledBucket(ItemStack stack) {
        return PunchyClient.isBucket(stack) && !PunchyClient.isEmptyBucket(stack);
    }

    private static boolean isShield(ItemStack stack) {
        return stack != null && stack.getItem() instanceof ShieldItem;
    }

    private static boolean isFishingRod(ItemStack stack) {
        return stack != null && stack.getItem() instanceof FishingRodItem;
    }

    private static boolean isThrowableItem(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return item instanceof SnowballItem || item instanceof EggItem || item instanceof EnderpearlItem || item instanceof ExperienceBottleItem || item instanceof ThrowablePotionItem || item instanceof TridentItem;
    }

    private static boolean isBrush(ItemStack stack) {
        return stack != null && stack.is(Items.BRUSH);
    }

    private static boolean isLead(ItemStack stack) {
        return stack != null && stack.is(Items.LEAD);
    }

    private static String resolveRightClickClip(ItemStack stack, boolean interactingWithBlock) {
        if (PunchyClient.isEmptyHand(stack)) {
            return interactingWithBlock ? "insert" : PUNCH_TRIGGER;
        }
        if (interactingWithBlock) {
            if (stack.getItem() instanceof FlintAndSteelItem) {
                return FLINT_STEEL_CLIP;
            }
            if (PunchyClient.isEmptyBucket(stack)) {
                return "bucket_fill";
            }
            if (PunchyClient.isFilledBucket(stack)) {
                return "bucket_throw";
            }
            if (PunchyClient.isBrush(stack)) {
                return "usebrush";
            }
            if (stack.getItem() instanceof SpawnEggItem || PunchyClient.isBlockItem(stack) || PunchyClient.isLead(stack)) {
                return "insert";
            }
            if (PunchyClient.isToolSwayItem(stack)) {
                return PunchyClient.resolveToolLoopClip(stack);
            }
            if (PunchyClient.isThrowableItem(stack)) {
                return "sway_throw";
            }
            return "insert";
        }
        if (PunchyClient.isShield(stack)) {
            return "rise_shield";
        }
        if (PunchyClient.isFishingRod(stack)) {
            return "fishing";
        }
        if (PunchyClient.isProjectileWeapon(stack)) {
            return "attack";
        }
        if (PunchyClient.isThrowableItem(stack)) {
            return "sway_throw";
        }
        if (PunchyClient.isBrush(stack)) {
            return "usebrush";
        }
        if (PunchyClient.isToolSwayItem(stack)) {
            return PunchyClient.resolveToolLoopClip(stack);
        }
        if (PunchyClient.isBlockItem(stack) || PunchyClient.isLead(stack)) {
            return "insert";
        }
        if (PunchyClient.isConsumable(stack)) {
            return PUNCH_TRIGGER;
        }
        return "insert";
    }

    public static LanternPose lanternPhysics(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return LanternPose.ZERO;
        }
        return inst.lanternPhysicsPose(hand);
    }

    public static float lanternGripBlend(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        LanternGripState state = inst.lanternGrips.get(hand == null ? InteractionHand.MAIN_HAND : hand);
        return state == null ? 0.0f : state.blend();
    }

    public static float lanternGripDeltaX(boolean leftHand) {
        return leftHand ? -0.16f : 0.16f;
    }

    public static float lanternGripDeltaY() {
        return 0.14f;
    }

    public static float lanternGripDeltaZ() {
        return 0.08f;
    }

    public static void nudgeLantern(InteractionHand hand, float forwardImpulse, float lateralImpulse) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return;
        }
        LanternPhysicsState state = inst.lanternPhysics.get(hand == null ? InteractionHand.MAIN_HAND : hand);
        if (state != null) {
            state.impulse(forwardImpulse, lateralImpulse);
        }
    }

    private LanternPose lanternPhysicsPose(InteractionHand hand) {
        LanternPhysicsState state = this.lanternPhysics.get(hand == null ? InteractionHand.MAIN_HAND : hand);
        return state == null ? LanternPose.ZERO : state.snapshot();
    }

    private JumpSpringState jumpSpringState(InteractionHand hand) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        return this.jumpSprings.computeIfAbsent(resolved, h -> new JumpSpringState());
    }

    private SneakSpringState sneakSpringState(InteractionHand hand) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        return this.sneakSprings.computeIfAbsent(resolved, h -> new SneakSpringState());
    }

    public static JumpSpringPose jumpSpringPose(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return JumpSpringPose.ZERO;
        }
        JumpSpringState state = inst.jumpSprings.get(hand == null ? InteractionHand.MAIN_HAND : hand);
        return state == null ? JumpSpringPose.ZERO : state.snapshot();
    }

    public static float sneakOffset(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return 0.0f;
        }
        SneakSpringState state = inst.sneakSprings.get(hand == null ? InteractionHand.MAIN_HAND : hand);
        return state == null ? 0.0f : state.offset();
    }

    public static JumpSpringPivot jumpSpringPivot() {
        return SPRING_PIVOT;
    }

    private static String randomizeLoopClip(String clip) {
        return PunchyClient.randomizeLoopClip(clip, null);
    }

    private static String randomizeLoopClip(String clip, String avoid) {
        if (clip == null || clip.isEmpty()) {
            return clip;
        }
        return switch (clip) {
            case "sway_forward" -> PunchyClient.rollWeightedVariant("sway_forward", "sway_forward_2", "sway_forward_3", 0.85, 0.15, avoid);
            case "sway_sideways" -> PunchyClient.rollWeightedVariant("sway_sideways", "sway_sideways_2", "sway_sideways_3", 0.85, 0.15, avoid);
            default -> clip;
        };
    }

    private static String resolveAttackClip(ItemStack stack, boolean entityTarget, String avoid) {
        LeftActionProfile profile = PunchyClient.resolveLeftActionProfile(stack);
        return switch (profile.ordinal()) {
            default -> throw new MatchException(null, null);
            case 3 -> "trident_attack";
            case 4 -> "attack_mace";
            case 2 -> PunchyClient.randomSwordClip(avoid);
            case 0 -> "attack";
            case 1 -> entityTarget ? PUNCH_ATTACK_TRIGGER : PUNCH_TRIGGER;
        };
    }

    private static String randomSwordClip(String avoid) {
        if (SWORD_ATTACK_VARIANTS.length == 0) {
            return "attack";
        }
        for (int attempt = 0; attempt < 4; ++attempt) {
            String pick = SWORD_ATTACK_VARIANTS[ThreadLocalRandom.current().nextInt(SWORD_ATTACK_VARIANTS.length)];
            if (avoid != null && avoid.equals(pick)) continue;
            return pick;
        }
        return avoid == null ? "attack" : avoid;
    }

    private static String rollWeightedVariant(String primary, String secondary, String tertiary) {
        return PunchyClient.rollWeightedVariant(primary, secondary, tertiary, 0.85, 0.15, null);
    }

    private static String rollWeightedVariant(String primary, String secondary, String tertiary, double primaryWeight, double secondaryWeight, String avoid) {
        double tertiaryWeight = 1.0 - (primaryWeight + secondaryWeight);
        for (int attempt = 0; attempt < 4; ++attempt) {
            double roll = ThreadLocalRandom.current().nextDouble();
            String pick = roll < primaryWeight ? primary : (roll < primaryWeight + secondaryWeight ? secondary : tertiary);
            if (avoid != null && Objects.equals(pick, avoid)) continue;
            return pick;
        }
        return avoid == null ? primary : avoid;
    }

    private static int resolveUseAnimationTicks(String clip) {
        if (PunchyClient.isBucketClip(clip)) {
            return 40;
        }
        return 6;
    }

    private int resolveUseAnimationTicks(LocalPlayer player, InteractionHand hand, String clip) {
        double seconds = this.clipDurationSeconds((Player)player, hand, clip);
        if (seconds <= 0.0) {
            seconds = 0.05;
        }
        int ticks = (int)Math.ceil(seconds * 20.0);
        return Math.max(1, ticks);
    }

    private static boolean isBucketClip(String clip) {
        return "bucket_fill".equals(clip) || "bucket_throw".equals(clip);
    }

    private void suppressNextSelect(InteractionHand hand) {
        this.selectSuppressionHands.add(hand == null ? InteractionHand.MAIN_HAND : hand);
    }

    private boolean consumeSelectSuppression(InteractionHand hand) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        return this.selectSuppressionHands.remove(resolved);
    }

    private void storeLastStack(InteractionHand hand, ItemStack stack) {
        ItemStack snapshot;
        ItemStack itemStack = snapshot = stack == null ? ItemStack.EMPTY : stack.copy();
        if (hand == InteractionHand.MAIN_HAND) {
            this.lastMainhandStack = snapshot;
        } else {
            this.lastOffhandStack = snapshot;
        }
    }

    private ItemStack lastStackForHand(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? this.lastOffhandStack : this.lastMainhandStack;
    }

    private ItemStack stackForClipResolution(ItemStack currentStack, InteractionHand hand) {
        boolean previousDiffers;
        ItemStack previous = this.lastStackForHand(hand);
        if (previous == null || previous.isEmpty()) {
            return currentStack;
        }
        boolean bl = previousDiffers = currentStack == null || currentStack.isEmpty() || previous.getItem() != currentStack.getItem();
        if (previousDiffers && PunchyClient.isBucket(previous)) {
            return previous;
        }
        return currentStack;
    }

    private ItemStack stackForAttackResolution(ItemStack currentStack, InteractionHand hand) {
        ItemStack previous;
        if (currentStack != null && currentStack.getItem() == Punchy.boneProxy() && (previous = this.lastStackForHand(hand)) != null && !previous.isEmpty()) {
            return previous;
        }
        return currentStack;
    }

    private static String resolveBlockLoopClip(ItemStack stack) {
        if (stack == null) {
            return PUNCH_TRIGGER;
        }
        return switch (PunchyClient.resolveLeftActionProfile(stack).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PunchyClient.resolveToolLoopClip(stack);
            case 1, 2, 3, 4 -> PUNCH_TRIGGER;
        };
    }

    private static boolean isToolSwayItem(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.getItem() instanceof TridentItem || PunchyClient.isSwordItem(stack)) {
            return false;
        }
        return stack.is(ItemTags.PICKAXES) || stack.is(ItemTags.HOES) || stack.is(ItemTags.AXES) || stack.is(ItemTags.SHOVELS);
    }

    private static String resolveToolLoopClip(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return "sway_forward";
        }
        if (stack.is(ItemTags.AXES)) {
            return "sway_sideways";
        }
        if (stack.is(ItemTags.SHOVELS)) {
            return "sway_digging";
        }
        return "sway_forward";
    }

    private static LeftActionProfile resolveLeftActionProfile(ItemStack stack) {
        if (stack == null) {
            return LeftActionProfile.PUNCH_ONLY;
        }
        if (stack.getItem() instanceof TridentItem) {
            return LeftActionProfile.TRIDENT;
        }
        if (stack.getItem() instanceof MaceItem) {
            return LeftActionProfile.MACE;
        }
        if (PunchyClient.isSwordItem(stack)) {
            return LeftActionProfile.SWORD;
        }
        if (stack.is(ItemTags.PICKAXES) || stack.is(ItemTags.SHOVELS) || stack.is(ItemTags.AXES) || stack.is(ItemTags.HOES)) {
            return LeftActionProfile.TOOL_SWAY;
        }
        return LeftActionProfile.PUNCH_ONLY;
    }

    private void updateLanternPhysics(Minecraft client) {
        int i;
        LocalPlayer player = client.player;
        InteractionHand[] hands = InteractionHand.values();
        LanternPhysicsState[] states = new LanternPhysicsState[hands.length];
        LanternGripState[] gripStates = new LanternGripState[hands.length];
        boolean[] physicsFlags = new boolean[hands.length];
        boolean[] leftFlags = new boolean[hands.length];
        boolean[] gripTargets = new boolean[hands.length];
        long now = System.nanoTime();
        float rawDt = Math.max(0.0f, (float)(now - this.lastLanternTickTime) / 1.0E9f);
        this.lastLanternTickTime = now;
        if (client.isPaused()) {
            rawDt = 0.0f;
        }
        for (i = 0; i < hands.length; ++i) {
            boolean left;
            LanternGripState gripState;
            LanternPhysicsState state;
            InteractionHand hand = hands[i];
            states[i] = state = this.lanternPhysics.computeIfAbsent(hand, h -> new LanternPhysicsState());
            gripStates[i] = gripState = this.lanternGrips.computeIfAbsent(hand, h -> new LanternGripState());
            boolean active = false;
            if (player != null) {
                ItemStack held = player.getItemInHand(hand);
                active = held != null && !held.isEmpty() && PunchyClient.isLantern(held) && ProxyItemHelper.requiresProxy(held);
            } else {
                state.reset();
                gripState.reset();
            }
            leftFlags[i] = left = hand == InteractionHand.OFF_HAND;
            physicsFlags[i] = active && Punchy.JUMP_PHYSICS_ENABLED;
            gripTargets[i] = active;
            if (player == null) continue;
            state.setBasePose(player, hand);
        }
        for (i = 0; i < hands.length; ++i) {
            LanternGripState gripState = gripStates[i];
            if (gripState == null) continue;
            gripState.tick(gripTargets[i], rawDt);
        }
        if (!Punchy.JUMP_PHYSICS_ENABLED || player == null || player.level() == null) {
            this.lanternTimeRemainder = 0.0f;
            return;
        }
        this.lanternTimeRemainder = Mth.clamp((float)(this.lanternTimeRemainder + rawDt), (float)0.0f, (float)0.5f);
        float targetStep = 0.016666668f;
        long gameTime = player.level().getGameTime();
        int guard = 0;
        while (this.lanternTimeRemainder >= 0.016666668f && guard < 8) {
            this.lanternTimeRemainder -= 0.016666668f;
            ++guard;
            for (int i2 = 0; i2 < hands.length; ++i2) {
                LanternPhysicsState state = states[i2];
                if (state == null) continue;
                state.tick(player, physicsFlags[i2], leftFlags[i2], this.lastCameraYawDelta, this.lastCameraPitchDelta, 0.016666668f, gameTime);
            }
        }
    }

    private void updateJumpSprings(Minecraft client) {
        long tick;
        if (!Punchy.JUMP_PHYSICS_ENABLED) {
            this.resetJumpSpringStates();
            return;
        }
        long now = System.nanoTime();
        float rawDt = Math.max(0.0f, (float)(now - this.lastSpringTickTime) / 1.0E9f);
        this.lastSpringTickTime = now;
        if (client.isPaused()) {
            rawDt = 0.0f;
        }
        this.springTimeRemainder = Mth.clamp((float)(this.springTimeRemainder + rawDt), (float)0.0f, (float)0.5f);
        float targetStep = 0.016666668f;
        InteractionHand[] hands = InteractionHand.values();
        LocalPlayer player = client.player;
        JumpSpringState[] states = new JumpSpringState[hands.length];
        SneakSpringState[] sneakStates = new SneakSpringState[hands.length];
        boolean[] activeFlags = new boolean[hands.length];
        boolean[] leftFlags = new boolean[hands.length];
        boolean[] sneakFlags = new boolean[hands.length];
        boolean playerSneaking = player != null && player.isCrouching();
        for (int i = 0; i < hands.length; ++i) {
            SneakSpringState sneakState;
            boolean active;
            InteractionHand hand = hands[i];
            states[i] = this.jumpSpringState(hand);
            leftFlags[i] = hand == InteractionHand.OFF_HAND;
            activeFlags[i] = active = player != null && ProxyItemHelper.requiresProxy(player.getItemInHand(hand));
            sneakStates[i] = sneakState = this.sneakSpringState(hand);
            boolean sneakActive = playerSneaking && active;
            sneakState.setSneaking(sneakActive);
            sneakFlags[i] = sneakActive;
        }
        int guard = 0;
        ClientLevel level = client.level;
        long l = tick = level != null ? level.getGameTime() : Long.MIN_VALUE;
        while (this.springTimeRemainder >= 0.016666668f && guard < 8) {
            this.springTimeRemainder -= 0.016666668f;
            ++guard;
            for (int i = 0; i < hands.length; ++i) {
                JumpSpringState state = states[i];
                state.tick(activeFlags[i], leftFlags[i], 0.016666668f);
                long logTick = tick != Long.MIN_VALUE ? tick : -1L;
                this.logJumpSpringPose(hands[i], state.snapshot(), activeFlags[i], sneakFlags[i], leftFlags[i], logTick, guard);
                SneakSpringState sneakState = sneakStates[i];
                if (sneakState == null) continue;
                sneakState.tick(0.016666668f);
            }
        }
    }

    private void logJumpSpringPose(InteractionHand hand, JumpSpringPose pose, boolean active, boolean sneaking, boolean leftHand, long tick, int iteration) {
        boolean changed;
        JumpSpringPose lastPose = this.lastLoggedJumpSpringPoses.get(hand);
        boolean bl = changed = lastPose == null || Math.abs(pose.rotX() - lastPose.rotX()) > 0.01f || Math.abs(pose.rotZ() - lastPose.rotZ()) > 0.01f || Math.abs(pose.offY() - lastPose.offY()) > 0.005f;
        if (!(changed || tick >= 0L && this.lastJumpSpringLogTick >= 0L && tick - this.lastJumpSpringLogTick >= 10L)) {
            return;
        }
        this.lastLoggedJumpSpringPoses.put(hand, pose);
        if (tick >= 0L) {
            this.lastJumpSpringLogTick = tick;
        }
    }

    public static void onPunchImpact() {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handlePunchImpact();
        }
    }

    public static void onAnimationTriggered(Player player, InteractionHand hand, String controller, String clip, long instanceId) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.recordAnimationStart(player, hand, controller, clip, instanceId);
        }
    }

    public static void onAnimationStopped(Player player, InteractionHand hand, String controller, String clip, long instanceId) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.recordAnimationStop(player, hand, controller, clip, instanceId);
        }
    }

    public static void onAnimationKeyframe(String controller, String clip, String label, double animationTick) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.recordAnimationKeyframe(controller, clip, label, animationTick);
        }
    }

    public static void onArrowInstruction(boolean equip) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleArrowInstruction(equip);
        }
    }

    private void stopInspect(LocalPlayer player) {
        if (!this.inspectActive) {
            return;
        }
        this.inspectActive = false;
        this.inspectStack = ItemStack.EMPTY;
        this.inspectStopGameTime = -1L;
        this.inspectBlendTicks = 0;
        if (player != null) {
            BoneAnimationController.stop((Player)player, InteractionHand.MAIN_HAND, "Inspect", "inspect_my_item");
            this.ensureIdleAfterAction(player, InteractionHand.MAIN_HAND);
        }
    }

    private void completeInspect(LocalPlayer player) {
        if (!this.inspectActive) {
            return;
        }
        this.inspectActive = false;
        this.inspectStack = ItemStack.EMPTY;
        this.inspectStopGameTime = -1L;
        this.inspectBlendTicks = Math.max(this.inspectBlendTicks, 8);
    }

    private static boolean isInspectEligible(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof BowItem || item instanceof TridentItem || item instanceof MaceItem || stack.is(ItemTags.SWORDS)) {
            return true;
        }
        return stack.is(ItemTags.PICKAXES) || stack.is(ItemTags.AXES) || stack.is(ItemTags.HOES) || stack.is(ItemTags.SHOVELS);
    }

    private static boolean inspectStacksMatch(ItemStack a, ItemStack b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        return a.getItem() == b.getItem();
    }

    public static void onCrossbowItemVisibility(InteractionHand hand, boolean hidden) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleCrossbowItemVisibility(hand, hidden);
        }
    }

    public static void onBowAnimationGate() {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.releaseBowSpriteSuppression();
        }
    }

    public static void onSpyglassInstruction() {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.allowSpyglassZoom();
        }
    }

    public static void onUseHandLocked(InteractionHand hand, ItemStack stack) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.lockedUseHand = hand == null ? InteractionHand.MAIN_HAND : hand;
            inst.lockedUseStack = stack == null ? ItemStack.EMPTY : stack.copy();
        }
    }

    public static void onFlintAndSteelArmIn(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleFlintAndSteelArmIn(hand);
        }
    }

    public static void onFlintAndSteelArmOut(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleFlintAndSteelArmOut(hand);
        }
    }

    public static void onFlintAndSteelSpark(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleFlintAndSteelSpark(hand);
        }
    }

    public static void onShieldImpact(LocalPlayer player) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.handleShieldImpact(player);
        }
    }

    private void allowSpyglassZoom() {
        if (this.spyglassActive) {
            this.spyglassZoomAllowed = true;
        }
    }

    public static boolean isBowHandSuppressed(InteractionHand hand) {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.isSpriteSuppressedFor(hand);
    }

    public static boolean shouldHoldBowAnimation(InteractionHand hand, ItemStack stack) {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.shouldHoldBowAnimationFor(hand, stack);
    }

    public static boolean shouldBlockSpyglassZoom(LocalPlayer player) {
        PunchyClient inst = INSTANCE;
        return inst != null && inst.isSpyglassZoomSuppressed(player);
    }

    private boolean shouldHoldBowAnimationFor(InteractionHand hand, ItemStack stack) {
        if (!this.isSpriteSuppressedFor(hand)) {
            return false;
        }
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        ItemUseAnimation animation = stack.getUseAnimation();
        if (animation == ItemUseAnimation.BOW || animation == ItemUseAnimation.CROSSBOW) {
            return true;
        }
        Item item = stack.getItem();
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    private boolean isSpyglassZoomSuppressed(LocalPlayer player) {
        if (!this.spyglassActive || this.spyglassZoomAllowed) {
            return false;
        }
        if (player == null || !player.isUsingItem()) {
            return false;
        }
        ItemStack stack = player.getUseItem();
        return stack != null && stack.getItem() instanceof SpyglassItem;
    }

    private void handlePunchImpact() {
        Minecraft client = Minecraft.getInstance();
        if (client == null) {
            return;
        }
        if (this.activationSource != ActivationSource.PUNCH) {
            return;
        }
        boolean stillHolding = client.options.keyAttack.isDown();
    }

    private void recordAnimationStart(Player player, InteractionHand hand, String controller, String clip, long instanceId) {
        if (player == null || player.level() == null || clip == null || clip.isEmpty()) {
            return;
        }
        InteractionHand safeHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        String normalizedClip = PunchyClient.normalizeClipKey(clip);
        boolean isIdleController = "Idle".equals(controller);
        if (!(PunchyClient.isIdleTransitionClip(normalizedClip) || isIdleController && this.pendingIdleTransitionSources.containsKey(safeHand))) {
            this.clearIdleTransitionState(safeHand);
        }
        long gameTime = player.level().getGameTime();
        String trackingClip = PunchyClient.clipKeyForTracking(clip);
        AnimationRunKey key = new AnimationRunKey(instanceId, controller, trackingClip);
        double clipSeconds = this.clipDurationSeconds(player, safeHand, clip);
        long expectedTicks = Math.max(1L, Math.round(clipSeconds * 20.0));
        AnimationRunInfo info = new AnimationRunInfo(gameTime, System.nanoTime(), safeHand, expectedTicks, clipSeconds);
        this.animationRuns.put(key, info);
    }

    private void recordAnimationStop(Player player, InteractionHand hand, String controller, String clip, long instanceId) {
        LocalPlayer lp;
        boolean isTransitionClip;
        long gameTime = player != null && player.level() != null ? player.level().getGameTime() : 0L;
        String normalizedClip = PunchyClient.normalizeClipKey(clip);
        AnimationRunKey key = new AnimationRunKey(instanceId, controller, PunchyClient.clipKeyForTracking(clip));
        AnimationRunInfo info = this.animationRuns.remove(key);
        boolean bl = isTransitionClip = clip != null && clip.startsWith("transition");
        if (info == null) {
            InteractionHand fallbackHand = hand == null ? InteractionHand.MAIN_HAND : hand;
            this.onQueuedIdleClipStopped(fallbackHand, clip);
            this.onSourceClipStoppedForIdle(fallbackHand, clip);
            if (CONTROLLER_ACTIVATION.equals(controller) && isTransitionClip) {
                this.handleTransitionStopped(hand);
            }
            if (this.flintAndSteelCleanupPending && fallbackHand == this.flintAndSteelProxyHand && "transition_to_idle_insert".equals(normalizedClip)) {
                this.finalizeFlintAndSteelCleanup(false);
            }
            return;
        }
        InteractionHand safeHand = hand == null ? info.hand() : hand;
        boolean queuedFromStop = this.queueIdleTransitionAfterClip(safeHand, controller, clip);
        this.onQueuedIdleClipStopped(safeHand, clip);
        this.onSourceClipStoppedForIdle(safeHand, clip);
        if (CONTROLLER_ACTIVATION.equals(controller)) {
            LocalPlayer local;
            Minecraft client = Minecraft.getInstance();
            LocalPlayer localPlayer = local = client != null ? client.player : null;
            if (this.activationSource == ActivationSource.PUNCH && safeHand == this.activationHand) {
                this.finalizePunch((Player)local, safeHand);
            } else if (this.activationSource == ActivationSource.USE && safeHand == this.useAnimationHand) {
                boolean stillHoldingUse;
                boolean isUsebrushClip = "usebrush".equals(normalizedClip);
                boolean bl2 = stillHoldingUse = client != null && client.options.keyUse.isDown();
                if (isUsebrushClip && stillHoldingUse && this.usebrushHolding) {
                    if (local != null) {
                        ItemStack current = local.getItemInHand(safeHand);
                        this.triggerUseClip(local, safeHand, current, this.useInteractsWithBlock);
                    }
                } else {
                    this.stopUseAction(client);
                }
            }
            if (isTransitionClip) {
                this.handleTransitionStopped(safeHand);
            }
            return;
        }
        if (isTransitionClip) {
            this.handleTransitionStopped(safeHand);
        }
        if (this.flintAndSteelCleanupPending && safeHand == this.flintAndSteelProxyHand && "transition_to_idle_insert".equals(normalizedClip)) {
            this.finalizeFlintAndSteelCleanup(false);
        }
        if ("Select".equals(controller) && "select".equals(normalizedClip)) {
            LocalPlayer local = player instanceof LocalPlayer ? (lp = (LocalPlayer)player) : Minecraft.getInstance().player;
            this.stopSelect((Player)local, safeHand, false);
        }
        if ("Inspect".equals(controller) && "inspect_my_item".equals(normalizedClip)) {
            LocalPlayer currentPlayer = player instanceof LocalPlayer ? (lp = (LocalPlayer)player) : null;
            this.completeInspect(currentPlayer);
            return;
        }
    }

    private void recordAnimationKeyframe(String controller, String clip, String label, double animationTick) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || clip == null || clip.isEmpty()) {
            return;
        }
        String trackingClip = PunchyClient.clipKeyForTracking(clip);
        AnimationRunInfo info = this.findAnimationRunInfo((Player)player, controller, trackingClip);
        if (info == null) {
            return;
        }
        String entry = label == null || label.isEmpty() ? String.format(Locale.ROOT, "@%.2f", animationTick) : String.format(Locale.ROOT, "%s@%.2f", label, animationTick);
        info.keyframes().add(entry);
        if ("instr:end".equals(label)) {
            this.handleEndInstruction((Player)player, controller, clip, info);
        }
    }

    private void handleEndInstruction(Player player, String controller, String clip, AnimationRunInfo info) {
        if (player == null || controller == null || clip == null || clip.isEmpty() || info == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        boolean mouseDown = client != null && (client.options.keyAttack.isDown() || client.options.keyUse.isDown());
        InteractionHand hand = info.hand() == null ? InteractionHand.MAIN_HAND : info.hand();
        boolean activationController = CONTROLLER_ACTIVATION.equals(controller);
        boolean blockTarget = PunchyClient.hasViableBlockTarget(client);
        boolean consumeController = "Consume".equals(controller);
        String normalizedClip = PunchyClient.normalizeClipKey(clip);
        if ("Inspect".equals(controller) && "inspect_my_item".equals(normalizedClip)) {
            LocalPlayer lp;
            LocalPlayer localPlayer;
            LocalPlayer localPlayer2 = localPlayer = player instanceof LocalPlayer ? (lp = (LocalPlayer)player) : null;
            if (localPlayer != null) {
                this.stopInspect(localPlayer);
            }
            return;
        }
        if (!activationController && !consumeController || info.stopScheduled()) {
            return;
        }
        if (activationController) {
            boolean allowLoop;
            boolean bl = allowLoop = this.activationSource == ActivationSource.PUNCH && this.activationHand == hand && !this.activationTargetIsEntity;
            if (mouseDown && blockTarget && allowLoop && PunchyClient.isMiningLoopClip(clip)) {
                HandSwayPhysics.get().trigger(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                String nextClip = AnimationRandomizer.nextMiningClip(player.getItemInHand(hand), clip);
                if (!nextClip.equals(clip)) {
                    BoneAnimationController.triggerActivation(player, hand, nextClip);
                    this.lastActivationClip.put(hand, nextClip);
                    PunchLoopState state = this.punchLoops.get(hand);
                    if (state != null) {
                        int newDuration = Math.max(1, (int)Math.round(this.clipDurationSeconds(player, hand, nextClip) * 20.0));
                        state.updateDuration(newDuration);
                    }
                }
                return;
            }
        } else if (consumeController) {
            boolean stillConsuming;
            boolean bl = stillConsuming = player.isUsingItem() && player.getUsedItemHand() == hand;
            if (mouseDown && stillConsuming) {
                return;
            }
        }
        info.markStopScheduled();
        if (consumeController) {
            String stopReason = !mouseDown ? "mouse released" : "consumption stopped";
        } else {
            String stopReason;
            String string = stopReason = !mouseDown ? "mouse released" : "lost block target";
        }
        if (activationController) {
            this.stopActivationLoop(player, hand, clip, true);
        } else {
            this.stopLoopedAnimation(player, controller, clip, hand);
        }
    }

    private void requestStopForClip(Player player, InteractionHand hand, String controller, String clip) {
        InteractionHand resolvedHand;
        if (player == null || controller == null || clip == null || clip.isEmpty()) {
            return;
        }
        String baseClip = PunchyClient.normalizeClipKey(clip);
        if (baseClip.isEmpty()) {
            baseClip = clip;
        }
        if (baseClip.isEmpty()) {
            return;
        }
        InteractionHand interactionHand = resolvedHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (CONTROLLER_ACTIVATION.equals(controller)) {
            BoneAnimationController.stopActivation(player, resolvedHand, baseClip);
        } else {
            BoneAnimationController.stop(player, resolvedHand, controller, baseClip);
        }
    }

    private void suppressBowSprite(InteractionHand hand, boolean holdUse) {
        InteractionHand target = hand == null ? InteractionHand.MAIN_HAND : hand;
        this.rangedSpriteSuppressed = true;
        this.rangedSpriteHand = target;
        if (holdUse) {
            this.enterBowUseHold();
        }
    }

    private void releaseBowSpriteSuppression() {
        if (this.rangedSpriteSuppressed) {
            this.exitBowUseHold();
        }
        this.rangedSpriteSuppressed = false;
        this.rangedSpriteHand = InteractionHand.MAIN_HAND;
    }

    private void clampBowUseTicks(LocalPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack stack = player.getUseItem();
        if (stack == null || stack.isEmpty()) {
            return;
        }
        int duration = stack.getUseDuration((LivingEntity)player);
        if (duration <= 0) {
            duration = 72000;
        }
        ((LivingEntityAccessor)player).punchy$setUseItemRemainingTicks(duration);
    }

    private ItemStack createVisualArrowStack(LocalPlayer player) {
        if (player == null) {
            return new ItemStack((ItemLike)Items.ARROW);
        }
        ItemStack projectile = player.getProjectile(player.getMainHandItem());
        if ((projectile == null || projectile.isEmpty()) && player != null) {
            projectile = player.getProjectile(player.getOffhandItem());
        }
        if (projectile == null || projectile.isEmpty()) {
            projectile = new ItemStack((ItemLike)Items.ARROW);
        } else {
            projectile = projectile.copy();
            projectile.setCount(1);
        }
        return projectile;
    }

    private void enterBowUseHold() {
        if (this.rangedSpriteHoldDepth++ == 0) {
            UseAnimationSuppressor.push();
        }
    }

    private void exitBowUseHold() {
        if (this.rangedSpriteHoldDepth <= 0) {
            this.rangedSpriteHoldDepth = 0;
            return;
        }
        --this.rangedSpriteHoldDepth;
        if (this.rangedSpriteHoldDepth == 0) {
            UseAnimationSuppressor.pop();
        }
    }

    private void restoreArrowHandState(InteractionHand hand) {
        if (hand == null) {
            return;
        }
        ItemStack previous = this.savedArrowOverrides.remove(hand);
        Boolean hidden = this.savedArrowHidden.remove(hand);
        if (previous != null) {
            HandItemOverrides.setOverride(hand, previous);
        } else {
            HandItemOverrides.clear(hand);
        }
        HandItemOverrides.setHidden(hand, hidden != null && hidden != false);
        ArmAnimationOverrides.clear(hand);
        this.activeArrowOverrides.remove(hand);
    }

    private boolean isSpriteSuppressedFor(InteractionHand hand) {
        return this.rangedSpriteSuppressed && this.rangedSpriteHand == (hand == null ? InteractionHand.MAIN_HAND : hand);
    }

    private static InteractionHand inferHandFromClip(String clip) {
        if (clip != null && clip.endsWith("_left")) {
            return InteractionHand.OFF_HAND;
        }
        return InteractionHand.MAIN_HAND;
    }

    private static String formatSeconds(double value) {
        return String.format(Locale.ROOT, "%.3f", value);
    }

    private double clipDurationSeconds(Player player, InteractionHand hand, String clip) {
        double seconds = 0.0;
        AnimatedBoneProxy proxy = Punchy.boneProxy();
        if (proxy != null) {
            seconds = proxy.getAnimationDurationSeconds(clip);
        }
        if (seconds <= 0.0) {
            seconds = 2.0;
        }
        double speedFactor = this.activationSpeedFactor(player, hand);
        return seconds / Math.max(0.001, speedFactor);
    }

    private double activationSpeedFactor(Player player, InteractionHand hand) {
        double factor;
        Item item;
        ItemStack held;
        double actionSpeed = AnimatedTool.currentActivationSpeedValue();
        double toolScale = 1.0;
        if (player != null && hand != null && (held = player.getItemInHand(hand)) != null && (item = held.getItem()) instanceof AnimatedTool) {
            AnimatedTool tool = (AnimatedTool)item;
            toolScale = tool.getToolSpeedScale();
        }
        return (factor = Punchy.ANIM_SPEED * toolScale * actionSpeed) <= 0.0 ? 1.0 : factor;
    }

    private static void playLocalSound(SoundEvent event, float volume, float pitch) {
        Minecraft client = Minecraft.getInstance();
        if (event == null || client == null || client.player == null) {
            return;
        }
        client.player.playSound(event, volume, pitch);
    }

    private static void handleImpactInstruction(AnimatedTool tool) {
        InteractionHand resolvedActionHand;
        BlockHitResult blockHr;
        if (tool == null) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        PunchyClient inst = INSTANCE;
        if (client == null || client.player == null || client.level == null) {
            return;
        }
        if (!Punchy.USE_IMPACT_TIMING) {
            return;
        }
        if (AnimatedTool.isCurrentActionUse()) {
            return;
        }
        boolean resetAttackCooldown = false;
        InteractionHand actionHand = AnimatedTool.currentActionHand();
        HitResult hr = client.hitResult;
        BlockHitResult bhr = hr instanceof BlockHitResult ? (blockHr = (BlockHitResult)hr) : null;
        boolean attackHeld = client.options.keyAttack.isDown();
        if (bhr != null && !attackHeld) {
            return;
        }
        BlockPos fallbackPos = lastMiningTargetPos;
        if (bhr != null || fallbackPos != null) {
            HitResult ray;
            BlockPos pos;
            BlockPos blockPos = pos = bhr != null ? bhr.getBlockPos() : fallbackPos;
            if (pos == null && (ray = client.player.pick(5.0, 0.0f, false)) instanceof BlockHitResult) {
                BlockHitResult extraHit = (BlockHitResult)ray;
                pos = extraHit.getBlockPos();
            }
            if (pos == null) {
                return;
            }
            BlockState state = client.level.getBlockState(pos);
            if (!state.isAir() && Punchy.TAP_MINING_ENABLED) {
                SoundEvent ev = state.getSoundType().getHitSound();
                float vol = Math.max(0.2f, Math.min(1.5f, state.getSoundType().getVolume()));
                float pitch = (float)Math.max(0.25, Math.min(2.0, Punchy.SOUND_RATE));
                client.player.playSound(ev, vol, pitch);
                ClientPlatform.get().sendToServer(new BlockImpactPayload(pos));
                resetAttackCooldown = true;
            }
        } else if (hr instanceof EntityHitResult) {
            Entity entity;
            EntityHitResult ehr = (EntityHitResult)hr;
            if (tool instanceof AnimatedBoneProxy && (entity = ehr.getEntity()) != null) {
                ImpactClientHooks.fireAttackImpact(entity, actionHand);
                if (inst != null) {
                    inst.cancelPunchLoopForHand(actionHand);
                    inst.activationTargetIsEntity = true;
                }
                resetAttackCooldown = true;
            }
        }
        InteractionHand interactionHand = resolvedActionHand = actionHand == null ? InteractionHand.MAIN_HAND : actionHand;
        if (resetAttackCooldown) {
            try {
                client.player.resetAttackStrengthTicker();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (inst != null) {
                inst.cancelPunchLoopForHand(resolvedActionHand);
                inst.attackLoopArmed = false;
                inst.finalizePunch((Player)client.player, resolvedActionHand);
            }
        }
        AnimatedTool.markNextActionHand(resolvedActionHand);
        PunchyClient.onPunchImpact();
    }

    private static void createAnimatedBoneRenderer(Consumer<GeoRenderProvider> consumer) {
        if (consumer == null) {
            return;
        }
        consumer.accept(new GeoRenderProvider(){
            private final RightArmRenderer<AnimatedBoneProxy> rightRenderer = new RightArmRenderer();
            private final LeftArmRenderer<AnimatedBoneProxy> leftRenderer = new LeftArmRenderer();

            public GeoItemRenderer<AnimatedBoneProxy> getGeoItemRenderer() {
                InteractionHand hand = VanillaProxyContext.getHand();
                return hand == InteractionHand.OFF_HAND ? this.leftRenderer : this.rightRenderer;
            }
        });
    }

    public static CameraDrift cameraDrift() {
        PunchyClient inst = INSTANCE;
        if (inst == null) {
            return CameraDrift.ZERO;
        }
        return new CameraDrift(inst.lastCameraYawDelta, inst.lastCameraPitchDelta);
    }

    private void resetIdleTransitionState() {
        this.idleTransitionQueues.clear();
        this.activeIdleTransitionClips.clear();
        this.pendingIdleTransitionSources.clear();
        this.deferredWalkRequests.clear();
        this.lastQueuedIdleClip.clear();
    }

    private boolean queueIdleTransitionAfterClip(InteractionHand hand, String controller, String clip) {
        if (clip == null || clip.isEmpty()) {
            return false;
        }
        String normalized = PunchyClient.normalizeClipKey(clip);
        if (PunchyClient.isIdleTransitionClip(normalized)) {
            return false;
        }
        TransitionRequest request = this.buildTransitionRequest(controller, clip);
        if (request == null) {
            return false;
        }
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        PendingTransition pending = this.pendingIdleTransitionSources.get(resolved);
        if (pending != null && pending.normalizedClip.equals(normalized)) {
            return false;
        }
        String lastQueued = this.lastQueuedIdleClip.get(resolved);
        if (lastQueued != null && lastQueued.equals(normalized)) {
            return false;
        }
        this.pendingIdleTransitionSources.put(resolved, new PendingTransition(normalized, request));
        this.lastQueuedIdleClip.put(resolved, normalized);
        return true;
    }

    private void onSourceClipStoppedForIdle(InteractionHand hand, String clip) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        String normalized = PunchyClient.normalizeClipKey(clip);
        PendingTransition pending = this.pendingIdleTransitionSources.get(resolved);
        if (pending == null || !pending.normalizedClip.equals(normalized)) {
            return;
        }
        this.pendingIdleTransitionSources.remove(resolved);
        TransitionRequest request = pending.request();
        if (request == null || request.clip() == null || request.clip().isEmpty()) {
            LocalPlayer local = Minecraft.getInstance().player;
            if (local != null) {
                ToolAnimationOverrides.clear(resolved);
                this.ensureIdleAfterAction(local, resolved);
            }
            return;
        }
        ArrayDeque queue = this.idleTransitionQueues.computeIfAbsent(resolved, h -> new ArrayDeque());
        queue.clear();
        queue.add(request);
        this.processIdleTransitionQueue(resolved);
    }

    private void onQueuedIdleClipStopped(InteractionHand hand, String clip) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        String normalized = PunchyClient.normalizeClipKey(clip);
        String active = this.activeIdleTransitionClips.get(resolved);
        if (active == null || !active.equals(normalized)) {
            return;
        }
        this.activeIdleTransitionClips.remove(resolved);
        this.lastQueuedIdleClip.remove(resolved);
        this.processIdleTransitionQueue(resolved);
    }

    private void processIdleTransitionQueue(InteractionHand hand) {
        InteractionHand resolved;
        InteractionHand interactionHand = resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (this.activeIdleTransitionClips.containsKey(resolved)) {
            return;
        }
        ArrayDeque<TransitionRequest> queue = this.idleTransitionQueues.get(resolved);
        if (queue == null || queue.isEmpty()) {
            this.idleTransitionQueues.remove(resolved);
            Double deferredSpeed = this.deferredWalkRequests.remove(resolved);
            if (deferredSpeed != null) {
                LocalPlayer local = Minecraft.getInstance().player;
                if (local != null) {
                    if (!this.walkActive || this.walkingHands.isEmpty()) {
                        this.walkSpeedMultiplier = deferredSpeed;
                        this.walkActive = true;
                    }
                    this.playWalkAnimation(local, resolved, deferredSpeed);
                    this.walkingHands.add(resolved);
                }
            } else {
                ToolAnimationOverrides.clear(resolved);
                LocalPlayer local = Minecraft.getInstance().player;
                if (local != null) {
                    this.ensureIdleAfterAction(local, resolved);
                }
            }
            return;
        }
        LocalPlayer local = Minecraft.getInstance().player;
        if (local == null) {
            this.idleTransitionQueues.remove(resolved);
            ToolAnimationOverrides.clear(resolved);
            return;
        }
        TransitionRequest next = queue.poll();
        if (next == null || next.clip() == null || next.clip().isEmpty()) {
            this.processIdleTransitionQueue(resolved);
            return;
        }
        AnimatedTool.markNextActionHand(resolved);
        BoneAnimationController.trigger((Player)local, resolved, next.controller(), next.clip());
        this.activeIdleTransitionClips.put(resolved, next.clip());
    }

    private boolean hasIdleTransitionInFlight(InteractionHand hand) {
        InteractionHand resolved;
        InteractionHand interactionHand = resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (this.pendingIdleTransitionSources.containsKey(resolved)) {
            return true;
        }
        if (this.activeIdleTransitionClips.containsKey(resolved)) {
            return true;
        }
        ArrayDeque<TransitionRequest> queue = this.idleTransitionQueues.get(resolved);
        return queue != null && !queue.isEmpty();
    }

    private void clearIdleTransitionState(InteractionHand hand) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        this.pendingIdleTransitionSources.remove(resolved);
        this.activeIdleTransitionClips.remove(resolved);
        this.idleTransitionQueues.remove(resolved);
        this.deferredWalkRequests.remove(resolved);
    }

    private static String normalizeClipKey(String clip) {
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        String normalized = clip;
        if (normalized.startsWith("animation.bone.")) {
            normalized = normalized.substring("animation.bone.".length());
        }
        if (normalized.endsWith("_left")) {
            normalized = normalized.substring(0, normalized.length() - "_left".length());
        } else if (normalized.endsWith("_right")) {
            normalized = normalized.substring(0, normalized.length() - "_right".length());
        }
        return normalized;
    }

    private static String clipKeyWithoutNamespace(String clip) {
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        if (clip.startsWith("animation.bone.")) {
            return clip.substring("animation.bone.".length());
        }
        return clip;
    }

    private static boolean isIdleTransitionClip(String normalizedClip) {
        if (normalizedClip == null || normalizedClip.isEmpty()) {
            return false;
        }
        return normalizedClip.startsWith(TRANSITION_PREFIX);
    }

    private TransitionRequest buildTransitionRequest(String controller, String clip) {
        String transitionClip = PunchyClient.findTransitionClipFor(clip);
        if (transitionClip == null || transitionClip.isEmpty()) {
            return null;
        }
        return new TransitionRequest(controller, transitionClip);
    }

    private static String findTransitionClipFor(String clip) {
        String candidate;
        String candidate2;
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        Set<String> transitions = PunchyClient.transitionAnimations();
        String sourceKey = PunchyClient.clipKeyWithoutNamespace(clip);
        if (!sourceKey.isEmpty() && transitions.contains(candidate2 = TRANSITION_PREFIX + sourceKey)) {
            return candidate2;
        }
        String normalized = PunchyClient.normalizeClipKey(clip);
        if (!normalized.isEmpty() && !normalized.equals(sourceKey) && transitions.contains(candidate = TRANSITION_PREFIX + normalized)) {
            return candidate;
        }
        return "";
    }

    private static String clipKeyForTracking(String clip) {
        if (clip == null || clip.isEmpty()) {
            return "";
        }
        String normalized = PunchyClient.normalizeClipKey(clip);
        return normalized.isEmpty() ? clip : normalized;
    }

    private static String normalizeTransitionAnimationName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (name.startsWith("animation.bone.")) {
            return name.substring("animation.bone.".length());
        }
        return name;
    }

    private static Set<String> transitionAnimations() {
        if (transitionAnimationsLoaded) {
            return cachedTransitionAnimations;
        }
        transitionAnimationsLoaded = true;
        if (Minecraft.getInstance() == null) {
            cachedTransitionAnimations = Set.of();
            return cachedTransitionAnimations;
        }
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"punchy", (String)"geckolib/animations/bone_anchor.animation.json");
        try {
            Optional optional = manager.getResource(location);
            if (optional.isEmpty()) {
                cachedTransitionAnimations = Set.of();
                return cachedTransitionAnimations;
            }
            Resource resource = (Resource)optional.get();
            try (InputStreamReader reader = new InputStreamReader(resource.open(), StandardCharsets.UTF_8);){
                JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonObject animations = GsonHelper.getAsJsonObject((JsonObject)root, (String)"animations", (JsonObject)new JsonObject());
                HashSet<String> names = new HashSet<String>();
                for (Map.Entry entry : animations.entrySet()) {
                    String name = (String)entry.getKey();
                    String normalizedName = PunchyClient.normalizeTransitionAnimationName(name);
                    if (name != null && name.startsWith(TRANSITION_PREFIX)) {
                        names.add(name);
                    }
                    if (!normalizedName.startsWith(TRANSITION_PREFIX)) continue;
                    names.add(normalizedName);
                }
                cachedTransitionAnimations = Set.copyOf(names);
            }
        }
        catch (Exception ignored) {
            cachedTransitionAnimations = Set.of();
        }
        return cachedTransitionAnimations;
    }

    private AnimationRunInfo findAnimationRunInfo(Player player, String controller, String clip) {
        if (player == null || controller == null || clip == null || clip.isEmpty()) {
            return null;
        }
        long mainId = BoneAnimationIds.compute(player, InteractionHand.MAIN_HAND);
        AnimationRunInfo info = this.animationRuns.get(new AnimationRunKey(mainId, controller, clip));
        if (info != null) {
            return info;
        }
        long offId = BoneAnimationIds.compute(player, InteractionHand.OFF_HAND);
        info = this.animationRuns.get(new AnimationRunKey(offId, controller, clip));
        if (info != null) {
            return info;
        }
        for (Map.Entry<AnimationRunKey, AnimationRunInfo> entry : this.animationRuns.entrySet()) {
            AnimationRunKey key = entry.getKey();
            if (!controller.equals(key.controller()) || !clip.equals(key.clip())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean hasViableBlockTarget(Minecraft client) {
        if (client == null || client.hitResult == null || client.level == null) {
            return false;
        }
        if (client.hitResult.getType() != HitResult.Type.BLOCK) {
            return false;
        }
        BlockHitResult blockHit = (BlockHitResult)client.hitResult;
        return blockHit != null && !client.level.getBlockState(blockHit.getBlockPos()).isAir();
    }

    public static void markNextAttackTarget(boolean entity, boolean block) {
        PunchyClient inst = INSTANCE;
        if (inst != null) {
            inst.setPendingAttackTarget(entity, block);
        }
    }

    private void setPendingAttackTarget(boolean entity, boolean block) {
        this.pendingAttackTarget = new AttackTarget(entity, block);
        this.pendingAttackExpiryNanos = System.nanoTime() + 200000000L;
    }

    private AttackTarget consumePendingAttackTarget() {
        if (this.pendingAttackTarget == null) {
            return null;
        }
        long now = System.nanoTime();
        if (now <= this.pendingAttackExpiryNanos) {
            AttackTarget result = this.pendingAttackTarget;
            this.pendingAttackTarget = null;
            return result;
        }
        this.pendingAttackTarget = null;
        return null;
    }

    private static AttackTarget detectAttackTarget(LocalPlayer player) {
        Minecraft client = Minecraft.getInstance();
        if (client != null) {
            Entity crosshairEntity = client.crosshairPickEntity;
            if (crosshairEntity != null && crosshairEntity.isPickable() && !crosshairEntity.isSpectator()) {
                return new AttackTarget(true, false);
            }
            HitResult clientHit = client.hitResult;
            if (clientHit != null) {
                if (clientHit.getType() == HitResult.Type.ENTITY) {
                    return new AttackTarget(true, false);
                }
                if (clientHit instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)clientHit;
                    boolean solid = client.level != null && !client.level.getBlockState(blockHit.getBlockPos()).isAir();
                    return new AttackTarget(false, solid);
                }
            }
        }
        if (player == null || player.level() == null) {
            return new AttackTarget(false, false);
        }
        double reach = player.isCreative() ? 6.0 : 4.5;
        HitResult hit = player.pick(reach, 0.0f, false);
        if (hit == null) {
            return new AttackTarget(false, false);
        }
        if (hit.getType() == HitResult.Type.ENTITY) {
            return new AttackTarget(true, false);
        }
        if (hit instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hit;
            boolean solid = !player.level().getBlockState(blockHit.getBlockPos()).isAir();
            return new AttackTarget(false, solid);
        }
        return new AttackTarget(false, false);
    }

    private static boolean isSwordItem(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        if (stack.is(ItemTags.SWORDS)) {
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof TridentItem || item instanceof MaceItem) {
            return true;
        }
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return key != null && key.getPath().contains("sword");
    }

    static {
        isMiningAnimationPlaying = false;
        miningAnimationStartTime = -1L;
        lastMiningTargetPos = null;
        IN_MAP_RENDER = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    private static enum RangedChargeKind {
        BOW("BowLoad", "bow_load_bow_hand", "bow_load_arrow_hand", true, true, ""),
        CROSSBOW("CrossbowLoad", "crossbow_load_crossbow_hand", "crossbow_load_arrow_hand", true, false, ""),
        TRIDENT("Trident", "trident_throw", "", false, false, "trident_throw_release");

        private final String controller;
        private final String weaponClip;
        private final String arrowClip;
        private final boolean usesArrowHand;
        private final boolean suppressSprite;
        private final String releaseClip;

        private RangedChargeKind(String controller, String weaponClip, String arrowClip, boolean usesArrowHand, boolean suppressSprite, String releaseClip) {
            this.controller = controller;
            this.weaponClip = weaponClip;
            this.arrowClip = arrowClip;
            this.usesArrowHand = usesArrowHand;
            this.suppressSprite = suppressSprite;
            this.releaseClip = releaseClip;
        }

        public String controller() {
            return this.controller;
        }

        public String weaponClip() {
            return this.weaponClip;
        }

        public String arrowClip() {
            return this.arrowClip;
        }

        public boolean usesArrowHand() {
            return this.usesArrowHand;
        }

        public boolean suppressSprite() {
            return this.suppressSprite;
        }

        public String releaseClip() {
            return this.releaseClip;
        }

        public static RangedChargeKind fromStack(ItemStack stack) {
            if (stack == null || stack.isEmpty()) {
                return null;
            }
            Item item = stack.getItem();
            if (item instanceof BowItem) {
                return BOW;
            }
            if (item instanceof CrossbowItem) {
                return CROSSBOW;
            }
            if (item instanceof TridentItem) {
                return TRIDENT;
            }
            return null;
        }
    }

    private static enum ActivationSource {
        NONE,
        PUNCH,
        LOOP,
        USE;

    }

    private static final class ClientHooks
    implements ClientBridge.Hooks {
        private ClientHooks() {
        }

        @Override
        public double walkSpeedForHand(InteractionHand hand) {
            return PunchyClient.walkSpeedForHand(hand);
        }

        @Override
        public double walkOnWaterAnimationSpeed() {
            return PunchyClient.walkOnWaterAnimationSpeed();
        }

        @Override
        public double jumpSpeedForClip(String name) {
            return PunchyClient.jumpSpeedForClip(name);
        }

        @Override
        public void onArrowInstruction(boolean equip) {
            PunchyClient.onArrowInstruction(equip);
        }

        @Override
        public void onCrossbowItemVisibility(InteractionHand hand, boolean hidden) {
            PunchyClient.onCrossbowItemVisibility(hand, hidden);
        }

        @Override
        public void onBowAnimationGate() {
            PunchyClient.onBowAnimationGate();
        }

        @Override
        public void onSpyglassInstruction() {
            PunchyClient.onSpyglassInstruction();
        }

        @Override
        public void onJumpGoingToLand(InteractionHand hand, double tick) {
            PunchyClient.onJumpGoingToLand(hand, tick);
        }

        @Override
        public void onPunchImpact() {
            PunchyClient.onPunchImpact();
        }

        @Override
        public void onAnimationKeyframe(String controller, String clip, String label, double tick) {
            PunchyClient.onAnimationKeyframe(controller, clip, label, tick);
        }

        @Override
        public void onFlintAndSteelArmIn(InteractionHand hand) {
            PunchyClient.onFlintAndSteelArmIn(hand);
        }

        @Override
        public void onFlintAndSteelArmOut(InteractionHand hand) {
            PunchyClient.onFlintAndSteelArmOut(hand);
        }

        @Override
        public void onFlintAndSteelSpark(InteractionHand hand) {
            PunchyClient.onFlintAndSteelSpark(hand);
        }

        @Override
        public void playLocalSound(SoundEvent event, float volume, float pitch) {
            PunchyClient.playLocalSound(event, volume, pitch);
        }

        @Override
        public void handleImpactInstruction(AnimatedTool tool) {
            PunchyClient.handleImpactInstruction(tool);
        }

        @Override
        public void createAnimatedBoneRenderer(Consumer<GeoRenderProvider> consumer) {
            PunchyClient.createAnimatedBoneRenderer(consumer);
        }
    }

    private static final class PunchLoopState {
        private static final int MIN_TAIL_TICKS = 4;
        private int durationTicks;
        private int remainingTicks;
        private boolean stopRequested = false;
        private boolean justLooped = false;

        PunchLoopState(int durationTicks) {
            this.remainingTicks = this.durationTicks = Math.max(1, durationTicks);
        }

        static int defaultTailTicks() {
            return 4;
        }

        void requestStop(int minTailTicks) {
            this.stopRequested = true;
            int tail = Math.max(0, minTailTicks);
            this.remainingTicks = Math.min(this.remainingTicks, tail);
        }

        boolean stopRequested() {
            return this.stopRequested;
        }

        boolean justLooped() {
            return this.justLooped;
        }

        void updateDuration(int newDuration) {
            this.remainingTicks = this.durationTicks = Math.max(1, newDuration);
        }

        boolean tick(boolean canLoop) {
            this.justLooped = false;
            if (--this.remainingTicks > 0) {
                return true;
            }
            if (!this.stopRequested && canLoop) {
                this.remainingTicks = this.durationTicks;
                this.justLooped = true;
                return true;
            }
            this.stopRequested = true;
            return false;
        }
    }

    private record AttackTarget(boolean entity, boolean block) {
    }

    private static final class LanternPhysicsState {
        private static final float STIFFNESS = 60.0f;
        private static final float DAMPING = 1.8f;
        private static final float CAMERA_GAIN_YAW = 100.0f;
        private static final float CAMERA_GAIN_PITCH = 100.0f;
        private static final float ANIMATION_FORWARD_GAIN = 1.0f;
        private static final float ANIMATION_LATERAL_GAIN = 1.0f;
        private static final float MAX_SWING = (float)Math.toRadians(85.0);
        private float forwardAngle;
        private float forwardVel;
        private float lateralAngle;
        private float lateralVel;
        private float twistAngle;
        private float twistVel;
        private float bobSeed = (float)(Math.random() * Math.PI * 2.0);
        private LanternPose pose = LanternPose.ZERO;

        private LanternPhysicsState() {
        }

        void tick(LocalPlayer player, boolean active, boolean leftHand, float yawDeltaDeg, float pitchDeltaDeg, float dt, long gameTime) {
            float yawRate = (float)Math.toRadians(yawDeltaDeg) * 100.0f;
            float pitchRate = (float)Math.toRadians(pitchDeltaDeg) * 100.0f;
            if (leftHand) {
                yawRate = -yawRate;
            }
            if (!active) {
                yawRate = 0.0f;
                pitchRate = 0.0f;
            }
            float deltaMagnitude = Mth.clamp((float)((Math.abs(yawDeltaDeg) + Math.abs(pitchDeltaDeg)) * 0.05f), (float)0.0f, (float)1.0f);
            float bob = (float)Math.sin(this.bobSeed + (float)gameTime * 0.08f) * 0.18f * deltaMagnitude;
            float lateralForce = -yawRate;
            float forwardForce = leftHand ? -pitchRate : pitchRate;
            this.forwardVel += (forwardForce + bob - 1.8f * this.forwardVel - 60.0f * this.forwardAngle) * dt;
            this.lateralVel += (lateralForce - 1.8f * this.lateralVel - 60.0f * this.lateralAngle) * dt;
            this.twistVel += (lateralForce * 0.3f - 1.8f * this.twistVel - 15.0f * this.twistAngle) * dt;
            this.lateralAngle = Mth.clamp((float)(this.lateralAngle + this.lateralVel * dt), (float)(-MAX_SWING), (float)MAX_SWING);
            this.forwardAngle = Mth.clamp((float)(this.forwardAngle + this.forwardVel * dt), (float)(-MAX_SWING), (float)MAX_SWING);
            this.twistAngle = Mth.clamp((float)(this.twistAngle + this.twistVel * dt), (float)(-MAX_SWING), (float)MAX_SWING);
            if (!active && Math.abs(this.lateralAngle) < 0.001f && Math.abs(this.forwardAngle) < 0.001f && Math.abs(this.twistAngle) < 0.001f) {
                this.twistAngle = 0.0f;
                this.forwardAngle = 0.0f;
                this.lateralAngle = 0.0f;
                this.twistVel = 0.0f;
                this.forwardVel = 0.0f;
                this.lateralVel = 0.0f;
            }
            float rotX = -this.lateralAngle;
            float rotZ = this.forwardAngle;
            float rotY = this.twistAngle;
            float offX = Mth.clamp((float)((float)Math.sin(this.forwardAngle) * 0.34f), (float)-0.34f, (float)0.34f);
            float offY = 0.0f;
            float offZ = Mth.clamp((float)(-((float)Math.sin(this.forwardAngle)) * 0.34f), (float)-0.34f, (float)0.34f);
            this.pose = new LanternPose(rotX, rotY, rotZ, offX, offY, offZ);
        }

        void setBasePose(LocalPlayer player, InteractionHand hand) {
            boolean left = hand == InteractionHand.OFF_HAND;
            float bias = left ? -0.015f : 0.015f;
            this.lateralAngle += bias;
        }

        void impulse(float forwardKick, float lateralKick) {
            this.forwardVel += forwardKick * 1.0f;
            this.lateralVel += lateralKick * 1.0f;
        }

        void reset() {
            this.twistAngle = 0.0f;
            this.lateralAngle = 0.0f;
            this.forwardAngle = 0.0f;
            this.twistVel = 0.0f;
            this.lateralVel = 0.0f;
            this.forwardVel = 0.0f;
            this.pose = LanternPose.ZERO;
        }

        LanternPose snapshot() {
            return this.pose;
        }
    }

    private static final class LanternGripState {
        private static final float SPEED = 8.0f;
        private float blend;

        private LanternGripState() {
        }

        void tick(boolean active, float dt) {
            float target = active ? 1.0f : 0.0f;
            float alpha = Mth.clamp((float)(dt * 8.0f), (float)0.0f, (float)1.0f);
            this.blend = Mth.lerp((float)alpha, (float)this.blend, (float)target);
        }

        void reset() {
            this.blend = 0.0f;
        }

        float blend() {
            return this.blend;
        }
    }

    private static final class JumpSpringState {
        private static final float DRIVE_UP = 7.0f;
        private static final float DRIVE_DOWN = 8.0f;
        private static final float RETURN_RATE = 6.5f;
        private static final float MAX_OFFSET = 1.25f;
        private float value;
        private float target;
        private JumpSpringPose pose = JumpSpringPose.ZERO;

        private JumpSpringState() {
        }

        void tick(boolean active, boolean leftHand, float dt) {
            float drive = this.value < this.target ? 7.0f : 8.0f;
            this.value = JumpSpringState.approach(this.value, this.target, drive * dt);
            float settleRate = active ? 2.2749999f : 6.5f;
            this.target = JumpSpringState.approach(this.target, 0.0f, settleRate * dt);
            float normalized = Mth.clamp((float)this.value, (float)-1.25f, (float)1.25f);
            float eased = (float)Math.sin(normalized * 0.65f);
            float pitch = eased * 0.2f;
            float roll = eased * -0.2f;
            if (leftHand) {
                roll = -roll;
            }
            float offY = eased * -0.22f;
            this.pose = new JumpSpringPose(pitch, roll, offY);
        }

        void impulse(float value) {
            this.target = Mth.clamp((float)(this.target + value * 0.22f), (float)-1.25f, (float)1.25f);
        }

        void reset() {
            this.value = 0.0f;
            this.target = 0.0f;
            this.pose = JumpSpringPose.ZERO;
        }

        JumpSpringPose snapshot() {
            return this.pose;
        }

        private static float approach(float current, float goal, float delta) {
            if (current < goal) {
                return Math.min(goal, current + delta);
            }
            if (current > goal) {
                return Math.max(goal, current - delta);
            }
            return current;
        }
    }

    private static final class SneakSpringState {
        private static final float TARGET_DEPTH = -0.095f;
        private static final float DOWN_STIFFNESS = 42.0f;
        private static final float UP_STIFFNESS = 32.0f;
        private static final float DAMPING = 14.0f;
        private static final float DOWN_IMPULSE = -2.4f;
        private static final float UP_IMPULSE = 2.0f;
        private float value;
        private float velocity;
        private boolean sneaking;

        private SneakSpringState() {
        }

        void setSneaking(boolean sneaking) {
            if (this.sneaking == sneaking) {
                return;
            }
            this.sneaking = sneaking;
            this.velocity += sneaking ? -2.4f : 2.0f;
        }

        void tick(float dt) {
            float target = this.sneaking ? -0.095f : 0.0f;
            float stiffness = this.sneaking ? 42.0f : 32.0f;
            float accel = stiffness * (target - this.value) - 14.0f * this.velocity;
            this.velocity += accel * dt;
            this.value += this.velocity * dt;
            if (!this.sneaking && Math.abs(this.value) < 1.0E-4f && Math.abs(this.velocity) < 1.0E-4f) {
                this.value = 0.0f;
                this.velocity = 0.0f;
            }
        }

        float offset() {
            return this.value;
        }

        void reset() {
            this.value = 0.0f;
            this.velocity = 0.0f;
            this.sneaking = false;
        }
    }

    private record ReleaseCleanup(InteractionHand arrowHand, boolean clearArrow, boolean releaseSprite, String controller, String releaseClip) {
    }

    public record LanternPose(float rotX, float rotY, float rotZ, float offX, float offY, float offZ) {
        public static final LanternPose ZERO = new LanternPose(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public record JumpSpringPose(float rotX, float rotZ, float offY) {
        public static final JumpSpringPose ZERO = new JumpSpringPose(0.0f, 0.0f, 0.0f);
    }

    public record JumpSpringPivot(float x, float y, float z) {
        public static final JumpSpringPivot ZERO = new JumpSpringPivot(0.0f, 0.0f, 0.0f);

        public boolean isZero() {
            return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
        }
    }

    private static enum LeftActionProfile {
        TOOL_SWAY,
        PUNCH_ONLY,
        SWORD,
        TRIDENT,
        MACE;

    }

    private record AnimationRunKey(long instanceId, String controller, String clip) {
    }

    private static final class AnimationRunInfo {
        private final long startGameTime;
        private final long startNanoTime;
        private final InteractionHand hand;
        private final long expectedTicks;
        private final double expectedSeconds;
        private final List<String> keyframes = new ArrayList<String>();
        private boolean stopScheduled = false;

        AnimationRunInfo(long startGameTime, long startNanoTime, InteractionHand hand, long expectedTicks, double expectedSeconds) {
            this.startGameTime = startGameTime;
            this.startNanoTime = startNanoTime;
            this.hand = hand;
            this.expectedTicks = expectedTicks;
            this.expectedSeconds = expectedSeconds;
        }

        long startGameTime() {
            return this.startGameTime;
        }

        long startNanoTime() {
            return this.startNanoTime;
        }

        InteractionHand hand() {
            return this.hand;
        }

        List<String> keyframes() {
            return this.keyframes;
        }

        long expectedTicks() {
            return this.expectedTicks;
        }

        double expectedSeconds() {
            return this.expectedSeconds;
        }

        boolean stopScheduled() {
            return this.stopScheduled;
        }

        void markStopScheduled() {
            this.stopScheduled = true;
        }
    }

    public record CameraDrift(float yawDeg, float pitchDeg) {
        public static final CameraDrift ZERO = new CameraDrift(0.0f, 0.0f);
    }

    private static final class TransitionRequest {
        private final String controller;
        private final String clip;

        private TransitionRequest(String controller, String clip) {
            this.controller = controller;
            this.clip = clip;
        }

        public String controller() {
            return this.controller;
        }

        public String clip() {
            return this.clip;
        }
    }

    private static final class PendingTransition {
        private final String normalizedClip;
        private final TransitionRequest request;

        private PendingTransition(String normalizedClip, TransitionRequest request) {
            this.normalizedClip = normalizedClip;
            this.request = request;
        }

        public TransitionRequest request() {
            return this.request;
        }
    }
}

