/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.gui.PunchyConfigScreen;
import com.henrique.punchy.client.tuning.TuningKeybinds;
import com.henrique.punchy.command.ModCommands;
import com.henrique.punchy.platform.ClientPlatform;
import com.henrique.punchy.platform.Platform;
import com.henrique.punchy.platform.neoforge.NeoForgeClientPlatformServices;
import com.henrique.punchy.platform.neoforge.NeoForgePlatformServices;
import com.henrique.punchy.util.OffhandMirrorGuard;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="punchy")
public final class PunchyNeoForge {
    public PunchyNeoForge(IEventBus modEventBus) {
        Platform.init(NeoForgePlatformServices.INSTANCE);
        ModCommands.register();
        NeoForgePlatformServices.INSTANCE.registerModEventListeners(modEventBus);
        Punchy.ITEMS.register(modEventBus);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (minecraft, parent) -> new PunchyConfigScreen(parent));
        modEventBus.addListener(this::onCommonSetup);
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            ClientPlatform.init(NeoForgeClientPlatformServices.INSTANCE);
            NeoForgeClientPlatformServices.INSTANCE.registerModListeners(modEventBus);
            modEventBus.addListener(ClientHooks::onClientSetup);
            TuningKeybinds.register();
        }
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            OffhandMirrorGuard.initConfig(Platform.get().getConfigDirectory());
            OffhandMirrorGuard.registerTickHandler();
            Punchy.initialize();
        });
    }

    private static final class ClientHooks {
        private ClientHooks() {
        }

        private static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(PunchyClient::initialize);
        }
    }
}

