/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client;

import com.henrique.punchy.item.AnimatedTool;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;

public final class ClientBridge {
    private static Hooks hooks = NoopHooks.INSTANCE;

    private ClientBridge() {
    }

    public static Hooks hooks() {
        return hooks;
    }

    public static void setHooks(Hooks impl) {
        hooks = impl == null ? NoopHooks.INSTANCE : impl;
    }

    public static interface Hooks {
        public double walkSpeedForHand(InteractionHand var1);

        public double jumpSpeedForClip(String var1);

        public double walkOnWaterAnimationSpeed();

        public void onArrowInstruction(boolean var1);

        public void onBowAnimationGate();

        public void onSpyglassInstruction();

        public void onJumpGoingToLand(InteractionHand var1, double var2);

        public void onPunchImpact();

        public void onCrossbowItemVisibility(InteractionHand var1, boolean var2);

        public void onAnimationKeyframe(String var1, String var2, String var3, double var4);

        public void onFlintAndSteelArmIn(InteractionHand var1);

        public void onFlintAndSteelArmOut(InteractionHand var1);

        public void onFlintAndSteelSpark(InteractionHand var1);

        public void playLocalSound(SoundEvent var1, float var2, float var3);

        public void handleImpactInstruction(AnimatedTool var1);

        public void createAnimatedBoneRenderer(Consumer<GeoRenderProvider> var1);
    }

    private static enum NoopHooks implements Hooks
    {
        INSTANCE;


        @Override
        public double walkSpeedForHand(InteractionHand hand) {
            return 1.0;
        }

        @Override
        public double jumpSpeedForClip(String name) {
            return 1.0;
        }

        @Override
        public double walkOnWaterAnimationSpeed() {
            return 1.0;
        }

        @Override
        public void onArrowInstruction(boolean equip) {
        }

        @Override
        public void onBowAnimationGate() {
        }

        @Override
        public void onSpyglassInstruction() {
        }

        @Override
        public void onJumpGoingToLand(InteractionHand hand, double tick) {
        }

        @Override
        public void onPunchImpact() {
        }

        @Override
        public void onCrossbowItemVisibility(InteractionHand hand, boolean hidden) {
        }

        @Override
        public void onAnimationKeyframe(String controller, String clip, String label, double tick) {
        }

        @Override
        public void onFlintAndSteelArmIn(InteractionHand hand) {
        }

        @Override
        public void onFlintAndSteelArmOut(InteractionHand hand) {
        }

        @Override
        public void onFlintAndSteelSpark(InteractionHand hand) {
        }

        @Override
        public void playLocalSound(SoundEvent event, float volume, float pitch) {
        }

        @Override
        public void handleImpactInstruction(AnimatedTool tool) {
        }

        @Override
        public void createAnimatedBoneRenderer(Consumer<GeoRenderProvider> consumer) {
        }
    }
}

