/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.debug;

import com.henrique.punchy.Punchy;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public final class AnchorDebugProbe {
    private static final Map<ProbeKey, Sample> SAMPLES = new EnumMap<ProbeKey, Sample>(ProbeKey.class);

    private AnchorDebugProbe() {
    }

    public static void sampleArm(InteractionHand hand, PoseStack.Pose entry, long worldTime) {
        if (!Punchy.DEBUG_POSITION) {
            return;
        }
        SAMPLES.put(ProbeKey.arm(hand), AnchorDebugProbe.capture(entry, worldTime));
    }

    public static void sampleItem(InteractionHand hand, PoseStack.Pose entry, long worldTime) {
        if (!Punchy.DEBUG_POSITION) {
            return;
        }
        SAMPLES.put(ProbeKey.item(hand), AnchorDebugProbe.capture(entry, worldTime));
    }

    private static Sample capture(PoseStack.Pose entry, long worldTime) {
        Matrix4f mat = new Matrix4f((Matrix4fc)entry.pose());
        Vector3f forward = new Vector3f(0.0f, 0.0f, -1.0f);
        forward.mulDirection((Matrix4fc)mat);
        if (forward.lengthSquared() > 1.0E-6f) {
            forward.normalize();
        }
        float yaw = (float)Math.toDegrees(Math.atan2(-forward.x, forward.z));
        float pitch = (float)Math.toDegrees(Math.asin(Math.max(-1.0f, Math.min(1.0f, forward.y))));
        Vector3f pos = mat.transformPosition(new Vector3f());
        return new Sample(yaw, pitch, forward, pos, worldTime);
    }

    public static void tick(Minecraft client) {
        if (!Punchy.DEBUG_POSITION || client == null || client.level == null) {
            SAMPLES.clear();
            return;
        }
        long time = client.level.getGameTime();
        SAMPLES.entrySet().removeIf(entry -> ((Sample)entry.getValue()).worldTime != time);
    }

    public static float getArmYaw(InteractionHand hand) {
        Sample sample = SAMPLES.get((Object)ProbeKey.arm(hand));
        return sample == null ? Float.NaN : sample.yaw;
    }

    public static float getItemYaw(InteractionHand hand) {
        Sample sample = SAMPLES.get((Object)ProbeKey.item(hand));
        return sample == null ? Float.NaN : sample.yaw;
    }

    public static void pushMessage(Minecraft client, String message) {
        if (client == null || client.player == null) {
            return;
        }
        client.gui.setOverlayMessage((Component)Component.literal((String)message), false);
    }

    private static enum ProbeKey {
        ARM_MAIN,
        ARM_OFF,
        ITEM_MAIN,
        ITEM_OFF;


        static ProbeKey arm(InteractionHand hand) {
            return hand == InteractionHand.OFF_HAND ? ARM_OFF : ARM_MAIN;
        }

        static ProbeKey item(InteractionHand hand) {
            return hand == InteractionHand.OFF_HAND ? ITEM_OFF : ITEM_MAIN;
        }
    }

    private static final class Sample {
        final float yaw;
        final float pitch;
        final float forwardX;
        final float forwardY;
        final float forwardZ;
        final float posX;
        final float posY;
        final float posZ;
        final long worldTime;

        Sample(float yaw, float pitch, Vector3f forward, Vector3f pos, long worldTime) {
            this.yaw = yaw;
            this.pitch = pitch;
            this.forwardX = forward.x;
            this.forwardY = forward.y;
            this.forwardZ = forward.z;
            this.posX = pos.x;
            this.posY = pos.y;
            this.posZ = pos.z;
            this.worldTime = worldTime;
        }
    }
}

