/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.gui;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.config.PunchyConfig;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class PunchyConfigScreen
extends Screen {
    private final Screen parent;
    private final PunchyConfig config;
    private Button vanillaButton;
    private Button punchyaButton;
    private CycleButton<Boolean> jumpPhysicsToggle;
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int TEXT_HEIGHT = 10;
    private static final int SMALL_GAP = 4;
    private static final int SECTION_GAP = 12;

    public PunchyConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"screen.punchy.config.title"));
        this.parent = parent;
        this.config = PunchyConfig.load();
    }

    protected void init() {
        int startY;
        int centerX = this.width / 2;
        int sectionHeight = 34;
        int totalContentHeight = sectionHeight * 3 + 36 + 20;
        int currentY = startY = (this.height - totalContentHeight) / 2 + 10;
        this.applySpeedPreset();
        int buttonSpacing = 10;
        int totalPresetWidth = 300 + buttonSpacing;
        int startX = centerX - totalPresetWidth / 2;
        this.vanillaButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.punchy.vanilla"), b -> this.applyPreset(PunchyConfig.SpeedPreset.VANILLA)).pos(startX, currentY).size(150, 20).build());
        this.punchyaButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.punchy.punchya"), b -> this.applyPreset(PunchyConfig.SpeedPreset.PUNCHYA)).pos(startX + 150 + buttonSpacing, currentY).size(150, 20).build());
        currentY += 34;
        int toggleY = (currentY += 12) + 10 + 4;
        this.jumpPhysicsToggle = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder().withInitialValue((Object)this.config.isJumpPhysicsEnabled()).create(centerX - 100, toggleY, 200, 20, (Component)Component.translatable((String)"option.punchy.jump_physics"), (button, value) -> {
            this.config.setJumpPhysicsEnabled((boolean)value);
            Punchy.applyCombatToggles(this.config);
            this.config.save();
            this.sendSpeedStatus();
        }));
        this.jumpPhysicsToggle.setTooltip(Tooltip.create((Component)Component.translatable((String)"option.punchy.jump_physics.tooltip")));
        currentY = toggleY + 20;
        int linkButtonsY = (currentY += 12) + 10 + 4;
        int smallButtonWidth = 100;
        int totalLinkWidth = smallButtonWidth * 3 + 16;
        int linkStartX = centerX - totalLinkWidth / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.punchy.buy_coffee"), b -> this.openSupportLink()).pos(linkStartX, linkButtonsY).size(smallButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.punchy.discord"), b -> this.openDiscordLink()).pos(linkStartX + smallButtonWidth + 8, linkButtonsY).size(smallButtonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.punchy.report_bug"), b -> this.openBugLink()).pos(linkStartX + (smallButtonWidth + 8) * 2, linkButtonsY).size(smallButtonWidth, 20).build());
        currentY = linkButtonsY + 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, b -> this.onClose()).pos(centerX - 75, currentY += 12).size(150, 20).build());
        this.updateSelected();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, -1879048192);
        int centerX = this.width / 2;
        guiGraphics.drawCenteredString(this.font, this.title, centerX, 15, 0xFFFFFF);
        int sectionHeight = 34;
        int totalContentHeight = sectionHeight * 3 + 36 + 20;
        int startY = (this.height - totalContentHeight) / 2 + 10;
        int presetDescY = startY + 20 + 4;
        int buttonSpacing = 10;
        int totalPresetWidth = 300 + buttonSpacing;
        int startX = centerX - totalPresetWidth / 2;
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"screen.punchy.config.vanilla_desc"), startX + 75, presetDescY, 0xA0A0A0);
        this.drawCenteredText(guiGraphics, (Component)Component.translatable((String)"screen.punchy.config.punchya_desc"), startX + 150 + buttonSpacing + 75, presetDescY, 0xA0A0A0);
        int gameplayBlockY = presetDescY + 10 + 12;
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.punchy.config.gameplay_settings"), centerX, gameplayBlockY, 16766720);
        int supportBlockY = gameplayBlockY + 10 + 4 + 20 + 12;
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.punchy.config.support_title"), centerX, supportBlockY, 0x55FF55);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void drawCenteredText(GuiGraphics graphics, Component text, int x, int y, int color) {
        graphics.drawCenteredString(this.font, text, x, y, color);
    }

    private void updateSelected() {
        boolean punchyaSelected;
        boolean vanillaSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.VANILLA;
        boolean bl = punchyaSelected = this.config.getSpeedPreset() == PunchyConfig.SpeedPreset.PUNCHYA;
        if (this.vanillaButton != null) {
            boolean bl2 = this.vanillaButton.active = !vanillaSelected;
        }
        if (this.punchyaButton != null) {
            this.punchyaButton.active = !punchyaSelected;
        }
        this.sendSpeedStatus();
    }

    private void sendSpeedStatus() {
        Minecraft client = this.minecraft;
        if (client != null && client.player != null) {
            String speedFactor = String.format(Locale.ROOT, "%.1f", Punchy.ANIM_SPEED);
            MutableComponent presetName = Component.translatable((String)this.config.getSpeedPreset().translationKey());
            MutableComponent tapState = Component.translatable((String)(this.config.isTapMiningEnabled() ? "state.punchy.on" : "state.punchy.off"));
            MutableComponent jumpState = Component.translatable((String)(this.config.isJumpPhysicsEnabled() ? "state.punchy.on" : "state.punchy.off"));
            MutableComponent message = Component.translatable((String)"message.punchy.speed_status", (Object[])new Object[]{presetName, speedFactor, tapState, jumpState});
            client.player.displayClientMessage((Component)message, true);
        }
    }

    private void applyPreset(PunchyConfig.SpeedPreset preset) {
        this.config.setSpeedPreset(preset);
        boolean tapOn = preset == PunchyConfig.SpeedPreset.PUNCHYA;
        this.setTapMining(tapOn);
        this.applySpeedPreset();
        this.config.save();
        this.updateSelected();
    }

    private void setTapMining(boolean value) {
        this.config.setTapMiningEnabled(value);
        Punchy.applyCombatToggles(this.config);
        this.config.save();
        this.sendSpeedStatus();
    }

    private void applySpeedPreset() {
        Punchy.applyCombatToggles(this.config);
    }

    private void openSupportLink() {
        this.openLink("https://ko-fi.com/modinpunchy");
    }

    private void openDiscordLink() {
        this.openLink("https://discord.com/invite/CXttaCyGCN");
    }

    private void openBugLink() {
        this.openLink("https://discord.com/invite/CXttaCyGCN");
    }

    private void openLink(String url) {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.getPlatform().openUri(url);
            }
            this.minecraft.setScreen((Screen)this);
        }, url, true));
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

