/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.render.AxolotlBucketRenderer;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateAccessor;
import com.henrique.punchy.mixin.accessor.ItemStackRenderStateLayerAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.joml.Vector3f;

public final class AxolotlBucketAnimator {
    private AxolotlBucketAnimator() {
    }

    public static void apply(ItemStack stack, ItemStackRenderState renderState, InteractionHand hand) {
        if (!AxolotlBucketAnimator.shouldAnimate(stack)) {
            return;
        }
        ItemStackRenderStateAccessor accessor = (ItemStackRenderStateAccessor)renderState;
        int layerCount = accessor.punchy$activeLayerCount();
        if (layerCount <= 0) {
            return;
        }
        ItemStackRenderState.LayerRenderState[] layers = accessor.punchy$layers();
        ArrayList<ExtractedLayer> extracted = new ArrayList<ExtractedLayer>();
        for (int i = 0; i < layerCount && i < layers.length; ++i) {
            List quads;
            ItemStackRenderState.LayerRenderState layer = layers[i];
            if (layer == null || (quads = layer.prepareQuadList()).isEmpty()) continue;
            ArrayList<BakedQuad> bodyQuads = new ArrayList<BakedQuad>();
            Iterator it = quads.iterator();
            while (it.hasNext()) {
                TextureAtlasSprite sprite;
                BakedQuad quad = (BakedQuad)it.next();
                if (quad == null || (sprite = quad.sprite()) == null || !AxolotlBucketAnimator.isCreatureTexture(sprite.contents().name())) continue;
                bodyQuads.add(quad);
                it.remove();
            }
            if (bodyQuads.isEmpty()) continue;
            ItemStackRenderStateLayerAccessor layerAccessor = (ItemStackRenderStateLayerAccessor)layer;
            RenderType renderType = layerAccessor.punchy$renderType();
            if (renderType == null) {
                quads.addAll(bodyQuads);
                continue;
            }
            ItemStackRenderState.FoilType foilType = layerAccessor.punchy$foilType();
            ItemTransform transform = layerAccessor.punchy$transform();
            int[] tintLayers = layerAccessor.punchy$tintLayers();
            int[] tintCopy = tintLayers == null || tintLayers.length == 0 ? new int[]{} : (int[])tintLayers.clone();
            TextureAtlasSprite particle = layerAccessor.punchy$particleIcon();
            Supplier<Vector3f[]> extents = layerAccessor.punchy$extents();
            boolean usesBlockLight = layerAccessor.punchy$usesBlockLight();
            extracted.add(new ExtractedLayer(List.copyOf(bodyQuads), renderType, foilType, transform, tintCopy, particle, extents, usesBlockLight));
        }
        if (extracted.isEmpty()) {
            return;
        }
        for (ExtractedLayer entry : extracted) {
            ItemStackRenderState.LayerRenderState target = renderState.newLayer();
            target.setRenderType(entry.renderType());
            target.setFoilType(entry.foilType());
            target.setTransform(entry.transform());
            target.setUsesBlockLight(entry.usesBlockLight());
            if (entry.particle() != null) {
                target.setParticleIcon(entry.particle());
            }
            if (entry.extents() != null) {
                target.setExtents(entry.extents());
            }
            int[] tint = entry.tintLayers();
            int[] dst = target.prepareTintLayers(tint.length);
            if (tint.length > 0) {
                System.arraycopy(tint, 0, dst, 0, tint.length);
            }
            target.setupSpecialModel((SpecialModelRenderer)AxolotlBucketRenderer.INSTANCE, (Object)new AxolotlBucketRenderer.LayerData(hand, entry.renderType(), entry.foilType(), dst, entry.quads()));
        }
    }

    private static boolean shouldAnimate(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return stack.is(Items.AXOLOTL_BUCKET) || stack.is(Items.TROPICAL_FISH_BUCKET) || stack.is(Items.PUFFERFISH_BUCKET) || stack.is(Items.COD_BUCKET) || stack.is(Items.SALMON_BUCKET) || stack.is(Items.TADPOLE_BUCKET);
    }

    private static boolean isCreatureTexture(ResourceLocation name) {
        if (name == null) {
            return false;
        }
        String path = name.getPath();
        if (path == null) {
            return false;
        }
        String normalized = path.toLowerCase(Locale.ROOT);
        if (!normalized.startsWith("item/")) {
            return false;
        }
        if (normalized.contains("_water")) {
            return false;
        }
        return normalized.contains("axolotl") || normalized.contains("tropical_fish") || normalized.contains("pufferfish") || normalized.contains("cod") || normalized.contains("salmon") || normalized.contains("tadpole");
    }

    private record ExtractedLayer(List<BakedQuad> quads, RenderType renderType, ItemStackRenderState.FoilType foilType, ItemTransform transform, int[] tintLayers, TextureAtlasSprite particle, Supplier<Vector3f[]> extents, boolean usesBlockLight) {
    }
}

