/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.AxolotlPhysics;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class AxolotlBucketRenderer
implements SpecialModelRenderer<LayerData> {
    static final AxolotlBucketRenderer INSTANCE = new AxolotlBucketRenderer();
    private static final EnumMap<InteractionHand, AxolotlPhysics> PHYSICS = new EnumMap(InteractionHand.class);

    private AxolotlBucketRenderer() {
    }

    public void submit(@Nullable LayerData data, ItemDisplayContext context, PoseStack poseStack, SubmitNodeCollector collector, int light, int overlay, boolean foilActive, int seed) {
        float pivotZ;
        float pivotY;
        float pivotX;
        Vec3 contextPivot;
        if (data == null || data.quads == null || data.quads.isEmpty() || data.renderType == null) {
            return;
        }
        InteractionHand hand = data.hand == null ? InteractionHand.MAIN_HAND : data.hand;
        PunchyClient.JumpSpringPose pose = PunchyClient.jumpSpringPose(InteractionHand.MAIN_HAND);
        boolean left = hand == InteractionHand.OFF_HAND;
        Vec3 tuningPivot = VanillaProxyContext.getItemPivot(hand);
        Vec3 vec3 = contextPivot = tuningPivot != null ? tuningPivot : VanillaProxyContext.getSpringPivot(hand);
        if (contextPivot != null) {
            pivotX = (float)contextPivot.x();
            pivotY = (float)contextPivot.y();
            pivotZ = (float)contextPivot.z();
        } else {
            PunchyClient.JumpSpringPivot pivot = PunchyClient.jumpSpringPivot();
            pivotX = pivot.x();
            pivotY = pivot.y();
            pivotZ = pivot.z();
        }
        if (left) {
            pivotX = -pivotX;
        }
        poseStack.translate(pivotX, pivotY, pivotZ);
        AxolotlPhysics physics = AxolotlBucketRenderer.stateFor(hand);
        PunchyClient.CameraDrift drift = PunchyClient.cameraDrift();
        physics.update(pose, left, drift);
        float pitch = physics.getPitch();
        float roll = physics.getRoll();
        if (left) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        }
        if (pitch != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotation(pitch));
        }
        if (roll != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(roll));
        }
        if (left) {
            poseStack.mulPose((Quaternionfc)Axis.YN.rotation((float)Math.PI));
        }
        poseStack.translate(-pivotX, -pivotY, -pivotZ);
        float offY = physics.getOffY();
        if (offY != 0.0f) {
            poseStack.translate(0.0f, offY, 0.0f);
        }
        collector.submitItem(poseStack, context, light, overlay, seed, data.tintLayers, data.quads, data.renderType, data.foilType);
    }

    public void getExtents(Set<Vector3f> extents) {
    }

    @Nullable
    public LayerData extractArgument(ItemStack stack) {
        return null;
    }

    private static AxolotlPhysics stateFor(InteractionHand hand) {
        InteractionHand resolved = hand == null ? InteractionHand.MAIN_HAND : hand;
        return PHYSICS.computeIfAbsent(resolved, h -> new AxolotlPhysics());
    }

    public record LayerData(InteractionHand hand, RenderType renderType, ItemStackRenderState.FoilType foilType, int[] tintLayers, List<BakedQuad> quads) {
    }
}

