/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.renderer.layer.VanillaFirstPersonItemLayer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class ToolTuning {
    private static Profile GLOBAL_RIGHT;
    private static Profile GLOBAL_LEFT;
    private static Profile AXE_R;
    private static Profile AXE_L;
    private static Profile PICKAXE_R;
    private static Profile PICKAXE_L;
    private static Profile HOE_R;
    private static Profile HOE_L;
    private static Profile SWORD_R;
    private static Profile SWORD_L;
    private static Profile SHOVEL_R;
    private static Profile SHOVEL_L;
    private static Profile SHIELD_R;
    private static Profile SHIELD_L;
    private static Profile BLOCK_R;
    private static Profile BLOCK_L;
    private static Profile FLOWER_PENDULUM_R;
    private static Profile FLOWER_PENDULUM_L;
    private static Profile BOW_R;
    private static Profile BOW_L;
    private static Profile ARROW_R;
    private static Profile ARROW_L;
    private static Profile CROSSBOW_R;
    private static Profile CROSSBOW_L;
    private static Profile SPYGLASS_R;
    private static Profile SPYGLASS_L;
    private static Profile FLINT_R;
    private static Profile FLINT_L;
    private static Profile FOOD_R;
    private static Profile FOOD_L;
    private static Profile SHUBBA_R;
    private static Profile SHUBBA_L;
    private static Profile MACE_R;
    private static Profile MACE_L;
    private static Profile TRIDENT_R;
    private static Profile TRIDENT_L;
    private static Profile FISHING_ROD_R;
    private static Profile FISHING_ROD_L;
    private static Profile TORCH_R;
    private static Profile TORCH_L;
    private static Profile LANTERN_R;
    private static Profile LANTERN_L;
    private static Profile REDSTONE_R;
    private static Profile REDSTONE_L;
    private static Profile CREATURE_BUCKET_R;
    private static Profile CREATURE_BUCKET_L;
    private static Profile MINECART_R;
    private static Profile MINECART_L;
    private static Profile BOAT_R;
    private static Profile BOAT_L;
    private static Profile BUTTON_PLATE_R;
    private static Profile BUTTON_PLATE_L;
    private static Profile TRAPDOOR_R;
    private static Profile TRAPDOOR_L;
    private static Profile CARPET_R;
    private static Profile CARPET_L;
    private static Profile BED_R;
    private static Profile BED_L;
    private static Profile INGREDIENT_R;
    private static Profile INGREDIENT_L;
    private static final Map<VanillaFirstPersonItemLayer.ToolKind, TransformOverride> OVERRIDE_RIGHT;
    private static final Map<VanillaFirstPersonItemLayer.ToolKind, TransformOverride> OVERRIDE_LEFT;
    private static final Map<ResourceLocation, SpecificEntry> ITEM_SPECIFICS;
    private static final EnumMap<VanillaFirstPersonItemLayer.ToolKind, Boolean> ATTACHED_RIGHT;
    private static final EnumMap<VanillaFirstPersonItemLayer.ToolKind, Boolean> ATTACHED_LEFT;

    private ToolTuning() {
    }

    public static void resetDefaults() {
        ToolTuning.resetAttachments();
        GLOBAL_RIGHT = new Profile(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        GLOBAL_LEFT = GLOBAL_RIGHT.mirror();
        AXE_R = ToolTuning.blankProfile();
        AXE_L = ToolTuning.blankProfile();
        PICKAXE_R = ToolTuning.blankProfile();
        PICKAXE_L = ToolTuning.blankProfile();
        HOE_R = ToolTuning.blankProfile();
        HOE_L = ToolTuning.blankProfile();
        SWORD_R = ToolTuning.blankProfile();
        SWORD_L = ToolTuning.blankProfile();
        SHOVEL_R = ToolTuning.blankProfile();
        SHOVEL_L = ToolTuning.blankProfile();
        SHIELD_R = ToolTuning.blankProfile();
        SHIELD_L = ToolTuning.blankProfile();
        BLOCK_R = ToolTuning.blankProfile();
        BLOCK_L = ToolTuning.blankProfile();
        FLOWER_PENDULUM_R = ToolTuning.blankProfile();
        FLOWER_PENDULUM_L = ToolTuning.blankProfile();
        TORCH_R = ToolTuning.blankProfile();
        TORCH_L = ToolTuning.blankProfile();
        LANTERN_R = new Profile(1.0f, 0.0f, -0.08f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.55f, 0.0f);
        LANTERN_L = LANTERN_R.mirror();
        REDSTONE_R = ToolTuning.blankProfile();
        REDSTONE_L = ToolTuning.blankProfile();
        CREATURE_BUCKET_R = ToolTuning.blankProfile();
        CREATURE_BUCKET_L = ToolTuning.blankProfile();
        MINECART_R = ToolTuning.blankProfile();
        MINECART_L = ToolTuning.blankProfile();
        BOAT_R = ToolTuning.blankProfile();
        BOAT_L = ToolTuning.blankProfile();
        BUTTON_PLATE_R = ToolTuning.blankProfile();
        BUTTON_PLATE_L = ToolTuning.blankProfile();
        TRAPDOOR_R = ToolTuning.blankProfile();
        TRAPDOOR_L = ToolTuning.blankProfile();
        CARPET_R = ToolTuning.blankProfile();
        CARPET_L = ToolTuning.blankProfile();
        BED_R = ToolTuning.blankProfile();
        BED_L = ToolTuning.blankProfile();
        INGREDIENT_R = ToolTuning.blankProfile();
        INGREDIENT_L = ToolTuning.blankProfile();
        BOW_R = ToolTuning.blankProfile();
        BOW_L = ToolTuning.blankProfile();
        ARROW_R = ToolTuning.blankProfile();
        ARROW_L = ToolTuning.blankProfile();
        CROSSBOW_R = ToolTuning.blankProfile();
        CROSSBOW_L = ToolTuning.blankProfile();
        SPYGLASS_R = ToolTuning.blankProfile();
        SPYGLASS_L = ToolTuning.blankProfile();
        FLINT_R = ToolTuning.blankProfile();
        FLINT_L = ToolTuning.blankProfile();
        FOOD_R = ToolTuning.blankProfile();
        FOOD_L = ToolTuning.blankProfile();
        SHUBBA_R = ToolTuning.blankProfile();
        SHUBBA_L = ToolTuning.blankProfile();
        MACE_R = ToolTuning.blankProfile();
        MACE_L = ToolTuning.blankProfile();
        TRIDENT_R = ToolTuning.blankProfile();
        TRIDENT_L = ToolTuning.blankProfile();
        FISHING_ROD_R = ToolTuning.blankProfile();
        FISHING_ROD_L = ToolTuning.blankProfile();
        OVERRIDE_RIGHT.clear();
        OVERRIDE_LEFT.clear();
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            OVERRIDE_RIGHT.put(kind, new TransformOverride());
            OVERRIDE_LEFT.put(kind, new TransformOverride());
        }
        ITEM_SPECIFICS.clear();
        ToolTuning.refreshAll();
    }

    public static void resetAttachments() {
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            ATTACHED_RIGHT.put(kind, true);
            ATTACHED_LEFT.put(kind, true);
        }
    }

    private static void setAttachmentState(VanillaFirstPersonItemLayer.ToolKind kind, boolean left, boolean attached) {
        if (kind == null) {
            return;
        }
        EnumMap<VanillaFirstPersonItemLayer.ToolKind, Boolean> map = left ? ATTACHED_LEFT : ATTACHED_RIGHT;
        map.put(kind, attached);
    }

    public static boolean isKindAttached(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        if (kind == null) {
            return true;
        }
        return (left ? ATTACHED_LEFT : ATTACHED_RIGHT).getOrDefault((Object)kind, true);
    }

    public static void markKindDetached(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        ToolTuning.setAttachmentState(kind, left, false);
    }

    public static void markKindAttached(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        ToolTuning.setAttachmentState(kind, left, true);
        ToolTuning.refreshKind(kind, left);
    }

    private static Profile blankProfile() {
        return new Profile(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static Profile get(VanillaFirstPersonItemLayer.ToolKind kind) {
        return ToolTuning.get(kind, false);
    }

    public static Profile get(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case VanillaFirstPersonItemLayer.ToolKind.AXE -> {
                if (left) {
                    yield AXE_L;
                }
                yield AXE_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.PICKAXE -> {
                if (left) {
                    yield PICKAXE_L;
                }
                yield PICKAXE_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.HOE -> {
                if (left) {
                    yield HOE_L;
                }
                yield HOE_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.SWORD -> {
                if (left) {
                    yield SWORD_L;
                }
                yield SWORD_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.SHOVEL -> {
                if (left) {
                    yield SHOVEL_L;
                }
                yield SHOVEL_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.SHIELD -> {
                if (left) {
                    yield SHIELD_L;
                }
                yield SHIELD_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.BLOCK -> {
                if (left) {
                    yield BLOCK_L;
                }
                yield BLOCK_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.FLOWER_PENDULUM -> {
                if (left) {
                    yield FLOWER_PENDULUM_L;
                }
                yield FLOWER_PENDULUM_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.CREATURE_BUCKET -> {
                if (left) {
                    yield CREATURE_BUCKET_L;
                }
                yield CREATURE_BUCKET_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.MINECART -> {
                if (left) {
                    yield MINECART_L;
                }
                yield MINECART_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.BOAT -> {
                if (left) {
                    yield BOAT_L;
                }
                yield BOAT_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.BUTTON_PLATE -> {
                if (left) {
                    yield BUTTON_PLATE_L;
                }
                yield BUTTON_PLATE_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.TRAPDOOR -> {
                if (left) {
                    yield TRAPDOOR_L;
                }
                yield TRAPDOOR_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.CARPET -> {
                if (left) {
                    yield CARPET_L;
                }
                yield CARPET_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.BED -> {
                if (left) {
                    yield BED_L;
                }
                yield BED_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.TORCH -> {
                if (left) {
                    yield TORCH_L;
                }
                yield TORCH_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.LANTERN -> {
                if (left) {
                    yield LANTERN_L;
                }
                yield LANTERN_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.REDSTONE -> {
                if (left) {
                    yield REDSTONE_L;
                }
                yield REDSTONE_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.INGREDIENT -> {
                if (left) {
                    yield INGREDIENT_L;
                }
                yield INGREDIENT_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.BOW -> {
                if (left) {
                    yield BOW_L;
                }
                yield BOW_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.ARROW -> {
                if (left) {
                    yield ARROW_L;
                }
                yield ARROW_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.CROSSBOW -> {
                if (left) {
                    yield CROSSBOW_L;
                }
                yield CROSSBOW_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.SPYGLASS -> {
                if (left) {
                    yield SPYGLASS_L;
                }
                yield SPYGLASS_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.FLINT -> {
                if (left) {
                    yield FLINT_L;
                }
                yield FLINT_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.FOOD -> {
                if (left) {
                    yield FOOD_L;
                }
                yield FOOD_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.SHUBBA_DUCK -> {
                if (left) {
                    yield SHUBBA_L;
                }
                yield SHUBBA_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.MACE -> {
                if (left) {
                    yield MACE_L;
                }
                yield MACE_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.TRIDENT -> {
                if (left) {
                    yield TRIDENT_L;
                }
                yield TRIDENT_R;
            }
            case VanillaFirstPersonItemLayer.ToolKind.FISHING_ROD -> left ? FISHING_ROD_L : FISHING_ROD_R;
        };
    }

    public static Profile getGlobal(boolean left) {
        return left ? GLOBAL_LEFT : GLOBAL_RIGHT;
    }

    public static void applyGlobal(boolean left, Profile p) {
        if (p == null) {
            return;
        }
        Profile dst = ToolTuning.getGlobal(left);
        ToolTuning.copyAll(p, dst);
        dst.recomputeRadians();
        ToolTuning.refresh(left);
    }

    public static Profile snapshotGlobal(boolean left) {
        Profile base = ToolTuning.getGlobal(left);
        return new Profile(base.scale, base.offX, base.offY, base.offZ, base.rotX, base.rotY, base.rotZ, base.pivotX, base.pivotY, base.pivotZ);
    }

    public static void commitGlobal(boolean left) {
        ToolTuning.getGlobal(left).recomputeRadians();
        ToolTuning.refresh(left);
    }

    public static void apply(VanillaFirstPersonItemLayer.ToolKind kind, boolean left, Profile p) {
        if (p == null) {
            return;
        }
        Profile dst = ToolTuning.get(kind, left);
        ToolTuning.copyAll(p, dst);
        dst.recomputeRadians();
        ToolTuning.commitKind(kind, left);
    }

    public static void commitKind(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        Profile base = ToolTuning.getGlobal(left);
        Profile dst = ToolTuning.get(kind, left);
        TransformOverride override = ToolTuning.getOverride(kind, left);
        override.set(base, dst);
        ToolTuning.refreshKind(kind, left);
    }

    public static Profile snapshot(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        Profile s = ToolTuning.get(kind, left);
        return new Profile(s.scale, s.offX, s.offY, s.offZ, s.rotX, s.rotY, s.rotZ, s.pivotX, s.pivotY, s.pivotZ);
    }

    private static void refresh(boolean left) {
        for (VanillaFirstPersonItemLayer.ToolKind kind : VanillaFirstPersonItemLayer.ToolKind.values()) {
            ToolTuning.refreshKind(kind, left);
        }
    }

    public static void refreshAll() {
        ToolTuning.refresh(false);
        ToolTuning.refresh(true);
    }

    private static void refreshKind(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        Profile dst = ToolTuning.get(kind, left);
        if (dst == null) {
            return;
        }
        if (!ToolTuning.isKindAttached(kind, left)) {
            dst.recomputeRadians();
            return;
        }
        Profile base = ToolTuning.getGlobal(left);
        TransformOverride override = ToolTuning.getOverride(kind, left);
        if (base == null || override == null) {
            return;
        }
        ToolTuning.copyAnchor(base, dst);
        dst.scale += override.scale;
        dst.offX += override.offX;
        dst.offY += override.offY;
        dst.offZ += override.offZ;
        dst.pivotX += override.pivotX;
        dst.pivotY += override.pivotY;
        dst.pivotZ += override.pivotZ;
        dst.rotX = base.rotX + override.rotX;
        dst.rotY = base.rotY + override.rotY;
        dst.rotZ = base.rotZ + override.rotZ;
        dst.recomputeRadians();
    }

    private static TransformOverride getOverride(VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        Map<VanillaFirstPersonItemLayer.ToolKind, TransformOverride> map = left ? OVERRIDE_LEFT : OVERRIDE_RIGHT;
        TransformOverride ovr = map.get((Object)kind);
        if (ovr == null) {
            ovr = new TransformOverride();
            map.put(kind, ovr);
        }
        return ovr;
    }

    private static void copyAnchor(Profile src, Profile dst) {
        dst.scale = src.scale;
        dst.offX = src.offX;
        dst.offY = src.offY;
        dst.offZ = src.offZ;
        dst.pivotX = src.pivotX;
        dst.pivotY = src.pivotY;
        dst.pivotZ = src.pivotZ;
    }

    private static void copyAll(Profile src, Profile dst) {
        ToolTuning.copyAnchor(src, dst);
        dst.rotX = src.rotX;
        dst.rotY = src.rotY;
        dst.rotZ = src.rotZ;
    }

    private static Profile copyProfile(Profile src) {
        return new Profile(src.scale, src.offX, src.offY, src.offZ, src.rotX, src.rotY, src.rotZ, src.pivotX, src.pivotY, src.pivotZ);
    }

    private static ResourceLocation idFor(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
    }

    public static Profile resolveProfile(ItemStack stack, VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        Profile profile;
        SpecificEntry entry;
        ResourceLocation id = ToolTuning.idFor(stack);
        if (id != null && (entry = ITEM_SPECIFICS.get(id)) != null && (profile = entry.get(left)) != null) {
            return profile;
        }
        return ToolTuning.get(kind, left);
    }

    public static boolean hasSpecificProfile(ItemStack stack) {
        ResourceLocation id = ToolTuning.idFor(stack);
        return id != null && ITEM_SPECIFICS.containsKey(id);
    }

    public static Profile getSpecificProfile(ResourceLocation id, VanillaFirstPersonItemLayer.ToolKind kind, boolean left) {
        Profile profile;
        if (id == null) {
            return null;
        }
        SpecificEntry entry = ITEM_SPECIFICS.computeIfAbsent(id, key -> new SpecificEntry(kind));
        if (entry.kind == null) {
            entry.kind = kind;
        }
        if ((profile = entry.get(left)) == null) {
            profile = ToolTuning.copyProfile(ToolTuning.snapshot(kind, left));
            entry.set(left, profile);
        }
        return profile;
    }

    public static Map<ResourceLocation, SpecificSnapshot> snapshotSpecifics() {
        HashMap<ResourceLocation, SpecificSnapshot> copy = new HashMap<ResourceLocation, SpecificSnapshot>();
        ITEM_SPECIFICS.forEach((id, entry) -> copy.put((ResourceLocation)id, new SpecificSnapshot(entry.kind, entry.right != null ? ToolTuning.copyProfile(entry.right) : null, entry.left != null ? ToolTuning.copyProfile(entry.left) : null)));
        return copy;
    }

    public static void applySpecific(ResourceLocation id, VanillaFirstPersonItemLayer.ToolKind kind, Profile right, Profile left) {
        if (id == null || kind == null) {
            return;
        }
        SpecificEntry entry = new SpecificEntry(kind);
        entry.right = right != null ? ToolTuning.copyProfile(right) : null;
        entry.left = left != null ? ToolTuning.copyProfile(left) : null;
        ITEM_SPECIFICS.put(id, entry);
    }

    public static void clearSpecifics() {
        ITEM_SPECIFICS.clear();
    }

    static {
        OVERRIDE_RIGHT = new EnumMap<VanillaFirstPersonItemLayer.ToolKind, TransformOverride>(VanillaFirstPersonItemLayer.ToolKind.class);
        OVERRIDE_LEFT = new EnumMap<VanillaFirstPersonItemLayer.ToolKind, TransformOverride>(VanillaFirstPersonItemLayer.ToolKind.class);
        ITEM_SPECIFICS = new HashMap<ResourceLocation, SpecificEntry>();
        ATTACHED_RIGHT = new EnumMap(VanillaFirstPersonItemLayer.ToolKind.class);
        ATTACHED_LEFT = new EnumMap(VanillaFirstPersonItemLayer.ToolKind.class);
        ToolTuning.resetDefaults();
    }

    public static final class Profile {
        public float scale;
        public float offX;
        public float offY;
        public float offZ;
        public float rotX;
        public float rotY;
        public float rotZ;
        public float pivotX;
        public float pivotY;
        public float pivotZ;
        private float rotXRad;
        private float rotYRad;
        private float rotZRad;

        public Profile(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ) {
            this(scale, offX, offY, offZ, rotX, rotY, rotZ, 0.0f, 0.0f, 0.0f);
        }

        public Profile(float scale, float offX, float offY, float offZ, float rotX, float rotY, float rotZ, float pivotX, float pivotY, float pivotZ) {
            this.scale = scale;
            this.offX = offX;
            this.offY = offY;
            this.offZ = offZ;
            this.rotX = rotX;
            this.rotY = rotY;
            this.rotZ = rotZ;
            this.pivotX = pivotX;
            this.pivotY = pivotY;
            this.pivotZ = pivotZ;
            this.recomputeRadians();
        }

        public void recomputeRadians() {
            this.rotXRad = (float)Math.toRadians(this.rotX);
            this.rotYRad = (float)Math.toRadians(this.rotY);
            this.rotZRad = (float)Math.toRadians(this.rotZ);
        }

        public float rotXRad() {
            return this.rotXRad;
        }

        public float rotYRad() {
            return this.rotYRad;
        }

        public float rotZRad() {
            return this.rotZRad;
        }

        public Profile mirror() {
            Profile mirrored = new Profile(this.scale, -this.offX, this.offY, this.offZ, this.rotX, -this.rotY, -this.rotZ, -this.pivotX, this.pivotY, this.pivotZ);
            return mirrored;
        }
    }

    private static final class TransformOverride {
        float scale;
        float offX;
        float offY;
        float offZ;
        float rotX;
        float rotY;
        float rotZ;
        float pivotX;
        float pivotY;
        float pivotZ;

        private TransformOverride() {
        }

        void set(Profile base, Profile target) {
            this.scale = target.scale - base.scale;
            this.offX = target.offX - base.offX;
            this.offY = target.offY - base.offY;
            this.offZ = target.offZ - base.offZ;
            this.rotX = target.rotX - base.rotX;
            this.rotY = target.rotY - base.rotY;
            this.rotZ = target.rotZ - base.rotZ;
            this.pivotX = target.pivotX - base.pivotX;
            this.pivotY = target.pivotY - base.pivotY;
            this.pivotZ = target.pivotZ - base.pivotZ;
        }
    }

    private static final class SpecificEntry {
        VanillaFirstPersonItemLayer.ToolKind kind;
        Profile right;
        Profile left;

        SpecificEntry(VanillaFirstPersonItemLayer.ToolKind kind) {
            this.kind = kind;
        }

        Profile get(boolean leftHand) {
            Profile profile;
            Profile profile2 = profile = leftHand ? this.left : this.right;
            if (profile == null) {
                Profile opposite;
                Profile profile3 = opposite = leftHand ? this.right : this.left;
                if (opposite != null) {
                    profile = opposite.mirror();
                    this.set(leftHand, profile);
                }
            }
            return profile;
        }

        void set(boolean leftHand, Profile profile) {
            if (leftHand) {
                this.left = profile;
            } else {
                this.right = profile;
            }
        }
    }

    public static final class SpecificSnapshot {
        private final VanillaFirstPersonItemLayer.ToolKind kind;
        private final Profile right;
        private final Profile left;

        public SpecificSnapshot(VanillaFirstPersonItemLayer.ToolKind kind, Profile right, Profile left) {
            this.kind = kind;
            this.right = right;
            this.left = left;
        }

        public VanillaFirstPersonItemLayer.ToolKind kind() {
            return this.kind;
        }

        public Profile right() {
            return this.right;
        }

        public Profile left() {
            return this.left;
        }
    }
}

