/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.client.render;

import com.henrique.punchy.client.render.HandRenderState;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class VanillaProxyContext {
    private static final Map<InteractionHand, HandRenderState> STATES = new EnumMap<InteractionHand, HandRenderState>(InteractionHand.class);
    private static final ThreadLocal<HandRenderState> ACTIVE = ThreadLocal.withInitial(() -> VanillaProxyContext.states().get(InteractionHand.MAIN_HAND));

    private VanillaProxyContext() {
    }

    private static Map<InteractionHand, HandRenderState> states() {
        return STATES;
    }

    public static HandRenderState state(InteractionHand hand) {
        return VanillaProxyContext.states().get(hand == null ? InteractionHand.MAIN_HAND : hand);
    }

    public static HandRenderState current() {
        return ACTIVE.get();
    }

    public static void setActiveHand(InteractionHand hand) {
        ACTIVE.set(VanillaProxyContext.state(hand));
    }

    public static InteractionHand getHand() {
        return VanillaProxyContext.current().getHand();
    }

    public static void setOriginal(ItemStack stack) {
        VanillaProxyContext.current().setOriginalStack(stack);
    }

    public static ItemStack getOriginal() {
        return VanillaProxyContext.current().getOriginalStack();
    }

    public static void setPlayer(Object player) {
        VanillaProxyContext.current().setPlayer(player);
    }

    public static Object getPlayer() {
        return VanillaProxyContext.current().getPlayer();
    }

    public static void clearHand(InteractionHand hand) {
        VanillaProxyContext.state(hand).clear();
        if (VanillaProxyContext.current().getHand() == hand) {
            ACTIVE.set(VanillaProxyContext.state(InteractionHand.MAIN_HAND));
        }
    }

    public static void clearAll() {
        for (HandRenderState state : VanillaProxyContext.states().values()) {
            state.clear();
        }
        ACTIVE.set(VanillaProxyContext.state(InteractionHand.MAIN_HAND));
        RenderSneakSuppressor.clear();
    }

    public static void setSpringPivot(InteractionHand hand, float x, float y, float z) {
        VanillaProxyContext.state(hand).setSpringPivot(x, y, z);
    }

    public static void clearSpringPivot(InteractionHand hand) {
        VanillaProxyContext.state(hand).clearSpringPivot();
    }

    public static Vec3 getSpringPivot(InteractionHand hand) {
        HandRenderState state = VanillaProxyContext.state(hand);
        if (state.hasSpringPivot()) {
            return new Vec3((double)state.springPivotX(), (double)state.springPivotY(), (double)state.springPivotZ());
        }
        return null;
    }

    public static void setItemPivot(InteractionHand hand, float x, float y, float z) {
        VanillaProxyContext.state(hand).setItemPivot(x, y, z);
    }

    public static void clearItemPivot(InteractionHand hand) {
        VanillaProxyContext.state(hand).clearItemPivot();
    }

    public static Vec3 getItemPivot(InteractionHand hand) {
        HandRenderState state = VanillaProxyContext.state(hand);
        if (state.hasItemPivot()) {
            return new Vec3((double)state.itemPivotX(), (double)state.itemPivotY(), (double)state.itemPivotZ());
        }
        return null;
    }

    public static void setBoneExtraZ(InteractionHand hand, float z) {
        VanillaProxyContext.state(hand).setBoneExtraZ(z);
    }

    public static float getBoneExtraZ(InteractionHand hand) {
        return VanillaProxyContext.state(hand).boneExtraZ();
    }

    static {
        STATES.put(InteractionHand.MAIN_HAND, new HandRenderState(InteractionHand.MAIN_HAND));
        STATES.put(InteractionHand.OFF_HAND, new HandRenderState(InteractionHand.OFF_HAND));
    }
}

