/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.command;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.config.PunchyConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;

public final class ModCommands {
    private ModCommands() {
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"punchy").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debugposition").requires(source -> source.hasPermission(2))).executes(context -> ModCommands.toggleDebugPosition((CommandContext<CommandSourceStack>)context))).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(context -> ModCommands.setDebugPosition((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value"))))));
    }

    private static int toggleDebugPosition(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PunchyConfig config = PunchyConfig.load();
        boolean newDebugPosition = !config.isDebugPosition();
        config.setDebugPosition(newDebugPosition);
        config.save();
        Punchy.applyCombatToggles(config);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Debug Position set to: " + newDebugPosition)), false);
        return 1;
    }

    private static int setDebugPosition(CommandContext<CommandSourceStack> context, boolean value) throws CommandSyntaxException {
        PunchyConfig config = PunchyConfig.load();
        config.setDebugPosition(value);
        config.save();
        Punchy.applyCombatToggles(config);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Debug Position set to: " + value)), false);
        return 1;
    }

    public static void register() {
        NeoForge.EVENT_BUS.addListener(RegisterClientCommandsEvent.class, ModCommands::onRegisterCommands);
    }

    private static void onRegisterCommands(RegisterClientCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

