/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.geo.renderer;

import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.client.render.anim.BoneAnimationIds;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public class GlintAwareGeoItemRenderer<T extends Item>
extends GeoItemRenderer<T> {
    private boolean skipBaseMesh = false;

    public GlintAwareGeoItemRenderer(GeoModel<T> model) {
        super(model);
    }

    public GlintAwareGeoItemRenderer<T> setSkipBaseMesh(boolean skip) {
        this.skipBaseMesh = skip;
        return this;
    }

    public boolean isSkipBaseMesh() {
        return this.skipBaseMesh;
    }

    public long getInstanceId(T animatable, GeoItemRenderer.RenderData renderData) {
        LivingEntity owner;
        InteractionHand hand = VanillaProxyContext.getHand();
        LivingEntity livingEntity = owner = renderData.itemOwner() != null ? renderData.itemOwner().asLivingEntity() : null;
        if (hand != null && owner instanceof Player) {
            Player player = (Player)owner;
            return BoneAnimationIds.compute(player, hand);
        }
        return super.getInstanceId(animatable, renderData);
    }

    public GeoRenderState captureDefaultRenderState(T animatable, GeoItemRenderer.RenderData renderData, GeoRenderState state, float partialTick) {
        GeoRenderState out = super.captureDefaultRenderState(animatable, renderData, state, partialTick);
        boolean hasGlint = false;
        Minecraft client = Minecraft.getInstance();
        if (client != null && client.player != null) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack s = client.player.getItemInHand(hand);
                if (s.isEmpty() || s.getItem() != animatable || !s.hasFoil()) continue;
                hasGlint = true;
                break;
            }
        }
        out.addGeckolibData(DataTickets.HAS_GLINT, (Object)hasGlint);
        out.addGeckolibData(DataTickets.IS_ENCHANTED, (Object)hasGlint);
        return out;
    }
}

