/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.item;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.world.item.ItemStack;

public final class AnimationRandomizer {
    private static final String[] MINING_VARIANTS = new String[]{"mining", "sway_digging", "sway_sideways", "sway_forward"};
    private static final String[] ATTACK_VARIANTS = new String[]{"attack", "attack_2", "attack_3"};
    private static final String[] SWAY_FORWARD_VARIANTS = new String[]{"sway_forward", "sway_forward_2", "sway_forward_3"};
    private static final String[] SWAY_SIDEWAYS_VARIANTS = new String[]{"sway_sideways", "sway_sideways_2", "sway_sideways_3"};

    private AnimationRandomizer() {
    }

    public static String nextMiningClip(ItemStack stack, String currentClip) {
        if (currentClip == null) {
            return "mining";
        }
        String base = AnimationRandomizer.getBaseClipName(currentClip);
        String[] variants = AnimationRandomizer.getVariantsForBase(base);
        if (variants.length <= 1) {
            return currentClip;
        }
        if (ThreadLocalRandom.current().nextFloat() < 0.8f) {
            return variants[0];
        }
        return variants[ThreadLocalRandom.current().nextInt(variants.length)];
    }

    private static String getBaseClipName(String clip) {
        if (clip.startsWith("sway_forward")) {
            return "sway_forward";
        }
        if (clip.startsWith("sway_sideways")) {
            return "sway_sideways";
        }
        if (clip.startsWith("attack")) {
            return "attack";
        }
        return clip;
    }

    private static String[] getVariantsForBase(String base) {
        String[] stringArray;
        switch (base) {
            case "sway_forward": {
                stringArray = SWAY_FORWARD_VARIANTS;
                break;
            }
            case "sway_sideways": {
                stringArray = SWAY_SIDEWAYS_VARIANTS;
                break;
            }
            case "attack": {
                stringArray = ATTACK_VARIANTS;
                break;
            }
            default: {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = base;
            }
        }
        return stringArray;
    }
}

