/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.Punchy;
import com.henrique.punchy.util.ProxyItemHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundManager.class})
public class CancelBlockHitSoundMixin {
    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$cancelBlockHitWhenUsingAnimatedPick(SoundInstance sound, CallbackInfoReturnable<?> ci) {
        if (!Punchy.TAP_MINING_ENABLED) {
            return;
        }
        if (sound == null) {
            return;
        }
        if (sound.getSource() != SoundSource.BLOCKS) {
            return;
        }
        ResourceLocation id = sound.getLocation();
        if (id == null || !id.getPath().endsWith(".hit")) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.player == null) {
            return;
        }
        for (InteractionHand hand : new InteractionHand[]{InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND}) {
            ItemStack stack = client.player.getItemInHand(hand);
            if (!ProxyItemHelper.requiresProxy(stack)) continue;
            ci.cancel();
            return;
        }
    }
}

