/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.util.ProxyItemHelper;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
abstract class ClientPlayerInteractionUseMixin {
    private InteractionHand punchy$storedUseHand = null;
    private ItemStack punchy$storedUseStack = ItemStack.EMPTY;

    ClientPlayerInteractionUseMixin() {
    }

    @Inject(method={"useItemOn"}, at={@At(value="TAIL")})
    private void punchy$triggerInsert(LocalPlayer player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        if (player == null || hand == null) {
            return;
        }
        InteractionResult result = (InteractionResult)cir.getReturnValue();
        if (result == null || !result.consumesAction()) {
            return;
        }
        InteractionHand actual = this.punchy$storedUseHand != null ? this.punchy$storedUseHand : this.resolveUseHand((Player)player, hand, this.punchy$storedUseHand, this.punchy$storedUseStack);
        ItemStack logStack = this.punchy$storedUseStack;
        if (!ProxyItemHelper.requiresProxy(player.getItemInHand(actual))) {
            return;
        }
        if (this.punchy$storedUseHand != null && this.punchy$storedUseHand != actual) {
            this.punchy$storedUseHand = null;
            this.punchy$storedUseStack = ItemStack.EMPTY;
            return;
        }
        if (this.punchy$storedUseHand != null && this.punchy$storedUseHand != actual) {
            this.punchy$storedUseHand = null;
            this.punchy$storedUseStack = ItemStack.EMPTY;
            return;
        }
        PunchyClient.onUseHandLocked(actual, logStack);
        if (player instanceof LocalPlayer) {
            LocalPlayer local = player;
            PunchyClient.triggerImmediateUse(local, actual, true);
        } else {
            PunchyClient.queueUseAnimation(actual, true);
        }
        this.punchy$storedUseHand = null;
        this.punchy$storedUseStack = ItemStack.EMPTY;
    }

    @Inject(method={"useItem"}, at={@At(value="TAIL")})
    private void punchy$triggerAirUse(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (player == null || hand == null) {
            return;
        }
        InteractionResult result = (InteractionResult)cir.getReturnValue();
        if (result == null || !result.consumesAction()) {
            return;
        }
        InteractionHand actual = this.punchy$storedUseHand != null ? this.punchy$storedUseHand : this.resolveUseHand(player, hand, this.punchy$storedUseHand, this.punchy$storedUseStack);
        ItemStack logStack = this.punchy$storedUseStack;
        if (!ProxyItemHelper.requiresProxy(player.getItemInHand(actual))) {
            return;
        }
        PunchyClient.onUseHandLocked(actual, logStack);
        if (player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            PunchyClient.triggerImmediateUse(local, actual, false);
        } else {
            PunchyClient.queueUseAnimation(actual, false);
        }
        this.punchy$storedUseHand = null;
        this.punchy$storedUseStack = ItemStack.EMPTY;
    }

    @Inject(method={"useItemOn"}, at={@At(value="HEAD")})
    private void punchy$cacheUseOn(LocalPlayer player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> cir) {
        this.punchy$storedUseHand = hand;
        this.punchy$storedUseStack = player == null || hand == null ? ItemStack.EMPTY : player.getItemInHand(hand).copy();
    }

    @Inject(method={"useItem"}, at={@At(value="HEAD")})
    private void punchy$cacheAirUse(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        this.punchy$storedUseHand = hand;
        this.punchy$storedUseStack = player == null || hand == null ? ItemStack.EMPTY : player.getItemInHand(hand).copy();
    }

    private InteractionHand resolveUseHand(Player player, InteractionHand hand, InteractionHand cachedHand, ItemStack cachedStack) {
        ItemStack off;
        InteractionHand candidate;
        InteractionHand interactionHand;
        if (player == null) {
            return hand;
        }
        if (player instanceof LocalPlayer) {
            LocalPlayer local = (LocalPlayer)player;
            interactionHand = local.getUsedItemHand();
        } else {
            interactionHand = null;
        }
        InteractionHand used = interactionHand;
        InteractionHand interactionHand2 = candidate = used == null ? hand : used;
        if (cachedHand != null && cachedStack != null && !cachedStack.isEmpty() && (off = player.getItemInHand(InteractionHand.OFF_HAND)) != null && !off.isEmpty() && cachedStack.getItem() == off.getItem()) {
            return InteractionHand.OFF_HAND;
        }
        return candidate;
    }
}

