/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.geo.renderer.GlintAwareGeoItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.RenderModelPositioner;

@Mixin(value={GeoItemRenderer.class})
public abstract class GeoItemRendererGlintMixin<T extends Item> {
    @Unique
    private static final ThreadLocal<Boolean> punchy$glintGuard = ThreadLocal.withInitial(() -> false);

    @Inject(method={"buildRenderTask"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$skipBaseMeshWhenRequested(GeoRenderState state, PoseStack matrices, BakedGeoModel bakedModel, GeoModel<T> geoModel, OrderedSubmitNodeCollector renderQueue, CameraRenderState camera, RenderType baseLayer, int light, int overlay, int unknown, RenderModelPositioner<GeoRenderState> positioner, CallbackInfo ci) {
        GlintAwareGeoItemRenderer r;
        GeoItemRendererGlintMixin self = this;
        if (self instanceof GlintAwareGeoItemRenderer && (r = (GlintAwareGeoItemRenderer)((Object)self)).isSkipBaseMesh()) {
            RenderModelPositioner callback = RenderModelPositioner.add(positioner, (renderState, baked) -> {
                GeoRenderer renderer = (GeoRenderer)this;
                geoModel.handleAnimations(renderer.createAnimationState(renderState));
            });
            callback.run(state, bakedModel);
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"buildRenderTask"}, at={@At(value="TAIL")})
    private void punchy$appendGlintOverlay(GeoRenderState state, PoseStack matrices, BakedGeoModel bakedModel, GeoModel<T> geoModel, OrderedSubmitNodeCollector renderQueue, CameraRenderState camera, RenderType baseLayer, int light, int overlay, int unknown, RenderModelPositioner<GeoRenderState> positioner, CallbackInfo ci) {
        if (Boolean.TRUE.equals(punchy$glintGuard.get())) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client == null || client.player == null) {
            return;
        }
        boolean enchanted = false;
        StringBuilder dbg = new StringBuilder();
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack s = client.player.getItemInHand(hand);
            if (!s.isEmpty()) {
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)s.getItem());
                dbg.append(" [").append(hand).append(": ").append(id).append(", hasGlint=").append(s.hasFoil()).append(", hasEnchants=").append(s.isEnchanted()).append("]");
                boolean isPunchy = id != null && "punchy".equals(id.getNamespace());
                boolean isGeo = s.getItem() instanceof GeoItem;
                if (!isPunchy || !isGeo || !s.hasFoil()) continue;
                enchanted = true;
                continue;
            }
            dbg.append(" [").append(hand).append(": empty]");
        }
        if (enchanted) {
            // empty if block
        }
        if (!enchanted) {
            return;
        }
        try {
            MultiBufferSource.BufferSource vcp = client.renderBuffers().bufferSource();
            for (RenderType gl : ItemRenderer.getFoilRenderTypes((RenderType)baseLayer, (boolean)false, (boolean)true)) {
                punchy$glintGuard.set(true);
                try {
                    ((GeoItemRenderer)this).buildRenderTask(state, matrices, bakedModel, geoModel, renderQueue, camera, gl, light, overlay, unknown, positioner);
                }
                finally {
                    punchy$glintGuard.set(false);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

