/*
 * Decompiled with CFR 0.152.
 */
package com.henrique.punchy.mixin;

import com.henrique.punchy.PunchyClient;
import com.henrique.punchy.client.render.ArmAnimationOverrides;
import com.henrique.punchy.client.render.ArmRenderMirror;
import com.henrique.punchy.client.render.HandItemOverrides;
import com.henrique.punchy.client.render.HandRenderState;
import com.henrique.punchy.client.render.MirrorOffhandLayer;
import com.henrique.punchy.client.render.RenderSneakSuppressor;
import com.henrique.punchy.client.render.VanillaBoneProxies;
import com.henrique.punchy.client.render.VanillaProxyContext;
import com.henrique.punchy.util.ProxyItemHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class}, priority=1200)
public abstract class HeldItemRendererMixin {
    private static Method punchy$getShaderMethod;
    private static Field punchy$shaderField;
    private static boolean punchy$shaderAccessorsInitialized;

    @ModifyVariable(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at=@At(value="HEAD"), argsOnly=true)
    private ItemStack punchy$mirrorAndProxy(ItemStack original, AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float equip, ItemStack stack, float swing, PoseStack matrices, SubmitNodeCollector queue, int light) {
        if (ProxyItemHelper.isMap(original)) {
            PunchyClient.IN_MAP_RENDER.set(Boolean.TRUE);
            return original;
        }
        PunchyClient.IN_MAP_RENDER.set(Boolean.FALSE);
        InteractionHand effectiveHand = hand != null ? hand : InteractionHand.MAIN_HAND;
        VanillaProxyContext.setActiveHand(effectiveHand);
        VanillaProxyContext.setPlayer(player);
        if (HandItemOverrides.isHidden(effectiveHand)) {
            VanillaProxyContext.setOriginal(ItemStack.EMPTY);
            this.punchy$activateSneakSuppress(effectiveHand);
            return VanillaBoneProxies.proxy(effectiveHand);
        }
        ItemStack override = HandItemOverrides.getOverride(effectiveHand);
        if (!override.isEmpty()) {
            VanillaProxyContext.setOriginal(override);
            this.punchy$activateSneakSuppress(effectiveHand);
            return VanillaBoneProxies.proxy(effectiveHand);
        }
        ItemStack mirrored = MirrorOffhandLayer.mirror(player, hand, original);
        if (ProxyItemHelper.requiresProxy((Player)player, effectiveHand)) {
            VanillaProxyContext.setOriginal(mirrored);
            this.punchy$activateSneakSuppress(effectiveHand);
            return VanillaBoneProxies.proxy(effectiveHand);
        }
        return mirrored;
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$cancelVanillaArm(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float equip, ItemStack stack, float swing, PoseStack matrices, SubmitNodeCollector queue, int light, CallbackInfo ci) {
        InteractionHand effectiveHand;
        if (Boolean.TRUE.equals(PunchyClient.IN_MAP_RENDER.get())) {
            return;
        }
        this.punchy$resetMatrices(matrices);
        ArmRenderMirror.beginRightHand();
        InteractionHand interactionHand = effectiveHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (ProxyItemHelper.requiresProxy((Player)player, effectiveHand) && !ProxyItemHelper.isGeo(stack)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at={@At(value="TAIL")})
    private void punchy$clearOriginal(AbstractClientPlayer player, float f, float g, InteractionHand hand, float equip, ItemStack stack, float swing, PoseStack matrices, SubmitNodeCollector queue, int light, CallbackInfo ci) {
        InteractionHand effectiveHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        HandRenderState state = VanillaProxyContext.state(effectiveHand);
        if (state != null && state.isSneakSuppressed()) {
            state.setSneakSuppressed(false);
            RenderSneakSuppressor.pop();
        }
        VanillaProxyContext.clearHand(effectiveHand);
        ArmRenderMirror.endRightHand();
        PunchyClient.IN_MAP_RENDER.set(Boolean.FALSE);
    }

    @Redirect(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/ItemInHandRenderer;swingArm(FFLcom/mojang/blaze3d/vertex/PoseStack;ILnet/minecraft/world/entity/HumanoidArm;)V"))
    private void punchy$skipSwing(ItemInHandRenderer renderer, float equipProgress, float swingProgress, PoseStack swingMatrices, int light, HumanoidArm arm, AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float equip, ItemStack stack, float swing, PoseStack renderMatrices, SubmitNodeCollector queue, int renderLight) {
    }

    @Inject(method={"applyItemArmTransform"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$skipEquip(PoseStack matrices, HumanoidArm arm, float equipProgress, CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"applyItemArmAttackTransform"}, at={@At(value="HEAD")}, cancellable=true)
    private void punchy$skipSwingOffset(PoseStack matrices, HumanoidArm arm, float swingProgress, CallbackInfo ci) {
        ci.cancel();
    }

    @Redirect(method={"evaluateWhichHandsToRender"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isUsingItem()Z"))
    private static boolean punchy$forceBothHands(LocalPlayer player) {
        if (ArmAnimationOverrides.isForceRender(InteractionHand.MAIN_HAND) || ArmAnimationOverrides.isForceRender(InteractionHand.OFF_HAND)) {
            return false;
        }
        return player.isUsingItem();
    }

    @Redirect(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/AbstractClientPlayer;isUsingItem()Z"))
    private boolean punchy$gateBowAnimation(AbstractClientPlayer player, AbstractClientPlayer context, float tickDelta, float pitch, InteractionHand hand, float equipProgress, ItemStack stack, float swingProgress, PoseStack matrices, SubmitNodeCollector queue, int light) {
        InteractionHand effectiveHand;
        InteractionHand interactionHand = effectiveHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (PunchyClient.shouldHoldBowAnimation(effectiveHand, stack)) {
            return false;
        }
        return player.isUsingItem();
    }

    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;I)V"}, at={@At(value="HEAD")})
    private void punchy$primeSneakSuppress(AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float equip, ItemStack stack, float swing, PoseStack matrices, SubmitNodeCollector queue, int light, CallbackInfo ci) {
        ItemStack original;
        InteractionHand effectiveHand;
        InteractionHand interactionHand = effectiveHand = hand == null ? InteractionHand.MAIN_HAND : hand;
        if (HandItemOverrides.isHidden(effectiveHand)) {
            this.punchy$activateSneakSuppress(effectiveHand);
            return;
        }
        ItemStack override = HandItemOverrides.getOverride(effectiveHand);
        if (!override.isEmpty()) {
            this.punchy$activateSneakSuppress(effectiveHand);
            return;
        }
        ItemStack itemStack = original = stack == null ? ItemStack.EMPTY : stack;
        if (ProxyItemHelper.requiresProxy(original)) {
            this.punchy$activateSneakSuppress(effectiveHand);
        }
    }

    private void punchy$activateSneakSuppress(InteractionHand hand) {
        HandRenderState state = VanillaProxyContext.state(hand);
        if (state != null && !state.isSneakSuppressed()) {
            state.setSneakSuppressed(true);
            RenderSneakSuppressor.push();
        }
    }

    private void punchy$resetMatrices(PoseStack matrices) {
        Minecraft client = Minecraft.getInstance();
        if (client == null || !HeldItemRendererMixin.punchy$isShaderActive(client)) {
            return;
        }
        PoseStack.Pose top = matrices.last();
        top.pose().identity();
        top.normal().identity();
    }

    private static void punchy$initShaderAccessors() {
        punchy$shaderAccessorsInitialized = true;
        try {
            punchy$getShaderMethod = GameRenderer.class.getMethod("getShader", new Class[0]);
            punchy$getShaderMethod.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (punchy$getShaderMethod == null) {
            try {
                punchy$shaderField = GameRenderer.class.getField("shader");
                punchy$shaderField.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean punchy$isShaderActive(Minecraft client) {
        if (client == null || client.gameRenderer == null) {
            return false;
        }
        if (!punchy$shaderAccessorsInitialized) {
            HeldItemRendererMixin.punchy$initShaderAccessors();
        }
        try {
            if (punchy$getShaderMethod != null) {
                return punchy$getShaderMethod.invoke((Object)client.gameRenderer, new Object[0]) != null;
            }
            if (punchy$shaderField != null) {
                return punchy$shaderField.get(client.gameRenderer) != null;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    static {
        punchy$shaderAccessorsInitialized = false;
    }
}

